/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.compiler.processing.XDeclaredType;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XVariableElement;
import androidx.room.parser.Section;
import androidx.room.processor.Context;
import androidx.room.processor.ProcessorErrors;
import androidx.room.solver.query.parameter.QueryParameterAdapter;
import androidx.room.vo.QueryParameter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0014\u001a\u00020\u0015R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/room/processor/QueryParameterProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XDeclaredType;", "element", "Landroidx/room/compiler/processing/XVariableElement;", "sqlName", "", "bindVarSection", "Landroidx/room/parser/Section$BindVar;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XDeclaredType;Landroidx/room/compiler/processing/XVariableElement;Ljava/lang/String;Landroidx/room/parser/Section$BindVar;)V", "getContaining", "()Landroidx/room/compiler/processing/XDeclaredType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Landroidx/room/compiler/processing/XVariableElement;", "process", "Landroidx/room/vo/QueryParameter;", "room-compiler"})
public final class QueryParameterProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final XDeclaredType containing;
    @NotNull
    private final XVariableElement element;
    private final String sqlName;
    private final Section.BindVar bindVarSection;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final QueryParameter process() {
        XType asMember = this.element.asMemberOf(this.containing);
        Section.BindVar bindVar = this.bindVarSection;
        QueryParameterAdapter parameterAdapter = this.context.getTypeAdapterStore().findQueryParameterAdapter(asMember, bindVar != null ? bindVar.isMultiple() : false);
        this.context.getChecker().check(parameterAdapter != null, (XElement)this.element, ProcessorErrors.INSTANCE.getCANNOT_BIND_QUERY_PARAMETER_INTO_STMT(), new Object[0]);
        String name = this.element.getName();
        this.context.getChecker().check(!StringsKt.startsWith$default((String)name, (String)"_", (boolean)false, (int)2, null), (XElement)this.element, ProcessorErrors.INSTANCE.getQUERY_PARAMETERS_CANNOT_START_WITH_UNDERSCORE(), new Object[0]);
        return new QueryParameter(name, this.sqlName, asMember, parameterAdapter);
    }

    @NotNull
    public final XDeclaredType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XVariableElement getElement() {
        return this.element;
    }

    public QueryParameterProcessor(@NotNull Context baseContext, @NotNull XDeclaredType containing, @NotNull XVariableElement element, @NotNull String sqlName, @Nullable Section.BindVar bindVarSection) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)sqlName, (String)"sqlName");
        this.containing = containing;
        this.element = element;
        this.sqlName = sqlName;
        this.bindVarSection = bindVarSection;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, 2, null);
    }
}

