/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.compiler.processing.XArrayType;
import androidx.room.compiler.processing.XDeclaredType;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XRawType;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeKt;
import androidx.room.compiler.processing.XVariableElement;
import androidx.room.processor.Context;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.ShortcutParameterProcessor;
import androidx.room.vo.ShortcutQueryParameter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0010\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Landroidx/room/processor/ShortcutParameterProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XDeclaredType;", "element", "Landroidx/room/compiler/processing/XVariableElement;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XDeclaredType;Landroidx/room/compiler/processing/XVariableElement;)V", "getContaining", "()Landroidx/room/compiler/processing/XDeclaredType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Landroidx/room/compiler/processing/XVariableElement;", "extractPojoType", "Lkotlin/Pair;", "Landroidx/room/compiler/processing/XType;", "", "typeMirror", "process", "Landroidx/room/vo/ShortcutQueryParameter;", "room-compiler"})
public final class ShortcutParameterProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final XDeclaredType containing;
    @NotNull
    private final XVariableElement element;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShortcutQueryParameter process() {
        void pojoType;
        XType asMember = this.element.asMemberOf(this.containing);
        String name = this.element.getName();
        this.context.getChecker().check(!StringsKt.startsWith$default((String)name, (String)"_", (boolean)false, (int)2, null), (XElement)this.element, ProcessorErrors.INSTANCE.getQUERY_PARAMETERS_CANNOT_START_WITH_UNDERSCORE(), new Object[0]);
        Pair<XType, Boolean> pair = this.extractPojoType(asMember);
        XType xType = (XType)pair.component1();
        boolean isMultiple = (Boolean)pair.component2();
        return new ShortcutQueryParameter(this.element, name, asMember, (XType)pojoType, isMultiple);
    }

    private final Pair<XType, Boolean> extractPojoType(XType typeMirror) {
        XProcessingEnv processingEnv = this.context.getProcessingEnv();
        extractPojoType.1 $fun$verifyAndPair$1 = extractPojoType.1.INSTANCE;
        extractPojoType.2 $fun$extractPojoTypeFromIterator$2 = extractPojoType.2.INSTANCE;
        XRawType iterableType = processingEnv.requireType("java.lang.Iterable").getRawType();
        if (iterableType.isAssignableFrom(typeMirror)) {
            XDeclaredType declared = XTypeKt.asDeclaredType((XType)typeMirror);
            XType pojo = $fun$extractPojoTypeFromIterator$2.invoke(declared);
            return $fun$verifyAndPair$1.invoke(pojo, true);
        }
        if (XTypeKt.isArray((XType)typeMirror)) {
            XType pojo = ((XArrayType)typeMirror).getComponentType();
            return $fun$verifyAndPair$1.invoke(pojo, true);
        }
        return $fun$verifyAndPair$1.invoke(typeMirror, false);
    }

    @NotNull
    public final XDeclaredType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XVariableElement getElement() {
        return this.element;
    }

    public ShortcutParameterProcessor(@NotNull Context baseContext, @NotNull XDeclaredType containing, @NotNull XVariableElement element) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.containing = containing;
        this.element = element;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, 2, null);
    }
}

