/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.room.Database;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XProcessingStep;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.processor.Context;
import androidx.room.processor.DatabaseProcessor;
import androidx.room.processor.MissingTypeException;
import androidx.room.processor.ProcessorErrors;
import androidx.room.vo.Dao;
import androidx.room.vo.DaoMethod;
import androidx.room.vo.Warning;
import androidx.room.writer.DaoWriter;
import androidx.room.writer.DatabaseWriter;
import com.google.auto.common.BasicAnnotationProcessor;
import com.squareup.javapoet.ClassName;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004H\u0016J$\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0002J8\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00042\u0006\u0010\u0010\u001a\u00020\u00112 \u0010\u0012\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\n0\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Landroidx/room/DatabaseProcessingStep;", "Landroidx/room/compiler/processing/XProcessingStep;", "()V", "annotations", "", "Lkotlin/reflect/KClass;", "", "prepareDaosForWriting", "", "databases", "", "Landroidx/room/vo/Database;", "daoMethods", "Landroidx/room/vo/DaoMethod;", "process", "Landroidx/room/compiler/processing/XTypeElement;", "env", "Landroidx/room/compiler/processing/XProcessingEnv;", "elementsByAnnotation", "", "room-compiler"})
public final class DatabaseProcessingStep
implements XProcessingStep {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<XTypeElement> process(@NotNull XProcessingEnv env, @NotNull Map<KClass<? extends Annotation>, ? extends List<? extends XTypeElement>> elementsByAnnotation) {
        Map daoMethodsMap;
        Map map2;
        Object list$iv$iv;
        List databases;
        List list;
        Iterable<androidx.room.vo.Database> destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter(elementsByAnnotation, (String)"elementsByAnnotation");
        Context context = new Context(env);
        boolean bl = false;
        Set rejectedElements = new LinkedHashSet();
        List<? extends XTypeElement> list2 = elementsByAnnotation.get(Reflection.getOrCreateKotlinClass(Database.class));
        if (list2 != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = list2;
            boolean $i$f$mapNotNull = false;
            void var8_12 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                androidx.room.vo.Database database;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                XTypeElement it = (XTypeElement)element$iv$iv;
                boolean bl3 = false;
                try {
                    database = new DatabaseProcessor(context, it).process();
                }
                catch (MissingTypeException ex) {
                    rejectedElements.add(it);
                    database = null;
                }
                if (database == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                androidx.room.vo.Database it$iv$iv = object;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List list3 = databases = list;
        if (list3 != null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = list3;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                androidx.room.vo.Database db = (androidx.room.vo.Database)element$iv$iv;
                boolean bl7 = false;
                Iterable $this$map$iv = db.getDaoMethods();
                boolean $i$f$map = false;
                Iterable bl3 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DaoMethod daoMethod = (DaoMethod)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl8 = false;
                    Pair pair = TuplesKt.to((Object)it, (Object)db);
                    collection.add(pair);
                }
                list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            map2 = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        } else {
            map2 = null;
        }
        Map map3 = daoMethodsMap = map2;
        if (map3 != null) {
            Map $this$flatMap$iv = map3;
            boolean $i$f$flatMap = false;
            boolean bl9 = false;
            Map it = $this$flatMap$iv;
            boolean bl10 = false;
            this.prepareDaosForWriting(databases, CollectionsKt.toList((Iterable)it.keySet()));
            Map $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            list$iv$iv = $this$forEach$iv;
            boolean bl7 = false;
            Iterator iterator = list$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void daoMethod;
                Map.Entry element$iv;
                Map.Entry $dstr$daoMethod$db = element$iv = iterator.next();
                boolean bl11 = false;
                Map.Entry entry = $dstr$daoMethod$db;
                boolean bl12 = false;
                DaoMethod item$iv$iv = (DaoMethod)entry.getKey();
                entry = $dstr$daoMethod$db;
                bl12 = false;
                androidx.room.vo.Database db = (androidx.room.vo.Database)entry.getValue();
                new DaoWriter(daoMethod.getDao(), (XElement)db.getElement(), context.getProcessingEnv()).write(context.getProcessingEnv());
            }
        }
        List list4 = databases;
        if (list4 != null) {
            Iterable $this$forEach$iv = list4;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String qName;
                File dbSchemaFolder;
                androidx.room.vo.Database db = (androidx.room.vo.Database)element$iv;
                boolean bl13 = false;
                new DatabaseWriter(db).write(context.getProcessingEnv());
                if (!db.getExportSchema()) continue;
                File schemaOutFolder2 = context.getSchemaOutFolder();
                if (schemaOutFolder2 == null) {
                    context.getLogger().w(Warning.MISSING_SCHEMA_LOCATION, (XElement)db.getElement(), ProcessorErrors.INSTANCE.getMISSING_SCHEMA_EXPORT_DIRECTORY(), new Object[0]);
                    continue;
                }
                if (!schemaOutFolder2.exists()) {
                    schemaOutFolder2.mkdirs();
                }
                if (!(dbSchemaFolder = new File(schemaOutFolder2, qName = db.getElement().getQualifiedName())).exists()) {
                    dbSchemaFolder.mkdirs();
                }
                db.exportSchema(new File(dbSchemaFolder, db.getVersion() + ".json"));
            }
        }
        return rejectedElements;
    }

    @NotNull
    public Set<KClass<? extends Annotation>> annotations() {
        return SetsKt.mutableSetOf((Object[])new KClass[]{Reflection.getOrCreateKotlinClass(Database.class)});
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareDaosForWriting(List<androidx.room.vo.Database> databases, List<DaoMethod> daoMethods) {
        void $this$filterTo$iv$iv;
        Object list$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = daoMethods;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object2;
            Object element$iv$iv = iterator.next();
            DaoMethod it = (DaoMethod)element$iv$iv;
            boolean bl = false;
            ClassName key$iv$iv = it.getDao().getTypeName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv;
        boolean element$iv$iv = false;
        list$iv$iv = iterator.entrySet().iterator();
        while (list$iv$iv.hasNext()) {
            Map.Entry element$iv$iv2;
            Map.Entry entry = element$iv$iv2 = (Map.Entry)list$iv$iv.next();
            boolean bl4 = false;
            if (!(((List)entry.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$forEach$iv2;
            Object $this$getOrPut$iv$iv$iv;
            void $this$groupByTo$iv$iv2;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl3 = false;
            Object $this$groupBy$iv2 = (Iterable)entry.getValue();
            boolean $i$f$groupBy2 = false;
            Iterable bl4 = $this$groupBy$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv3 : $this$groupByTo$iv$iv2) {
                Object object3;
                Object element$iv22;
                block13: {
                    DaoMethod daoMethod = (DaoMethod)element$iv$iv3;
                    boolean bl5 = false;
                    Iterable $this$first$iv = databases;
                    boolean $i$f$first = false;
                    for (Object element$iv22 : $this$first$iv) {
                        androidx.room.vo.Database db = (androidx.room.vo.Database)element$iv22;
                        boolean bl6 = false;
                        if (!db.getDaoMethods().contains(daoMethod)) continue;
                        break block13;
                    }
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                androidx.room.vo.Database db = (androidx.room.vo.Database)element$iv22;
                String key$iv$iv = db.getTypeName().simpleName();
                $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl7 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv2 = (List)object3;
                list$iv$iv2.add(element$iv$iv3);
            }
            $this$groupBy$iv2 = destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            void var13_24 = $this$forEach$iv2;
            boolean bl8 = false;
            Iterator iterator3 = var13_24.entrySet().iterator();
            while (iterator3.hasNext()) {
                void dbName;
                Map.Entry element$iv3;
                Map.Entry $dstr$dbName$methods = element$iv3 = iterator3.next();
                boolean bl9 = false;
                Map.Entry bl5 = $dstr$dbName$methods;
                boolean $this$first$iv = false;
                String $i$f$first = (String)bl5.getKey();
                bl5 = $dstr$dbName$methods;
                $this$first$iv = false;
                List methods2 = (List)bl5.getValue();
                if (methods2.size() == 1) {
                    Dao dao = ((DaoMethod)CollectionsKt.first((List)methods2)).getDao();
                    void v3 = dbName;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"dbName");
                    dao.setSuffix((String)v3);
                    continue;
                }
                Iterable $this$forEachIndexed$iv = methods2;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void method;
                    int n = index$iv++;
                    boolean bl10 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    $this$getOrPut$iv$iv$iv = (DaoMethod)item$iv;
                    int index = n;
                    boolean bl11 = false;
                    method.getDao().setSuffix((String)dbName + '_' + index);
                }
            }
        }
    }

    @NotNull
    public BasicAnnotationProcessor.ProcessingStep asAutoCommonProcessor(@NotNull ProcessingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        return XProcessingStep.DefaultImpls.asAutoCommonProcessor((XProcessingStep)this, (ProcessingEnvironment)env);
    }

    public void executeInKsp(@NotNull XProcessingEnv env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        XProcessingStep.DefaultImpls.executeInKsp((XProcessingStep)this, (XProcessingEnv)env);
    }
}

