/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.RewriteQueriesToDropUnusedColumns;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XType;
import androidx.room.log.RLog;
import androidx.room.parser.expansion.ProjectionExpander;
import androidx.room.parser.optimization.RemoveUnusedColumnQueryRewriter;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.CustomConverterProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.QueryRewriter;
import androidx.room.processor.SuppressWarningProcessor;
import androidx.room.processor.cache.Cache;
import androidx.room.solver.TypeAdapterStore;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.vo.Warning;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 C2\u00020\u0001:\u0004ABCDB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B9\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u00102\u001a\u0002032\u0006\u0010\u001c\u001a\u00020\u001bJ,\u00104\u001a\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u00020705\"\u0004\b\u0000\u001062\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H609J\u001e\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020<2\u000e\b\u0002\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>J\f\u0010@\u001a\u00020\u000e*\u00020<H\u0002R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001b\u0010#\u001a\u00020$8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&R\u001d\u0010)\u001a\u0004\u0018\u00010*8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010(\u001a\u0004\b+\u0010,R\u001b\u0010.\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010(\u001a\u0004\b/\u00100R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Landroidx/room/processor/Context;", "", "processingEnv", "Landroidx/room/compiler/processing/XProcessingEnv;", "(Landroidx/room/compiler/processing/XProcessingEnv;)V", "logger", "Landroidx/room/log/RLog;", "typeConverters", "Landroidx/room/processor/CustomConverterProcessor$ProcessResult;", "inheritedAdapterStore", "Landroidx/room/solver/TypeAdapterStore;", "cache", "Landroidx/room/processor/cache/Cache;", "canRewriteQueriesToDropUnusedColumns", "", "(Landroidx/room/compiler/processing/XProcessingEnv;Landroidx/room/log/RLog;Landroidx/room/processor/CustomConverterProcessor$ProcessResult;Landroidx/room/solver/TypeAdapterStore;Landroidx/room/processor/cache/Cache;Z)V", "COMMON_TYPES", "Landroidx/room/processor/Context$CommonTypes;", "getCOMMON_TYPES", "()Landroidx/room/processor/Context$CommonTypes;", "getCache", "()Landroidx/room/processor/cache/Cache;", "checker", "Landroidx/room/preconditions/Checks;", "getChecker", "()Landroidx/room/preconditions/Checks;", "<set-?>", "Landroidx/room/verifier/DatabaseVerifier;", "databaseVerifier", "getDatabaseVerifier", "()Landroidx/room/verifier/DatabaseVerifier;", "getLogger", "()Landroidx/room/log/RLog;", "getProcessingEnv", "()Landroidx/room/compiler/processing/XProcessingEnv;", "queryRewriter", "Landroidx/room/processor/QueryRewriter;", "getQueryRewriter", "()Landroidx/room/processor/QueryRewriter;", "queryRewriter$delegate", "Lkotlin/Lazy;", "schemaOutFolder", "Ljava/io/File;", "getSchemaOutFolder", "()Ljava/io/File;", "schemaOutFolder$delegate", "typeAdapterStore", "getTypeAdapterStore", "()Landroidx/room/solver/TypeAdapterStore;", "typeAdapterStore$delegate", "attachDatabaseVerifier", "", "collectLogs", "Lkotlin/Pair;", "T", "Landroidx/room/log/RLog$CollectingMessager;", "handler", "Lkotlin/Function1;", "fork", "element", "Landroidx/room/compiler/processing/XElement;", "forceSuppressedWarnings", "", "Landroidx/room/vo/Warning;", "hasRemoveUnusedColumnsAnnotation", "BooleanProcessorOptions", "CommonTypes", "Companion", "ProcessorOptions", "room-compiler"})
public final class Context {
    @NotNull
    private final Checks checker;
    @NotNull
    private final CommonTypes COMMON_TYPES;
    @NotNull
    private final Lazy typeAdapterStore$delegate;
    @Nullable
    private DatabaseVerifier databaseVerifier;
    @NotNull
    private final Lazy queryRewriter$delegate;
    @Nullable
    private final Lazy schemaOutFolder$delegate;
    @NotNull
    private final XProcessingEnv processingEnv;
    @NotNull
    private final RLog logger;
    private final CustomConverterProcessor.ProcessResult typeConverters;
    private final TypeAdapterStore inheritedAdapterStore;
    @NotNull
    private final Cache cache;
    private final boolean canRewriteQueriesToDropUnusedColumns;
    @NotNull
    private static final Lazy ARG_OPTIONS$delegate;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Checks getChecker() {
        return this.checker;
    }

    @NotNull
    public final CommonTypes getCOMMON_TYPES() {
        return this.COMMON_TYPES;
    }

    @NotNull
    public final TypeAdapterStore getTypeAdapterStore() {
        Lazy lazy = this.typeAdapterStore$delegate;
        Context context = this;
        Object var3_3 = null;
        boolean bl = false;
        return (TypeAdapterStore)lazy.getValue();
    }

    @Nullable
    public final DatabaseVerifier getDatabaseVerifier() {
        return this.databaseVerifier;
    }

    @NotNull
    public final QueryRewriter getQueryRewriter() {
        Lazy lazy = this.queryRewriter$delegate;
        Context context = this;
        Object var3_3 = null;
        boolean bl = false;
        return (QueryRewriter)lazy.getValue();
    }

    public final void attachDatabaseVerifier(@NotNull DatabaseVerifier databaseVerifier) {
        Intrinsics.checkNotNullParameter((Object)databaseVerifier, (String)"databaseVerifier");
        boolean bl = this.databaseVerifier == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "database verifier is already set";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.databaseVerifier = databaseVerifier;
    }

    @Nullable
    public final File getSchemaOutFolder() {
        Lazy lazy = this.schemaOutFolder$delegate;
        Context context = this;
        Object var3_3 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    @NotNull
    public final <T> Pair<T, RLog.CollectingMessager> collectLogs(@NotNull Function1<? super Context, ? extends T> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        RLog.CollectingMessager collector = new RLog.CollectingMessager();
        Context subContext = new Context(this.processingEnv, new RLog(collector, this.logger.getSuppressedWarnings(), this.logger.getDefaultElement()), this.typeConverters, this.getTypeAdapterStore(), this.cache, this.canRewriteQueriesToDropUnusedColumns);
        subContext.databaseVerifier = this.databaseVerifier;
        Object result = handler.invoke((Object)subContext);
        return new Pair(result, (Object)collector);
    }

    @NotNull
    public final Context fork(@NotNull XElement element, @NotNull Set<? extends Warning> forceSuppressedWarnings) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(forceSuppressedWarnings, (String)"forceSuppressedWarnings");
        Set<Warning> suppressedWarnings = SuppressWarningProcessor.INSTANCE.getSuppressedWarnings(element);
        CustomConverterProcessor.ProcessResult processConvertersResult = CustomConverterProcessor.Companion.findConverters(this, element);
        boolean canReUseAdapterStore = processConvertersResult.getClasses().isEmpty();
        CustomConverterProcessor.ProcessResult subTypeConverters = canReUseAdapterStore ? this.typeConverters : processConvertersResult.plus(this.typeConverters);
        Set subSuppressedWarnings = SetsKt.plus((Set)SetsKt.plus(forceSuppressedWarnings, (Iterable)suppressedWarnings), (Iterable)this.logger.getSuppressedWarnings());
        Cache subCache = new Cache(this.cache, subTypeConverters.getClasses(), subSuppressedWarnings);
        boolean subCanRemoveUnusedColumns = this.canRewriteQueriesToDropUnusedColumns || this.hasRemoveUnusedColumnsAnnotation(element);
        Context subContext = new Context(this.processingEnv, new RLog(this.logger.getMessager(), subSuppressedWarnings, element), subTypeConverters, canReUseAdapterStore ? this.getTypeAdapterStore() : null, subCache, subCanRemoveUnusedColumns);
        subContext.databaseVerifier = this.databaseVerifier;
        return subContext;
    }

    public static /* synthetic */ Context fork$default(Context context, XElement xElement, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return context.fork(xElement, set);
    }

    private final boolean hasRemoveUnusedColumnsAnnotation(XElement $this$hasRemoveUnusedColumnsAnnotation) {
        boolean bl = $this$hasRemoveUnusedColumnsAnnotation.hasAnnotation(Reflection.getOrCreateKotlinClass(RewriteQueriesToDropUnusedColumns.class));
        boolean bl2 = false;
        boolean bl3 = false;
        boolean annotated = bl;
        boolean bl4 = false;
        if (annotated && BooleanProcessorOptions.EXPAND_PROJECTION.getValue(this.processingEnv)) {
            this.logger.w(Warning.EXPAND_PROJECTION_WITH_REMOVE_UNUSED_COLUMNS, $this$hasRemoveUnusedColumnsAnnotation, ProcessorErrors.INSTANCE.getEXPAND_PROJECTION_ALONG_WITH_REMOVE_UNUSED(), new Object[0]);
        }
        return bl;
    }

    @NotNull
    public final XProcessingEnv getProcessingEnv() {
        return this.processingEnv;
    }

    @NotNull
    public final RLog getLogger() {
        return this.logger;
    }

    @NotNull
    public final Cache getCache() {
        return this.cache;
    }

    private Context(XProcessingEnv processingEnv, RLog logger, CustomConverterProcessor.ProcessResult typeConverters, TypeAdapterStore inheritedAdapterStore, Cache cache, boolean canRewriteQueriesToDropUnusedColumns) {
        this.processingEnv = processingEnv;
        this.logger = logger;
        this.typeConverters = typeConverters;
        this.inheritedAdapterStore = inheritedAdapterStore;
        this.cache = cache;
        this.canRewriteQueriesToDropUnusedColumns = canRewriteQueriesToDropUnusedColumns;
        this.checker = new Checks(this.logger);
        this.COMMON_TYPES = new CommonTypes(this.processingEnv);
        this.typeAdapterStore$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TypeAdapterStore>(this){
            final /* synthetic */ Context this$0;

            @NotNull
            public final TypeAdapterStore invoke() {
                return Context.access$getInheritedAdapterStore$p(this.this$0) != null ? TypeAdapterStore.Companion.copy(this.this$0, Context.access$getInheritedAdapterStore$p(this.this$0)) : TypeAdapterStore.Companion.create(this.this$0, Context.access$getTypeConverters$p(this.this$0).getConverters());
            }
            {
                this.this$0 = context;
                super(0);
            }
        }));
        this.queryRewriter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<QueryRewriter>(this){
            final /* synthetic */ Context this$0;

            @NotNull
            public final QueryRewriter invoke() {
                DatabaseVerifier verifier = this.this$0.getDatabaseVerifier();
                return verifier == null ? QueryRewriter.Companion.getNoOpRewriter() : (Context.access$getCanRewriteQueriesToDropUnusedColumns$p(this.this$0) ? (QueryRewriter)RemoveUnusedColumnQueryRewriter.INSTANCE : (BooleanProcessorOptions.EXPAND_PROJECTION.getValue(this.this$0.getProcessingEnv()) ? (QueryRewriter)new ProjectionExpander(verifier.getEntitiesAndViews()) : QueryRewriter.Companion.getNoOpRewriter()));
            }
            {
                this.this$0 = context;
                super(0);
            }
        }));
        this.schemaOutFolder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ Context this$0;

            @Nullable
            public final File invoke() {
                boolean bl;
                String arg;
                String string = arg = (String)this.this$0.getProcessingEnv().getOptions().get(ProcessorOptions.OPTION_SCHEMA_FOLDER.getArgName());
                if (string != null) {
                    CharSequence charSequence = string;
                    boolean bl2 = false;
                    bl = charSequence.length() > 0;
                } else {
                    bl = false;
                }
                return bl ? new File(arg) : null;
            }
            {
                this.this$0 = context;
                super(0);
            }
        }));
    }

    public Context(@NotNull XProcessingEnv processingEnv) {
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        this(processingEnv, new RLog(processingEnv.getMessager(), SetsKt.emptySet(), null), CustomConverterProcessor.ProcessResult.EMPTY.INSTANCE, null, new Cache(null, new LinkedHashSet<XType>(), SetsKt.emptySet()), false);
    }

    static {
        Companion = new Companion(null);
        ARG_OPTIONS$delegate = LazyKt.lazy((Function0)Companion.ARG_OPTIONS.2.INSTANCE);
    }

    public static final /* synthetic */ TypeAdapterStore access$getInheritedAdapterStore$p(Context $this) {
        return $this.inheritedAdapterStore;
    }

    public static final /* synthetic */ CustomConverterProcessor.ProcessResult access$getTypeConverters$p(Context $this) {
        return $this.typeConverters;
    }

    public static final /* synthetic */ DatabaseVerifier access$getDatabaseVerifier$p(Context $this) {
        return $this.databaseVerifier;
    }

    public static final /* synthetic */ void access$setDatabaseVerifier$p(Context $this, DatabaseVerifier databaseVerifier) {
        $this.databaseVerifier = databaseVerifier;
    }

    public static final /* synthetic */ boolean access$getCanRewriteQueriesToDropUnusedColumns$p(Context $this) {
        return $this.canRewriteQueriesToDropUnusedColumns;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR\u001b\u0010\u000e\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Landroidx/room/processor/Context$CommonTypes;", "", "processingEnv", "Landroidx/room/compiler/processing/XProcessingEnv;", "(Landroidx/room/compiler/processing/XProcessingEnv;)V", "READONLY_COLLECTION", "Landroidx/room/compiler/processing/XType;", "getREADONLY_COLLECTION", "()Landroidx/room/compiler/processing/XType;", "READONLY_COLLECTION$delegate", "Lkotlin/Lazy;", "STRING", "getSTRING", "STRING$delegate", "VOID", "getVOID", "VOID$delegate", "getProcessingEnv", "()Landroidx/room/compiler/processing/XProcessingEnv;", "room-compiler"})
    public static final class CommonTypes {
        @NotNull
        private final Lazy VOID$delegate;
        @NotNull
        private final Lazy STRING$delegate;
        @NotNull
        private final Lazy READONLY_COLLECTION$delegate;
        @NotNull
        private final XProcessingEnv processingEnv;

        @NotNull
        public final XType getVOID() {
            Lazy lazy = this.VOID$delegate;
            CommonTypes commonTypes = this;
            Object var3_3 = null;
            boolean bl = false;
            return (XType)lazy.getValue();
        }

        @NotNull
        public final XType getSTRING() {
            Lazy lazy = this.STRING$delegate;
            CommonTypes commonTypes = this;
            Object var3_3 = null;
            boolean bl = false;
            return (XType)lazy.getValue();
        }

        @NotNull
        public final XType getREADONLY_COLLECTION() {
            Lazy lazy = this.READONLY_COLLECTION$delegate;
            CommonTypes commonTypes = this;
            Object var3_3 = null;
            boolean bl = false;
            return (XType)lazy.getValue();
        }

        @NotNull
        public final XProcessingEnv getProcessingEnv() {
            return this.processingEnv;
        }

        public CommonTypes(@NotNull XProcessingEnv processingEnv) {
            Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
            this.processingEnv = processingEnv;
            this.VOID$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
                final /* synthetic */ CommonTypes this$0;

                @NotNull
                public final XType invoke() {
                    return this.this$0.getProcessingEnv().requireType("java.lang.Void");
                }
                {
                    this.this$0 = commonTypes;
                    super(0);
                }
            }));
            this.STRING$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
                final /* synthetic */ CommonTypes this$0;

                @NotNull
                public final XType invoke() {
                    return this.this$0.getProcessingEnv().requireType("java.lang.String");
                }
                {
                    this.this$0 = commonTypes;
                    super(0);
                }
            }));
            this.READONLY_COLLECTION$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
                final /* synthetic */ CommonTypes this$0;

                @NotNull
                public final XType invoke() {
                    return this.this$0.getProcessingEnv().getBackend() == XProcessingEnv.Backend.KSP ? this.this$0.getProcessingEnv().requireType("kotlin.collections.Collection") : this.this$0.getProcessingEnv().requireType("java.util.Collection");
                }
                {
                    this.this$0 = commonTypes;
                    super(0);
                }
            }));
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Landroidx/room/processor/Context$ProcessorOptions;", "", "argName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getArgName", "()Ljava/lang/String;", "OPTION_SCHEMA_FOLDER", "room-compiler"})
    public static final class ProcessorOptions
    extends Enum<ProcessorOptions> {
        public static final /* enum */ ProcessorOptions OPTION_SCHEMA_FOLDER;
        private static final /* synthetic */ ProcessorOptions[] $VALUES;
        @NotNull
        private final String argName;

        static {
            ProcessorOptions[] processorOptionsArray = new ProcessorOptions[1];
            ProcessorOptions[] processorOptionsArray2 = processorOptionsArray;
            processorOptionsArray[0] = OPTION_SCHEMA_FOLDER = new ProcessorOptions("room.schemaLocation");
            $VALUES = processorOptionsArray;
        }

        @NotNull
        public final String getArgName() {
            return this.argName;
        }

        private ProcessorOptions(String argName) {
            this.argName = argName;
        }

        public static ProcessorOptions[] values() {
            return (ProcessorOptions[])$VALUES.clone();
        }

        public static ProcessorOptions valueOf(String string) {
            return Enum.valueOf(ProcessorOptions.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Landroidx/room/processor/Context$BooleanProcessorOptions;", "", "argName", "", "defaultValue", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getArgName", "()Ljava/lang/String;", "getValue", "processingEnv", "Landroidx/room/compiler/processing/XProcessingEnv;", "INCREMENTAL", "EXPAND_PROJECTION", "room-compiler"})
    public static final class BooleanProcessorOptions
    extends Enum<BooleanProcessorOptions> {
        public static final /* enum */ BooleanProcessorOptions INCREMENTAL;
        public static final /* enum */ BooleanProcessorOptions EXPAND_PROJECTION;
        private static final /* synthetic */ BooleanProcessorOptions[] $VALUES;
        @NotNull
        private final String argName;
        private final boolean defaultValue;

        static {
            BooleanProcessorOptions[] booleanProcessorOptionsArray = new BooleanProcessorOptions[2];
            BooleanProcessorOptions[] booleanProcessorOptionsArray2 = booleanProcessorOptionsArray;
            booleanProcessorOptionsArray[0] = INCREMENTAL = new BooleanProcessorOptions("room.incremental", true);
            booleanProcessorOptionsArray[1] = EXPAND_PROJECTION = new BooleanProcessorOptions("room.expandProjection", false);
            $VALUES = booleanProcessorOptionsArray;
        }

        public final boolean getValue(@NotNull XProcessingEnv processingEnv) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
            String value = (String)processingEnv.getOptions().get(this.argName);
            CharSequence charSequence = value;
            boolean bl2 = false;
            boolean bl3 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                bl = this.defaultValue;
            } else {
                charSequence = value;
                bl2 = false;
                bl = Boolean.parseBoolean((String)charSequence);
            }
            return bl;
        }

        @NotNull
        public final String getArgName() {
            return this.argName;
        }

        private BooleanProcessorOptions(String argName, boolean defaultValue) {
            this.argName = argName;
            this.defaultValue = defaultValue;
        }

        public static BooleanProcessorOptions[] values() {
            return (BooleanProcessorOptions[])$VALUES.clone();
        }

        public static BooleanProcessorOptions valueOf(String string) {
            return Enum.valueOf(BooleanProcessorOptions.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Landroidx/room/processor/Context$Companion;", "", "()V", "ARG_OPTIONS", "", "", "getARG_OPTIONS", "()Ljava/util/List;", "ARG_OPTIONS$delegate", "Lkotlin/Lazy;", "room-compiler"})
    public static final class Companion {
        @NotNull
        public final List<String> getARG_OPTIONS() {
            Lazy lazy = ARG_OPTIONS$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (List)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

