/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.ColumnInfo;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XFieldElement;
import androidx.room.compiler.processing.XType;
import androidx.room.parser.Collate;
import androidx.room.parser.SQLTypeAffinity;
import androidx.room.processor.Context;
import androidx.room.processor.FieldProcessor$WhenMappings;
import androidx.room.processor.FieldProcessorKt;
import androidx.room.processor.ProcessorErrors;
import androidx.room.solver.types.ColumnTypeAdapter;
import androidx.room.vo.EmbeddedField;
import androidx.room.vo.Field;
import com.squareup.javapoet.TypeName;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001*Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00126\u0010\f\u001a2\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\r\u00a2\u0006\u0002\u0010\u0015J&\u0010#\u001a\u0004\u0018\u00010\u00122\b\u0010$\u001a\u0004\u0018\u00010\u00122\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0002J\u0006\u0010)\u001a\u00020\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 RA\u0010\f\u001a2\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Landroidx/room/processor/FieldProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XType;", "element", "Landroidx/room/compiler/processing/XFieldElement;", "bindingScope", "Landroidx/room/processor/FieldProcessor$BindingScope;", "fieldParent", "Landroidx/room/vo/EmbeddedField;", "onBindingError", "Lkotlin/Function2;", "Landroidx/room/vo/Field;", "Lkotlin/ParameterName;", "name", "field", "", "errorMsg", "", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XFieldElement;Landroidx/room/processor/FieldProcessor$BindingScope;Landroidx/room/vo/EmbeddedField;Lkotlin/jvm/functions/Function2;)V", "getBindingScope", "()Landroidx/room/processor/FieldProcessor$BindingScope;", "getContaining", "()Landroidx/room/compiler/processing/XType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Landroidx/room/compiler/processing/XFieldElement;", "getFieldParent", "()Landroidx/room/vo/EmbeddedField;", "getOnBindingError", "()Lkotlin/jvm/functions/Function2;", "extractDefaultValue", "value", "affinity", "Landroidx/room/parser/SQLTypeAffinity;", "fieldNonNull", "", "process", "BindingScope", "room-compiler"})
public final class FieldProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final XType containing;
    @NotNull
    private final XFieldElement element;
    @NotNull
    private final BindingScope bindingScope;
    @Nullable
    private final EmbeddedField fieldParent;
    @NotNull
    private final Function2<Field, String, Unit> onBindingError;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final Field process() {
        SQLTypeAffinity sQLTypeAffinity;
        XType member = this.element.asMemberOf(this.containing);
        TypeName type = member.getTypeName();
        XAnnotationBox xAnnotationBox = this.element.toAnnotationBox(Reflection.getOrCreateKotlinClass(ColumnInfo.class));
        ColumnInfo columnInfo2 = xAnnotationBox != null ? (ColumnInfo)xAnnotationBox.getValue() : null;
        String name = this.element.getName();
        String rawCName = columnInfo2 != null && Intrinsics.areEqual((Object)columnInfo2.name(), (Object)"[field-name]") ^ true ? columnInfo2.name() : name;
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.fieldParent;
        if (object == null || (object = ((EmbeddedField)object).getPrefix()) == null) {
            object = "";
        }
        String columnName = stringBuilder.append((String)object).append(rawCName).toString();
        try {
            ColumnInfo columnInfo3 = columnInfo2;
            sQLTypeAffinity = SQLTypeAffinity.Companion.fromAnnotationValue(columnInfo3 != null ? Integer.valueOf(columnInfo3.typeAffinity()) : null);
        }
        catch (NumberFormatException ex) {
            sQLTypeAffinity = null;
        }
        SQLTypeAffinity affinity = sQLTypeAffinity;
        this.context.getChecker().notBlank(columnName, (XElement)this.element, ProcessorErrors.INSTANCE.getCOLUMN_NAME_CANNOT_BE_EMPTY(), new Object[0]);
        this.context.getChecker().notUnbound(type, (XElement)this.element, ProcessorErrors.INSTANCE.getCANNOT_USE_UNBOUND_GENERICS_IN_ENTITY_FIELDS(), new Object[0]);
        ColumnTypeAdapter adapter = this.context.getTypeAdapterStore().findColumnTypeAdapter(member, affinity, false);
        Object object2 = adapter;
        if (object2 == null || (object2 = object2.getTypeAffinity()) == null) {
            object2 = affinity;
        }
        Object adapterAffinity = object2;
        boolean nonNull = Field.Companion.calcNonNull(member, this.fieldParent);
        ColumnInfo columnInfo4 = columnInfo2;
        ColumnInfo columnInfo5 = columnInfo2;
        ColumnInfo columnInfo6 = columnInfo2;
        boolean bl = nonNull;
        boolean bl2 = columnInfo6 != null ? columnInfo6.index() : false;
        EmbeddedField embeddedField = this.fieldParent;
        String string = this.extractDefaultValue(columnInfo5 != null ? columnInfo5.defaultValue() : null, (SQLTypeAffinity)((Object)adapterAffinity), nonNull);
        Collate collate = Collate.Companion.fromAnnotationValue(columnInfo4 != null ? Integer.valueOf(columnInfo4.collate()) : null);
        SQLTypeAffinity sQLTypeAffinity2 = affinity;
        String string2 = columnName;
        XFieldElement xFieldElement = this.element;
        XType xType = member;
        String string3 = name;
        Field field = new Field(xFieldElement, string3, xType, sQLTypeAffinity2, collate, string2, string, embeddedField, bl2, bl);
        switch (FieldProcessor$WhenMappings.$EnumSwitchMapping$0[this.bindingScope.ordinal()]) {
            case 1: {
                field.setStatementBinder(adapter);
                field.setCursorValueReader(adapter);
                field.setAffinity((SQLTypeAffinity)((Object)adapterAffinity));
                if (adapter != null) break;
                this.onBindingError.invoke((Object)field, (Object)ProcessorErrors.INSTANCE.getCANNOT_FIND_COLUMN_TYPE_ADAPTER());
                break;
            }
            case 2: {
                field.setStatementBinder(this.context.getTypeAdapterStore().findStatementValueBinder(field.getType(), field.getAffinity()));
                if (field.getStatementBinder() != null) break;
                this.onBindingError.invoke((Object)field, (Object)ProcessorErrors.INSTANCE.getCANNOT_FIND_STMT_BINDER());
                break;
            }
            case 3: {
                field.setCursorValueReader(this.context.getTypeAdapterStore().findCursorValueReader(field.getType(), field.getAffinity()));
                if (field.getCursorValueReader() != null) break;
                this.onBindingError.invoke((Object)field, (Object)ProcessorErrors.INSTANCE.getCANNOT_FIND_CURSOR_READER());
                break;
            }
        }
        return field;
    }

    private final String extractDefaultValue(String value, SQLTypeAffinity affinity, boolean fieldNonNull) {
        String defaultValue;
        if (value == null) {
            return null;
        }
        String string = value;
        boolean bl = false;
        string = ((Object)StringsKt.trim((CharSequence)string)).toString();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        boolean bl2 = false;
        String string2 = string;
        boolean bl3 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        String trimmed = string4;
        String string5 = affinity == SQLTypeAffinity.TEXT ? (Intrinsics.areEqual((Object)value, (Object)"[value-unspecified]") ? null : (StringsKt.startsWith$default((String)trimmed, (String)"(", (boolean)false, (int)2, null) || FieldProcessorKt.getSQLITE_VALUE_CONSTANTS().contains(trimmed) ? value : '\'' + StringsKt.trim((String)value, (char[])new char[]{'\''}) + '\'')) : (defaultValue = Intrinsics.areEqual((Object)value, (Object)"[value-unspecified]") || Intrinsics.areEqual((Object)trimmed, (Object)"") ? null : value);
        if (Intrinsics.areEqual((Object)trimmed, (Object)"null") && fieldNonNull) {
            this.context.getLogger().e((XElement)this.element, "Use of NULL as the default value of a non-null field", new Object[0]);
        }
        return defaultValue;
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XFieldElement getElement() {
        return this.element;
    }

    @NotNull
    public final BindingScope getBindingScope() {
        return this.bindingScope;
    }

    @Nullable
    public final EmbeddedField getFieldParent() {
        return this.fieldParent;
    }

    @NotNull
    public final Function2<Field, String, Unit> getOnBindingError() {
        return this.onBindingError;
    }

    public FieldProcessor(@NotNull Context baseContext, @NotNull XType containing, @NotNull XFieldElement element, @NotNull BindingScope bindingScope, @Nullable EmbeddedField fieldParent, @NotNull Function2<? super Field, ? super String, Unit> onBindingError) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)bindingScope), (String)"bindingScope");
        Intrinsics.checkNotNullParameter(onBindingError, (String)"onBindingError");
        this.containing = containing;
        this.element = element;
        this.bindingScope = bindingScope;
        this.fieldParent = fieldParent;
        this.onBindingError = onBindingError;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, 2, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/room/processor/FieldProcessor$BindingScope;", "", "(Ljava/lang/String;I)V", "TWO_WAY", "BIND_TO_STMT", "READ_FROM_CURSOR", "room-compiler"})
    public static final class BindingScope
    extends Enum<BindingScope> {
        public static final /* enum */ BindingScope TWO_WAY;
        public static final /* enum */ BindingScope BIND_TO_STMT;
        public static final /* enum */ BindingScope READ_FROM_CURSOR;
        private static final /* synthetic */ BindingScope[] $VALUES;

        static {
            BindingScope[] bindingScopeArray = new BindingScope[3];
            BindingScope[] bindingScopeArray2 = bindingScopeArray;
            bindingScopeArray[0] = TWO_WAY = new BindingScope();
            bindingScopeArray[1] = BIND_TO_STMT = new BindingScope();
            bindingScopeArray[2] = READ_FROM_CURSOR = new BindingScope();
            $VALUES = bindingScopeArray;
        }

        public static BindingScope[] values() {
            return (BindingScope[])$VALUES.clone();
        }

        public static BindingScope valueOf(String string) {
            return Enum.valueOf(BindingScope.class, string);
        }
    }
}

