/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.SkipQueryVerification;
import androidx.room.Transaction;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.ext.Xtype_extKt;
import androidx.room.log.RLog;
import androidx.room.parser.ParsedQuery;
import androidx.room.parser.QueryType;
import androidx.room.parser.Section;
import androidx.room.parser.SqlParser;
import androidx.room.processor.Context;
import androidx.room.processor.MethodProcessorDelegate;
import androidx.room.processor.ProcessorErrors;
import androidx.room.solver.prepared.binder.PreparedQueryResultBinder;
import androidx.room.solver.query.result.PojoRowAdapter;
import androidx.room.solver.query.result.QueryResultAdapter;
import androidx.room.solver.query.result.QueryResultBinder;
import androidx.room.solver.query.result.RowAdapter;
import androidx.room.verifier.DatabaseVerificationErrors;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.verifier.QueryResultInfo;
import androidx.room.vo.QueryMethod;
import androidx.room.vo.QueryParameter;
import androidx.room.vo.ReadQueryMethod;
import androidx.room.vo.Warning;
import androidx.room.vo.WriteQueryMethod;
import com.squareup.javapoet.TypeName;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Landroidx/room/processor/InternalQueryProcessor;", "", "context", "Landroidx/room/processor/Context;", "executableElement", "Landroidx/room/compiler/processing/XMethodElement;", "containing", "Landroidx/room/compiler/processing/XType;", "dbVerifier", "Landroidx/room/verifier/DatabaseVerifier;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XMethodElement;Landroidx/room/compiler/processing/XType;Landroidx/room/verifier/DatabaseVerifier;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "getContext", "()Landroidx/room/processor/Context;", "getDbVerifier", "()Landroidx/room/verifier/DatabaseVerifier;", "getExecutableElement", "()Landroidx/room/compiler/processing/XMethodElement;", "getPreparedQueryMethod", "Landroidx/room/vo/WriteQueryMethod;", "delegate", "Landroidx/room/processor/MethodProcessorDelegate;", "returnType", "query", "Landroidx/room/parser/ParsedQuery;", "getQueryMethod", "Landroidx/room/vo/QueryMethod;", "processQuery", "input", "", "processQueryMethod", "queryMethod", "validateQuery", "", "Companion", "room-compiler"})
final class InternalQueryProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final XMethodElement executableElement;
    @NotNull
    private final XType containing;
    @Nullable
    private final DatabaseVerifier dbVerifier;
    @NotNull
    private static final QueryType[] PREPARED_TYPES;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final QueryMethod processQuery(@Nullable String input) {
        ParsedQuery parsedQuery;
        MethodProcessorDelegate delegate = MethodProcessorDelegate.Companion.createFor(this.context, this.containing, this.executableElement);
        XType returnType = delegate.extractReturnType();
        if (input != null) {
            ParsedQuery query2 = SqlParser.Companion.parse(input);
            this.context.getChecker().check(query2.getErrors().isEmpty(), (XElement)this.executableElement, CollectionsKt.joinToString$default((Iterable)query2.getErrors(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new Object[0]);
            this.validateQuery(query2);
            this.context.getChecker().check(Xtype_extKt.isNotError(returnType), (XElement)this.executableElement, ProcessorErrors.INSTANCE.getCANNOT_RESOLVE_RETURN_TYPE(), this.executableElement);
            parsedQuery = query2;
        } else {
            parsedQuery = ParsedQuery.Companion.getMISSING();
        }
        ParsedQuery query3 = parsedQuery;
        TypeName returnTypeName = returnType.getTypeName();
        this.context.getChecker().notUnbound(returnTypeName, (XElement)this.executableElement, ProcessorErrors.INSTANCE.getCANNOT_USE_UNBOUND_GENERICS_IN_QUERY_METHODS(), new Object[0]);
        boolean isPreparedQuery = ArraysKt.contains((Object[])PREPARED_TYPES, (Object)((Object)query3.getType()));
        QueryMethod queryMethod = isPreparedQuery ? (QueryMethod)this.getPreparedQueryMethod(delegate, returnType, query3) : this.getQueryMethod(delegate, returnType, query3);
        return this.processQueryMethod(queryMethod);
    }

    /*
     * WARNING - void declaration
     */
    private final QueryMethod processQueryMethod(QueryMethod queryMethod) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        String string;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Pair it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = queryMethod.getSectionToParamMapping();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(it.getSecond() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = ((Section.BindVar)it.getFirst()).getText();
            collection.add(string);
        }
        List missing = (List)destination$iv$iv;
        $this$map$iv2 = missing;
        $i$f$map = false;
        if (!$this$map$iv2.isEmpty()) {
            this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.missingParameterForBindVariable(missing), new Object[0]);
        }
        Iterable $this$filterNot$iv = queryMethod.getParameters();
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl;
            block9: {
                QueryParameter param = (QueryParameter)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = queryMethod.getSectionToParamMapping();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Pair it2 = (Pair)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)((QueryParameter)it2.getSecond()), (Object)param)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object param = item$iv$iv = iterator.next();
            collection = destination$iv$iv2;
            boolean bl = false;
            string = ((QueryParameter)receiver).getSqlName();
            collection.add(string);
        }
        List unused = (List)destination$iv$iv2;
        Collection collection2 = unused;
        boolean bl = false;
        if (!collection2.isEmpty()) {
            this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.unusedQueryMethodParameter(unused), new Object[0]);
        }
        return queryMethod;
    }

    private final void validateQuery(ParsedQuery query2) {
        boolean skipQueryVerification = this.executableElement.hasAnnotation(Reflection.getOrCreateKotlinClass(SkipQueryVerification.class));
        if (skipQueryVerification) {
            return;
        }
        DatabaseVerifier databaseVerifier = this.dbVerifier;
        query2.setResultInfo(databaseVerifier != null ? databaseVerifier.analyze(query2.getOriginal()) : null);
        QueryResultInfo queryResultInfo = query2.getResultInfo();
        if ((queryResultInfo != null ? queryResultInfo.getError() : null) != null) {
            RLog rLog = this.context.getLogger();
            XElement xElement = (XElement)this.executableElement;
            QueryResultInfo queryResultInfo2 = query2.getResultInfo();
            Intrinsics.checkNotNull((Object)queryResultInfo2);
            SQLException sQLException = queryResultInfo2.getError();
            Intrinsics.checkNotNull((Object)sQLException);
            rLog.e(xElement, DatabaseVerificationErrors.INSTANCE.cannotVerifyQuery(sQLException), new Object[0]);
        }
    }

    private final WriteQueryMethod getPreparedQueryMethod(MethodProcessorDelegate delegate, XType returnType, ParsedQuery query2) {
        PreparedQueryResultBinder resultBinder = delegate.findPreparedResultBinder(returnType, query2);
        this.context.getChecker().check(resultBinder.getAdapter() != null, (XElement)this.executableElement, ProcessorErrors.INSTANCE.cannotFindPreparedQueryResultAdapter(returnType.toString(), query2.getType()), new Object[0]);
        List<QueryParameter> parameters = delegate.extractQueryParams(query2);
        return new WriteQueryMethod(this.executableElement, query2, this.executableElement.getName(), returnType, parameters, resultBinder);
    }

    private final QueryMethod getQueryMethod(MethodProcessorDelegate delegate, XType returnType, ParsedQuery query2) {
        QueryResultBinder resultBinder = delegate.findResultBinder(returnType, query2);
        QueryResultAdapter queryResultAdapter = resultBinder.getAdapter();
        RowAdapter rowAdapter = queryResultAdapter != null ? queryResultAdapter.getRowAdapter() : null;
        this.context.getChecker().check(resultBinder.getAdapter() != null, (XElement)this.executableElement, ProcessorErrors.INSTANCE.cannotFindQueryResultAdapter(returnType.getTypeName()), new Object[0]);
        boolean inTransaction = this.executableElement.hasAnnotation(Reflection.getOrCreateKotlinClass(Transaction.class));
        if (query2.getType() == QueryType.SELECT && !inTransaction && rowAdapter instanceof PojoRowAdapter) {
            Collection collection = ((PojoRowAdapter)rowAdapter).getRelationCollectors();
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.context.getLogger().w(Warning.RELATION_QUERY_WITHOUT_TRANSACTION, (XElement)this.executableElement, ProcessorErrors.INSTANCE.getTRANSACTION_MISSING_ON_RELATION(), new Object[0]);
            }
        }
        List<QueryParameter> parameters = delegate.extractQueryParams(query2);
        return new ReadQueryMethod(this.executableElement, query2, this.executableElement.getName(), returnType, parameters, inTransaction, resultBinder);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final XMethodElement getExecutableElement() {
        return this.executableElement;
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @Nullable
    public final DatabaseVerifier getDbVerifier() {
        return this.dbVerifier;
    }

    public InternalQueryProcessor(@NotNull Context context, @NotNull XMethodElement executableElement, @NotNull XType containing, @Nullable DatabaseVerifier dbVerifier) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)executableElement, (String)"executableElement");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        this.context = context;
        this.executableElement = executableElement;
        this.containing = containing;
        this.dbVerifier = dbVerifier;
    }

    public /* synthetic */ InternalQueryProcessor(Context context, XMethodElement xMethodElement, XType xType, DatabaseVerifier databaseVerifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            databaseVerifier = null;
        }
        this(context, xMethodElement, xType, databaseVerifier);
    }

    static {
        Companion = new Companion(null);
        PREPARED_TYPES = new QueryType[]{QueryType.INSERT, QueryType.DELETE, QueryType.UPDATE};
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Landroidx/room/processor/InternalQueryProcessor$Companion;", "", "()V", "PREPARED_TYPES", "", "Landroidx/room/parser/QueryType;", "getPREPARED_TYPES", "()[Landroidx/room/parser/QueryType;", "[Landroidx/room/parser/QueryType;", "room-compiler"})
    public static final class Companion {
        @NotNull
        public final QueryType[] getPREPARED_TYPES() {
            return PREPARED_TYPES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

