/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import androidx.room.migration.bundle.DatabaseBundle;
import androidx.room.migration.bundle.EntityBundle;
import androidx.room.migration.bundle.FieldBundle;
import androidx.room.processor.ProcessorErrors;
import androidx.room.util.DiffException;
import androidx.room.util.SchemaDiffResult;
import androidx.room.vo.AutoMigrationResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000f"}, d2={"Landroidx/room/util/SchemaDiffer;", "", "fromSchemaBundle", "Landroidx/room/migration/bundle/DatabaseBundle;", "toSchemaBundle", "(Landroidx/room/migration/bundle/DatabaseBundle;Landroidx/room/migration/bundle/DatabaseBundle;)V", "getFromSchemaBundle", "()Landroidx/room/migration/bundle/DatabaseBundle;", "getToSchemaBundle", "diffError", "", "errorMsg", "", "diffSchemas", "Landroidx/room/util/SchemaDiffResult;", "room-compiler"})
public final class SchemaDiffer {
    @NotNull
    private final DatabaseBundle fromSchemaBundle;
    @NotNull
    private final DatabaseBundle toSchemaBundle;

    @NotNull
    public final SchemaDiffResult diffSchemas() {
        FieldBundle match;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Map.Entry element$iv;
        boolean bl = false;
        List addedTables = new ArrayList();
        boolean bl2 = false;
        List removedTables = new ArrayList();
        boolean bl3 = false;
        List addedColumns = new ArrayList();
        boolean bl4 = false;
        List changedColumns = new ArrayList();
        boolean bl5 = false;
        List removedColumns = new ArrayList();
        Map map2 = this.fromSchemaBundle.getEntitiesByTableName();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"fromSchemaBundle.entitiesByTableName");
        Object $this$forEach$iv2 = map2;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv2;
        boolean bl6 = false;
        Iterator iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry v1Table = element$iv = iterator2.next();
            boolean bl7 = false;
            EntityBundle v2Table = (EntityBundle)this.toSchemaBundle.getEntitiesByTableName().get(v1Table.getKey());
            if (v2Table == null) {
                Object v = v1Table.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"v1Table.value");
                removedTables.add(new AutoMigrationResult.RemovedTable((EntityBundle)v));
                continue;
            }
            Object v = v1Table.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"v1Table.value");
            Map v1Columns = ((EntityBundle)v).getFieldsByColumnName();
            Map v2Columns = v2Table.getFieldsByColumnName();
            $this$forEach$iv = v1Columns.entrySet();
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Map.Entry v1Column = (Map.Entry)element$iv2;
                boolean bl8 = false;
                match = (FieldBundle)v2Columns.get(v1Column.getKey());
                if (match != null && !match.isSchemaEqual((FieldBundle)v1Column.getValue())) {
                    Object k = v1Table.getKey();
                    Intrinsics.checkNotNullExpressionValue(k, (String)"v1Table.key");
                    String string = (String)k;
                    Object v2 = v1Column.getValue();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"v1Column.value");
                    changedColumns.add(new AutoMigrationResult.ChangedColumn(string, (FieldBundle)v2, match));
                    continue;
                }
                if (match != null) continue;
                Object k = v1Table.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"v1Table.key");
                String string = (String)k;
                Object v3 = v1Column.getValue();
                Intrinsics.checkNotNullExpressionValue(v3, (String)"v1Column.value");
                removedColumns.add(new AutoMigrationResult.RemovedColumn(string, (FieldBundle)v3));
            }
        }
        Map map3 = this.toSchemaBundle.getEntitiesByTableName();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"toSchemaBundle.entitiesByTableName");
        $this$forEach$iv2 = map3;
        $i$f$forEach2 = false;
        iterator = $this$forEach$iv2;
        bl6 = false;
        iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry v2Table = element$iv = iterator2.next();
            boolean bl9 = false;
            EntityBundle v1Table = (EntityBundle)this.fromSchemaBundle.getEntitiesByTableName().get(v2Table.getKey());
            if (v1Table == null) {
                Object v = v2Table.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"v2Table.value");
                addedTables.add(new AutoMigrationResult.AddedTable((EntityBundle)v));
                continue;
            }
            Object v = v2Table.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"v2Table.value");
            Map v2Columns = ((EntityBundle)v).getFieldsByColumnName();
            Map v1Columns = v1Table.getFieldsByColumnName();
            $this$forEach$iv = v2Columns.entrySet();
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Map.Entry v2Column = (Map.Entry)element$iv2;
                boolean bl10 = false;
                match = (FieldBundle)v1Columns.get(v2Column.getKey());
                if (match != null) continue;
                Object v4 = v2Column.getValue();
                Intrinsics.checkNotNullExpressionValue(v4, (String)"v2Column.value");
                if (((FieldBundle)v4).isNonNull()) {
                    Object v5 = v2Column.getValue();
                    Intrinsics.checkNotNullExpressionValue(v5, (String)"v2Column.value");
                    if (((FieldBundle)v5).getDefaultValue() == null) {
                        Object k = v2Column.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, (String)"v2Column.key");
                        this.diffError(ProcessorErrors.INSTANCE.newNotNullColumnMustHaveDefaultValue((String)k));
                    }
                }
                Object k = v2Table.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"v2Table.key");
                String string = (String)k;
                Object v6 = v2Column.getValue();
                Intrinsics.checkNotNullExpressionValue(v6, (String)"v2Column.value");
                addedColumns.add(new AutoMigrationResult.AddedColumn(string, (FieldBundle)v6));
            }
        }
        $this$forEach$iv2 = changedColumns;
        $i$f$forEach2 = false;
        if (!$this$forEach$iv2.isEmpty()) {
            $this$forEach$iv2 = changedColumns;
            $i$f$forEach2 = false;
            iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                Object element$iv3 = iterator.next();
                AutoMigrationResult.ChangedColumn changedColumn = (AutoMigrationResult.ChangedColumn)element$iv3;
                boolean bl11 = false;
                String string = changedColumn.getOriginalFieldBundle().getColumnName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"changedColumn.originalFieldBundle.columnName");
                this.diffError(ProcessorErrors.INSTANCE.columnWithChangedSchemaFound(string));
            }
        }
        $this$forEach$iv2 = removedColumns;
        $i$f$forEach2 = false;
        if (!$this$forEach$iv2.isEmpty()) {
            $this$forEach$iv2 = removedColumns;
            $i$f$forEach2 = false;
            iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                Object element$iv4 = iterator.next();
                AutoMigrationResult.RemovedColumn removedColumn = (AutoMigrationResult.RemovedColumn)element$iv4;
                boolean bl12 = false;
                String string = removedColumn.getFieldBundle().getColumnName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removedColumn.fieldBundle.columnName");
                this.diffError(ProcessorErrors.INSTANCE.removedOrRenamedColumnFound(string));
            }
        }
        $this$forEach$iv2 = removedTables;
        $i$f$forEach2 = false;
        if (!$this$forEach$iv2.isEmpty()) {
            $this$forEach$iv2 = removedTables;
            $i$f$forEach2 = false;
            iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                Object element$iv5 = iterator.next();
                AutoMigrationResult.RemovedTable removedTable = (AutoMigrationResult.RemovedTable)element$iv5;
                boolean bl13 = false;
                String string = removedTable.getEntityBundle().getTableName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removedTable.entityBundle.tableName");
                this.diffError(ProcessorErrors.INSTANCE.removedOrRenamedTableFound(string));
            }
        }
        return new SchemaDiffResult(addedColumns, changedColumns, removedColumns, addedTables, removedTables);
    }

    private final void diffError(String errorMsg) {
        throw (Throwable)new DiffException(errorMsg);
    }

    @NotNull
    public final DatabaseBundle getFromSchemaBundle() {
        return this.fromSchemaBundle;
    }

    @NotNull
    public final DatabaseBundle getToSchemaBundle() {
        return this.toSchemaBundle;
    }

    public SchemaDiffer(@NotNull DatabaseBundle fromSchemaBundle, @NotNull DatabaseBundle toSchemaBundle) {
        Intrinsics.checkNotNullParameter((Object)fromSchemaBundle, (String)"fromSchemaBundle");
        Intrinsics.checkNotNullParameter((Object)toSchemaBundle, (String)"toSchemaBundle");
        this.fromSchemaBundle = fromSchemaBundle;
        this.toSchemaBundle = toSchemaBundle;
    }
}

