/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.verifier;

import androidx.room.verifier.NativeSQLiteLoader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.sqlite.SQLiteJDBCLoader;
import org.sqlite.util.OSInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\fH\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0007J\b\u0010\u001c\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Landroidx/room/verifier/NativeSQLiteLoader;", "", "()V", "loaded", "", "tempDir", "Ljava/io/File;", "getTempDir", "()Ljava/io/File;", "tempDir$delegate", "Lkotlin/Lazy;", "version", "", "getVersion", "()Ljava/lang/String;", "version$delegate", "cleanupTempFolder", "", "extractNativeLibrary", "libraryPath", "libraryName", "targetDirPath", "getResourceAsStream", "Ljava/io/InputStream;", "name", "hasResource", "path", "load", "loadNativeLibrary", "room-compiler"})
public final class NativeSQLiteLoader {
    @NotNull
    public static final NativeSQLiteLoader INSTANCE = new NativeSQLiteLoader();
    private static boolean loaded;
    @NotNull
    private static final Lazy tempDir$delegate;
    @NotNull
    private static final Lazy version$delegate;

    private NativeSQLiteLoader() {
    }

    private final File getTempDir() {
        Lazy lazy = tempDir$delegate;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    private final String getVersion() {
        Lazy lazy = version$delegate;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-version>(...)");
        return (String)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void load() {
        Boolean bl = loaded;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (bl) {
            boolean bl4 = false;
            if (loaded) {
                return;
            }
            try {
                INSTANCE.cleanupTempFolder();
                INSTANCE.loadNativeLibrary();
                Field field = SQLiteJDBCLoader.class.getDeclaredField("extracted");
                boolean bl5 = false;
                boolean bl6 = false;
                Field $this$load_u24lambda_u2d1_u24lambda_u2d0 = field;
                boolean bl7 = false;
                $this$load_u24lambda_u2d1_u24lambda_u2d0.trySetAccessible();
                field.set(null, true);
            }
            catch (Exception ex) {
                new RuntimeException("Failed to load native SQLite library, will try again though.", ex).printStackTrace();
                SQLiteJDBCLoader.initialize();
            }
            loaded = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void cleanupTempFolder() {
        File[] fileArray = this.getTempDir().listFiles(cleanupTempFolder.1.INSTANCE);
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            File[] fileArray2 = $this$forEach$iv;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File libFile = element$iv = fileArray2[i];
                boolean bl = false;
                File lckFile = new File(Intrinsics.stringPlus((String)libFile.getAbsolutePath(), (Object)".lck"));
                if (lckFile.exists()) continue;
                libFile.delete();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void loadNativeLibrary() {
        block7: {
            block6: {
                var2_1 = SQLiteJDBCLoader.class.getPackage().getName();
                Intrinsics.checkNotNullExpressionValue((Object)var2_1, (String)"SQLiteJDBCLoader::class.java.getPackage().name");
                packagePath = StringsKt.replace$default((String)var2_1, (String)".", (String)"/", (boolean)false, (int)4, null);
                nativeLibraryPath = '/' + packagePath + "/native/" + OSInfo.getNativeLibFolderPathForCurrentOS();
                var4_3 = this;
                var5_4 = false;
                var6_7 = false;
                it = var4_3;
                $i$a$-let-NativeSQLiteLoader$loadNativeLibrary$nativeLibraryName$1 = false;
                var9_11 = System.mapLibraryName("sqlitejdbc");
                var10_12 = false;
                var11_13 = false;
                $this$loadNativeLibrary_u24lambda_u2d4_u24lambda_u2d3 = var9_11;
                $i$a$-apply-NativeSQLiteLoader$loadNativeLibrary$nativeLibraryName$1$libName$1 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$loadNativeLibrary_u24lambda_u2d4_u24lambda_u2d3, (String)"");
                StringsKt.replace$default((String)$this$loadNativeLibrary_u24lambda_u2d4_u24lambda_u2d3, (String)"dylib", (String)"jnilib", (boolean)false, (int)4, null);
                libName = var9_11;
                if (!NativeSQLiteLoader.INSTANCE.hasResource(nativeLibraryPath + '/' + libName)) break block6;
                v0 = libName;
                break block7;
            }
            if (!Intrinsics.areEqual((Object)OSInfo.getOSName(), (Object)"Mac")) ** GOTO lbl-1000
            altLibName = "libsqlitejdbc.jnilib";
            if (NativeSQLiteLoader.INSTANCE.hasResource(nativeLibraryPath + '/' + altLibName)) {
                v0 = altLibName;
            } else lbl-1000:
            // 2 sources

            {
                var9_11 = "No native library is found for os.name=" + OSInfo.getOSName() + " and os.arch=" + OSInfo.getArchName() + ". path=" + nativeLibraryPath;
                var10_12 = false;
                throw (Throwable)new IllegalStateException(var9_11.toString());
            }
        }
        nativeLibraryName = v0;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)nativeLibraryName, (String)"nativeLibraryName");
            var5_5 = this.getTempDir().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)var5_5, (String)"tempDir.absolutePath");
            var5_5 = this.extractNativeLibrary(nativeLibraryPath, nativeLibraryName, (String)var5_5);
        }
        catch (IOException ex) {
            throw new RuntimeException("Couldn't extract native SQLite library.", ex);
        }
        extractedNativeLibraryFile = var5_5;
        try {
            System.load(extractedNativeLibraryFile.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError ex) {
            throw new RuntimeException("Couldn't load native SQLite library.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File extractNativeLibrary(String libraryPath, String libraryName, String targetDirPath) {
        String libraryFilePath = libraryPath + '/' + libraryName;
        File file = new File(targetDirPath, "sqlite-" + this.getVersion() + '-' + UUID.randomUUID() + '-' + libraryName);
        boolean bl = false;
        boolean bl2 = false;
        File $this$extractNativeLibrary_u24lambda_u2d5 = file;
        boolean bl3 = false;
        $this$extractNativeLibrary_u24lambda_u2d5.deleteOnExit();
        File outputLibraryFile = file;
        Object object = new File(targetDirPath, Intrinsics.stringPlus((String)outputLibraryFile.getName(), (Object)".lck"));
        bl2 = false;
        boolean bl4 = false;
        File $this$extractNativeLibrary_u24lambda_u2d6 = object;
        boolean bl5 = false;
        $this$extractNativeLibrary_u24lambda_u2d6.deleteOnExit();
        File outputLibraryLckFile = object;
        if (!outputLibraryLckFile.exists()) {
            object = outputLibraryLckFile;
            bl2 = false;
            new FileOutputStream((File)object).close();
        }
        object = this.getResourceAsStream(libraryFilePath);
        bl2 = false;
        bl4 = false;
        Throwable throwable = null;
        try {
            long l;
            InputStream inputStream = (InputStream)object;
            boolean bl6 = false;
            Object object2 = outputLibraryFile;
            boolean bl7 = false;
            object2 = new FileOutputStream((File)object2);
            bl7 = false;
            boolean bl8 = false;
            Throwable throwable2 = null;
            try {
                FileOutputStream outputStream = (FileOutputStream)object2;
                boolean bl9 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        outputLibraryFile.setReadable(true);
        outputLibraryFile.setExecutable(true);
        return outputLibraryFile;
    }

    private final boolean hasResource(String path) {
        return SQLiteJDBCLoader.class.getResource(path) != null;
    }

    private final InputStream getResourceAsStream(String name) {
        String resolvedName = StringsKt.drop((String)name, (int)1);
        Object object = SQLiteJDBCLoader.class.getClassLoader().getResource(resolvedName);
        if (object == null) {
            throw new IOException("Resource '" + resolvedName + "' could not be found.");
        }
        URL url = object;
        URLConnection uRLConnection = url.openConnection();
        boolean bl = false;
        boolean bl2 = false;
        URLConnection $this$getResourceAsStream_u24lambda_u2d9 = uRLConnection;
        boolean bl3 = false;
        $this$getResourceAsStream_u24lambda_u2d9.setDefaultUseCaches(false);
        object = uRLConnection.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"url.openConnection().apply {\n            defaultUseCaches = false\n        }.getInputStream()");
        return object;
    }

    public static final /* synthetic */ String access$getVersion(NativeSQLiteLoader $this) {
        return $this.getVersion();
    }

    static {
        tempDir$delegate = LazyKt.lazy((Function0)tempDir.2.INSTANCE);
        version$delegate = LazyKt.lazy((Function0)version.2.INSTANCE);
    }
}

