/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.vo;

import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.migration.bundle.DatabaseViewBundle;
import androidx.room.parser.ParsedQuery;
import androidx.room.vo.Constructor;
import androidx.room.vo.EmbeddedField;
import androidx.room.vo.EntityOrView;
import androidx.room.vo.Field;
import androidx.room.vo.HasSchemaIdentity;
import androidx.room.vo.Pojo;
import androidx.room.vo.SchemaIdentityKey;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BK\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\"\u001a\u00020\u0007H\u0016J\u0006\u0010#\u001a\u00020$R\u001b\u0010\u0014\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0016\u00a8\u0006%"}, d2={"Landroidx/room/vo/DatabaseView;", "Landroidx/room/vo/Pojo;", "Landroidx/room/vo/HasSchemaIdentity;", "Landroidx/room/vo/EntityOrView;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "viewName", "", "query", "Landroidx/room/parser/ParsedQuery;", "type", "Landroidx/room/compiler/processing/XType;", "fields", "", "Landroidx/room/vo/Field;", "embeddedFields", "Landroidx/room/vo/EmbeddedField;", "constructor", "Landroidx/room/vo/Constructor;", "(Landroidx/room/compiler/processing/XTypeElement;Ljava/lang/String;Landroidx/room/parser/ParsedQuery;Landroidx/room/compiler/processing/XType;Ljava/util/List;Ljava/util/List;Landroidx/room/vo/Constructor;)V", "createViewQuery", "getCreateViewQuery", "()Ljava/lang/String;", "createViewQuery$delegate", "Lkotlin/Lazy;", "getQuery", "()Landroidx/room/parser/ParsedQuery;", "tableName", "getTableName", "tables", "", "getTables", "()Ljava/util/Set;", "getViewName", "getIdKey", "toBundle", "Landroidx/room/migration/bundle/DatabaseViewBundle;", "room-compiler"})
public final class DatabaseView
extends Pojo
implements HasSchemaIdentity,
EntityOrView {
    @NotNull
    private final String viewName;
    @NotNull
    private final ParsedQuery query;
    @NotNull
    private final String tableName;
    @NotNull
    private final Lazy createViewQuery$delegate;
    @NotNull
    private final Set<String> tables;

    public DatabaseView(@NotNull XTypeElement element, @NotNull String viewName, @NotNull ParsedQuery query2, @NotNull XType type, @NotNull List<Field> fields, @NotNull List<EmbeddedField> embeddedFields, @Nullable Constructor constructor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)viewName, (String)"viewName");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter(embeddedFields, (String)"embeddedFields");
        super(element, type, fields, embeddedFields, CollectionsKt.emptyList(), constructor);
        this.viewName = viewName;
        this.query = query2;
        this.tableName = this.viewName;
        this.createViewQuery$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DatabaseView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return DatabaseView.access$createViewQuery(this.this$0, this.this$0.getViewName());
            }
        }));
        boolean bl = false;
        this.tables = new LinkedHashSet();
    }

    @NotNull
    public final String getViewName() {
        return this.viewName;
    }

    @NotNull
    public final ParsedQuery getQuery() {
        return this.query;
    }

    @Override
    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @NotNull
    public final String getCreateViewQuery() {
        Lazy lazy = this.createViewQuery$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @NotNull
    public final Set<String> getTables() {
        return this.tables;
    }

    @NotNull
    public final DatabaseViewBundle toBundle() {
        return new DatabaseViewBundle(this.viewName, this.createViewQuery("${VIEW_NAME}"));
    }

    @Override
    @NotNull
    public String getIdKey() {
        SchemaIdentityKey identityKey = new SchemaIdentityKey();
        identityKey.append(this.query.getOriginal());
        String string = identityKey.hash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"identityKey.hash()");
        return string;
    }

    private final String createViewQuery(String viewName) {
        String string = this.query.getOriginal();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return "CREATE VIEW `" + viewName + "` AS " + ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    public static final /* synthetic */ String access$createViewQuery(DatabaseView $this, String viewName) {
        return $this.createViewQuery(viewName);
    }
}

