/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.vo;

import androidx.room.migration.bundle.IndexBundle;
import androidx.room.vo.Field;
import androidx.room.vo.Fields;
import androidx.room.vo.HasFields;
import androidx.room.vo.HasFieldsKt;
import androidx.room.vo.HasSchemaIdentity;
import androidx.room.vo.Index;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B%\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u000bH\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u000bH\u00c6\u0001J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u0013\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u0006\u0010\u001f\u001a\u00020 J\t\u0010!\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Landroidx/room/vo/Index;", "Landroidx/room/vo/HasSchemaIdentity;", "Landroidx/room/vo/HasFields;", "name", "", "unique", "", "fields", "", "Landroidx/room/vo/Field;", "(Ljava/lang/String;ZLjava/util/List;)V", "Landroidx/room/vo/Fields;", "(Ljava/lang/String;ZLandroidx/room/vo/Fields;)V", "getFields", "()Landroidx/room/vo/Fields;", "getName", "()Ljava/lang/String;", "getUnique", "()Z", "component1", "component2", "component3", "copy", "createQuery", "tableName", "equals", "other", "", "getIdKey", "hashCode", "", "toBundle", "Landroidx/room/migration/bundle/IndexBundle;", "toString", "Companion", "room-compiler"})
public final class Index
implements HasSchemaIdentity,
HasFields {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final boolean unique;
    @NotNull
    private final Fields fields;
    @NotNull
    public static final String DEFAULT_PREFIX = "index_";

    public Index(@NotNull String name, boolean unique, @NotNull Fields fields) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        this.name = name;
        this.unique = unique;
        this.fields = fields;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean getUnique() {
        return this.unique;
    }

    @Override
    @NotNull
    public Fields getFields() {
        return this.fields;
    }

    public Index(@NotNull String name, boolean unique, @NotNull List<Field> fields) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        this(name, unique, new Fields(fields));
    }

    @Override
    @NotNull
    public String getIdKey() {
        return "" + this.unique + '-' + this.name + '-' + CollectionsKt.joinToString$default((Iterable)HasFieldsKt.getColumnNames(this), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String createQuery(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        String indexSQL = this.unique ? "UNIQUE INDEX" : "INDEX";
        return StringsKt.replace$default((String)StringsKt.trimIndent((String)("\n            CREATE " + indexSQL + " IF NOT EXISTS `" + this.name + "`\n            ON `" + tableName + "` (" + CollectionsKt.joinToString$default((Iterable)HasFieldsKt.getColumnNames(this), (CharSequence)", ", null, null, (int)0, null, (Function1)createQuery.1.INSTANCE, (int)30, null) + ")\n        ")), (String)"\n", (String)" ", (boolean)false, (int)4, null);
    }

    @NotNull
    public final IndexBundle toBundle() {
        return new IndexBundle(this.name, this.unique, HasFieldsKt.getColumnNames(this), this.createQuery("${TABLE_NAME}"));
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final boolean component2() {
        return this.unique;
    }

    @NotNull
    public final Fields component3() {
        return this.getFields();
    }

    @NotNull
    public final Index copy(@NotNull String name, boolean unique, @NotNull Fields fields) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        return new Index(name, unique, fields);
    }

    public static /* synthetic */ Index copy$default(Index index, String string, boolean bl, Fields fields, int n, Object object) {
        if ((n & 1) != 0) {
            string = index.name;
        }
        if ((n & 2) != 0) {
            bl = index.unique;
        }
        if ((n & 4) != 0) {
            fields = index.getFields();
        }
        return index.copy(string, bl, fields);
    }

    @NotNull
    public String toString() {
        return "Index(name=" + this.name + ", unique=" + this.unique + ", fields=" + this.getFields() + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        int n = this.unique ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + this.getFields().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Index)) {
            return false;
        }
        Index index = (Index)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)index.name)) {
            return false;
        }
        if (this.unique != index.unique) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getFields(), (Object)index.getFields());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/room/vo/Index$Companion;", "", "()V", "DEFAULT_PREFIX", "", "room-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

