/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.parser;

import androidx.room.parser.BindParameterNode;
import androidx.room.parser.ParsedQuery;
import androidx.room.parser.ParserErrors;
import androidx.room.parser.QueryType;
import androidx.room.parser.Section;
import androidx.room.parser.Table;
import androidx.room.verifier.QueryResultInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 >2\u00020\u0001:\u0001>B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\rJ\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\u0005H\u00c6\u0003J\u000f\u00102\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\u000f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003JM\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001J\u0013\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00109\u001a\u00020:H\u00d6\u0001J\t\u0010;\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0002J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0002R&\u0010\u000e\u001a\r\u0012\t\u0012\u00070\u000f\u00a2\u0006\u0002\b\u00100\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0016\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0014\u001a\u0004\b\u001c\u0010\u001aR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R+\u0010$\u001a\u0012\u0012\u0004\u0012\u00020&0%j\b\u0012\u0004\u0012\u00020&`'8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u0014\u001a\u0004\b(\u0010)R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006?"}, d2={"Landroidx/room/parser/ParsedQuery;", "", "original", "", "type", "Landroidx/room/parser/QueryType;", "inputs", "", "Landroidx/room/parser/BindParameterNode;", "tables", "", "Landroidx/room/parser/Table;", "syntaxErrors", "(Ljava/lang/String;Landroidx/room/parser/QueryType;Ljava/util/List;Ljava/util/Set;Ljava/util/List;)V", "bindSections", "Landroidx/room/parser/Section$BindVar;", "Lkotlin/internal/NoInfer;", "getBindSections", "()Ljava/util/List;", "bindSections$delegate", "Lkotlin/Lazy;", "errors", "getErrors", "errors$delegate", "getInputs", "getOriginal", "()Ljava/lang/String;", "queryWithReplacedBindParams", "getQueryWithReplacedBindParams", "queryWithReplacedBindParams$delegate", "resultInfo", "Landroidx/room/verifier/QueryResultInfo;", "getResultInfo", "()Landroidx/room/verifier/QueryResultInfo;", "setResultInfo", "(Landroidx/room/verifier/QueryResultInfo;)V", "sections", "Ljava/util/ArrayList;", "Landroidx/room/parser/Section;", "Lkotlin/collections/ArrayList;", "getSections", "()Ljava/util/ArrayList;", "sections$delegate", "getSyntaxErrors", "getTables", "()Ljava/util/Set;", "getType", "()Landroidx/room/parser/QueryType;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "unknownQueryTypeErrors", "unnamedVariableErrors", "Companion", "room-compiler"})
public final class ParsedQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String original;
    @NotNull
    private final QueryType type;
    @NotNull
    private final List<BindParameterNode> inputs;
    @NotNull
    private final Set<Table> tables;
    @NotNull
    private final List<String> syntaxErrors;
    @Nullable
    private QueryResultInfo resultInfo;
    @NotNull
    private final Lazy sections$delegate;
    @NotNull
    private final Lazy bindSections$delegate;
    @NotNull
    private final Lazy errors$delegate;
    @NotNull
    private final Lazy queryWithReplacedBindParams$delegate;
    @NotNull
    private static final Regex STARTS_WITH_NUMBER;
    @NotNull
    private static final ParsedQuery MISSING;

    public ParsedQuery(@NotNull String original, @NotNull QueryType type, @NotNull List<BindParameterNode> inputs, @NotNull Set<Table> tables, @NotNull List<String> syntaxErrors) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Intrinsics.checkNotNullParameter(syntaxErrors, (String)"syntaxErrors");
        this.original = original;
        this.type = type;
        this.inputs = inputs;
        this.tables = tables;
        this.syntaxErrors = syntaxErrors;
        this.sections$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ArrayList<Section>>(this){
            final /* synthetic */ ParsedQuery this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ArrayList<Section> invoke() {
                void $this$groupByTo$iv$iv;
                List lines = StringsKt.lines((CharSequence)this.this$0.getOriginal());
                Iterable $this$groupBy$iv = this.this$0.getInputs();
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    BindParameterNode it = (BindParameterNode)element$iv$iv;
                    boolean bl3 = false;
                    Integer key$iv$iv = it.getSymbol().getLine();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Map inputsByLine = destination$iv$iv;
                $i$f$groupBy = false;
                ArrayList<Section> sections2 = new ArrayList<Section>();
                Iterable $this$forEachIndexed$iv = lines;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void line;
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String bl3 = (String)item$iv;
                    int index = n;
                    boolean bl4 = false;
                    int charInLine = 0;
                    List list = (List)inputsByLine.get(index + 1);
                    if (list != null) {
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            String string;
                            BindParameterNode bindVar = (BindParameterNode)element$iv;
                            boolean bl5 = false;
                            if (charInLine < bindVar.getSymbol().getCharPositionInLine()) {
                                string = line;
                                int n2 = charInLine;
                                int n3 = bindVar.getSymbol().getCharPositionInLine();
                                boolean bl6 = false;
                                String string2 = string;
                                if (string2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string3 = string2.substring(n2, n3);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                sections2.add(Section.Companion.text(string3));
                            }
                            string = bindVar.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bindVar.text");
                            sections2.add(Section.Companion.bindVar(string, bindVar.isMultiple()));
                            charInLine = bindVar.getSymbol().getCharPositionInLine() + bindVar.getSymbol().getText().length();
                        }
                    }
                    if (charInLine < line.length()) {
                        list = line;
                        int n4 = charInLine;
                        boolean bl7 = false;
                        List list2 = list;
                        if (list2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string = ((String)((Object)list2)).substring(n4);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                        sections2.add(Section.Companion.text(string));
                    }
                    if (index + 1 >= lines.size()) continue;
                    sections2.add(Section.Companion.newline());
                }
                return sections2;
            }
        }));
        this.bindSections$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Section.BindVar>>(this){
            final /* synthetic */ ParsedQuery this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Section.BindVar> invoke() {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = this.this$0.getSections();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Section.BindVar)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }));
        this.errors$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ ParsedQuery this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                Collection collection = this.this$0.getSyntaxErrors();
                boolean bl = false;
                return !collection.isEmpty() ? this.this$0.getSyntaxErrors() : CollectionsKt.plus((Collection)ParsedQuery.access$unnamedVariableErrors(this.this$0), (Iterable)ParsedQuery.access$unknownQueryTypeErrors(this.this$0));
            }
        }));
        this.queryWithReplacedBindParams$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ ParsedQuery this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return CollectionsKt.joinToString$default((Iterable)this.this$0.getSections(), (CharSequence)"", null, null, (int)0, null, (Function1)queryWithReplacedBindParams.1.INSTANCE, (int)30, null);
            }
        }));
    }

    @NotNull
    public final String getOriginal() {
        return this.original;
    }

    @NotNull
    public final QueryType getType() {
        return this.type;
    }

    @NotNull
    public final List<BindParameterNode> getInputs() {
        return this.inputs;
    }

    @NotNull
    public final Set<Table> getTables() {
        return this.tables;
    }

    @NotNull
    public final List<String> getSyntaxErrors() {
        return this.syntaxErrors;
    }

    @Nullable
    public final QueryResultInfo getResultInfo() {
        return this.resultInfo;
    }

    public final void setResultInfo(@Nullable QueryResultInfo queryResultInfo) {
        this.resultInfo = queryResultInfo;
    }

    @NotNull
    public final ArrayList<Section> getSections() {
        Lazy lazy = this.sections$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (ArrayList)lazy.getValue();
    }

    @NotNull
    public final List<Section.BindVar> getBindSections() {
        Lazy lazy = this.bindSections$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> unnamedVariableErrors() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        CharSequence charSequence;
        BindParameterNode it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List list;
        boolean bl;
        Object[] $this$any$iv;
        block7: {
            $this$any$iv = (String[])this.inputs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object t : $this$any$iv) {
                    BindParameterNode it2 = (BindParameterNode)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2.getText(), (Object)"?")) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            $this$any$iv = new String[]{ParserErrors.INSTANCE.getANONYMOUS_BIND_ARGUMENT()};
            list = CollectionsKt.arrayListOf((Object[])$this$any$iv);
        } else {
            list = CollectionsKt.emptyList();
        }
        List anonymousBindError = list;
        $this$any$iv = this.inputs;
        Collection collection = anonymousBindError;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection collection2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (BindParameterNode)element$iv$iv;
            boolean bl3 = false;
            charSequence = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"it.text");
            charSequence = charSequence;
            Regex regex = STARTS_WITH_NUMBER;
            boolean bl2 = false;
            if (!regex.matches(charSequence)) continue;
            collection2.add(element$iv$iv);
        }
        Collection<String> collection3 = (List)collection2;
        $this$filter$iv = collection3;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        Collection collection4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (BindParameterNode)item$iv$iv;
            collection3 = collection4;
            boolean bl5 = false;
            charSequence = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"it.text");
            String string = ParserErrors.INSTANCE.cannotUseVariableIndices((String)charSequence, it.getSymbol().getCharPositionInLine());
            collection3.add(string);
        }
        collection3 = (List)collection4;
        return CollectionsKt.plus((Collection)collection, (Iterable)collection3);
    }

    private final List<String> unknownQueryTypeErrors() {
        return QueryType.Companion.getSUPPORTED().contains((Object)this.type) ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)ParserErrors.INSTANCE.invalidQueryType(this.type));
    }

    @NotNull
    public final List<String> getErrors() {
        Lazy lazy = this.errors$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final String getQueryWithReplacedBindParams() {
        Lazy lazy = this.queryWithReplacedBindParams$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String component1() {
        return this.original;
    }

    @NotNull
    public final QueryType component2() {
        return this.type;
    }

    @NotNull
    public final List<BindParameterNode> component3() {
        return this.inputs;
    }

    @NotNull
    public final Set<Table> component4() {
        return this.tables;
    }

    @NotNull
    public final List<String> component5() {
        return this.syntaxErrors;
    }

    @NotNull
    public final ParsedQuery copy(@NotNull String original, @NotNull QueryType type, @NotNull List<BindParameterNode> inputs, @NotNull Set<Table> tables, @NotNull List<String> syntaxErrors) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Intrinsics.checkNotNullParameter(syntaxErrors, (String)"syntaxErrors");
        return new ParsedQuery(original, type, inputs, tables, syntaxErrors);
    }

    public static /* synthetic */ ParsedQuery copy$default(ParsedQuery parsedQuery, String string, QueryType queryType, List list, Set set, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = parsedQuery.original;
        }
        if ((n & 2) != 0) {
            queryType = parsedQuery.type;
        }
        if ((n & 4) != 0) {
            list = parsedQuery.inputs;
        }
        if ((n & 8) != 0) {
            set = parsedQuery.tables;
        }
        if ((n & 0x10) != 0) {
            list2 = parsedQuery.syntaxErrors;
        }
        return parsedQuery.copy(string, queryType, list, set, list2);
    }

    @NotNull
    public String toString() {
        return "ParsedQuery(original=" + this.original + ", type=" + (Object)((Object)this.type) + ", inputs=" + this.inputs + ", tables=" + this.tables + ", syntaxErrors=" + this.syntaxErrors + ')';
    }

    public int hashCode() {
        int result = this.original.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + ((Object)this.inputs).hashCode();
        result = result * 31 + ((Object)this.tables).hashCode();
        result = result * 31 + ((Object)this.syntaxErrors).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParsedQuery)) {
            return false;
        }
        ParsedQuery parsedQuery = (ParsedQuery)other;
        if (!Intrinsics.areEqual((Object)this.original, (Object)parsedQuery.original)) {
            return false;
        }
        if (this.type != parsedQuery.type) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inputs, parsedQuery.inputs)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tables, parsedQuery.tables)) {
            return false;
        }
        return Intrinsics.areEqual(this.syntaxErrors, parsedQuery.syntaxErrors);
    }

    public static final /* synthetic */ List access$unnamedVariableErrors(ParsedQuery $this) {
        return $this.unnamedVariableErrors();
    }

    public static final /* synthetic */ List access$unknownQueryTypeErrors(ParsedQuery $this) {
        return $this.unknownQueryTypeErrors();
    }

    static {
        String string = "^\\?[0-9]";
        boolean bl = false;
        STARTS_WITH_NUMBER = new Regex(string);
        MISSING = new ParsedQuery("missing query", QueryType.UNKNOWN, CollectionsKt.emptyList(), SetsKt.emptySet(), CollectionsKt.emptyList());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Landroidx/room/parser/ParsedQuery$Companion;", "", "()V", "MISSING", "Landroidx/room/parser/ParsedQuery;", "getMISSING", "()Landroidx/room/parser/ParsedQuery;", "STARTS_WITH_NUMBER", "Lkotlin/text/Regex;", "getSTARTS_WITH_NUMBER", "()Lkotlin/text/Regex;", "room-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getSTARTS_WITH_NUMBER() {
            return STARTS_WITH_NUMBER;
        }

        @NotNull
        public final ParsedQuery getMISSING() {
            return MISSING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

