/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.solver;

import androidx.room.compiler.processing.XType;
import androidx.room.solver.types.CompositeTypeConverter;
import androidx.room.solver.types.NoOpConverter;
import androidx.room.solver.types.TypeConverter;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0006\u001a\u0004\u0018\u00010\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0003J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/room/solver/TypeConverterStore;", "", "typeConverters", "", "Landroidx/room/solver/types/TypeConverter;", "(Ljava/util/List;)V", "findTypeConverter", "inputs", "Landroidx/room/compiler/processing/XType;", "outputs", "getAllTypeConverters", "input", "excludes", "reverse", "converter", "room-compiler"})
public final class TypeConverterStore {
    @NotNull
    private final List<TypeConverter> typeConverters;

    public TypeConverterStore(@NotNull List<? extends TypeConverter> typeConverters) {
        Intrinsics.checkNotNullParameter(typeConverters, (String)"typeConverters");
        this.typeConverters = typeConverters;
    }

    @Nullable
    public final TypeConverter findTypeConverter(@NotNull List<? extends XType> inputs, @NotNull List<? extends XType> outputs) {
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        if (inputs.isEmpty()) {
            return null;
        }
        Iterable $this$forEach$iv = inputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            XType input;
            block11: {
                input = (XType)element$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = outputs;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        XType output = (XType)element$iv2;
                        boolean bl3 = false;
                        if (!input.isSameType(output)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return new NoOpConverter(input);
        }
        $i$f$forEach = false;
        ArrayList<XType> excludes = new ArrayList<XType>();
        LinkedList<TypeConverter> queue = new LinkedList<TypeConverter>();
        Iterable $this$forEach$iv2 = inputs;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            XType input = (XType)element$iv;
            boolean bl = false;
            List<TypeConverter> candidates = this.getAllTypeConverters(input, (List<? extends XType>)excludes);
            TypeConverter match = TypeConverterStore.findTypeConverter$findMatchingConverter(candidates, outputs);
            if (match != null) {
                return match;
            }
            Iterable $this$forEach$iv3 = candidates;
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                TypeConverter it = (TypeConverter)element$iv3;
                boolean bl4 = false;
                excludes.add(it.getTo());
                queue.add(it);
            }
        }
        excludes.addAll((Collection)inputs);
        block4: while (true) {
            $this$forEach$iv2 = queue;
            $i$f$forEach2 = false;
            if (!(!$this$forEach$iv2.isEmpty())) break;
            TypeConverter prev = (TypeConverter)queue.pop();
            XType from = prev.getTo();
            List<TypeConverter> candidates = this.getAllTypeConverters(from, (List<? extends XType>)excludes);
            TypeConverter match = TypeConverterStore.findTypeConverter$findMatchingConverter(candidates, outputs);
            if (match != null) {
                Intrinsics.checkNotNullExpressionValue((Object)prev, (String)"prev");
                return new CompositeTypeConverter(prev, match);
            }
            Iterable $this$forEach$iv4 = candidates;
            boolean $i$f$forEach4 = false;
            Iterator iterator = $this$forEach$iv4.iterator();
            while (true) {
                Object element$iv2;
                if (!iterator.hasNext()) continue block4;
                element$iv2 = iterator.next();
                TypeConverter it = (TypeConverter)element$iv2;
                boolean bl = false;
                excludes.add(it.getTo());
                Intrinsics.checkNotNullExpressionValue((Object)prev, (String)"prev");
                queue.add(new CompositeTypeConverter(prev, it));
            }
            break;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final List<TypeConverter> getAllTypeConverters(XType input, List<? extends XType> excludes) {
        $this$filter$iv = this.typeConverters;
        $i$f$filter = false;
        var5_5 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block6: {
                converter = (TypeConverter)element$iv$iv;
                $i$a$-filter-TypeConverterStore$getAllTypeConverters$1 = false;
                if (!converter.getFrom().isAssignableFrom(input)) ** GOTO lbl-1000
                $this$any$iv = excludes;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (XType)element$iv;
                        $i$a$-any-TypeConverterStore$getAllTypeConverters$1$1 = false;
                        if (!it.isSameType(converter.getTo())) continue;
                        v0 = true;
                        break block6;
                    }
                    v0 = false;
                }
            }
            if (!v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$sortedByDescending$iv = (List)destination$iv$iv;
        $i$f$sortedByDescending = false;
        var5_6 = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(input){
            final /* synthetic */ XType $input$inlined;
            {
                this.$input$inlined = xType;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                TypeConverter it = (TypeConverter)b;
                boolean bl2 = false;
                int n = it.getFrom().isSameType(this.$input$inlined) ? 2 : 1;
                it = (TypeConverter)a;
                Comparable comparable = Integer.valueOf(n);
                bl2 = false;
                Integer n2 = it.getFrom().isSameType(this.$input$inlined) ? 2 : 1;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n2);
            }
        });
    }

    @VisibleForTesting
    @Nullable
    public final TypeConverter reverse(@NotNull TypeConverter converter) {
        TypeConverter typeConverter2;
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        TypeConverter typeConverter3 = converter;
        if (typeConverter3 instanceof NoOpConverter) {
            typeConverter2 = converter;
        } else if (typeConverter3 instanceof CompositeTypeConverter) {
            TypeConverter typeConverter4 = this.reverse(((CompositeTypeConverter)converter).getConv1());
            if (typeConverter4 == null) {
                return null;
            }
            TypeConverter r1 = typeConverter4;
            TypeConverter typeConverter5 = this.reverse(((CompositeTypeConverter)converter).getConv2());
            if (typeConverter5 == null) {
                return null;
            }
            TypeConverter r2 = typeConverter5;
            typeConverter2 = new CompositeTypeConverter(r2, r1);
        } else {
            Object v2;
            block7: {
                Iterable $this$firstOrNull$iv = this.typeConverters;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TypeConverter it = (TypeConverter)element$iv;
                    boolean bl = false;
                    boolean bl2 = it.getFrom().isSameType(converter.getTo()) && it.getTo().isSameType(converter.getFrom());
                    if (!bl2) continue;
                    v2 = element$iv;
                    break block7;
                }
                v2 = null;
            }
            typeConverter2 = v2;
        }
        return typeConverter2;
    }

    private static final TypeConverter findTypeConverter$findMatchingConverter(List<? extends TypeConverter> $this$findTypeConverter_u24findMatchingConverter, List<? extends XType> $outputs) {
        TypeConverter assignableMatchFallback = null;
        Iterable $this$forEach$iv = $this$findTypeConverter_u24findMatchingConverter;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeConverter converter = (TypeConverter)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = $outputs;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                XType output = (XType)element$iv2;
                boolean bl2 = false;
                if (output.isSameType(converter.getTo())) {
                    return converter;
                }
                if (assignableMatchFallback != null || !output.isAssignableFrom(converter.getTo())) continue;
                assignableMatchFallback = converter;
            }
        }
        return assignableMatchFallback;
    }
}

