/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import androidx.room.migration.bundle.DatabaseBundle;
import androidx.room.migration.bundle.EntityBundle;
import androidx.room.migration.bundle.FieldBundle;
import androidx.room.migration.bundle.ForeignKeyBundle;
import androidx.room.migration.bundle.FtsEntityBundle;
import androidx.room.migration.bundle.IndexBundle;
import androidx.room.processor.ProcessorErrors;
import androidx.room.util.DiffException;
import androidx.room.util.SchemaDiffResult;
import androidx.room.vo.AutoMigration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\u0002\u0010\u0010J\"\u0010#\u001a\u0004\u0018\u00010\u00062\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u001d2\u0006\u0010$\u001a\u00020\u001dH\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0006H\u0002J\u0006\u0010,\u001a\u00020-J\u001a\u0010.\u001a\u0004\u0018\u00010\t2\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u0006H\u0002J$\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\b2\f\u00105\u001a\b\u0012\u0004\u0012\u0002040\bH\u0002J$\u00106\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u0002070\b2\f\u00105\u001a\b\u0012\u0004\u0012\u0002070\bH\u0002J\u0012\u00108\u001a\u0004\u0018\u00010\r2\u0006\u00100\u001a\u00020\u0006H\u0002J*\u00109\u001a\u00020:2\u0006\u0010%\u001a\u00020\u001d2\u0018\u0010;\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0019H\u0002J\b\u0010<\u001a\u00020:H\u0002J\b\u0010=\u001a\u00020:H\u0002J\u0018\u0010>\u001a\u0002022\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001dH\u0002R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0012j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Landroidx/room/util/SchemaDiffer;", "", "fromSchemaBundle", "Landroidx/room/migration/bundle/DatabaseBundle;", "toSchemaBundle", "className", "", "renameColumnEntries", "", "Landroidx/room/vo/AutoMigration$RenamedColumn;", "deleteColumnEntries", "Landroidx/room/vo/AutoMigration$DeletedColumn;", "renameTableEntries", "Landroidx/room/vo/AutoMigration$RenamedTable;", "deleteTableEntries", "Landroidx/room/vo/AutoMigration$DeletedTable;", "(Landroidx/room/migration/bundle/DatabaseBundle;Landroidx/room/migration/bundle/DatabaseBundle;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "addedColumns", "Ljava/util/LinkedHashMap;", "Landroidx/room/vo/AutoMigration$AddedColumn;", "Lkotlin/collections/LinkedHashMap;", "addedTables", "", "Landroidx/room/vo/AutoMigration$AddedTable;", "complexChangedTables", "", "Landroidx/room/vo/AutoMigration$ComplexChangedTable;", "contentTableToFtsEntities", "", "Landroidx/room/migration/bundle/EntityBundle;", "deletedColumns", "deletedTables", "", "potentiallyDeletedTables", "renamedTables", "detectColumnLevelChanges", "fromTable", "toTable", "fromColumn", "Landroidx/room/migration/bundle/FieldBundle;", "detectTableLevelChanges", "diffError", "", "errorMsg", "diffSchemas", "Landroidx/room/util/SchemaDiffResult;", "isColumnRenamed", "columnName", "tableName", "isForeignKeyBundlesListEqual", "", "fromBundle", "Landroidx/room/migration/bundle/ForeignKeyBundle;", "toBundle", "isIndexBundlesListEqual", "Landroidx/room/migration/bundle/IndexBundle;", "isTableRenamed", "processAddedTableAndColumns", "", "processedTablesAndColumnsInNewVersion", "processContentTables", "processDeletedColumns", "tableContainsComplexChanges", "room-compiler"})
public final class SchemaDiffer {
    @NotNull
    private final DatabaseBundle fromSchemaBundle;
    @NotNull
    private final DatabaseBundle toSchemaBundle;
    @Nullable
    private final String className;
    @NotNull
    private final List<AutoMigration.RenamedColumn> renameColumnEntries;
    @NotNull
    private final List<AutoMigration.DeletedColumn> deleteColumnEntries;
    @NotNull
    private final List<AutoMigration.RenamedTable> renameTableEntries;
    @NotNull
    private final List<AutoMigration.DeletedTable> deleteTableEntries;
    @NotNull
    private final Set<String> potentiallyDeletedTables;
    @NotNull
    private final Map<String, List<EntityBundle>> contentTableToFtsEntities;
    @NotNull
    private final Set<AutoMigration.AddedTable> addedTables;
    @NotNull
    private final Map<String, String> renamedTables;
    @NotNull
    private final Map<String, AutoMigration.ComplexChangedTable> complexChangedTables;
    @NotNull
    private final Set<String> deletedTables;
    @NotNull
    private final LinkedHashMap<String, AutoMigration.AddedColumn> addedColumns;
    @NotNull
    private final List<AutoMigration.DeletedColumn> deletedColumns;

    /*
     * WARNING - void declaration
     */
    public SchemaDiffer(@NotNull DatabaseBundle fromSchemaBundle, @NotNull DatabaseBundle toSchemaBundle, @Nullable String className, @NotNull List<AutoMigration.RenamedColumn> renameColumnEntries, @NotNull List<AutoMigration.DeletedColumn> deleteColumnEntries, @NotNull List<AutoMigration.RenamedTable> renameTableEntries, @NotNull List<AutoMigration.DeletedTable> deleteTableEntries) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)fromSchemaBundle, (String)"fromSchemaBundle");
        Intrinsics.checkNotNullParameter((Object)toSchemaBundle, (String)"toSchemaBundle");
        Intrinsics.checkNotNullParameter(renameColumnEntries, (String)"renameColumnEntries");
        Intrinsics.checkNotNullParameter(deleteColumnEntries, (String)"deleteColumnEntries");
        Intrinsics.checkNotNullParameter(renameTableEntries, (String)"renameTableEntries");
        Intrinsics.checkNotNullParameter(deleteTableEntries, (String)"deleteTableEntries");
        this.fromSchemaBundle = fromSchemaBundle;
        this.toSchemaBundle = toSchemaBundle;
        this.className = className;
        this.renameColumnEntries = renameColumnEntries;
        this.deleteColumnEntries = deleteColumnEntries;
        this.renameTableEntries = renameTableEntries;
        this.deleteTableEntries = deleteTableEntries;
        boolean bl = false;
        this.potentiallyDeletedTables = new LinkedHashSet();
        bl = false;
        this.contentTableToFtsEntities = new LinkedHashMap();
        bl = false;
        this.addedTables = new LinkedHashSet();
        bl = false;
        this.renamedTables = new LinkedHashMap();
        bl = false;
        this.complexChangedTables = new LinkedHashMap();
        Iterable iterable = this.deleteTableEntries;
        SchemaDiffer schemaDiffer = this;
        boolean $i$f$map = false;
        void var10_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AutoMigration.DeletedTable deletedTable = (AutoMigration.DeletedTable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string = it.getDeletedTableName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        schemaDiffer.deletedTables = CollectionsKt.toSet((Iterable)collection);
        boolean bl3 = false;
        this.addedColumns = new LinkedHashMap();
        this.deletedColumns = this.deleteColumnEntries;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SchemaDiffResult diffSchemas() {
        Object toTable;
        boolean bl = false;
        Map processedTablesAndColumnsInNewVersion = new LinkedHashMap();
        Object $this$forEach$iv = this.fromSchemaBundle.getEntitiesByTableName().values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            Object element$iv = iterator.next();
            EntityBundle fromTable = (EntityBundle)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)fromTable, (String)"fromTable");
            toTable = this.detectTableLevelChanges(fromTable);
            if (toTable == null) continue;
            if (fromTable instanceof FtsEntityBundle) {
                Object object = ((FtsEntityBundle)fromTable).getFtsOptions().getContentTable();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromTable.ftsOptions.contentTable");
                object = (CharSequence)object;
                boolean bl3 = false;
                if (object.length() > 0) {
                    Object object2;
                    void $this$getOrPut$iv;
                    object = this.contentTableToFtsEntities;
                    String string = ((FtsEntityBundle)fromTable).getFtsOptions().getContentTable();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fromTable.ftsOptions.contentTable");
                    String key$iv = string;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl4 = false;
                        boolean bl5 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    ((List)object2).add(fromTable);
                }
            }
            Map fromColumns = fromTable.getFieldsByColumnName();
            Iterable $this$mapNotNull$iv = fromColumns.values();
            boolean $i$f$mapNotNull = false;
            Iterable answer$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl6 = false;
                FieldBundle fromColumn = (FieldBundle)element$iv$iv;
                boolean bl7 = false;
                Intrinsics.checkNotNullExpressionValue((Object)fromColumn, (String)"fromColumn");
                if (this.detectColumnLevelChanges(fromTable, (EntityBundle)toTable, fromColumn) == null) continue;
                boolean bl8 = false;
                boolean bl9 = false;
                String it$iv$iv = string;
                boolean bl10 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List processedColumnsInNewVersion = (List)destination$iv$iv;
            Map map = processedTablesAndColumnsInNewVersion;
            String string = toTable.getTableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toTable.tableName");
            boolean bl11 = false;
            map.put(string, processedColumnsInNewVersion);
        }
        $this$forEach$iv = this.toSchemaBundle.getEntitiesByTableName();
        Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"toSchemaBundle.entitiesByTableName");
        $i$f$forEach = false;
        iterator = $this$forEach$iv;
        boolean element$iv = false;
        for (Map.Entry entry : iterator.entrySet()) {
            toTable = entry;
            boolean bl12 = false;
            Object v = toTable.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"toTable.value");
            this.processAddedTableAndColumns((EntityBundle)v, processedTablesAndColumnsInNewVersion);
        }
        $this$forEach$iv = this.potentiallyDeletedTables;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        if (iterator.hasNext()) {
            Object element$iv3 = iterator.next();
            String tableName = (String)element$iv3;
            boolean bl3 = false;
            this.diffError(ProcessorErrors.INSTANCE.deletedOrRenamedTableFound(this.className, tableName));
            throw new KotlinNothingValueException();
        }
        this.processDeletedColumns();
        this.processContentTables();
        List list = CollectionsKt.toList((Iterable)this.deletedTables);
        List list2 = this.fromSchemaBundle.getViews();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"fromSchemaBundle.views");
        List list3 = list2;
        list2 = this.toSchemaBundle.getViews();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toSchemaBundle.views");
        return new SchemaDiffResult(this.addedColumns, this.deletedColumns, this.addedTables, this.renamedTables, this.complexChangedTables, list, list3, list2);
    }

    /*
     * WARNING - void declaration
     */
    private final void processContentTables() {
        Iterable $this$forEach$iv = this.renameTableEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            AutoMigration.RenamedTable renamedTable = (AutoMigration.RenamedTable)element$iv;
            boolean bl = false;
            List<EntityBundle> list = this.contentTableToFtsEntities.get(renamedTable.getOriginalTableName());
            if (list == null) continue;
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                EntityBundle it = (EntityBundle)element$iv$iv;
                boolean bl2 = false;
                if (!(!this.complexChangedTables.containsKey(it.getTableName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            $this$filter$iv = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                EntityBundle ftsTable = (EntityBundle)element$iv2;
                boolean bl3 = false;
                Map<String, AutoMigration.ComplexChangedTable> map = this.complexChangedTables;
                String string = ftsTable.getTableName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ftsTable.tableName");
                String string2 = ftsTable.getTableName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ftsTable.tableName");
                String string3 = string2;
                string2 = ftsTable.getNewTableName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ftsTable.newTableName");
                boolean bl4 = false;
                AutoMigration.ComplexChangedTable complexChangedTable = new AutoMigration.ComplexChangedTable(string3, string2, ftsTable, ftsTable, new LinkedHashMap());
                boolean bl5 = false;
                map.put(string, complexChangedTable);
            }
        }
    }

    private final EntityBundle detectTableLevelChanges(EntityBundle fromTable) {
        EntityBundle toTable;
        String string = fromTable.getTableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fromTable.tableName");
        AutoMigration.RenamedTable renamedTable = this.isTableRenamed(string);
        if (renamedTable != null) {
            toTable = (EntityBundle)this.toSchemaBundle.getEntitiesByTableName().get(renamedTable.getNewTableName());
            if (toTable != null) {
                boolean isComplexChangedTable = this.tableContainsComplexChanges(fromTable, toTable);
                boolean isFtsEntity = fromTable instanceof FtsEntityBundle;
                if (isComplexChangedTable || isFtsEntity) {
                    if (this.toSchemaBundle.getEntitiesByTableName().containsKey(toTable.getNewTableName())) {
                        String string2 = toTable.getNewTableName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toTable.newTableName");
                        this.diffError(ProcessorErrors.INSTANCE.tableWithConflictingPrefixFound(string2));
                        throw new KotlinNothingValueException();
                    }
                    this.renamedTables.remove(renamedTable.getOriginalTableName());
                    Map<String, AutoMigration.ComplexChangedTable> map = this.complexChangedTables;
                    String string3 = renamedTable.getOriginalTableName();
                    String string4 = toTable.getTableName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toTable.tableName");
                    String string5 = string4;
                    string4 = toTable.getNewTableName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toTable.newTableName");
                    boolean bl = false;
                    AutoMigration.ComplexChangedTable complexChangedTable = new AutoMigration.ComplexChangedTable(string5, string4, fromTable, toTable, new LinkedHashMap());
                    boolean bl2 = false;
                    map.put(string3, complexChangedTable);
                } else {
                    Map<String, String> map = this.renamedTables;
                    String string6 = fromTable.getTableName();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"fromTable.tableName");
                    String string7 = toTable.getTableName();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toTable.tableName");
                    boolean bl = false;
                    map.put(string6, string7);
                }
            } else {
                String string8 = this.className;
                Intrinsics.checkNotNull((Object)string8);
                this.diffError(ProcessorErrors.INSTANCE.tableRenameError(string8, renamedTable.getOriginalTableName(), renamedTable.getNewTableName()));
                throw new KotlinNothingValueException();
            }
            return toTable;
        }
        toTable = (EntityBundle)this.toSchemaBundle.getEntitiesByTableName().get(fromTable.getTableName());
        boolean isDeletedTable = this.deletedTables.contains(fromTable.getTableName());
        if (toTable != null) {
            if (isDeletedTable) {
                String isFtsEntity = toTable.getTableName();
                Intrinsics.checkNotNullExpressionValue((Object)isFtsEntity, (String)"toTable.tableName");
                this.diffError(ProcessorErrors.INSTANCE.deletedOrRenamedTableFound(this.className, isFtsEntity));
                throw new KotlinNothingValueException();
            }
            boolean isComplexChangedTable = this.tableContainsComplexChanges(fromTable, toTable);
            if (isComplexChangedTable) {
                Map<String, AutoMigration.ComplexChangedTable> map = this.complexChangedTables;
                String string9 = fromTable.getTableName();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"fromTable.tableName");
                String string10 = toTable.getTableName();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toTable.tableName");
                String string11 = string10;
                string10 = toTable.getNewTableName();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toTable.newTableName");
                boolean bl = false;
                AutoMigration.ComplexChangedTable complexChangedTable = new AutoMigration.ComplexChangedTable(string11, string10, fromTable, toTable, new LinkedHashMap());
                boolean bl3 = false;
                map.put(string9, complexChangedTable);
            }
            return toTable;
        }
        if (!isDeletedTable) {
            String string12 = fromTable.getTableName();
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"fromTable.tableName");
            this.potentiallyDeletedTables.add(string12);
        }
        return null;
    }

    private final String detectColumnLevelChanges(EntityBundle fromTable, EntityBundle toTable, FieldBundle fromColumn) {
        boolean isColumnDeleted;
        block9: {
            boolean bl;
            String string = fromColumn.getColumnName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fromColumn.columnName");
            String string2 = string;
            string = fromTable.getTableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fromTable.tableName");
            AutoMigration.RenamedColumn renamedToColumn = this.isColumnRenamed(string2, string);
            if (renamedToColumn != null) {
                Object object = new Pair[]{TuplesKt.to((Object)renamedToColumn.getNewColumnName(), (Object)fromColumn.getColumnName())};
                Map renamedColumnsMap = MapsKt.mutableMapOf((Pair[])object);
                if (this.toSchemaBundle.getEntitiesByTableName().containsKey(toTable.getNewTableName())) {
                    object = toTable.getNewTableName();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toTable.newTableName");
                    this.diffError(ProcessorErrors.INSTANCE.tableWithConflictingPrefixFound((String)object));
                    throw new KotlinNothingValueException();
                }
                this.renamedTables.remove(fromTable.getTableName());
                object = this.complexChangedTables;
                String string3 = fromTable.getTableName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fromTable.tableName");
                Object object2 = fromTable.getTableName();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fromTable.tableName");
                String string4 = object2;
                object2 = toTable.getNewTableName();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"toTable.newTableName");
                object2 = new AutoMigration.ComplexChangedTable(string4, (String)object2, fromTable, toTable, renamedColumnsMap);
                boolean bl2 = false;
                object.put(string3, object2);
                return renamedToColumn.getNewColumnName();
            }
            FieldBundle match = (FieldBundle)toTable.getFieldsByColumnName().get(fromColumn.getColumnName());
            if (match != null) {
                boolean columnChanged;
                boolean bl3 = columnChanged = !match.isSchemaEqual(fromColumn);
                if (columnChanged && !this.complexChangedTables.containsKey(fromTable.getTableName())) {
                    if (this.toSchemaBundle.getEntitiesByTableName().containsKey(toTable.getNewTableName())) {
                        String string5 = toTable.getNewTableName();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toTable.newTableName");
                        this.diffError(ProcessorErrors.INSTANCE.tableWithConflictingPrefixFound(string5));
                        throw new KotlinNothingValueException();
                    }
                    this.renamedTables.remove(fromTable.getTableName());
                    Map<String, AutoMigration.ComplexChangedTable> map = this.complexChangedTables;
                    String string6 = fromTable.getTableName();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"fromTable.tableName");
                    String string7 = fromTable.getTableName();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"fromTable.tableName");
                    String string8 = string7;
                    string7 = toTable.getNewTableName();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toTable.newTableName");
                    boolean bl4 = false;
                    AutoMigration.ComplexChangedTable complexChangedTable = new AutoMigration.ComplexChangedTable(string8, string7, fromTable, toTable, new LinkedHashMap());
                    boolean bl5 = false;
                    map.put(string6, complexChangedTable);
                }
                return match.getColumnName();
            }
            Iterable $this$any$iv = this.deletedColumns;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AutoMigration.DeletedColumn it = (AutoMigration.DeletedColumn)element$iv;
                    boolean bl6 = false;
                    if (!(Intrinsics.areEqual((Object)it.getTableName(), (Object)fromTable.getTableName()) && Intrinsics.areEqual((Object)it.getColumnName(), (Object)fromColumn.getColumnName()))) continue;
                    bl = true;
                    break block9;
                }
                bl = isColumnDeleted = false;
            }
        }
        if (!isColumnDeleted) {
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            String string = this.className;
            String string9 = fromTable.getTableName();
            String string10 = fromColumn.getColumnName();
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"columnName");
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"tableName");
            this.diffError(processorErrors.deletedOrRenamedColumnFound(string, string10, string9));
            throw new KotlinNothingValueException();
        }
        return null;
    }

    private final boolean tableContainsComplexChanges(EntityBundle fromTable, EntityBundle toTable) {
        boolean bl;
        block12: {
            if (fromTable instanceof FtsEntityBundle && toTable instanceof FtsEntityBundle && !((FtsEntityBundle)fromTable).getFtsOptions().isSchemaEqual(((FtsEntityBundle)toTable).getFtsOptions())) {
                return true;
            }
            if (fromTable instanceof FtsEntityBundle && !(toTable instanceof FtsEntityBundle) || toTable instanceof FtsEntityBundle && !(fromTable instanceof FtsEntityBundle)) {
                return true;
            }
            List list = fromTable.getForeignKeys();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fromTable.foreignKeys");
            List list2 = list;
            list = toTable.getForeignKeys();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toTable.foreignKeys");
            if (!this.isForeignKeyBundlesListEqual(list2, list)) {
                return true;
            }
            list = fromTable.getIndices();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fromTable.indices");
            List list3 = list;
            list = toTable.getIndices();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toTable.indices");
            if (!this.isIndexBundlesListEqual(list3, list)) {
                return true;
            }
            if (!fromTable.getPrimaryKey().isSchemaEqual(toTable.getPrimaryKey())) {
                return true;
            }
            list = fromTable.getForeignKeys();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fromTable.foreignKeys");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block11: {
                        ForeignKeyBundle foreignKey = (ForeignKeyBundle)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = this.renameTableEntries;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                AutoMigration.RenamedTable it = (AutoMigration.RenamedTable)element$iv2;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)it.getOriginalTableName(), (Object)foreignKey.getTable())) continue;
                                bl2 = true;
                                break block11;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final Void diffError(String errorMsg) {
        throw new DiffException(errorMsg);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isForeignKeyBundlesListEqual(List<? extends ForeignKeyBundle> fromBundle, List<? extends ForeignKeyBundle> toBundle) {
        void $this$groupByTo$iv$iv;
        List set = CollectionsKt.plus((Collection)fromBundle, (Iterable)toBundle);
        Iterable $this$groupBy$iv = set;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ForeignKeyBundle it = (ForeignKeyBundle)element$iv$iv;
            boolean bl = false;
            List key$iv$iv = it.getColumns();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Set matches2 = destination$iv$iv.entrySet();
        Iterable $this$forEach$iv = matches2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ForeignKeyBundle toForeignKeyBundle;
            Object element$iv$iv;
            Map.Entry $dstr$_u24__u24$bundles = (Map.Entry)element$iv;
            boolean bl = false;
            element$iv$iv = $dstr$_u24__u24$bundles;
            boolean list$iv$iv = false;
            List bundles = (List)element$iv$iv.getValue();
            if (bundles.size() < 2) {
                return false;
            }
            ForeignKeyBundle fromForeignKeyBundle = (ForeignKeyBundle)bundles.get(0);
            if (fromForeignKeyBundle.isSchemaEqual(toForeignKeyBundle = (ForeignKeyBundle)bundles.get(1))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isIndexBundlesListEqual(List<? extends IndexBundle> fromBundle, List<? extends IndexBundle> toBundle) {
        void $this$groupByTo$iv$iv;
        List set = CollectionsKt.plus((Collection)fromBundle, (Iterable)toBundle);
        Iterable $this$groupBy$iv = set;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            IndexBundle it = (IndexBundle)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Set matches2 = destination$iv$iv.entrySet();
        Iterable $this$forEach$iv = matches2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry bundlesWithSameName = (Map.Entry)element$iv;
            boolean bl = false;
            if (((List)bundlesWithSameName.getValue()).size() < 2) {
                return false;
            }
            if (((IndexBundle)((List)bundlesWithSameName.getValue()).get(0)).isSchemaEqual((IndexBundle)((List)bundlesWithSameName.getValue()).get(1))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final AutoMigration.RenamedTable isTableRenamed(String tableName) {
        void $this$filterTo$iv$iv;
        List<AutoMigration.RenamedTable> annotations = this.renameTableEntries;
        Iterable $this$filter$iv = annotations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AutoMigration.RenamedTable it = (AutoMigration.RenamedTable)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getOriginalTableName(), (Object)tableName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List renamedTableAnnotations = (List)destination$iv$iv;
        if (renamedTableAnnotations.size() > 1) {
            this.diffError(ProcessorErrors.INSTANCE.conflictingRenameTableAnnotationsFound(CollectionsKt.joinToString$default((Iterable)renamedTableAnnotations, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
            throw new KotlinNothingValueException();
        }
        return (AutoMigration.RenamedTable)CollectionsKt.firstOrNull((List)renamedTableAnnotations);
    }

    /*
     * WARNING - void declaration
     */
    private final AutoMigration.RenamedColumn isColumnRenamed(String columnName, String tableName) {
        void $this$filterTo$iv$iv;
        List<AutoMigration.RenamedColumn> annotations = this.renameColumnEntries;
        Iterable $this$filter$iv = annotations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AutoMigration.RenamedColumn it = (AutoMigration.RenamedColumn)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getOriginalColumnName(), (Object)columnName) && Intrinsics.areEqual((Object)it.getTableName(), (Object)tableName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List renamedColumnAnnotations = (List)destination$iv$iv;
        if (renamedColumnAnnotations.size() > 1) {
            this.diffError(ProcessorErrors.INSTANCE.conflictingRenameColumnAnnotationsFound(CollectionsKt.joinToString$default((Iterable)renamedColumnAnnotations, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
            throw new KotlinNothingValueException();
        }
        return (AutoMigration.RenamedColumn)CollectionsKt.firstOrNull((List)renamedColumnAnnotations);
    }

    private final void processAddedTableAndColumns(EntityBundle toTable, Map<String, List<String>> processedTablesAndColumnsInNewVersion) {
        Object object;
        Map map;
        EntityBundle fromTable;
        Object v0;
        List<String> it;
        Object element$iv2;
        block7: {
            Iterable $this$firstOrNull$iv = this.renameTableEntries;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                it = (AutoMigration.RenamedTable)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((AutoMigration.RenamedTable)((Object)it)).getNewTableName(), (Object)toTable.getTableName())) continue;
                v0 = element$iv2;
                break block7;
            }
            v0 = null;
        }
        AutoMigration.RenamedTable isRenamed = v0;
        EntityBundle entityBundle = fromTable = isRenamed != null ? (EntityBundle)this.fromSchemaBundle.getEntitiesByTableName().get(isRenamed.getOriginalTableName()) : (EntityBundle)this.fromSchemaBundle.getEntitiesByTableName().get(toTable.getTableName());
        if (fromTable == null) {
            this.addedTables.add(new AutoMigration.AddedTable(toTable));
            return;
        }
        Map fromColumns = fromTable.getFieldsByColumnName();
        it = processedTablesAndColumnsInNewVersion.get(toTable.getTableName());
        if (it == null) {
            map = null;
        } else {
            List<String> list = it;
            boolean bl = false;
            boolean bl2 = false;
            List<String> processedColumns = list;
            boolean bl3 = false;
            object = toTable.getFieldsByColumnName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toTable.fieldsByColumnName");
            Map $this$filterKeys$iv = object;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            Map map2 = $this$filterKeys$iv;
            boolean bl4 = false;
            for (Map.Entry entry$iv : map2.entrySet()) {
                String it2 = (String)entry$iv.getKey();
                boolean bl5 = false;
                if (!(!processedColumns.contains(it2))) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            map = result$iv;
        }
        element$iv2 = map;
        Map toColumns = element$iv2 == null ? toTable.getFieldsByColumnName() : element$iv2;
        Iterable $this$forEach$iv = toColumns.values();
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            FieldBundle toColumn = (FieldBundle)element$iv3;
            boolean bl = false;
            FieldBundle match = (FieldBundle)fromColumns.get(toColumn.getColumnName());
            if (match != null) continue;
            if (toColumn.isNonNull() && toColumn.getDefaultValue() == null) {
                object = toColumn.getColumnName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toColumn.columnName");
                this.diffError(ProcessorErrors.INSTANCE.newNotNullColumnMustHaveDefaultValue((String)object));
                throw new KotlinNothingValueException();
            }
            if (this.complexChangedTables.containsKey(fromTable.getTableName())) continue;
            object = this.addedColumns;
            String string = toColumn.getColumnName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toColumn.columnName");
            Object object2 = toTable.getTableName();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"toTable.tableName");
            Intrinsics.checkNotNullExpressionValue((Object)toColumn, (String)"toColumn");
            object2 = new AutoMigration.AddedColumn((String)object2, toColumn);
            boolean bl6 = false;
            object.put(string, object2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processDeletedColumns() {
        boolean bl;
        Object object;
        Object object2;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.deletedColumns;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            AutoMigration.DeletedColumn it = (AutoMigration.DeletedColumn)element$iv$iv;
            boolean bl2 = false;
            object2 = this.complexChangedTables;
            object = it.getTableName();
            bl = false;
            Map<String, AutoMigration.ComplexChangedTable> map = object2;
            boolean bl3 = false;
            if (map.containsKey(object)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object element$iv$iv;
            AutoMigration.DeletedColumn deletedColumn = (AutoMigration.DeletedColumn)element$iv;
            boolean bl4 = false;
            element$iv$iv = this.fromSchemaBundle.getEntitiesByTableName();
            Intrinsics.checkNotNullExpressionValue(element$iv$iv, (String)"fromSchemaBundle.entitiesByTableName");
            EntityBundle fromTableBundle = (EntityBundle)MapsKt.getValue(element$iv$iv, (Object)deletedColumn.getTableName());
            Map<String, AutoMigration.ComplexChangedTable> map = this.toSchemaBundle.getEntitiesByTableName();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"toSchemaBundle.entitiesByTableName");
            EntityBundle toTableBundle = (EntityBundle)MapsKt.getValue((Map)map, (Object)deletedColumn.getTableName());
            map = this.complexChangedTables;
            object2 = deletedColumn.getTableName();
            String string = deletedColumn.getTableName();
            object = fromTableBundle.getNewTableName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromTableBundle.newTableName");
            Intrinsics.checkNotNullExpressionValue((Object)fromTableBundle, (String)"fromTableBundle");
            Intrinsics.checkNotNullExpressionValue((Object)toTableBundle, (String)"toTableBundle");
            boolean bl5 = false;
            object = new AutoMigration.ComplexChangedTable(string, (String)object, fromTableBundle, toTableBundle, new LinkedHashMap());
            bl = false;
            map.put((String)object2, (AutoMigration.ComplexChangedTable)object);
        }
    }
}

