/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.jarjarred.org.stringtemplate.v4.misc;

import androidx.room.jarjarred.org.stringtemplate.v4.Interpreter;
import androidx.room.jarjarred.org.stringtemplate.v4.ModelAdaptor;
import androidx.room.jarjarred.org.stringtemplate.v4.ST;
import androidx.room.jarjarred.org.stringtemplate.v4.misc.STNoSuchPropertyException;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectModelAdaptor
implements ModelAdaptor {
    protected static final Member INVALID_MEMBER;
    protected static final Map<Class<?>, Map<String, Member>> membersCache;

    @Override
    public synchronized Object getProperty(Interpreter interp, ST self, Object o, Object property, String propertyName) throws STNoSuchPropertyException {
        if (o == null) {
            throw new NullPointerException("o");
        }
        Class<?> c = o.getClass();
        if (property == null) {
            return this.throwNoSuchProperty(c, propertyName, null);
        }
        Member member = ObjectModelAdaptor.findMember(c, propertyName);
        if (member != null) {
            try {
                if (member instanceof Method) {
                    return ((Method)member).invoke(o, new Object[0]);
                }
                if (member instanceof Field) {
                    return ((Field)member).get(o);
                }
            }
            catch (Exception e) {
                this.throwNoSuchProperty(c, propertyName, e);
            }
        }
        return this.throwNoSuchProperty(c, propertyName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Member findMember(Class<?> clazz, String memberName) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (memberName == null) {
            throw new NullPointerException("memberName");
        }
        Map<Class<?>, Map<String, Member>> map = membersCache;
        synchronized (map) {
            Map<String, Member> members = membersCache.get(clazz);
            Member member = null;
            if (members != null) {
                member = members.get(memberName);
                if (member != null) {
                    return member != INVALID_MEMBER ? member : null;
                }
            } else {
                members = new HashMap<String, Member>();
                membersCache.put(clazz, members);
            }
            String methodSuffix = Character.toUpperCase(memberName.charAt(0)) + memberName.substring(1, memberName.length());
            member = ObjectModelAdaptor.tryGetMethod(clazz, "get" + methodSuffix);
            if (member == null && (member = ObjectModelAdaptor.tryGetMethod(clazz, "is" + methodSuffix)) == null) {
                member = ObjectModelAdaptor.tryGetMethod(clazz, "has" + methodSuffix);
            }
            if (member == null) {
                member = ObjectModelAdaptor.tryGetField(clazz, memberName);
            }
            members.put(memberName, member != null ? member : INVALID_MEMBER);
            return member;
        }
    }

    protected static Method tryGetMethod(Class<?> clazz, String methodName2) {
        try {
            Method method = clazz.getMethod(methodName2, new Class[0]);
            if (method != null) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    protected static Field tryGetField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getField(fieldName);
            if (field != null) {
                field.setAccessible(true);
            }
            return field;
        }
        catch (NoSuchFieldException ex) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    protected Object throwNoSuchProperty(Class<?> clazz, String propertyName, Exception cause) {
        throw new STNoSuchPropertyException(cause, null, clazz.getName() + "." + propertyName);
    }

    static {
        Field invalidMember;
        try {
            invalidMember = ObjectModelAdaptor.class.getDeclaredField("INVALID_MEMBER");
        }
        catch (NoSuchFieldException ex) {
            invalidMember = null;
        }
        catch (SecurityException ex) {
            invalidMember = null;
        }
        INVALID_MEMBER = invalidMember;
        membersCache = new HashMap();
    }
}

