/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.jarjarred.org.antlr.v4.codegen;

import androidx.room.jarjarred.org.antlr.v4.Tool;
import androidx.room.jarjarred.org.antlr.v4.codegen.CodeGenerator;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.RuleFunction;
import androidx.room.jarjarred.org.antlr.v4.misc.CharSupport;
import androidx.room.jarjarred.org.antlr.v4.misc.Utils;
import androidx.room.jarjarred.org.antlr.v4.runtime.RuntimeMetaData;
import androidx.room.jarjarred.org.antlr.v4.tool.ErrorType;
import androidx.room.jarjarred.org.antlr.v4.tool.Grammar;
import androidx.room.jarjarred.org.antlr.v4.tool.Rule;
import androidx.room.jarjarred.org.antlr.v4.tool.ast.GrammarAST;
import androidx.room.jarjarred.org.stringtemplate.v4.NumberRenderer;
import androidx.room.jarjarred.org.stringtemplate.v4.ST;
import androidx.room.jarjarred.org.stringtemplate.v4.STErrorListener;
import androidx.room.jarjarred.org.stringtemplate.v4.STGroup;
import androidx.room.jarjarred.org.stringtemplate.v4.STGroupFile;
import androidx.room.jarjarred.org.stringtemplate.v4.StringRenderer;
import androidx.room.jarjarred.org.stringtemplate.v4.misc.STMessage;

public abstract class Target {
    protected String[] targetCharValueEscape = new String[255];
    protected final CodeGenerator gen;
    private final String language;
    private STGroup templates;

    protected Target(CodeGenerator gen, String language) {
        this.targetCharValueEscape[10] = "\\n";
        this.targetCharValueEscape[13] = "\\r";
        this.targetCharValueEscape[9] = "\\t";
        this.targetCharValueEscape[8] = "\\b";
        this.targetCharValueEscape[12] = "\\f";
        this.targetCharValueEscape[92] = "\\\\";
        this.targetCharValueEscape[39] = "\\'";
        this.targetCharValueEscape[34] = "\\\"";
        this.gen = gen;
        this.language = language;
    }

    public CodeGenerator getCodeGenerator() {
        return this.gen;
    }

    public String getLanguage() {
        return this.language;
    }

    public abstract String getVersion();

    public STGroup getTemplates() {
        if (this.templates == null) {
            String version = this.getVersion();
            if (version == null || !RuntimeMetaData.getMajorMinorVersion(version).equals(RuntimeMetaData.getMajorMinorVersion(Tool.VERSION))) {
                this.gen.tool.errMgr.toolError(ErrorType.INCOMPATIBLE_TOOL_AND_TEMPLATES, version, Tool.VERSION, this.language);
            }
            this.templates = this.loadTemplates();
        }
        return this.templates;
    }

    protected void genFile(Grammar g, ST outputFileST, String fileName) {
        this.getCodeGenerator().write(outputFileST, fileName);
    }

    public String getTokenTypeAsTargetLabel(Grammar g, int ttype) {
        String name = g.getTokenName(ttype);
        if ("<INVALID>".equals(name)) {
            return String.valueOf(ttype);
        }
        return name;
    }

    public String[] getTokenTypesAsTargetLabels(Grammar g, int[] ttypes) {
        String[] labels = new String[ttypes.length];
        for (int i = 0; i < ttypes.length; ++i) {
            labels[i] = this.getTokenTypeAsTargetLabel(g, ttypes[i]);
        }
        return labels;
    }

    public String getTargetStringLiteralFromString(String s, boolean quoted) {
        int c;
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (quoted) {
            buf.append('\"');
        }
        for (int i = 0; i < s.length(); i += Character.charCount(c)) {
            c = s.codePointAt(i);
            if (c != 39 && c < this.targetCharValueEscape.length && this.targetCharValueEscape[c] != null) {
                buf.append(this.targetCharValueEscape[c]);
                continue;
            }
            if (Target.shouldUseUnicodeEscapeForCodePointInDoubleQuotedString(c)) {
                this.appendUnicodeEscapedCodePoint(i, buf);
                continue;
            }
            buf.appendCodePoint(c);
        }
        if (quoted) {
            buf.append('\"');
        }
        return buf.toString();
    }

    protected abstract void appendUnicodeEscapedCodePoint(int var1, StringBuilder var2);

    public String getTargetStringLiteralFromString(String s) {
        return this.getTargetStringLiteralFromString(s, true);
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator generator, String literal, boolean addQuotes) {
        int toAdvance;
        StringBuilder sb = new StringBuilder();
        String is = literal;
        if (addQuotes) {
            sb.append('\"');
        }
        block4: for (int i = 1; i < is.length() - 1; i += toAdvance) {
            int codePoint = is.codePointAt(i);
            toAdvance = Character.charCount(codePoint);
            if (codePoint == 92) {
                int escapedCodePoint = is.codePointAt(i + toAdvance);
                ++toAdvance;
                switch (escapedCodePoint) {
                    case 92: 
                    case 98: 
                    case 102: 
                    case 110: 
                    case 114: 
                    case 116: {
                        sb.append('\\');
                        sb.appendCodePoint(escapedCodePoint);
                        break;
                    }
                    case 117: {
                        if (is.charAt(i + toAdvance) == '{') {
                            while (is.charAt(i + toAdvance) != '}') {
                                ++toAdvance;
                            }
                            ++toAdvance;
                        } else {
                            toAdvance += 4;
                        }
                        if (i + toAdvance > is.length()) continue block4;
                        String fullEscape = is.substring(i, i + toAdvance);
                        this.appendUnicodeEscapedCodePoint(CharSupport.getCharValueFromCharInGrammarLiteral(fullEscape), sb);
                        break;
                    }
                    default: {
                        if (Target.shouldUseUnicodeEscapeForCodePointInDoubleQuotedString(escapedCodePoint)) {
                            this.appendUnicodeEscapedCodePoint(escapedCodePoint, sb);
                            break;
                        }
                        sb.appendCodePoint(escapedCodePoint);
                        break;
                    }
                }
                continue;
            }
            if (codePoint == 34) {
                sb.append("\\\"");
                continue;
            }
            if (Target.shouldUseUnicodeEscapeForCodePointInDoubleQuotedString(codePoint)) {
                this.appendUnicodeEscapedCodePoint(codePoint, sb);
                continue;
            }
            sb.appendCodePoint(codePoint);
        }
        if (addQuotes) {
            sb.append('\"');
        }
        return sb.toString();
    }

    private static boolean shouldUseUnicodeEscapeForCodePointInDoubleQuotedString(int codePoint) {
        assert (codePoint != 10 && codePoint != 34);
        return codePoint < 32 || codePoint == 92 || codePoint >= 127;
    }

    public String encodeIntAsCharEscape(int v) {
        if (v < 0 || v > 65535) {
            throw new IllegalArgumentException(String.format("Cannot encode the specified value: %d", v));
        }
        if (v >= 0 && v < this.targetCharValueEscape.length && this.targetCharValueEscape[v] != null) {
            return this.targetCharValueEscape[v];
        }
        if (!(v < 32 || v >= 127 || Character.isDigit(v) && v != 56 && v != 57)) {
            return String.valueOf((char)v);
        }
        if (v >= 0 && v <= 127) {
            String oct = Integer.toOctalString(v);
            return "\\" + oct;
        }
        String hex = Integer.toHexString(v | 0x10000).substring(1, 5);
        return "\\u" + hex;
    }

    public String getLoopLabel(GrammarAST ast) {
        return "loop" + ast.token.getTokenIndex();
    }

    public String getLoopCounter(GrammarAST ast) {
        return "cnt" + ast.token.getTokenIndex();
    }

    public String getListLabel(String label) {
        ST st = this.getTemplates().getInstanceOf("ListLabelName");
        st.add("label", label);
        return st.render();
    }

    public String getRuleFunctionContextStructName(Rule r) {
        if (r.g.isLexer()) {
            return this.getTemplates().getInstanceOf("LexerRuleContext").render();
        }
        return Utils.capitalize(r.name) + this.getTemplates().getInstanceOf("RuleContextNameSuffix").render();
    }

    public String getAltLabelContextStructName(String label) {
        return Utils.capitalize(label) + this.getTemplates().getInstanceOf("RuleContextNameSuffix").render();
    }

    public String getRuleFunctionContextStructName(RuleFunction function) {
        Rule r = function.rule;
        if (r.g.isLexer()) {
            return this.getTemplates().getInstanceOf("LexerRuleContext").render();
        }
        return Utils.capitalize(r.name) + this.getTemplates().getInstanceOf("RuleContextNameSuffix").render();
    }

    public String getImplicitTokenLabel(String tokenName) {
        ST st = this.getTemplates().getInstanceOf("ImplicitTokenLabel");
        int ttype = this.getCodeGenerator().g.getTokenType(tokenName);
        if (tokenName.startsWith("'")) {
            return "s" + ttype;
        }
        String text = this.getTokenTypeAsTargetLabel(this.getCodeGenerator().g, ttype);
        st.add("tokenName", text);
        return st.render();
    }

    public String getImplicitSetLabel(String id) {
        ST st = this.getTemplates().getInstanceOf("ImplicitSetLabel");
        st.add("id", id);
        return st.render();
    }

    public String getImplicitRuleLabel(String ruleName) {
        ST st = this.getTemplates().getInstanceOf("ImplicitRuleLabel");
        st.add("ruleName", ruleName);
        return st.render();
    }

    public String getElementListName(String name) {
        ST st = this.getTemplates().getInstanceOf("ElementListName");
        st.add("elemName", this.getElementName(name));
        return st.render();
    }

    public String getElementName(String name) {
        if (".".equals(name)) {
            return "_wild";
        }
        if (this.getCodeGenerator().g.getRule(name) != null) {
            return name;
        }
        int ttype = this.getCodeGenerator().g.getTokenType(name);
        if (ttype == 0) {
            return name;
        }
        return this.getTokenTypeAsTargetLabel(this.getCodeGenerator().g, ttype);
    }

    public String getRecognizerFileName(boolean header) {
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String recognizerName = this.gen.g.getRecognizerName();
        return recognizerName + extST.render();
    }

    public String getListenerFileName(boolean header) {
        assert (this.gen.g.name != null);
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.gen.g.name + "Listener";
        return listenerName + extST.render();
    }

    public String getVisitorFileName(boolean header) {
        assert (this.gen.g.name != null);
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.gen.g.name + "Visitor";
        return listenerName + extST.render();
    }

    public String getBaseListenerFileName(boolean header) {
        assert (this.gen.g.name != null);
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.gen.g.name + "BaseListener";
        return listenerName + extST.render();
    }

    public String getBaseVisitorFileName(boolean header) {
        assert (this.gen.g.name != null);
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.gen.g.name + "BaseVisitor";
        return listenerName + extST.render();
    }

    public int getSerializedATNSegmentLimit() {
        return Integer.MAX_VALUE;
    }

    public int getInlineTestSetWordSize() {
        return 64;
    }

    public boolean grammarSymbolCausesIssueInGeneratedCode(GrammarAST idNode) {
        switch (idNode.getParent().getType()) {
            case 10: {
                switch (idNode.getParent().getParent().getType()) {
                    case 42: 
                    case 82: {
                        return false;
                    }
                }
                break;
            }
            case 11: 
            case 82: {
                return false;
            }
            case 86: {
                if (idNode.getChildIndex() != 0) break;
                return false;
            }
        }
        return this.visibleGrammarSymbolCausesIssueInGeneratedCode(idNode);
    }

    protected abstract boolean visibleGrammarSymbolCausesIssueInGeneratedCode(GrammarAST var1);

    public boolean templatesExist() {
        String groupFileName = "androidx/room/jarjarred/org/antlr/v4/tool/templates/codegen/" + this.getLanguage() + "/" + this.getLanguage() + STGroup.GROUP_FILE_EXTENSION;
        STGroupFile result = null;
        try {
            result = new STGroupFile(groupFileName);
        }
        catch (IllegalArgumentException iae) {
            result = null;
        }
        return result != null;
    }

    protected STGroup loadTemplates() {
        String groupFileName = "androidx/room/jarjarred/org/antlr/v4/tool/templates/codegen/" + this.getLanguage() + "/" + this.getLanguage() + STGroup.GROUP_FILE_EXTENSION;
        STGroupFile result = null;
        try {
            result = new STGroupFile(groupFileName);
        }
        catch (IllegalArgumentException iae) {
            this.gen.tool.errMgr.toolError(ErrorType.MISSING_CODE_GEN_TEMPLATES, iae, this.language);
        }
        if (result == null) {
            return null;
        }
        result.registerRenderer(Integer.class, new NumberRenderer());
        result.registerRenderer(String.class, new StringRenderer());
        result.setListener(new STErrorListener(){

            @Override
            public void compileTimeError(STMessage msg) {
                this.reportError(msg);
            }

            @Override
            public void runTimeError(STMessage msg) {
                this.reportError(msg);
            }

            @Override
            public void IOError(STMessage msg) {
                this.reportError(msg);
            }

            @Override
            public void internalError(STMessage msg) {
                this.reportError(msg);
            }

            private void reportError(STMessage msg) {
                Target.this.getCodeGenerator().tool.errMgr.toolError(ErrorType.STRING_TEMPLATE_WARNING, msg.cause, msg.toString());
            }
        });
        return result;
    }

    public boolean wantsBaseListener() {
        return true;
    }

    public boolean wantsBaseVisitor() {
        return true;
    }

    public boolean supportsOverloadedMethods() {
        return true;
    }

    public boolean needsHeader() {
        return false;
    }
}

