/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Insert;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.OnConflictProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.ShortcutMethodProcessor;
import androidx.room.solver.shortcut.binder.InsertMethodBinder;
import androidx.room.vo.Entity;
import androidx.room.vo.Field;
import androidx.room.vo.HasFieldsKt;
import androidx.room.vo.InsertionMethod;
import androidx.room.vo.Pojo;
import androidx.room.vo.ShortcutEntity;
import androidx.room.vo.ShortcutQueryParameter;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Landroidx/room/processor/InsertionMethodProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XType;", "executableElement", "Landroidx/room/compiler/processing/XMethodElement;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XMethodElement;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getExecutableElement", "()Landroidx/room/compiler/processing/XMethodElement;", "process", "Landroidx/room/vo/InsertionMethod;", "room-compiler"})
public final class InsertionMethodProcessor {
    @NotNull
    private final XType containing;
    @NotNull
    private final XMethodElement executableElement;
    @NotNull
    private final Context context;

    public InsertionMethodProcessor(@NotNull Context baseContext, @NotNull XType containing, @NotNull XMethodElement executableElement) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = Context.fork$default(baseContext, (XElement)this.executableElement, null, 2, null);
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XMethodElement getExecutableElement() {
        return this.executableElement;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final InsertionMethod process() {
        Integer n;
        XAnnotationBox annotation;
        ShortcutMethodProcessor delegate = new ShortcutMethodProcessor(this.context, this.containing, this.executableElement);
        XAnnotationBox xAnnotationBox = annotation = delegate.extractAnnotation(Reflection.getOrCreateKotlinClass(Insert.class), ProcessorErrors.INSTANCE.getMISSING_INSERT_ANNOTATION());
        if (xAnnotationBox == null) {
            n = null;
        } else {
            Insert insert = (Insert)xAnnotationBox.getValue();
            n = insert == null ? null : Integer.valueOf(insert.onConflict());
        }
        int onConflict = n == null ? OnConflictProcessor.INSTANCE.getINVALID_ON_CONFLICT() : n.intValue();
        this.context.getChecker().check(1 <= onConflict ? onConflict < 6 : false, (XElement)this.executableElement, ProcessorErrors.INSTANCE.getINVALID_ON_CONFLICT_VALUE(), new Object[0]);
        XType returnType = delegate.extractReturnType();
        TypeName returnTypeName = returnType.getTypeName();
        this.context.getChecker().notUnbound(returnTypeName, (XElement)this.executableElement, ProcessorErrors.INSTANCE.getCANNOT_USE_UNBOUND_GENERICS_IN_INSERTION_METHODS(), new Object[0]);
        XAnnotationBox xAnnotationBox2 = annotation;
        Pair<Map<String, ShortcutEntity>, List<ShortcutQueryParameter>> pair = delegate.extractParams(xAnnotationBox2 == null ? null : xAnnotationBox2.getAsType("entity"), ProcessorErrors.INSTANCE.getINSERTION_DOES_NOT_HAVE_ANY_PARAMETERS_TO_INSERT(), (Function2<? super Entity, ? super Pojo, Unit>)((Function2)new Function2<Entity, Pojo, Unit>(this){
            final /* synthetic */ InsertionMethodProcessor this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Entity entity, @NotNull Pojo pojo) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Field it;
                void $this$filterTo$iv$iv;
                Object element$iv;
                boolean bl;
                Object $this$any$iv;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                    Intrinsics.checkNotNullParameter((Object)pojo, (String)"pojo");
                    $this$any$iv = entity.getPrimaryKey().getFields();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator<T> iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            element$iv = iterator.next();
                            Field it2 = (Field)element$iv;
                            boolean bl2 = false;
                            if (!(HasFieldsKt.findFieldByColumnName(pojo, it2.getColumnName()) == null)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                boolean missingPrimaryKeys = bl;
                Checks checks = this.this$0.getContext().getChecker();
                boolean bl3 = entity.getPrimaryKey().getAutoGenerateId() || !missingPrimaryKeys;
                XElement xElement = (XElement)this.this$0.getExecutableElement();
                $this$any$iv = pojo.getTypeName().toString();
                Intrinsics.checkNotNullExpressionValue((Object)$this$any$iv, (String)"pojo.typeName.toString()");
                checks.check(bl3, xElement, ProcessorErrors.INSTANCE.missingPrimaryKeysInPartialEntityForInsert((String)$this$any$iv, entity.getPrimaryKey().getFields().getColumnNames$room_compiler()), new Object[0]);
                Object $this$filter$iv = CollectionsKt.minus((Iterable)entity.getFields(), (Iterable)entity.getPrimaryKey().getFields());
                boolean $i$f$filter = false;
                element$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Field)element$iv$iv;
                    boolean bl4 = false;
                    boolean bl5 = it.getNonNull() && it.getDefaultValue() == null && HasFieldsKt.findFieldByColumnName(pojo, it.getColumnName()) == null;
                    if (!bl5) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List missingRequiredFields = (List)destination$iv$iv;
                Checks checks2 = this.this$0.getContext().getChecker();
                boolean bl6 = missingRequiredFields.isEmpty();
                XElement xElement2 = (XElement)this.this$0.getExecutableElement();
                $this$filter$iv = pojo.getTypeName().toString();
                Intrinsics.checkNotNullExpressionValue((Object)$this$filter$iv, (String)"pojo.typeName.toString()");
                Object object = $this$filter$iv;
                $this$filter$iv = missingRequiredFields;
                Object object2 = object;
                ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                XElement xElement3 = xElement2;
                boolean bl7 = bl6;
                Checks checks3 = checks2;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Field)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl8 = false;
                    collection.add(it.getColumnName());
                }
                collection = (List)destination$iv$iv;
                checks3.check(bl7, xElement3, processorErrors.missingRequiredColumnsInPartialEntity((String)object2, (List<String>)collection), new Object[0]);
            }
        }));
        Map entities = (Map)pair.component1();
        List params2 = (List)pair.component2();
        InsertMethodBinder methodBinder = delegate.findInsertMethodBinder(returnType, params2);
        this.context.getChecker().check(methodBinder.getAdapter() != null, (XElement)this.executableElement, ProcessorErrors.INSTANCE.getCANNOT_FIND_INSERT_RESULT_ADAPTER(), new Object[0]);
        XMethodElement xMethodElement = this.executableElement;
        return new InsertionMethod(xMethodElement, onConflict, entities, returnType, params2, methodBinder);
    }
}

