/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.compiler.processing.XArrayType;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XRawType;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.compiler.processing.XTypeKt;
import androidx.room.compiler.processing.XVariableElement;
import androidx.room.processor.Context;
import androidx.room.processor.ProcessorErrors;
import androidx.room.vo.ShortcutQueryParameter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0010\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Landroidx/room/processor/ShortcutParameterProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XType;", "element", "Landroidx/room/compiler/processing/XVariableElement;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XVariableElement;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Landroidx/room/compiler/processing/XVariableElement;", "extractPojoType", "Lkotlin/Pair;", "", "typeMirror", "process", "Landroidx/room/vo/ShortcutQueryParameter;", "room-compiler"})
public final class ShortcutParameterProcessor {
    @NotNull
    private final XType containing;
    @NotNull
    private final XVariableElement element;
    @NotNull
    private final Context context;

    public ShortcutParameterProcessor(@NotNull Context baseContext, @NotNull XType containing, @NotNull XVariableElement element) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.containing = containing;
        this.element = element;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, 2, null);
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XVariableElement getElement() {
        return this.element;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final ShortcutQueryParameter process() {
        XType asMember = this.element.asMemberOf(this.containing);
        String name = this.element.getName();
        this.context.getChecker().check(!StringsKt.startsWith$default((String)name, (String)"_", (boolean)false, (int)2, null), (XElement)this.element, ProcessorErrors.INSTANCE.getQUERY_PARAMETERS_CANNOT_START_WITH_UNDERSCORE(), new Object[0]);
        Pair<XType, Boolean> pair = this.extractPojoType(asMember);
        XType pojoType = (XType)pair.component1();
        boolean isMultiple = (Boolean)pair.component2();
        return new ShortcutQueryParameter(this.element, name, asMember, pojoType, isMultiple);
    }

    private final Pair<XType, Boolean> extractPojoType(XType typeMirror) {
        XProcessingEnv processingEnv = this.context.getProcessingEnv();
        XRawType iterableType = processingEnv.requireType("java.lang.Iterable").getRawType();
        if (iterableType.isAssignableFrom(typeMirror)) {
            XType pojo = ShortcutParameterProcessor.extractPojoType$extractPojoTypeFromIterator(typeMirror);
            return ShortcutParameterProcessor.extractPojoType$verifyAndPair(pojo, true);
        }
        if (XTypeKt.isArray((XType)typeMirror)) {
            XType pojo = ((XArrayType)typeMirror).getComponentType();
            return ShortcutParameterProcessor.extractPojoType$verifyAndPair(pojo, true);
        }
        return ShortcutParameterProcessor.extractPojoType$verifyAndPair(typeMirror, false);
    }

    private static final Pair<XType, Boolean> extractPojoType$verifyAndPair(XType pojoType, boolean isMultiple) {
        XType boundedVar = pojoType.extendsBound();
        return boundedVar != null ? ShortcutParameterProcessor.extractPojoType$verifyAndPair(boundedVar, isMultiple) : new Pair((Object)pojoType, (Object)isMultiple);
    }

    private static final XType extractPojoType$extractPojoTypeFromIterator(XType iterableType) {
        XTypeElement xTypeElement = iterableType.getTypeElement();
        Intrinsics.checkNotNull((Object)xTypeElement);
        Sequence $this$forEach$iv = xTypeElement.getAllNonPrivateInstanceMethods();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XMethodElement it = (XMethodElement)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getJvmName(), (Object)"iterator")) continue;
            return (XType)CollectionsKt.first((List)it.asMemberOf(iterableType).getReturnType().getTypeArguments());
        }
        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"iterator() not found in Iterable ", (Object)iterableType));
    }
}

