/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.solver;

import androidx.room.compiler.processing.XType;
import androidx.room.solver.TypeConverterStore;
import androidx.room.solver.types.CompositeTypeConverter;
import androidx.room.solver.types.NoOpConverter;
import androidx.room.solver.types.TypeConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\"\u0010\n\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u0006H\u0016J\"\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003H\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0016J&\u0010\u000f\u001a\u0004\u0018\u00010\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0002J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Landroidx/room/solver/TypeConverterStoreImpl;", "Landroidx/room/solver/TypeConverterStore;", "typeConverters", "", "Landroidx/room/solver/types/TypeConverter;", "knownColumnTypes", "Landroidx/room/compiler/processing/XType;", "(Ljava/util/List;Ljava/util/List;)V", "getTypeConverters", "()Ljava/util/List;", "findConverterFromCursor", "columnTypes", "output", "findConverterIntoStatement", "input", "findTypeConverter", "inputs", "outputs", "getAllTypeConverters", "excludes", "room-compiler"})
public final class TypeConverterStoreImpl
implements TypeConverterStore {
    @NotNull
    private final List<TypeConverter> typeConverters;
    @NotNull
    private final List<XType> knownColumnTypes;

    public TypeConverterStoreImpl(@NotNull List<? extends TypeConverter> typeConverters, @NotNull List<? extends XType> knownColumnTypes) {
        Intrinsics.checkNotNullParameter(typeConverters, (String)"typeConverters");
        Intrinsics.checkNotNullParameter(knownColumnTypes, (String)"knownColumnTypes");
        this.typeConverters = typeConverters;
        this.knownColumnTypes = knownColumnTypes;
    }

    @Override
    @NotNull
    public List<TypeConverter> getTypeConverters() {
        return this.typeConverters;
    }

    @Override
    @Nullable
    public TypeConverter findConverterIntoStatement(@NotNull XType input, @Nullable List<? extends XType> columnTypes) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        List list = CollectionsKt.listOf((Object)input);
        List<? extends XType> list2 = columnTypes;
        if (list2 == null) {
            list2 = this.knownColumnTypes;
        }
        return this.findTypeConverter(list, list2);
    }

    @Override
    @Nullable
    public TypeConverter findConverterFromCursor(@Nullable List<? extends XType> columnTypes, @NotNull XType output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        List<? extends XType> list = columnTypes;
        if (list == null) {
            list = this.knownColumnTypes;
        }
        return this.findTypeConverter(list, CollectionsKt.listOf((Object)output));
    }

    @Override
    @Nullable
    public TypeConverter findTypeConverter(@NotNull XType input, @NotNull XType output) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return this.findTypeConverter(CollectionsKt.listOf((Object)input), CollectionsKt.listOf((Object)output));
    }

    private final TypeConverter findTypeConverter(List<? extends XType> inputs, List<? extends XType> outputs) {
        if (inputs.isEmpty()) {
            return null;
        }
        Iterable $this$forEach$iv = inputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            XType input;
            block11: {
                input = (XType)element$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = outputs;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        XType output = (XType)element$iv2;
                        boolean bl3 = false;
                        if (!input.isSameType(output)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return new NoOpConverter(input);
        }
        ArrayList<XType> excludes = new ArrayList<XType>();
        LinkedList<TypeConverter> queue2 = new LinkedList<TypeConverter>();
        Iterable $this$forEach$iv2 = inputs;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            XType input = (XType)element$iv;
            boolean bl = false;
            List<TypeConverter> candidates = this.getAllTypeConverters(input, (List<? extends XType>)excludes);
            TypeConverter match = TypeConverterStoreImpl.findTypeConverter$findMatchingConverter(candidates, outputs);
            if (match != null) {
                return match;
            }
            Iterable $this$forEach$iv3 = candidates;
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                TypeConverter it = (TypeConverter)element$iv3;
                boolean bl4 = false;
                excludes.add(it.getTo());
                queue2.add(it);
            }
        }
        excludes.addAll((Collection)inputs);
        while (!((Collection)queue2).isEmpty()) {
            TypeConverter prev = (TypeConverter)queue2.pop();
            XType from = prev.getTo();
            List<TypeConverter> candidates = this.getAllTypeConverters(from, (List<? extends XType>)excludes);
            TypeConverter match = TypeConverterStoreImpl.findTypeConverter$findMatchingConverter(candidates, outputs);
            if (match != null) {
                Intrinsics.checkNotNullExpressionValue((Object)prev, (String)"prev");
                return new CompositeTypeConverter(prev, match);
            }
            Iterable $this$forEach$iv4 = candidates;
            boolean $i$f$forEach4 = false;
            for (Object element$iv2 : $this$forEach$iv4) {
                TypeConverter it = (TypeConverter)element$iv2;
                boolean bl = false;
                excludes.add(it.getTo());
                Intrinsics.checkNotNullExpressionValue((Object)prev, (String)"prev");
                queue2.add(new CompositeTypeConverter(prev, it));
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final List<TypeConverter> getAllTypeConverters(XType input, List<? extends XType> excludes) {
        $this$filter$iv = this.getTypeConverters();
        $i$f$filter = false;
        var5_5 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block6: {
                converter = (TypeConverter)element$iv$iv;
                $i$a$-filter-TypeConverterStoreImpl$getAllTypeConverters$1 = false;
                if (!converter.getFrom().isAssignableFrom(input)) ** GOTO lbl-1000
                $this$any$iv = excludes;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (XType)element$iv;
                        $i$a$-any-TypeConverterStoreImpl$getAllTypeConverters$1$1 = false;
                        if (!it.isSameType(converter.getTo())) continue;
                        v0 = true;
                        break block6;
                    }
                    v0 = false;
                }
            }
            if (!v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$sortedByDescending$iv = (List)destination$iv$iv;
        $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(input){
            final /* synthetic */ XType $input$inlined;
            {
                this.$input$inlined = xType;
            }

            public final int compare(T a, T b) {
                TypeConverter it = (TypeConverter)b;
                boolean bl = false;
                int n = it.getFrom().isSameType(this.$input$inlined) ? 2 : 1;
                it = (TypeConverter)a;
                Comparable comparable = Integer.valueOf(n);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.getFrom().isSameType(this.$input$inlined) ? 2 : 1));
            }
        });
    }

    private static final TypeConverter findTypeConverter$findMatchingConverter(List<? extends TypeConverter> $this$findTypeConverter_u24findMatchingConverter, List<? extends XType> $outputs) {
        TypeConverter assignableMatchFallback = null;
        Iterable $this$forEach$iv = $this$findTypeConverter_u24findMatchingConverter;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeConverter converter = (TypeConverter)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = $outputs;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                XType output = (XType)element$iv2;
                boolean bl2 = false;
                if (output.isSameType(converter.getTo())) {
                    return converter;
                }
                if (assignableMatchFallback != null || !output.isAssignableFrom(converter.getTo())) continue;
                assignableMatchFallback = converter;
            }
        }
        return assignableMatchFallback;
    }
}

