/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Update;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.OnConflictProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.ShortcutMethodProcessor;
import androidx.room.solver.shortcut.binder.DeleteOrUpdateMethodBinder;
import androidx.room.vo.Entity;
import androidx.room.vo.Field;
import androidx.room.vo.HasFieldsKt;
import androidx.room.vo.Pojo;
import androidx.room.vo.ShortcutEntity;
import androidx.room.vo.ShortcutQueryParameter;
import androidx.room.vo.UpdateMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Landroidx/room/processor/UpdateMethodProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XType;", "executableElement", "Landroidx/room/compiler/processing/XMethodElement;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XMethodElement;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getExecutableElement", "()Landroidx/room/compiler/processing/XMethodElement;", "process", "Landroidx/room/vo/UpdateMethod;", "room-compiler"})
public final class UpdateMethodProcessor {
    @NotNull
    private final XType containing;
    @NotNull
    private final XMethodElement executableElement;
    @NotNull
    private final Context context;

    public UpdateMethodProcessor(@NotNull Context baseContext, @NotNull XType containing, @NotNull XMethodElement executableElement) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = Context.fork$default(baseContext, (XElement)this.executableElement, null, 2, null);
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XMethodElement getExecutableElement() {
        return this.executableElement;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final UpdateMethod process() {
        ShortcutMethodProcessor delegate = new ShortcutMethodProcessor(this.context, this.containing, this.executableElement);
        Update annotation = delegate.extractAnnotation(Reflection.getOrCreateKotlinClass(Update.class), ProcessorErrors.INSTANCE.getMISSING_UPDATE_ANNOTATION());
        Update update = annotation;
        int onConflict = update != null && (update = (Update)update.getValue()) != null ? update.onConflict() : OnConflictProcessor.INSTANCE.getINVALID_ON_CONFLICT();
        this.context.getChecker().check(1 <= onConflict ? onConflict < 6 : false, (XElement)this.executableElement, ProcessorErrors.INSTANCE.getINVALID_ON_CONFLICT_VALUE(), new Object[0]);
        Update update2 = annotation;
        Pair<Map<String, ShortcutEntity>, List<ShortcutQueryParameter>> pair = delegate.extractParams((XType)(update2 != null ? update2.getAsType("entity") : null), ProcessorErrors.INSTANCE.getUPDATE_MISSING_PARAMS(), (Function2<? super Entity, ? super Pojo, Unit>)((Function2)new Function2<Entity, Pojo, Unit>(this){
            final /* synthetic */ UpdateMethodProcessor this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Entity entity, @NotNull Pojo pojo) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Field it;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                Intrinsics.checkNotNullParameter((Object)pojo, (String)"pojo");
                Iterable $this$filter$iv = entity.getPrimaryKey().getFields();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Field)element$iv$iv;
                    boolean bl = false;
                    if (!(HasFieldsKt.findFieldByColumnName(pojo, it.getColumnName()) == null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List missingPrimaryKeys = (List)destination$iv$iv;
                Checks checks = this.this$0.getContext().getChecker();
                boolean bl = missingPrimaryKeys.isEmpty();
                XElement xElement = (XElement)this.this$0.getExecutableElement();
                String string = pojo.getTypeName().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pojo.typeName.toString()");
                $this$filter$iv = missingPrimaryKeys;
                String string2 = string;
                ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                XElement xElement2 = xElement;
                boolean bl2 = bl;
                Checks checks2 = checks;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Field)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getColumnName());
                }
                collection = (List)destination$iv$iv;
                checks2.check(bl2, xElement2, processorErrors.missingPrimaryKeysInPartialEntityForUpdate(string2, (List<String>)collection), new Object[0]);
            }
        }));
        Map entities = (Map)pair.component1();
        List params2 = (List)pair.component2();
        XType returnType = delegate.extractReturnType();
        DeleteOrUpdateMethodBinder methodBinder = delegate.findDeleteOrUpdateMethodBinder(returnType);
        this.context.getChecker().check(methodBinder.getAdapter() != null, (XElement)this.executableElement, ProcessorErrors.INSTANCE.getCANNOT_FIND_UPDATE_RESULT_ADAPTER(), new Object[0]);
        XMethodElement xMethodElement = delegate.getExecutableElement();
        return new UpdateMethod(xMethodElement, entities, params2, methodBinder, onConflict);
    }
}

