/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.RewriteQueriesToDropUnusedColumns;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XType;
import androidx.room.log.RLog;
import androidx.room.parser.expansion.ProjectionExpander;
import androidx.room.parser.optimization.RemoveUnusedColumnQueryRewriter;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.CustomConverterProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.QueryRewriter;
import androidx.room.processor.SuppressWarningProcessor;
import androidx.room.processor.cache.Cache;
import androidx.room.solver.TypeAdapterStore;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.vo.BuiltInConverterFlags;
import androidx.room.vo.Warning;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 K2\u00020\u0001:\u0004IJKLB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B9\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u00106\u001a\u0002072\u0006\u0010\u001c\u001a\u00020\u001bJ,\u00108\u001a\u000e\u0012\u0004\u0012\u0002H:\u0012\u0004\u0012\u00020;09\"\u0004\b\u0000\u0010:2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H:0=J\u001e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020@2\u000e\b\u0002\u0010A\u001a\b\u0012\u0004\u0012\u00020C0BJ\u000e\u0010D\u001a\u0002072\u0006\u0010E\u001a\u00020*J\u000e\u0010F\u001a\u0002072\u0006\u0010G\u001a\u00020*J\f\u0010H\u001a\u00020\u000e*\u00020@H\u0002R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001b\u0010#\u001a\u00020$8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&R\u001d\u0010)\u001a\u0004\u0018\u00010*8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010(\u001a\u0004\b+\u0010,R\u001b\u0010.\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010(\u001a\u0004\b/\u00100R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u00102\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010(\u001a\u0004\b3\u00104\u00a8\u0006M"}, d2={"Landroidx/room/processor/Context;", "", "processingEnv", "Landroidx/room/compiler/processing/XProcessingEnv;", "(Landroidx/room/compiler/processing/XProcessingEnv;)V", "logger", "Landroidx/room/log/RLog;", "typeConverters", "Landroidx/room/processor/CustomConverterProcessor$ProcessResult;", "inheritedAdapterStore", "Landroidx/room/solver/TypeAdapterStore;", "cache", "Landroidx/room/processor/cache/Cache;", "canRewriteQueriesToDropUnusedColumns", "", "(Landroidx/room/compiler/processing/XProcessingEnv;Landroidx/room/log/RLog;Landroidx/room/processor/CustomConverterProcessor$ProcessResult;Landroidx/room/solver/TypeAdapterStore;Landroidx/room/processor/cache/Cache;Z)V", "COMMON_TYPES", "Landroidx/room/processor/Context$CommonTypes;", "getCOMMON_TYPES", "()Landroidx/room/processor/Context$CommonTypes;", "getCache", "()Landroidx/room/processor/cache/Cache;", "checker", "Landroidx/room/preconditions/Checks;", "getChecker", "()Landroidx/room/preconditions/Checks;", "<set-?>", "Landroidx/room/verifier/DatabaseVerifier;", "databaseVerifier", "getDatabaseVerifier", "()Landroidx/room/verifier/DatabaseVerifier;", "getLogger", "()Landroidx/room/log/RLog;", "getProcessingEnv", "()Landroidx/room/compiler/processing/XProcessingEnv;", "queryRewriter", "Landroidx/room/processor/QueryRewriter;", "getQueryRewriter", "()Landroidx/room/processor/QueryRewriter;", "queryRewriter$delegate", "Lkotlin/Lazy;", "schemaOutFolderPath", "", "getSchemaOutFolderPath", "()Ljava/lang/String;", "schemaOutFolderPath$delegate", "typeAdapterStore", "getTypeAdapterStore", "()Landroidx/room/solver/TypeAdapterStore;", "typeAdapterStore$delegate", "useNullAwareConverter", "getUseNullAwareConverter", "()Z", "useNullAwareConverter$delegate", "attachDatabaseVerifier", "", "collectLogs", "Lkotlin/Pair;", "T", "Landroidx/room/log/RLog$CollectingMessager;", "handler", "Lkotlin/Function1;", "fork", "element", "Landroidx/room/compiler/processing/XElement;", "forceSuppressedWarnings", "", "Landroidx/room/vo/Warning;", "reportMissingType", "typeName", "reportMissingTypeReference", "containerName", "hasRemoveUnusedColumnsAnnotation", "BooleanProcessorOptions", "CommonTypes", "Companion", "ProcessorOptions", "room-compiler"})
public final class Context {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XProcessingEnv processingEnv;
    @NotNull
    private final RLog logger;
    @NotNull
    private final CustomConverterProcessor.ProcessResult typeConverters;
    @Nullable
    private final TypeAdapterStore inheritedAdapterStore;
    @NotNull
    private final Cache cache;
    private final boolean canRewriteQueriesToDropUnusedColumns;
    @NotNull
    private final Checks checker;
    @NotNull
    private final CommonTypes COMMON_TYPES;
    @NotNull
    private final Lazy useNullAwareConverter$delegate;
    @NotNull
    private final Lazy typeAdapterStore$delegate;
    @Nullable
    private DatabaseVerifier databaseVerifier;
    @NotNull
    private final Lazy queryRewriter$delegate;
    @NotNull
    private final Lazy schemaOutFolderPath$delegate;
    @NotNull
    private static final Lazy<List<String>> ARG_OPTIONS$delegate = LazyKt.lazy((Function0)Companion.ARG_OPTIONS.2.INSTANCE);

    private Context(XProcessingEnv processingEnv, RLog logger, CustomConverterProcessor.ProcessResult typeConverters, TypeAdapterStore inheritedAdapterStore, Cache cache, boolean canRewriteQueriesToDropUnusedColumns) {
        this.processingEnv = processingEnv;
        this.logger = logger;
        this.typeConverters = typeConverters;
        this.inheritedAdapterStore = inheritedAdapterStore;
        this.cache = cache;
        this.canRewriteQueriesToDropUnusedColumns = canRewriteQueriesToDropUnusedColumns;
        this.checker = new Checks(this.logger);
        this.COMMON_TYPES = new CommonTypes(this.processingEnv);
        this.useNullAwareConverter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ Context this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Boolean bl = BooleanProcessorOptions.USE_NULL_AWARE_CONVERTER.getInputValue(this.this$0.getProcessingEnv());
                return bl != null ? bl : this.this$0.getProcessingEnv().getBackend() == XProcessingEnv.Backend.KSP;
            }
        }));
        this.typeAdapterStore$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TypeAdapterStore>(this){
            final /* synthetic */ Context this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TypeAdapterStore invoke() {
                TypeAdapterStore typeAdapterStore2;
                if (Context.access$getInheritedAdapterStore$p(this.this$0) != null) {
                    typeAdapterStore2 = TypeAdapterStore.Companion.copy(this.this$0, Context.access$getInheritedAdapterStore$p(this.this$0));
                } else {
                    Object[] objectArray = new Object[]{Context.access$getTypeConverters$p(this.this$0).getConverters()};
                    typeAdapterStore2 = TypeAdapterStore.Companion.create(this.this$0, Context.access$getTypeConverters$p(this.this$0).getBuiltInConverterFlags(), objectArray);
                }
                return typeAdapterStore2;
            }
        }));
        this.queryRewriter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<QueryRewriter>(this){
            final /* synthetic */ Context this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final QueryRewriter invoke() {
                DatabaseVerifier verifier = this.this$0.getDatabaseVerifier();
                return verifier == null ? QueryRewriter.Companion.getNoOpRewriter() : (Context.access$getCanRewriteQueriesToDropUnusedColumns$p(this.this$0) ? (QueryRewriter)RemoveUnusedColumnQueryRewriter.INSTANCE : (BooleanProcessorOptions.EXPAND_PROJECTION.getValue(this.this$0.getProcessingEnv()) ? (QueryRewriter)new ProjectionExpander(verifier.getEntitiesAndViews()) : QueryRewriter.Companion.getNoOpRewriter()));
            }
        }));
        this.schemaOutFolderPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Context this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                String arg;
                String string = arg = (String)this.this$0.getProcessingEnv().getOptions().get(ProcessorOptions.OPTION_SCHEMA_FOLDER.getArgName());
                return (string != null ? ((CharSequence)string).length() > 0 : false) ? arg : (String)null;
            }
        }));
    }

    @NotNull
    public final XProcessingEnv getProcessingEnv() {
        return this.processingEnv;
    }

    @NotNull
    public final RLog getLogger() {
        return this.logger;
    }

    @NotNull
    public final Cache getCache() {
        return this.cache;
    }

    @NotNull
    public final Checks getChecker() {
        return this.checker;
    }

    @NotNull
    public final CommonTypes getCOMMON_TYPES() {
        return this.COMMON_TYPES;
    }

    public final boolean getUseNullAwareConverter() {
        Lazy lazy = this.useNullAwareConverter$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final TypeAdapterStore getTypeAdapterStore() {
        Lazy lazy = this.typeAdapterStore$delegate;
        return (TypeAdapterStore)lazy.getValue();
    }

    @Nullable
    public final DatabaseVerifier getDatabaseVerifier() {
        return this.databaseVerifier;
    }

    @NotNull
    public final QueryRewriter getQueryRewriter() {
        Lazy lazy = this.queryRewriter$delegate;
        return (QueryRewriter)lazy.getValue();
    }

    public final void attachDatabaseVerifier(@NotNull DatabaseVerifier databaseVerifier) {
        Intrinsics.checkNotNullParameter((Object)databaseVerifier, (String)"databaseVerifier");
        if (!(this.databaseVerifier == null)) {
            boolean bl = false;
            String string = "database verifier is already set";
            throw new IllegalStateException(string.toString());
        }
        this.databaseVerifier = databaseVerifier;
    }

    public Context(@NotNull XProcessingEnv processingEnv) {
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        this(processingEnv, new RLog(processingEnv.getMessager(), SetsKt.emptySet(), null), CustomConverterProcessor.ProcessResult.EMPTY.INSTANCE, null, new Cache(null, new LinkedHashSet<XType>(), SetsKt.emptySet(), BuiltInConverterFlags.Companion.getDEFAULT()), false);
    }

    @Nullable
    public final String getSchemaOutFolderPath() {
        Lazy lazy = this.schemaOutFolderPath$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final <T> Pair<T, RLog.CollectingMessager> collectLogs(@NotNull Function1<? super Context, ? extends T> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        RLog.CollectingMessager collector = new RLog.CollectingMessager();
        Context subContext = new Context(this.processingEnv, new RLog(collector, this.logger.getSuppressedWarnings(), this.logger.getDefaultElement()), this.typeConverters, this.getTypeAdapterStore(), this.cache, this.canRewriteQueriesToDropUnusedColumns);
        subContext.databaseVerifier = this.databaseVerifier;
        Object result = handler.invoke((Object)subContext);
        return new Pair(result, (Object)collector);
    }

    @NotNull
    public final Context fork(@NotNull XElement element, @NotNull Set<? extends Warning> forceSuppressedWarnings) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(forceSuppressedWarnings, (String)"forceSuppressedWarnings");
        Set<Warning> suppressedWarnings = SuppressWarningProcessor.INSTANCE.getSuppressedWarnings(element);
        CustomConverterProcessor.ProcessResult processConvertersResult = CustomConverterProcessor.Companion.findConverters(this, element);
        BuiltInConverterFlags subBuiltInConverterFlags = this.typeConverters.getBuiltInConverterFlags().withNext(processConvertersResult.getBuiltInConverterFlags());
        boolean canReUseAdapterStore = Intrinsics.areEqual((Object)subBuiltInConverterFlags, (Object)this.typeConverters.getBuiltInConverterFlags()) && processConvertersResult.getClasses().isEmpty();
        CustomConverterProcessor.ProcessResult subTypeConverters = canReUseAdapterStore ? this.typeConverters : processConvertersResult.plus(this.typeConverters);
        Set subSuppressedWarnings = SetsKt.plus((Set)SetsKt.plus(forceSuppressedWarnings, (Iterable)suppressedWarnings), (Iterable)this.logger.getSuppressedWarnings());
        Cache subCache = new Cache(this.cache, subTypeConverters.getClasses(), subSuppressedWarnings, subBuiltInConverterFlags);
        boolean subCanRemoveUnusedColumns = this.canRewriteQueriesToDropUnusedColumns || this.hasRemoveUnusedColumnsAnnotation(element);
        Context subContext = new Context(this.processingEnv, new RLog(this.logger.getMessager(), subSuppressedWarnings, element), subTypeConverters, canReUseAdapterStore ? this.getTypeAdapterStore() : null, subCache, subCanRemoveUnusedColumns);
        subContext.databaseVerifier = this.databaseVerifier;
        return subContext;
    }

    public static /* synthetic */ Context fork$default(Context context, XElement xElement, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return context.fork(xElement, set);
    }

    private final boolean hasRemoveUnusedColumnsAnnotation(XElement $this$hasRemoveUnusedColumnsAnnotation) {
        boolean bl;
        boolean annotated = bl = $this$hasRemoveUnusedColumnsAnnotation.hasAnnotation(Reflection.getOrCreateKotlinClass(RewriteQueriesToDropUnusedColumns.class));
        boolean bl2 = false;
        if (annotated && BooleanProcessorOptions.EXPAND_PROJECTION.getValue(this.processingEnv)) {
            this.logger.w(Warning.EXPAND_PROJECTION_WITH_REMOVE_UNUSED_COLUMNS, $this$hasRemoveUnusedColumnsAnnotation, ProcessorErrors.INSTANCE.getEXPAND_PROJECTION_ALONG_WITH_REMOVE_UNUSED(), new Object[0]);
        }
        return bl;
    }

    public final void reportMissingType(@NotNull String typeName2) {
        Intrinsics.checkNotNullParameter((Object)typeName2, (String)"typeName");
        this.logger.e("[MissingType]: Type '" + typeName2 + "' is not present", new Object[0]);
    }

    public final void reportMissingTypeReference(@NotNull String containerName) {
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        this.logger.e("[MissingType]: Element '" + containerName + "' references a type that is not present", new Object[0]);
    }

    public static final /* synthetic */ TypeAdapterStore access$getInheritedAdapterStore$p(Context $this) {
        return $this.inheritedAdapterStore;
    }

    public static final /* synthetic */ CustomConverterProcessor.ProcessResult access$getTypeConverters$p(Context $this) {
        return $this.typeConverters;
    }

    public static final /* synthetic */ boolean access$getCanRewriteQueriesToDropUnusedColumns$p(Context $this) {
        return $this.canRewriteQueriesToDropUnusedColumns;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Landroidx/room/processor/Context$Companion;", "", "()V", "ARG_OPTIONS", "", "", "getARG_OPTIONS", "()Ljava/util/List;", "ARG_OPTIONS$delegate", "Lkotlin/Lazy;", "room-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getARG_OPTIONS() {
            Lazy lazy = ARG_OPTIONS$delegate;
            return (List)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR\u001b\u0010\u000e\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Landroidx/room/processor/Context$CommonTypes;", "", "processingEnv", "Landroidx/room/compiler/processing/XProcessingEnv;", "(Landroidx/room/compiler/processing/XProcessingEnv;)V", "READONLY_COLLECTION", "Landroidx/room/compiler/processing/XType;", "getREADONLY_COLLECTION", "()Landroidx/room/compiler/processing/XType;", "READONLY_COLLECTION$delegate", "Lkotlin/Lazy;", "STRING", "getSTRING", "STRING$delegate", "VOID", "getVOID", "VOID$delegate", "getProcessingEnv", "()Landroidx/room/compiler/processing/XProcessingEnv;", "room-compiler"})
    public static final class CommonTypes {
        @NotNull
        private final XProcessingEnv processingEnv;
        @NotNull
        private final Lazy VOID$delegate;
        @NotNull
        private final Lazy STRING$delegate;
        @NotNull
        private final Lazy READONLY_COLLECTION$delegate;

        public CommonTypes(@NotNull XProcessingEnv processingEnv) {
            Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
            this.processingEnv = processingEnv;
            this.VOID$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
                final /* synthetic */ CommonTypes this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final XType invoke() {
                    return this.this$0.getProcessingEnv().requireType("java.lang.Void");
                }
            }));
            this.STRING$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
                final /* synthetic */ CommonTypes this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final XType invoke() {
                    return this.this$0.getProcessingEnv().requireType("java.lang.String");
                }
            }));
            this.READONLY_COLLECTION$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
                final /* synthetic */ CommonTypes this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final XType invoke() {
                    return this.this$0.getProcessingEnv().getBackend() == XProcessingEnv.Backend.KSP ? this.this$0.getProcessingEnv().requireType("kotlin.collections.Collection") : this.this$0.getProcessingEnv().requireType("java.util.Collection");
                }
            }));
        }

        @NotNull
        public final XProcessingEnv getProcessingEnv() {
            return this.processingEnv;
        }

        @NotNull
        public final XType getVOID() {
            Lazy lazy = this.VOID$delegate;
            return (XType)lazy.getValue();
        }

        @NotNull
        public final XType getSTRING() {
            Lazy lazy = this.STRING$delegate;
            return (XType)lazy.getValue();
        }

        @NotNull
        public final XType getREADONLY_COLLECTION() {
            Lazy lazy = this.READONLY_COLLECTION$delegate;
            return (XType)lazy.getValue();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Landroidx/room/processor/Context$ProcessorOptions;", "", "argName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getArgName", "()Ljava/lang/String;", "OPTION_SCHEMA_FOLDER", "room-compiler"})
    public static final class ProcessorOptions
    extends Enum<ProcessorOptions> {
        @NotNull
        private final String argName;
        public static final /* enum */ ProcessorOptions OPTION_SCHEMA_FOLDER = new ProcessorOptions("room.schemaLocation");
        private static final /* synthetic */ ProcessorOptions[] $VALUES;

        private ProcessorOptions(String argName) {
            this.argName = argName;
        }

        @NotNull
        public final String getArgName() {
            return this.argName;
        }

        public static ProcessorOptions[] values() {
            return (ProcessorOptions[])$VALUES.clone();
        }

        public static ProcessorOptions valueOf(String value) {
            return Enum.valueOf(ProcessorOptions.class, value);
        }

        static {
            $VALUES = processorOptionsArray = new ProcessorOptions[]{ProcessorOptions.OPTION_SCHEMA_FOLDER};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Landroidx/room/processor/Context$BooleanProcessorOptions;", "", "argName", "", "defaultValue", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getArgName", "()Ljava/lang/String;", "getInputValue", "processingEnv", "Landroidx/room/compiler/processing/XProcessingEnv;", "(Landroidx/room/compiler/processing/XProcessingEnv;)Ljava/lang/Boolean;", "getValue", "INCREMENTAL", "EXPAND_PROJECTION", "USE_NULL_AWARE_CONVERTER", "room-compiler"})
    public static final class BooleanProcessorOptions
    extends Enum<BooleanProcessorOptions> {
        @NotNull
        private final String argName;
        private final boolean defaultValue;
        public static final /* enum */ BooleanProcessorOptions INCREMENTAL = new BooleanProcessorOptions("room.incremental", true);
        public static final /* enum */ BooleanProcessorOptions EXPAND_PROJECTION = new BooleanProcessorOptions("room.expandProjection", false);
        public static final /* enum */ BooleanProcessorOptions USE_NULL_AWARE_CONVERTER = new BooleanProcessorOptions("room.useNullAwareTypeAnalysis", false);
        private static final /* synthetic */ BooleanProcessorOptions[] $VALUES;

        private BooleanProcessorOptions(String argName, boolean defaultValue) {
            this.argName = argName;
            this.defaultValue = defaultValue;
        }

        @NotNull
        public final String getArgName() {
            return this.argName;
        }

        public final boolean getValue(@NotNull XProcessingEnv processingEnv) {
            Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
            Boolean bl = this.getInputValue(processingEnv);
            return bl != null ? bl : this.defaultValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final Boolean getInputValue(@NotNull XProcessingEnv processingEnv) {
            String string;
            Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
            String string2 = (String)processingEnv.getOptions().get(this.argName);
            if (string2 == null) return null;
            String it = string = string2;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)it)) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            String string3 = string;
            String string4 = string3;
            if (string4 == null) return null;
            Boolean bl3 = Boolean.parseBoolean(string4);
            return bl3;
        }

        public static BooleanProcessorOptions[] values() {
            return (BooleanProcessorOptions[])$VALUES.clone();
        }

        public static BooleanProcessorOptions valueOf(String value) {
            return Enum.valueOf(BooleanProcessorOptions.class, value);
        }

        static {
            $VALUES = booleanProcessorOptionsArray = new BooleanProcessorOptions[]{BooleanProcessorOptions.INCREMENTAL, BooleanProcessorOptions.EXPAND_PROJECTION, BooleanProcessorOptions.USE_NULL_AWARE_CONVERTER};
        }
    }
}

