/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Entity;
import androidx.room.Fts3;
import androidx.room.Fts4;
import androidx.room.FtsOptions;
import androidx.room.PrimaryKey;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.log.RLog;
import androidx.room.parser.FtsVersion;
import androidx.room.parser.SQLTypeAffinity;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.EntityProcessor;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.FieldProcessor;
import androidx.room.processor.PojoProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.cache.Cache;
import androidx.room.vo.Constructor;
import androidx.room.vo.EmbeddedField;
import androidx.room.vo.Field;
import androidx.room.vo.Fields;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.FtsOptions;
import androidx.room.vo.HasFieldsKt;
import androidx.room.vo.LanguageId;
import androidx.room.vo.Pojo;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\bH\u0002J&\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0016\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001bH\u0002J\u0016\u0010%\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020&0\u001bH\u0002J\b\u0010'\u001a\u00020\u0011H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0011H\u0002R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Landroidx/room/processor/FtsTableEntityProcessor;", "Landroidx/room/processor/EntityProcessor;", "baseContext", "Landroidx/room/processor/Context;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "referenceStack", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XTypeElement;Ljava/util/LinkedHashSet;)V", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Landroidx/room/compiler/processing/XTypeElement;", "doProcess", "Landroidx/room/vo/FtsEntity;", "findAndValidateLanguageId", "Landroidx/room/vo/LanguageId;", "fields", "", "Landroidx/room/vo/Field;", "languageIdColumnName", "findAndValidatePrimaryKey", "Landroidx/room/vo/PrimaryKey;", "entityAnnotation", "Landroidx/room/compiler/processing/XAnnotationBox;", "Landroidx/room/Entity;", "getContentEntity", "Landroidx/room/vo/Entity;", "entityType", "Landroidx/room/compiler/processing/XType;", "getFts3Options", "Landroidx/room/vo/FtsOptions;", "annotation", "Landroidx/room/Fts3;", "getFts4Options", "Landroidx/room/Fts4;", "process", "validateExternalContentEntity", "", "ftsEntity", "room-compiler"})
public final class FtsTableEntityProcessor
implements EntityProcessor {
    @NotNull
    private final XTypeElement element;
    @NotNull
    private final LinkedHashSet<String> referenceStack;
    @NotNull
    private final Context context;

    public FtsTableEntityProcessor(@NotNull Context baseContext, @NotNull XTypeElement element, @NotNull LinkedHashSet<String> referenceStack) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(referenceStack, (String)"referenceStack");
        this.element = element;
        this.referenceStack = referenceStack;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, 2, null);
    }

    public /* synthetic */ FtsTableEntityProcessor(Context context, XTypeElement xTypeElement, LinkedHashSet linkedHashSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            linkedHashSet = new LinkedHashSet<String>();
        }
        this(context, xTypeElement, linkedHashSet);
    }

    @NotNull
    public final XTypeElement getElement() {
        return this.element;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public FtsEntity process() {
        androidx.room.vo.Entity entity = this.context.getCache().getEntities().get(new Cache.EntityKey((XElement)this.element), (Function0<androidx.room.vo.Entity>)((Function0)new Function0<androidx.room.vo.Entity>(this){
            final /* synthetic */ FtsTableEntityProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final androidx.room.vo.Entity invoke() {
                return FtsTableEntityProcessor.access$doProcess(this.this$0);
            }
        }));
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type androidx.room.vo.FtsEntity");
        return (FtsEntity)entity;
    }

    /*
     * WARNING - void declaration
     */
    private final FtsEntity doProcess() {
        boolean bl;
        Checks checks;
        androidx.room.vo.PrimaryKey primaryKey2;
        Object shadowTableName;
        FtsOptions ftsOptions;
        FtsVersion ftsVersion;
        Pojo pojo;
        String tableName;
        block7: {
            void $this$all$iv;
            Pair pair;
            this.context.getChecker().hasAnnotation((XElement)this.element, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Entity.class), ProcessorErrors.INSTANCE.getENTITY_MUST_BE_ANNOTATED_WITH_ENTITY(), new Object[0]);
            XAnnotationBox entityAnnotation = this.element.getAnnotation(Reflection.getOrCreateKotlinClass(Entity.class));
            tableName = null;
            if (entityAnnotation != null) {
                tableName = EntityProcessor.Companion.extractTableName(this.element, (Entity)entityAnnotation.getValue());
                this.context.getChecker().check(EntityProcessor.Companion.extractIndices((XAnnotationBox<Entity>)entityAnnotation, tableName).isEmpty(), (XElement)this.element, ProcessorErrors.INSTANCE.getINDICES_IN_FTS_ENTITY(), new Object[0]);
                this.context.getChecker().check(EntityProcessor.Companion.extractForeignKeys((XAnnotationBox<Entity>)entityAnnotation).isEmpty(), (XElement)this.element, ProcessorErrors.INSTANCE.getFOREIGN_KEYS_IN_FTS_ENTITY(), new Object[0]);
            } else {
                tableName = this.element.getName();
            }
            pojo = PojoProcessor.Companion.createFor(this.context, this.element, FieldProcessor.BindingScope.TWO_WAY, null, this.referenceStack).process();
            this.context.getChecker().check(pojo.getRelations().isEmpty(), (XElement)this.element, ProcessorErrors.INSTANCE.getRELATION_IN_ENTITY(), new Object[0]);
            if (this.element.hasAnnotation(Reflection.getOrCreateKotlinClass(Fts3.class))) {
                XAnnotationBox xAnnotationBox = this.element.getAnnotation(Reflection.getOrCreateKotlinClass(Fts3.class));
                Intrinsics.checkNotNull((Object)xAnnotationBox);
                pair = TuplesKt.to((Object)((Object)FtsVersion.FTS3), (Object)this.getFts3Options((XAnnotationBox<Fts3>)xAnnotationBox));
            } else {
                XAnnotationBox xAnnotationBox = this.element.getAnnotation(Reflection.getOrCreateKotlinClass(Fts4.class));
                Intrinsics.checkNotNull((Object)xAnnotationBox);
                pair = TuplesKt.to((Object)((Object)FtsVersion.FTS4), (Object)this.getFts4Options((XAnnotationBox<Fts4>)xAnnotationBox));
            }
            Pair pair2 = pair;
            ftsVersion = (FtsVersion)((Object)pair2.component1());
            ftsOptions = (FtsOptions)pair2.component2();
            shadowTableName = ftsOptions.getContentEntity() != null ? ftsOptions.getContentEntity().getTableName() : tableName + "_content";
            primaryKey2 = this.findAndValidatePrimaryKey((XAnnotationBox<Entity>)entityAnnotation, pojo.getFields());
            this.findAndValidateLanguageId(pojo.getFields(), ftsOptions.getLanguageIdColumnName());
            List missingNotIndexed = CollectionsKt.minus((Iterable)ftsOptions.getNotIndexedColumns(), (Iterable)HasFieldsKt.getColumnNames(pojo));
            this.context.getChecker().check(missingNotIndexed.isEmpty(), (XElement)this.element, ProcessorErrors.INSTANCE.missingNotIndexedField(missingNotIndexed), new Object[0]);
            Iterable iterable = ftsOptions.getPrefixSizes();
            checks = this.context.getChecker();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (it > 0) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        boolean bl3 = bl;
        checks.check(bl3, (XElement)this.element, ProcessorErrors.INSTANCE.getINVALID_FTS_ENTITY_PREFIX_SIZES(), new Object[0]);
        XTypeElement xTypeElement = this.element;
        XType xType = pojo.getType();
        Fields fields = pojo.getFields();
        List<EmbeddedField> list = pojo.getEmbeddedFields();
        Constructor constructor = pojo.getConstructor();
        FtsEntity entity = new FtsEntity(xTypeElement, tableName, xType, (List<Field>)fields, list, primaryKey2, constructor, (String)shadowTableName, ftsVersion, ftsOptions);
        this.validateExternalContentEntity(entity);
        return entity;
    }

    private final FtsOptions getFts3Options(XAnnotationBox<Fts3> annotation) {
        return new FtsOptions(((Fts3)annotation.getValue()).tokenizer(), ArraysKt.asList((Object[])((Fts3)annotation.getValue()).tokenizerArgs()), null, "", FtsOptions.MatchInfo.FTS4, CollectionsKt.emptyList(), CollectionsKt.emptyList(), FtsOptions.Order.ASC);
    }

    private final FtsOptions getFts4Options(XAnnotationBox<Fts4> annotation) {
        androidx.room.vo.Entity contentEntity = this.getContentEntity(annotation.getAsType("contentEntity"));
        return new FtsOptions(((Fts4)annotation.getValue()).tokenizer(), ArraysKt.asList((Object[])((Fts4)annotation.getValue()).tokenizerArgs()), contentEntity, ((Fts4)annotation.getValue()).languageId(), ((Fts4)annotation.getValue()).matchInfo(), ArraysKt.asList((Object[])((Fts4)annotation.getValue()).notIndexed()), ArraysKt.asList((int[])((Fts4)annotation.getValue()).prefix()), ((Fts4)annotation.getValue()).order());
    }

    private final androidx.room.vo.Entity getContentEntity(XType entityType) {
        if (entityType == null) {
            this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.getFTS_EXTERNAL_CONTENT_CANNOT_FIND_ENTITY(), new Object[0]);
            return null;
        }
        XType defaultType = this.context.getProcessingEnv().requireType(Reflection.getOrCreateKotlinClass(Object.class));
        if (entityType.isSameType(defaultType)) {
            return null;
        }
        XTypeElement contentEntityElement = entityType.getTypeElement();
        if (contentEntityElement == null) {
            this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.getFTS_EXTERNAL_CONTENT_CANNOT_FIND_ENTITY(), new Object[0]);
            return null;
        }
        if (!contentEntityElement.hasAnnotation(Reflection.getOrCreateKotlinClass(Entity.class))) {
            RLog rLog = this.context.getLogger();
            XElement xElement = (XElement)contentEntityElement;
            String string = contentEntityElement.getClassName().canonicalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contentEntityElement.className.canonicalName()");
            rLog.e(xElement, ProcessorErrors.INSTANCE.externalContentNotAnEntity(string), new Object[0]);
            return null;
        }
        return EntityProcessorKt.EntityProcessor(this.context, contentEntityElement, this.referenceStack).process();
    }

    /*
     * WARNING - void declaration
     */
    private final androidx.room.vo.PrimaryKey findAndValidatePrimaryKey(XAnnotationBox<Entity> entityAnnotation, List<Field> fields) {
        void $this$mapNotNullTo$iv$iv;
        List list;
        Iterator $this$forEach$iv$iv$iv;
        Object $this$mapNotNull$iv;
        String[] stringArray = entityAnnotation;
        if (entityAnnotation != null && (stringArray = (String[])stringArray.getValue()) != null && (stringArray = stringArray.primaryKeys()) != null) {
            void $this$mapNotNullTo$iv$iv2;
            $this$mapNotNull$iv = stringArray;
            boolean $i$f$mapNotNull = false;
            Object object = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            int n = ((Iterator<T>)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                androidx.room.vo.PrimaryKey primaryKey2;
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object v1;
                Iterable $this$firstOrNull$iv;
                Iterator pkColumnName;
                block13: {
                    Iterator element$iv$iv$iv;
                    Iterator element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    pkColumnName = element$iv$iv;
                    boolean bl2 = false;
                    $this$firstOrNull$iv = fields;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Field it = (Field)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getColumnName(), pkColumnName)) continue;
                        v1 = element$iv;
                        break block13;
                    }
                    v1 = null;
                }
                Field field = v1;
                $this$firstOrNull$iv = fields;
                Iterator iterator = pkColumnName;
                ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                XElement xElement = (XElement)this.element;
                boolean bl = field != null;
                Checks checks = this.context.getChecker();
                boolean $i$f$map = false;
                Iterator iterator2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Field field2 = (Field)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(it.getColumnName());
                }
                collection = (List)destination$iv$iv2;
                checks.check(bl, xElement, processorErrors.primaryKeyColumnDoesNotExist((String)((Object)iterator), (List<String>)collection), new Object[0]);
                if (field != null) {
                    Field pkField;
                    boolean bl5 = false;
                    primaryKey2 = new androidx.room.vo.PrimaryKey((XElement)pkField.getElement().getEnclosingElement(), new Fields(pkField), true);
                } else {
                    primaryKey2 = null;
                }
                if (primaryKey2 == null) continue;
                androidx.room.vo.PrimaryKey it$iv$iv = primaryKey2;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List keysFromEntityAnnotation = list;
        Iterable $this$mapNotNull$iv2 = fields;
        boolean $i$f$mapNotNull = false;
        $this$mapNotNull$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        $this$forEach$iv$iv$iv = $this$forEach$iv$iv$iv2.iterator();
        while ($this$forEach$iv$iv$iv.hasNext()) {
            androidx.room.vo.PrimaryKey it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv.next();
            boolean bl = false;
            Field field = (Field)element$iv$iv;
            boolean bl7 = false;
            if ((field.getElement().hasAnnotation(Reflection.getOrCreateKotlinClass(PrimaryKey.class)) ? new androidx.room.vo.PrimaryKey((XElement)field.getElement().getEnclosingElement(), new Fields(field), true) : (androidx.room.vo.PrimaryKey)null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List keysFromPrimaryKeyAnnotations = (List)destination$iv$iv;
        List primaryKeys = CollectionsKt.plus((Collection)keysFromEntityAnnotation, (Iterable)keysFromPrimaryKeyAnnotations);
        if (primaryKeys.isEmpty()) {
            Object v4;
            block14: {
                Iterable $this$firstOrNull$iv = fields;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Field it = (Field)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getColumnName(), (Object)"rowid")) continue;
                    v4 = element$iv;
                    break block14;
                }
                v4 = null;
            }
            Field field = v4;
            if (field != null) {
                Field it = field;
                boolean bl = false;
                this.context.getChecker().check(it.getElement().hasAnnotation(Reflection.getOrCreateKotlinClass(PrimaryKey.class)), (XElement)it.getElement(), ProcessorErrors.INSTANCE.getMISSING_PRIMARY_KEYS_ANNOTATION_IN_ROW_ID(), new Object[0]);
            }
            return androidx.room.vo.PrimaryKey.Companion.getMISSING();
        }
        this.context.getChecker().check(primaryKeys.size() == 1, (XElement)this.element, ProcessorErrors.INSTANCE.getTOO_MANY_PRIMARY_KEYS_IN_FTS_ENTITY(), new Object[0]);
        androidx.room.vo.PrimaryKey primaryKey3 = (androidx.room.vo.PrimaryKey)CollectionsKt.first((List)primaryKeys);
        Checks checks = this.context.getChecker();
        boolean bl = Intrinsics.areEqual((Object)CollectionsKt.first(HasFieldsKt.getColumnNames(primaryKey3)), (Object)"rowid");
        XElement xElement = primaryKey3.getDeclaredIn();
        if (xElement == null) {
            xElement = (XElement)this.element;
        }
        checks.check(bl, xElement, ProcessorErrors.INSTANCE.getINVALID_FTS_ENTITY_PRIMARY_KEY_NAME(), new Object[0]);
        Checks checks2 = this.context.getChecker();
        boolean bl9 = ((Field)CollectionsKt.first((List)primaryKey3.getFields())).getAffinity() == SQLTypeAffinity.INTEGER;
        XElement xElement2 = primaryKey3.getDeclaredIn();
        if (xElement2 == null) {
            xElement2 = (XElement)this.element;
        }
        checks2.check(bl9, xElement2, ProcessorErrors.INSTANCE.getINVALID_FTS_ENTITY_PRIMARY_KEY_AFFINITY(), new Object[0]);
        return primaryKey3;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateExternalContentEntity(FtsEntity ftsEntity) {
        void $this$filterNotTo$iv$iv;
        androidx.room.vo.Entity contentEntity = ftsEntity.getFtsOptions().getContentEntity();
        if (contentEntity == null) {
            return;
        }
        Iterable $this$filterNot$iv = ftsEntity.getNonHiddenFields();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl;
            block6: {
                Field it = (Field)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = contentEntity.getFields();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Field contentField = (Field)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)contentField.getColumnName(), (Object)it.getColumnName())) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it = (Field)element$iv;
            boolean bl = false;
            this.context.getLogger().e((XElement)it.getElement(), ProcessorErrors.INSTANCE.missingFtsContentField(this.element.getQualifiedName(), it.getColumnName(), contentEntity.getElement().getQualifiedName()), new Object[0]);
        }
    }

    private final LanguageId findAndValidateLanguageId(List<Field> fields, String languageIdColumnName) {
        Object v0;
        block3: {
            if (((CharSequence)languageIdColumnName).length() == 0) {
                return LanguageId.Companion.getMISSING();
            }
            Iterable $this$firstOrNull$iv = fields;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getColumnName(), (Object)languageIdColumnName)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Field languageIdField = v0;
        if (languageIdField == null) {
            this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.missingLanguageIdField(languageIdColumnName), new Object[0]);
            return LanguageId.Companion.getMISSING();
        }
        this.context.getChecker().check(languageIdField.getAffinity() == SQLTypeAffinity.INTEGER, (XElement)languageIdField.getElement(), ProcessorErrors.INSTANCE.getINVALID_FTS_ENTITY_LANGUAGE_ID_AFFINITY(), new Object[0]);
        return new LanguageId((XElement)languageIdField.getElement(), languageIdField);
    }

    public static final /* synthetic */ FtsEntity access$doProcess(FtsTableEntityProcessor $this) {
        return $this.doProcess();
    }
}

