/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.annotation.NonNull;
import androidx.room.compiler.processing.JavaPoetExtKt;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.Javapoet_extKt;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SupportDbTypeNames;
import androidx.room.migration.bundle.DatabaseViewBundle;
import androidx.room.migration.bundle.EntityBundle;
import androidx.room.migration.bundle.FtsEntityBundle;
import androidx.room.migration.bundle.IndexBundle;
import androidx.room.vo.AutoMigration;
import androidx.room.writer.AutoMigrationWriter;
import androidx.room.writer.ClassWriter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JD\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110,2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010/\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u00101\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00102\u001a\u00020)2\u0006\u0010.\u001a\u00020)2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110,H\u0002J\u0018\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u00105\u001a\u000206H\u0002J\n\u00107\u001a\u0004\u0018\u000106H\u0002J\b\u00108\u001a\u000209H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Landroidx/room/writer/AutoMigrationWriter;", "Landroidx/room/writer/ClassWriter;", "dbElement", "Landroidx/room/compiler/processing/XTypeElement;", "autoMigration", "Landroidx/room/vo/AutoMigration;", "(Landroidx/room/compiler/processing/XTypeElement;Landroidx/room/vo/AutoMigration;)V", "addedColumns", "", "Landroidx/room/vo/AutoMigration$AddedColumn;", "addedTables", "", "Landroidx/room/vo/AutoMigration$AddedTable;", "getAutoMigration", "()Landroidx/room/vo/AutoMigration;", "complexChangedTables", "", "", "Landroidx/room/vo/AutoMigration$ComplexChangedTable;", "deletedTables", "renamedTables", "addComplexChangeStatements", "", "migrateBuilder", "Lcom/squareup/javapoet/MethodSpec$Builder;", "addDatabaseExecuteSqlStatement", "sql", "addDeleteTableStatements", "addDropViewStatements", "addMigrationStatements", "addNewColumnStatements", "addNewTableStatements", "addRecreateViewStatements", "addRenameTableStatements", "addSimpleChangeStatements", "addStatementsToCheckForeignKeyConstraint", "tableName", "addStatementsToContentTransfer", "oldTableName", "tableNameWithNewPrefix", "oldEntityBundle", "Landroidx/room/migration/bundle/EntityBundle;", "newEntityBundle", "renamedColumnsMap", "", "addStatementsToCreateNewTable", "newTable", "addStatementsToDropTableAndRenameTempTable", "newTableName", "addStatementsToMigrateFtsTable", "oldTable", "addStatementsToRecreateIndexes", "table", "createConstructor", "Lcom/squareup/javapoet/MethodSpec;", "createMigrateMethod", "createTypeSpecBuilder", "Lcom/squareup/javapoet/TypeSpec$Builder;", "room-compiler"})
public final class AutoMigrationWriter
extends ClassWriter {
    @NotNull
    private final XTypeElement dbElement;
    @NotNull
    private final AutoMigration autoMigration;
    @NotNull
    private final List<AutoMigration.AddedColumn> addedColumns;
    @NotNull
    private final Set<AutoMigration.AddedTable> addedTables;
    @NotNull
    private final Map<String, String> renamedTables;
    @NotNull
    private final Map<String, AutoMigration.ComplexChangedTable> complexChangedTables;
    @NotNull
    private final List<String> deletedTables;

    public AutoMigrationWriter(@NotNull XTypeElement dbElement, @NotNull AutoMigration autoMigration) {
        Intrinsics.checkNotNullParameter((Object)dbElement, (String)"dbElement");
        Intrinsics.checkNotNullParameter((Object)autoMigration, (String)"autoMigration");
        super(autoMigration.getImplTypeName(dbElement.getClassName()));
        this.dbElement = dbElement;
        this.autoMigration = autoMigration;
        this.addedColumns = this.autoMigration.getSchemaDiff().getAddedColumns();
        this.addedTables = this.autoMigration.getSchemaDiff().getAddedTables();
        this.renamedTables = this.autoMigration.getSchemaDiff().getRenamedTables();
        this.complexChangedTables = this.autoMigration.getSchemaDiff().getComplexChangedTables();
        this.deletedTables = this.autoMigration.getSchemaDiff().getDeletedTables();
    }

    @NotNull
    public final AutoMigration getAutoMigration() {
        return this.autoMigration;
    }

    @Override
    @NotNull
    public TypeSpec.Builder createTypeSpecBuilder() {
        TypeSpec.Builder builder;
        TypeSpec.Builder builder2;
        TypeSpec.Builder $this$createTypeSpecBuilder_u24lambda_u2d1 = builder2 = (builder = TypeSpec.classBuilder((ClassName)this.autoMigration.getImplTypeName(this.dbElement.getClassName())));
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$createTypeSpecBuilder_u24lambda_u2d1, (String)"");
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)$this$createTypeSpecBuilder_u24lambda_u2d1, (XElement)((XElement)this.dbElement));
        $this$createTypeSpecBuilder_u24lambda_u2d1.superclass((TypeName)RoomTypeNames.INSTANCE.getMIGRATION());
        if (this.autoMigration.getSpecClassName() != null) {
            Modifier[] modifierArray = new Modifier[]{Modifier.PRIVATE, Modifier.FINAL};
            Modifier[] $this$createTypeSpecBuilder_u24lambda_u2d1_u24lambda_u2d0 = modifierArray = FieldSpec.builder((TypeName)((TypeName)RoomTypeNames.INSTANCE.getAUTO_MIGRATION_SPEC()), (String)"callback", (Modifier[])modifierArray);
            boolean bl2 = false;
            if (!this.autoMigration.isSpecProvided()) {
                Object[] objectArray = new Object[]{this.autoMigration.getSpecClassName()};
                $this$createTypeSpecBuilder_u24lambda_u2d1_u24lambda_u2d0.initializer("new " + Javapoet_extKt.getT() + "()", objectArray);
            }
            Modifier[] callbackField = modifierArray;
            builder.addField(callbackField.build());
        }
        $this$createTypeSpecBuilder_u24lambda_u2d1.addMethod(this.createConstructor());
        $this$createTypeSpecBuilder_u24lambda_u2d1.addMethod(this.createMigrateMethod());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        return builder;
    }

    private final MethodSpec createConstructor() {
        MethodSpec.Builder builder;
        MethodSpec.Builder $this$createConstructor_u24lambda_u2d2 = builder = MethodSpec.constructorBuilder();
        boolean bl = false;
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        $this$createConstructor_u24lambda_u2d2.addModifiers(objectArray);
        objectArray = new Object[]{this.autoMigration.getFrom(), this.autoMigration.getTo()};
        $this$createConstructor_u24lambda_u2d2.addStatement("super(" + Javapoet_extKt.getL() + ", " + Javapoet_extKt.getL() + ")", objectArray);
        if (this.autoMigration.isSpecProvided()) {
            $this$createConstructor_u24lambda_u2d2.addParameter(ParameterSpec.builder((TypeName)((TypeName)RoomTypeNames.INSTANCE.getAUTO_MIGRATION_SPEC()), (String)"callback", (Modifier[])new Modifier[0]).addAnnotation(NonNull.class).build());
            $this$createConstructor_u24lambda_u2d2.addStatement("this.callback = callback", new Object[0]);
        }
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"constructorBuilder().app\u2026      }\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createMigrateMethod() {
        MethodSpec.Builder builder;
        MethodSpec.Builder $this$createMigrateMethod_u24lambda_u2d3 = builder = MethodSpec.methodBuilder((String)"migrate");
        boolean bl = false;
        $this$createMigrateMethod_u24lambda_u2d3.addParameter(ParameterSpec.builder((TypeName)((TypeName)SupportDbTypeNames.INSTANCE.getDB()), (String)"database", (Modifier[])new Modifier[0]).addAnnotation(NonNull.class).build());
        $this$createMigrateMethod_u24lambda_u2d3.addAnnotation(Override.class);
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        $this$createMigrateMethod_u24lambda_u2d3.addModifiers(modifierArray);
        $this$createMigrateMethod_u24lambda_u2d3.returns(TypeName.VOID);
        Intrinsics.checkNotNullExpressionValue((Object)$this$createMigrateMethod_u24lambda_u2d3, (String)"this");
        this.addMigrationStatements($this$createMigrateMethod_u24lambda_u2d3);
        if (this.autoMigration.getSpecClassName() != null) {
            $this$createMigrateMethod_u24lambda_u2d3.addStatement("callback.onPostMigrate(database)", new Object[0]);
        }
        MethodSpec.Builder builder2 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"methodBuilder(\"migrate\")\u2026          }\n            }");
        MethodSpec.Builder migrateFunctionBuilder = builder2;
        return migrateFunctionBuilder.build();
    }

    private final void addMigrationStatements(MethodSpec.Builder migrateBuilder) {
        this.addDropViewStatements(migrateBuilder);
        this.addSimpleChangeStatements(migrateBuilder);
        this.addComplexChangeStatements(migrateBuilder);
        this.addRecreateViewStatements(migrateBuilder);
    }

    private final void addDropViewStatements(MethodSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.autoMigration.getSchemaDiff().getFromViews();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseViewBundle view = (DatabaseViewBundle)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, "DROP VIEW " + view.getViewName());
        }
    }

    private final void addRecreateViewStatements(MethodSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.autoMigration.getSchemaDiff().getToViews();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseViewBundle view = (DatabaseViewBundle)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, view.createView());
        }
    }

    private final void addComplexChangeStatements(MethodSpec.Builder migrateBuilder) {
        Iterable $this$sortedBy$iv = this.complexChangedTables.values();
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AutoMigration.ComplexChangedTable it = (AutoMigration.ComplexChangedTable)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.getNewVersionEntityBundle() instanceof FtsEntityBundle);
                it = (AutoMigration.ComplexChangedTable)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it.getNewVersionEntityBundle() instanceof FtsEntityBundle));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CharSequence charSequence;
            AutoMigration.ComplexChangedTable complexChangedTable = (AutoMigration.ComplexChangedTable)element$iv;
            boolean bl = false;
            String tableNameWithNewPrefix = complexChangedTable.component2();
            EntityBundle oldEntityBundle = complexChangedTable.component3();
            EntityBundle newEntityBundle = complexChangedTable.component4();
            Map<String, String> renamedColumnsMap = complexChangedTable.component5();
            if (oldEntityBundle instanceof FtsEntityBundle && !((charSequence = (CharSequence)((FtsEntityBundle)oldEntityBundle).getFtsOptions().getContentTable()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                this.addStatementsToMigrateFtsTable(migrateBuilder, oldEntityBundle, newEntityBundle, renamedColumnsMap);
                continue;
            }
            this.addStatementsToCreateNewTable(newEntityBundle, migrateBuilder);
            this.addStatementsToContentTransfer(oldEntityBundle.getTableName(), tableNameWithNewPrefix, oldEntityBundle, newEntityBundle, renamedColumnsMap, migrateBuilder);
            this.addStatementsToDropTableAndRenameTempTable(oldEntityBundle.getTableName(), newEntityBundle.getTableName(), tableNameWithNewPrefix, migrateBuilder);
            this.addStatementsToRecreateIndexes(newEntityBundle, migrateBuilder);
            if (!(!((Collection)newEntityBundle.getForeignKeys()).isEmpty())) continue;
            this.addStatementsToCheckForeignKeyConstraint(newEntityBundle.getTableName(), migrateBuilder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addStatementsToMigrateFtsTable(MethodSpec.Builder migrateBuilder, EntityBundle oldTable, EntityBundle newTable, Map<String, String> renamedColumnsMap) {
        void $this$addStatementsToMigrateFtsTable_u24lambda_u2d10;
        void $this$filterTo$iv$iv;
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "DROP TABLE `" + oldTable.getTableName() + "`");
        this.addDatabaseExecuteSqlStatement(migrateBuilder, newTable.createTable());
        Iterable $this$filter$iv = oldTable.getFieldsByColumnName().keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = oldTable.getFieldsByColumnName().keySet().contains(it) || renamedColumnsMap.containsKey(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newColumnSequence = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        List oldColumnSequence = new ArrayList();
        Iterable $this$forEach$iv = newColumnSequence;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            String column = (String)element$iv;
            boolean bl = false;
            String string = renamedColumnsMap.get(column);
            if (string == null) {
                string = column;
            }
            oldColumnSequence.add(string);
        }
        if (oldTable instanceof FtsEntityBundle) {
            oldColumnSequence.add("rowid");
            newColumnSequence.add("docid");
        }
        Intrinsics.checkNotNull((Object)newTable, (String)"null cannot be cast to non-null type androidx.room.migration.bundle.FtsEntityBundle");
        String contentTable = ((FtsEntityBundle)newTable).getFtsOptions().getContentTable();
        String selectFromTable = ((CharSequence)contentTable).length() == 0 ? oldTable.getTableName() : contentTable;
        Object element$iv = object = new StringBuilder();
        MethodSpec.Builder builder = migrateBuilder;
        AutoMigrationWriter autoMigrationWriter = this;
        boolean bl = false;
        $this$addStatementsToMigrateFtsTable_u24lambda_u2d10.append("INSERT INTO `" + newTable.getTableName() + "` (" + CollectionsKt.joinToString$default((Iterable)newColumnSequence, (CharSequence)",", null, null, (int)0, null, (Function1)addStatementsToMigrateFtsTable.2.1.INSTANCE, (int)30, null) + ") SELECT " + CollectionsKt.joinToString$default((Iterable)oldColumnSequence, (CharSequence)",", null, null, (int)0, null, (Function1)addStatementsToMigrateFtsTable.2.2.INSTANCE, (int)30, null) + " FROM `" + selectFromTable + "`");
        Unit unit = Unit.INSTANCE;
        String string = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        autoMigrationWriter.addDatabaseExecuteSqlStatement(builder, string);
    }

    private final void addSimpleChangeStatements(MethodSpec.Builder migrateBuilder) {
        this.addDeleteTableStatements(migrateBuilder);
        this.addRenameTableStatements(migrateBuilder);
        this.addNewColumnStatements(migrateBuilder);
        this.addNewTableStatements(migrateBuilder);
    }

    private final void addStatementsToCreateNewTable(EntityBundle newTable, MethodSpec.Builder migrateBuilder) {
        this.addDatabaseExecuteSqlStatement(migrateBuilder, newTable.createNewTable());
    }

    /*
     * WARNING - void declaration
     */
    private final void addStatementsToContentTransfer(String oldTableName, String tableNameWithNewPrefix, EntityBundle oldEntityBundle, EntityBundle newEntityBundle, Map<String, String> renamedColumnsMap, MethodSpec.Builder migrateBuilder) {
        void $this$addStatementsToContentTransfer_u24lambda_u2d13;
        StringBuilder stringBuilder;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = newEntityBundle.getFieldsByColumnName().keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = oldEntityBundle.getFieldsByColumnName().keySet().contains(it) || renamedColumnsMap.containsKey(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newColumnSequence = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        List oldColumnSequence = new ArrayList();
        Iterable $this$forEach$iv = newColumnSequence;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            String column = (String)element$iv;
            boolean bl = false;
            String string = renamedColumnsMap.get(column);
            if (string == null) {
                string = column;
            }
            oldColumnSequence.add(string);
        }
        StringBuilder $i$f$forEach22 = stringBuilder = new StringBuilder();
        MethodSpec.Builder builder = migrateBuilder;
        AutoMigrationWriter autoMigrationWriter = this;
        boolean bl = false;
        $this$addStatementsToContentTransfer_u24lambda_u2d13.append("INSERT INTO `" + tableNameWithNewPrefix + "` (" + CollectionsKt.joinToString$default((Iterable)newColumnSequence, (CharSequence)",", null, null, (int)0, null, (Function1)addStatementsToContentTransfer.2.1.INSTANCE, (int)30, null) + ") SELECT " + CollectionsKt.joinToString$default((Iterable)oldColumnSequence, (CharSequence)",", null, null, (int)0, null, (Function1)addStatementsToContentTransfer.2.2.INSTANCE, (int)30, null) + " FROM `" + oldTableName + "`");
        Unit unit = Unit.INSTANCE;
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        autoMigrationWriter.addDatabaseExecuteSqlStatement(builder, string);
    }

    private final void addStatementsToDropTableAndRenameTempTable(String oldTableName, String newTableName, String tableNameWithNewPrefix, MethodSpec.Builder migrateBuilder) {
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "DROP TABLE `" + oldTableName + "`");
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "ALTER TABLE `" + tableNameWithNewPrefix + "` RENAME TO `" + newTableName + "`");
    }

    private final void addStatementsToRecreateIndexes(EntityBundle table, MethodSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = table.getIndices();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexBundle index = (IndexBundle)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, index.getCreateSql(table.getTableName()));
        }
    }

    private final void addStatementsToCheckForeignKeyConstraint(String tableName, MethodSpec.Builder migrateBuilder) {
        Object[] objectArray = new Object[]{RoomTypeNames.INSTANCE.getDB_UTIL(), tableName};
        migrateBuilder.addStatement(Javapoet_extKt.getT() + ".foreignKeyCheck(database, " + Javapoet_extKt.getS() + ")", objectArray);
    }

    private final void addDeleteTableStatements(MethodSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.deletedTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String deleteTableSql;
            StringBuilder stringBuilder;
            String tableName = (String)element$iv;
            boolean bl = false;
            StringBuilder $this$addDeleteTableStatements_u24lambda_u2d16_u24lambda_u2d15 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$addDeleteTableStatements_u24lambda_u2d16_u24lambda_u2d15.append("DROP TABLE `" + tableName + "`");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, deleteTableSql);
        }
    }

    private final void addRenameTableStatements(MethodSpec.Builder migrateBuilder) {
        Map<String, String> $this$forEach$iv = this.renamedTables;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String renameTableSql;
            StringBuilder stringBuilder;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String oldName = entry.getKey();
            String newName = entry.getValue();
            StringBuilder $this$addRenameTableStatements_u24lambda_u2d18_u24lambda_u2d17 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$addRenameTableStatements_u24lambda_u2d18_u24lambda_u2d17.append("ALTER TABLE `" + oldName + "` RENAME TO `" + newName + "`");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, renameTableSql);
        }
    }

    private final void addNewColumnStatements(MethodSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.addedColumns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String addNewColumnSql;
            StringBuilder stringBuilder;
            AutoMigration.AddedColumn it = (AutoMigration.AddedColumn)element$iv;
            boolean bl = false;
            StringBuilder $this$addNewColumnStatements_u24lambda_u2d21_u24lambda_u2d20 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$addNewColumnStatements_u24lambda_u2d21_u24lambda_u2d20.append("ALTER TABLE `" + it.getTableName() + "` ADD COLUMN `" + it.getFieldBundle().getColumnName() + "` " + it.getFieldBundle().getAffinity());
            if (it.getFieldBundle().isNonNull()) {
                $this$addNewColumnStatements_u24lambda_u2d21_u24lambda_u2d20.append(" NOT NULL");
            }
            String string = it.getFieldBundle().getDefaultValue();
            boolean bl3 = string != null ? ((CharSequence)string).length() > 0 : false;
            if (bl3) {
                $this$addNewColumnStatements_u24lambda_u2d21_u24lambda_u2d20.append(" DEFAULT " + it.getFieldBundle().getDefaultValue());
            } else {
                if (!(!it.getFieldBundle().isNonNull())) {
                    boolean bl4 = false;
                    String string2 = "A Non-Null field should always have a default value.";
                    throw new IllegalStateException(string2.toString());
                }
                $this$addNewColumnStatements_u24lambda_u2d21_u24lambda_u2d20.append(" DEFAULT NULL");
            }
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, addNewColumnSql);
        }
    }

    private final void addNewTableStatements(MethodSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.addedTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AutoMigration.AddedTable addedTable = (AutoMigration.AddedTable)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, addedTable.getEntityBundle().createTable());
            this.addStatementsToRecreateIndexes(addedTable.getEntityBundle(), migrateBuilder);
        }
    }

    private final void addDatabaseExecuteSqlStatement(MethodSpec.Builder migrateBuilder, String sql) {
        Object[] objectArray = new Object[]{sql};
        migrateBuilder.addStatement("database.execSQL(" + Javapoet_extKt.getS() + ")", objectArray);
    }
}

