/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.room.RoomProcessor;
import androidx.room.compiler.processing.XFiler;
import androidx.room.compiler.processing.XFilerKt;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.Javapoet_extKt;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0002'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\b\u0010\u0018\u001a\u00020\u0013H&J\"\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\u0004\b\u0000\u0010\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0086\u0002\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"J\u001e\u0010#\u001a\u00020\n2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010%\u001a\u00020\nH\u0002J\u001d\u0010$\u001a\u00020\u00112\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010%\u001a\u00020\u0001H\u0086\u0002J\u000e\u0010&\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Landroidx/room/writer/ClassWriter;", "", "className", "Lcom/squareup/javapoet/ClassName;", "(Lcom/squareup/javapoet/ClassName;)V", "metadata", "", "Lkotlin/reflect/KClass;", "sharedFieldNames", "", "", "sharedFieldSpecs", "Lcom/squareup/javapoet/FieldSpec;", "sharedMethodNames", "sharedMethodSpecs", "Lcom/squareup/javapoet/MethodSpec;", "addGeneratedAnnotationIfAvailable", "", "adapterTypeSpecBuilder", "Lcom/squareup/javapoet/TypeSpec$Builder;", "processingEnv", "Landroidx/room/compiler/processing/XProcessingEnv;", "addSuppressWarnings", "builder", "createTypeSpecBuilder", "get", "T", "key", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "getOrCreateField", "sharedField", "Landroidx/room/writer/ClassWriter$SharedFieldSpec;", "getOrCreateMethod", "sharedMethod", "Landroidx/room/writer/ClassWriter$SharedMethodSpec;", "makeUnique", "set", "value", "write", "SharedFieldSpec", "SharedMethodSpec", "room-compiler"})
public abstract class ClassWriter {
    @NotNull
    private final ClassName className;
    @NotNull
    private final Map<String, FieldSpec> sharedFieldSpecs;
    @NotNull
    private final Map<String, MethodSpec> sharedMethodSpecs;
    @NotNull
    private final Set<String> sharedFieldNames;
    @NotNull
    private final Set<String> sharedMethodNames;
    @NotNull
    private final Map<KClass<?>, Object> metadata;

    public ClassWriter(@NotNull ClassName className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.className = className;
        this.sharedFieldSpecs = new LinkedHashMap();
        this.sharedMethodSpecs = new LinkedHashMap();
        this.sharedFieldNames = new LinkedHashSet();
        this.sharedMethodNames = new LinkedHashSet();
        this.metadata = new LinkedHashMap();
    }

    @NotNull
    public abstract TypeSpec.Builder createTypeSpecBuilder();

    @Nullable
    public final <T> T get(@NotNull KClass<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Object object = this.metadata.get(key);
        if (object == null) {
            object = null;
        }
        return (T)object;
    }

    public final void set(@NotNull KClass<?> key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.metadata.put(key, value);
    }

    public final void write(@NotNull XProcessingEnv processingEnv) {
        FieldSpec it;
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        TypeSpec.Builder builder = this.createTypeSpecBuilder();
        Iterable $this$forEach$iv = this.sharedFieldSpecs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FieldSpec)element$iv;
            boolean bl = false;
            builder.addField(it);
        }
        $this$forEach$iv = this.sharedMethodSpecs.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MethodSpec)element$iv;
            boolean bl = false;
            builder.addMethod((MethodSpec)it);
        }
        this.addGeneratedAnnotationIfAvailable(builder, processingEnv);
        this.addSuppressWarnings(builder);
        JavaFile javaFile = JavaFile.builder((String)this.className.packageName(), (TypeSpec)builder.build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)javaFile, (String)"builder(className.packag\u2026d())\n            .build()");
        XFilerKt.writeTo$default((JavaFile)javaFile, (XFiler)processingEnv.getFiler(), null, (int)2, null);
    }

    private final void addSuppressWarnings(TypeSpec.Builder builder) {
        Object[] objectArray = new Object[]{"unchecked", "deprecation"};
        AnnotationSpec suppressSpec = AnnotationSpec.builder((ClassName)Javapoet_extKt.getTypeName(Reflection.getOrCreateKotlinClass(SuppressWarnings.class))).addMember("value", "{" + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getS() + "}", objectArray).build();
        builder.addAnnotation(suppressSpec);
    }

    private final void addGeneratedAnnotationIfAvailable(TypeSpec.Builder adapterTypeSpecBuilder, XProcessingEnv processingEnv) {
        block0: {
            XTypeElement xTypeElement = processingEnv.findGeneratedAnnotation();
            if (xTypeElement == null) break block0;
            XTypeElement it = xTypeElement;
            boolean bl = false;
            Object[] objectArray = new Object[]{RoomProcessor.class.getCanonicalName()};
            AnnotationSpec generatedAnnotationSpec = AnnotationSpec.builder((ClassName)it.getClassName()).addMember("value", Javapoet_extKt.getS(), objectArray).build();
            adapterTypeSpecBuilder.addAnnotation(generatedAnnotationSpec);
        }
    }

    private final String makeUnique(Set<String> set, String value) {
        if (!StringsKt.startsWith$default((String)value, (String)"__", (boolean)false, (int)2, null)) {
            return this.makeUnique(set, "__" + value);
        }
        if (set.add(value)) {
            return value;
        }
        int index = 1;
        while (!set.add(value + "_" + index)) {
            ++index;
        }
        return value + "_" + index;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FieldSpec getOrCreateField(@NotNull SharedFieldSpec sharedField) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)sharedField, (String)"sharedField");
        Map<String, FieldSpec> map = this.sharedFieldSpecs;
        String key$iv = sharedField.getUniqueKey();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            FieldSpec answer$iv = sharedField.build(this, this.makeUnique(this.sharedFieldNames, sharedField.getBaseName()));
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (FieldSpec)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MethodSpec getOrCreateMethod(@NotNull SharedMethodSpec sharedMethod) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)sharedMethod, (String)"sharedMethod");
        Map<String, MethodSpec> map = this.sharedMethodSpecs;
        String key$iv = sharedMethod.getUniqueKey();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            MethodSpec answer$iv = sharedMethod.build(this, this.makeUnique(this.sharedMethodNames, sharedMethod.getBaseName()));
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (MethodSpec)object;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\b\u0010\u0010\u001a\u00020\u0003H&J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Landroidx/room/writer/ClassWriter$SharedFieldSpec;", "", "baseName", "", "type", "Lcom/squareup/javapoet/TypeName;", "(Ljava/lang/String;Lcom/squareup/javapoet/TypeName;)V", "getBaseName", "()Ljava/lang/String;", "getType", "()Lcom/squareup/javapoet/TypeName;", "build", "Lcom/squareup/javapoet/FieldSpec;", "classWriter", "Landroidx/room/writer/ClassWriter;", "name", "getUniqueKey", "prepare", "", "writer", "builder", "Lcom/squareup/javapoet/FieldSpec$Builder;", "room-compiler"})
    public static abstract class SharedFieldSpec {
        @NotNull
        private final String baseName;
        @NotNull
        private final TypeName type;

        public SharedFieldSpec(@NotNull String baseName, @NotNull TypeName type) {
            Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.baseName = baseName;
            this.type = type;
        }

        @NotNull
        public final String getBaseName() {
            return this.baseName;
        }

        @NotNull
        public final TypeName getType() {
            return this.type;
        }

        @NotNull
        public abstract String getUniqueKey();

        public abstract void prepare(@NotNull ClassWriter var1, @NotNull FieldSpec.Builder var2);

        @NotNull
        public final FieldSpec build(@NotNull ClassWriter classWriter, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)classWriter, (String)"classWriter");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.type, (String)name, (Modifier[])new Modifier[0]);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
            this.prepare(classWriter, builder);
            FieldSpec fieldSpec = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)fieldSpec, (String)"builder.build()");
            return fieldSpec;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\b\u0010\f\u001a\u00020\u0003H&J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Landroidx/room/writer/ClassWriter$SharedMethodSpec;", "", "baseName", "", "(Ljava/lang/String;)V", "getBaseName", "()Ljava/lang/String;", "build", "Lcom/squareup/javapoet/MethodSpec;", "writer", "Landroidx/room/writer/ClassWriter;", "name", "getUniqueKey", "prepare", "", "methodName", "builder", "Lcom/squareup/javapoet/MethodSpec$Builder;", "room-compiler"})
    public static abstract class SharedMethodSpec {
        @NotNull
        private final String baseName;

        public SharedMethodSpec(@NotNull String baseName) {
            Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
            this.baseName = baseName;
        }

        @NotNull
        public final String getBaseName() {
            return this.baseName;
        }

        @NotNull
        public abstract String getUniqueKey();

        public abstract void prepare(@NotNull String var1, @NotNull ClassWriter var2, @NotNull MethodSpec.Builder var3);

        @NotNull
        public final MethodSpec build(@NotNull ClassWriter writer, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
            this.prepare(name, writer, builder);
            MethodSpec methodSpec = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"builder.build()");
            return methodSpec;
        }
    }
}

