/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Delete;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.processor.Context;
import androidx.room.processor.DeletionMethodProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.ShortcutMethodProcessor;
import androidx.room.solver.shortcut.binder.DeleteOrUpdateMethodBinder;
import androidx.room.vo.DeletionMethod;
import androidx.room.vo.Entity;
import androidx.room.vo.Pojo;
import androidx.room.vo.ShortcutEntity;
import androidx.room.vo.ShortcutQueryParameter;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Landroidx/room/processor/DeletionMethodProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XType;", "executableElement", "Landroidx/room/compiler/processing/XMethodElement;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XMethodElement;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getExecutableElement", "()Landroidx/room/compiler/processing/XMethodElement;", "process", "Landroidx/room/vo/DeletionMethod;", "room-compiler"})
public final class DeletionMethodProcessor {
    @NotNull
    private final XType containing;
    @NotNull
    private final XMethodElement executableElement;
    @NotNull
    private final Context context;

    public DeletionMethodProcessor(@NotNull Context baseContext, @NotNull XType containing, @NotNull XMethodElement executableElement) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = Context.fork$default(baseContext, (XElement)this.executableElement, null, 2, null);
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XMethodElement getExecutableElement() {
        return this.executableElement;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final DeletionMethod process() {
        ShortcutMethodProcessor delegate = new ShortcutMethodProcessor(this.context, this.containing, this.executableElement);
        XAnnotationBox annotation = delegate.extractAnnotation(Reflection.getOrCreateKotlinClass(Delete.class), ProcessorErrors.INSTANCE.getMISSING_DELETE_ANNOTATION());
        XType returnType = delegate.extractReturnType();
        DeleteOrUpdateMethodBinder methodBinder = delegate.findDeleteOrUpdateMethodBinder(returnType);
        this.context.getChecker().check(methodBinder.getAdapter() != null, (XElement)this.executableElement, ProcessorErrors.INSTANCE.getCANNOT_FIND_DELETE_RESULT_ADAPTER(), new Object[0]);
        XAnnotationBox xAnnotationBox = annotation;
        Pair<Map<String, ShortcutEntity>, List<ShortcutQueryParameter>> pair = delegate.extractParams((XType)(xAnnotationBox != null ? xAnnotationBox.getAsType("entity") : null), ProcessorErrors.INSTANCE.getDELETION_MISSING_PARAMS(), (Function2<? super Entity, ? super Pojo, Unit>)((Function2)process.1.INSTANCE));
        Map entities = (Map)pair.component1();
        List params2 = (List)pair.component2();
        return new DeletionMethod(delegate.getExecutableElement(), entities, params2, methodBinder);
    }
}

