/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.MapInfo;
import androidx.room.RawQuery;
import androidx.room.Transaction;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XNullability;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.compiler.processing.XVariableElement;
import androidx.room.ext.SupportDbTypeNames;
import androidx.room.ext.Xelement_extKt;
import androidx.room.parser.ParsedQuery;
import androidx.room.parser.SqlParser;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.FieldProcessor;
import androidx.room.processor.MethodProcessorDelegate;
import androidx.room.processor.MethodProcessorDelegateKt;
import androidx.room.processor.PojoProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.solver.TypeAdapterExtras;
import androidx.room.solver.query.result.QueryResultBinder;
import androidx.room.vo.Entity;
import androidx.room.vo.Pojo;
import androidx.room.vo.RawQueryMethod;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Landroidx/room/processor/RawQueryMethodProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XType;", "executableElement", "Landroidx/room/compiler/processing/XMethodElement;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XMethodElement;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getExecutableElement", "()Landroidx/room/compiler/processing/XMethodElement;", "findRuntimeQueryParameter", "Landroidx/room/vo/RawQueryMethod$RuntimeQueryParameter;", "extractParams", "", "Landroidx/room/compiler/processing/XVariableElement;", "process", "Landroidx/room/vo/RawQueryMethod;", "processObservedTables", "", "", "room-compiler"})
public final class RawQueryMethodProcessor {
    @NotNull
    private final XType containing;
    @NotNull
    private final XMethodElement executableElement;
    @NotNull
    private final Context context;

    public RawQueryMethodProcessor(@NotNull Context baseContext, @NotNull XType containing, @NotNull XMethodElement executableElement) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = Context.fork$default(baseContext, (XElement)this.executableElement, null, 2, null);
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XMethodElement getExecutableElement() {
        return this.executableElement;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final RawQueryMethod process() {
        MethodProcessorDelegate delegate = MethodProcessorDelegate.Companion.createFor(this.context, this.containing, this.executableElement);
        XType returnType = delegate.extractReturnType();
        this.context.getChecker().check(this.executableElement.hasAnnotation(Reflection.getOrCreateKotlinClass(RawQuery.class)), (XElement)this.executableElement, ProcessorErrors.INSTANCE.getMISSING_RAWQUERY_ANNOTATION(), new Object[0]);
        TypeName returnTypeName = returnType.getTypeName();
        this.context.getChecker().notUnbound(returnTypeName, (XElement)this.executableElement, ProcessorErrors.INSTANCE.getCANNOT_USE_UNBOUND_GENERICS_IN_QUERY_METHODS(), new Object[0]);
        Checks checks = this.context.getChecker();
        boolean bl = !MethodProcessorDelegateKt.isSuspendAndReturnsDeferredType(delegate);
        XElement xElement = (XElement)this.executableElement;
        String string = returnType.getRawType().getTypeName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"returnType.rawType.typeName.toString()");
        checks.check(bl, xElement, ProcessorErrors.INSTANCE.suspendReturnsDeferredType(string), new Object[0]);
        Set<String> observedTableNames = this.processObservedTables();
        ParsedQuery query2 = SqlParser.Companion.rawQueryForTables(observedTableNames);
        QueryResultBinder resultBinder2 = delegate.findResultBinder(returnType, query2, (Function1<? super TypeAdapterExtras, Unit>)((Function1)new Function1<TypeAdapterExtras, Unit>(delegate, this){
            final /* synthetic */ MethodProcessorDelegate $delegate;
            final /* synthetic */ RawQueryMethodProcessor this$0;
            {
                this.$delegate = $delegate;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull TypeAdapterExtras $this$findResultBinder) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)$this$findResultBinder, (String)"$this$findResultBinder");
                    XAnnotationBox xAnnotationBox = this.$delegate.getExecutableElement().getAnnotation(Reflection.getOrCreateKotlinClass(MapInfo.class));
                    if (xAnnotationBox == null) break block0;
                    XAnnotationBox xAnnotationBox2 = xAnnotationBox;
                    RawQueryMethodProcessor rawQueryMethodProcessor = this.this$0;
                    XAnnotationBox it = xAnnotationBox2;
                    boolean bl = false;
                    String keyColumn = ((MapInfo)it.getValue()).keyColumn().toString();
                    String valueColumn = ((MapInfo)it.getValue()).valueColumn().toString();
                    rawQueryMethodProcessor.getContext().getChecker().check(((CharSequence)keyColumn).length() > 0 || ((CharSequence)valueColumn).length() > 0, (XElement)rawQueryMethodProcessor.getExecutableElement(), ProcessorErrors.INSTANCE.getMAP_INFO_MUST_HAVE_AT_LEAST_ONE_COLUMN_PROVIDED(), new Object[0]);
                    $this$findResultBinder.putData(Reflection.getOrCreateKotlinClass(androidx.room.vo.MapInfo.class), new androidx.room.vo.MapInfo(keyColumn, valueColumn));
                }
            }
        }));
        RawQueryMethod.RuntimeQueryParameter runtimeQueryParam = this.findRuntimeQueryParameter(delegate.extractParams());
        boolean inTransaction = this.executableElement.hasAnnotation(Reflection.getOrCreateKotlinClass(Transaction.class));
        XMethodElement xMethodElement = this.executableElement;
        String string2 = this.executableElement.getJvmName();
        RawQueryMethod rawQueryMethod = new RawQueryMethod(xMethodElement, string2, returnType, inTransaction, observedTableNames, runtimeQueryParam, resultBinder2);
        this.context.getChecker().check(rawQueryMethod.getReturnsValue(), (XElement)this.executableElement, ProcessorErrors.INSTANCE.getRAW_QUERY_BAD_RETURN_TYPE(), new Object[0]);
        return rawQueryMethod;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Set<String> processObservedTables() {
        Set set;
        List list;
        XAnnotationBox annotation = this.executableElement.getAnnotation(Reflection.getOrCreateKotlinClass(RawQuery.class));
        if (annotation != null && (list = annotation.getAsTypeList("observedEntities")) != null) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Object[] it;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull22 = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                XTypeElement it$iv$iv;
                XTypeElement xTypeElement;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                it = (Object[])element$iv$iv;
                boolean bl2 = false;
                XTypeElement typeElement = xTypeElement = it.getTypeElement();
                boolean bl3 = false;
                if (typeElement == null) {
                    this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.getNOT_ENTITY_OR_VIEW(), new Object[0]);
                }
                if (xTypeElement == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $i$f$mapNotNull22 = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list2;
                XTypeElement it2 = (XTypeElement)element$iv$iv;
                boolean bl = false;
                if (Xelement_extKt.isEntityElement((XElement)it2)) {
                    Entity entity = EntityProcessorKt.EntityProcessor$default(this.context, it2, null, 4, null).process();
                    it = new String[]{entity.getTableName()};
                    list2 = CollectionsKt.arrayListOf((Object[])it);
                } else {
                    Pojo pojo = PojoProcessor.Companion.createFor$default(PojoProcessor.Companion, this.context, it2, FieldProcessor.BindingScope.READ_FROM_CURSOR, null, null, 16, null).process();
                    List tableNames2 = pojo.accessedTableNames();
                    if (tableNames2.isEmpty()) {
                        this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.rawQueryBadEntity(it2.getType().getTypeName()), new Object[0]);
                    }
                    list2 = tableNames2;
                }
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            if (set2 != null) {
                set = set2;
                return set;
            }
        }
        set = SetsKt.emptySet();
        return set;
    }

    private final RawQueryMethod.RuntimeQueryParameter findRuntimeQueryParameter(List<? extends XVariableElement> extractParams) {
        if (extractParams.size() == 1 && !this.executableElement.isVarArgs()) {
            XType supportQueryType;
            boolean isSupportSql;
            XType param = ((XVariableElement)CollectionsKt.first(extractParams)).asMemberOf(this.containing);
            XProcessingEnv processingEnv = this.context.getProcessingEnv();
            if (param.getNullability() == XNullability.NULLABLE) {
                this.context.getLogger().e((XElement)CollectionsKt.first(extractParams), ProcessorErrors.INSTANCE.parameterCannotBeNullable(((XVariableElement)CollectionsKt.first(extractParams)).getName()), new Object[0]);
            }
            if (isSupportSql = (supportQueryType = processingEnv.requireType((TypeName)SupportDbTypeNames.INSTANCE.getQUERY())).isAssignableFrom(param)) {
                return new RawQueryMethod.RuntimeQueryParameter(extractParams.get(0).getName(), supportQueryType.getTypeName());
            }
            XType stringType = processingEnv.requireType("java.lang.String");
            boolean isString = stringType.isAssignableFrom(param);
            if (isString) {
                this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.getRAW_QUERY_STRING_PARAMETER_REMOVED(), new Object[0]);
                return null;
            }
        }
        this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.getRAW_QUERY_BAD_PARAMS(), new Object[0]);
        return null;
    }
}

