/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.parser.expansion;

import androidx.room.jarjarred.org.antlr.v4.runtime.RuleContext;
import androidx.room.jarjarred.org.antlr.v4.runtime.tree.ParseTree;
import androidx.room.jarjarred.org.antlr.v4.runtime.tree.TerminalNode;
import androidx.room.parser.QueryType;
import androidx.room.parser.SQLiteBaseVisitor;
import androidx.room.parser.SQLiteParser;
import androidx.room.parser.Table;
import androidx.room.parser.expansion.ExpandableParsedQuery;
import androidx.room.parser.expansion.ExpandableSection;
import androidx.room.parser.expansion.ExpandableSqlParserKt;
import androidx.room.parser.expansion.Position;
import androidx.room.parser.expansion.SectionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001&B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020!H\u0016J\u0014\u0010\"\u001a\u0004\u0018\u00010\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020%H\u0016R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00040\rj\b\u0012\u0004\u0012\u00020\u0004`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Landroidx/room/parser/expansion/ExpandableQueryVisitor;", "Landroidx/room/parser/SQLiteBaseVisitor;", "Ljava/lang/Void;", "original", "", "syntaxErrors", "", "statement", "Landroidx/room/jarjarred/org/antlr/v4/runtime/tree/ParseTree;", "forRuntimeQuery", "", "(Ljava/lang/String;Ljava/util/List;Lorg/antlr/v4/runtime/tree/ParseTree;Z)V", "bindingExpressions", "Ljava/util/ArrayList;", "Landroidx/room/parser/expansion/SectionInfo;", "Lkotlin/collections/ArrayList;", "explicitColumns", "queryType", "Landroidx/room/parser/QueryType;", "resultColumns", "tableNames", "", "Landroidx/room/parser/Table;", "withClauseNames", "createParsedQuery", "Landroidx/room/parser/expansion/ExpandableParsedQuery;", "findQueryType", "unescapeIdentifier", "text", "visitCommon_table_expression", "ctx", "Landroidx/room/parser/SQLiteParser$Common_table_expressionContext;", "visitExpr", "Landroidx/room/parser/SQLiteParser$ExprContext;", "visitResult_column", "Landroidx/room/parser/SQLiteParser$Result_columnContext;", "visitTable_or_subquery", "Landroidx/room/parser/SQLiteParser$Table_or_subqueryContext;", "Companion", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nExpandableSqlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpandableSqlParser.kt\nandroidx/room/parser/expansion/ExpandableQueryVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1549#2:231\n1620#2,3:232\n819#2:235\n847#2,2:236\n1855#2,2:238\n*S KotlinDebug\n*F\n+ 1 ExpandableSqlParser.kt\nandroidx/room/parser/expansion/ExpandableQueryVisitor\n*L\n46#1:231\n46#1:232,3\n48#1:235\n48#1:236,2\n175#1:238,2\n*E\n"})
public final class ExpandableQueryVisitor
extends SQLiteBaseVisitor<Void> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String original;
    @NotNull
    private final List<String> syntaxErrors;
    private final boolean forRuntimeQuery;
    @NotNull
    private final ArrayList<SectionInfo> resultColumns;
    @NotNull
    private final ArrayList<String> explicitColumns;
    @NotNull
    private final ArrayList<SectionInfo> bindingExpressions;
    @NotNull
    private final Set<Table> tableNames;
    @NotNull
    private final Set<String> withClauseNames;
    @NotNull
    private final QueryType queryType;
    @NotNull
    private static final List<String> ESCAPE_LITERALS;

    /*
     * WARNING - void declaration
     */
    public ExpandableQueryVisitor(@NotNull String original, @NotNull List<String> syntaxErrors, @NotNull ParseTree statement, boolean forRuntimeQuery) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter(syntaxErrors, (String)"syntaxErrors");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this.original = original;
        this.syntaxErrors = syntaxErrors;
        this.forRuntimeQuery = forRuntimeQuery;
        this.resultColumns = new ArrayList();
        this.explicitColumns = new ArrayList();
        this.bindingExpressions = new ArrayList();
        this.tableNames = new LinkedHashSet();
        this.withClauseNames = new LinkedHashSet();
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)statement.getChildCount());
        ExpandableQueryVisitor expandableQueryVisitor = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ParseTree parseTree = statement.getChild((int)it);
            Intrinsics.checkNotNullExpressionValue((Object)parseTree, (String)"statement.getChild(it)");
            collection.add(this.findQueryType(parseTree));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            QueryType it = (QueryType)((Object)element$iv$iv);
            boolean bl = false;
            if (it == QueryType.UNKNOWN) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        QueryType queryType = (QueryType)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
        if (queryType == null) {
            queryType = QueryType.UNKNOWN;
        }
        expandableQueryVisitor.queryType = queryType;
        statement.accept(this);
    }

    private final QueryType findQueryType(ParseTree statement) {
        ParseTree parseTree = statement;
        return parseTree instanceof SQLiteParser.Select_stmtContext ? QueryType.SELECT : ((parseTree instanceof SQLiteParser.Delete_stmt_limitedContext ? true : parseTree instanceof SQLiteParser.Delete_stmtContext) ? QueryType.DELETE : (parseTree instanceof SQLiteParser.Insert_stmtContext ? QueryType.INSERT : ((parseTree instanceof SQLiteParser.Update_stmtContext ? true : parseTree instanceof SQLiteParser.Update_stmt_limitedContext) ? QueryType.UPDATE : (parseTree instanceof TerminalNode ? (Intrinsics.areEqual((Object)((TerminalNode)statement).getText(), (Object)"EXPLAIN") ? QueryType.EXPLAIN : QueryType.UNKNOWN) : QueryType.UNKNOWN))));
    }

    @Override
    @Nullable
    public Void visitResult_column(@Nullable SQLiteParser.Result_columnContext ctx) {
        block7: {
            SQLiteParser.Result_columnContext result_columnContext = ctx;
            if (result_columnContext == null) break block7;
            SQLiteParser.Result_columnContext c = result_columnContext;
            boolean bl = false;
            RuleContext ruleContext = c.parent;
            Intrinsics.checkNotNullExpressionValue((Object)ruleContext, (String)"c.parent");
            if (ExpandableSqlParserKt.isCoreSelect(ruleContext)) {
                if (Intrinsics.areEqual((Object)c.getText(), (Object)"*")) {
                    ExpandableQueryVisitor.visitResult_column$addProjectionSection(this, c, ExpandableSection.Projection.All.INSTANCE);
                } else if (c.table_name() != null) {
                    String string = c.table_name().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"c.table_name().text");
                    char[] cArray = new char[]{'`'};
                    String string2 = StringsKt.trim((String)string, (char[])cArray);
                    String string3 = this.original.substring(c.start.getStartIndex(), c.stop.getStopIndex() + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    ExpandableQueryVisitor.visitResult_column$addProjectionSection(this, c, new ExpandableSection.Projection.Table(string2, string3));
                } else if (c.column_alias() != null) {
                    String string = c.column_alias().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"c.column_alias().text");
                    char[] cArray = new char[]{'`'};
                    this.explicitColumns.add(StringsKt.trim((String)string, (char[])cArray));
                } else {
                    String string = c.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"c.text");
                    char[] cArray = new char[]{'`'};
                    this.explicitColumns.add(StringsKt.trim((String)string, (char[])cArray));
                }
            }
        }
        return (Void)super.visitResult_column(ctx);
    }

    @Override
    @Nullable
    public Void visitExpr(@NotNull SQLiteParser.ExprContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        TerminalNode bindParameter = ctx.BIND_PARAMETER();
        if (bindParameter != null) {
            Position position = new Position(bindParameter.getSymbol().getLine() - 1, bindParameter.getSymbol().getCharPositionInLine());
            Position position2 = new Position(bindParameter.getSymbol().getLine() - 1, bindParameter.getSymbol().getCharPositionInLine() + bindParameter.getText().length());
            String string = bindParameter.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bindParameter.text");
            this.bindingExpressions.add(new SectionInfo(position, position2, new ExpandableSection.BindVar(string)));
        }
        return (Void)super.visitExpr(ctx);
    }

    @NotNull
    public final ExpandableParsedQuery createParsedQuery() {
        String string = this.original;
        QueryType queryType = this.queryType;
        List list = CollectionsKt.toList((Iterable)this.resultColumns);
        List list2 = CollectionsKt.toList((Iterable)this.explicitColumns);
        List list3 = CollectionsKt.toList((Iterable)this.bindingExpressions);
        Set<Table> set = this.tableNames;
        List<String> list4 = this.syntaxErrors;
        boolean bl = this.forRuntimeQuery;
        return new ExpandableParsedQuery(string, queryType, list3, list, list2, set, list4, bl);
    }

    @Override
    @Nullable
    public Void visitCommon_table_expression(@NotNull SQLiteParser.Common_table_expressionContext ctx) {
        String tableName;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        SQLiteParser.Table_nameContext table_nameContext = ctx.table_name();
        String string = tableName = table_nameContext != null ? table_nameContext.getText() : null;
        if (tableName != null) {
            this.withClauseNames.add(this.unescapeIdentifier(tableName));
        }
        return (Void)super.visitCommon_table_expression(ctx);
    }

    @Override
    @Nullable
    public Void visitTable_or_subquery(@NotNull SQLiteParser.Table_or_subqueryContext ctx) {
        String tableName;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        SQLiteParser.Table_nameContext table_nameContext = ctx.table_name();
        String string = tableName = table_nameContext != null ? table_nameContext.getText() : null;
        if (tableName != null) {
            String tableAlias;
            SQLiteParser.Table_aliasContext table_aliasContext = ctx.table_alias();
            String string2 = tableAlias = table_aliasContext != null ? table_aliasContext.getText() : null;
            if (!this.withClauseNames.contains(tableName)) {
                String string3 = this.unescapeIdentifier(tableName);
                String string4 = tableAlias;
                if (string4 == null) {
                    string4 = tableName;
                }
                this.tableNames.add(new Table(string3, this.unescapeIdentifier(string4)));
            }
        }
        return (Void)super.visitTable_or_subquery(ctx);
    }

    private final String unescapeIdentifier(String text) {
        String trimmed = ((Object)StringsKt.trim((CharSequence)text)).toString();
        Iterable $this$forEach$iv = ESCAPE_LITERALS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)trimmed, (String)it, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)trimmed, (String)it, (boolean)false, (int)2, null)) continue;
            String string = trimmed.substring(1, trimmed.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return this.unescapeIdentifier(string);
        }
        return trimmed;
    }

    private static final void visitResult_column$addProjectionSection(ExpandableQueryVisitor this$0, SQLiteParser.Result_columnContext c, ExpandableSection.Projection p) {
        this$0.resultColumns.add(new SectionInfo(new Position(c.start.getLine() - 1, c.start.getCharPositionInLine()), new Position(c.stop.getLine() - 1, c.stop.getCharPositionInLine() + c.stop.getText().length()), p));
    }

    static {
        Object[] objectArray = new String[]{"\"", "'", "`"};
        ESCAPE_LITERALS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/room/parser/expansion/ExpandableQueryVisitor$Companion;", "", "()V", "ESCAPE_LITERALS", "", "", "room-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

