/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.MapInfo;
import androidx.room.SkipQueryVerification;
import androidx.room.Transaction;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.ext.Xtype_extKt;
import androidx.room.log.RLog;
import androidx.room.parser.ParsedQuery;
import androidx.room.parser.QueryType;
import androidx.room.parser.Section;
import androidx.room.parser.SqlParser;
import androidx.room.parser.Table;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.MethodProcessorDelegate;
import androidx.room.processor.MethodProcessorDelegateKt;
import androidx.room.processor.ProcessorErrors;
import androidx.room.solver.TypeAdapterExtras;
import androidx.room.solver.prepared.binder.PreparedQueryResultBinder;
import androidx.room.solver.query.result.PojoRowAdapter;
import androidx.room.solver.query.result.QueryMappedRowAdapter;
import androidx.room.solver.query.result.QueryResultAdapter;
import androidx.room.solver.query.result.QueryResultBinder;
import androidx.room.solver.query.result.RowAdapter;
import androidx.room.verifier.ColumnInfo;
import androidx.room.verifier.DatabaseVerificationErrors;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.verifier.QueryResultInfo;
import androidx.room.vo.QueryMethod;
import androidx.room.vo.QueryParameter;
import androidx.room.vo.ReadQueryMethod;
import androidx.room.vo.Warning;
import androidx.room.vo.WriteQueryMethod;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J.\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u001b2\b\u0010%\u001a\u0004\u0018\u00010&J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001bH\u0002J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006+"}, d2={"Landroidx/room/processor/InternalQueryProcessor;", "", "context", "Landroidx/room/processor/Context;", "executableElement", "Landroidx/room/compiler/processing/XMethodElement;", "containing", "Landroidx/room/compiler/processing/XType;", "dbVerifier", "Landroidx/room/verifier/DatabaseVerifier;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XMethodElement;Landroidx/room/compiler/processing/XType;Landroidx/room/verifier/DatabaseVerifier;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "getContext", "()Landroidx/room/processor/Context;", "getDbVerifier", "()Landroidx/room/verifier/DatabaseVerifier;", "getExecutableElement", "()Landroidx/room/compiler/processing/XMethodElement;", "getPreparedQueryMethod", "Landroidx/room/vo/WriteQueryMethod;", "delegate", "Landroidx/room/processor/MethodProcessorDelegate;", "returnType", "query", "Landroidx/room/parser/ParsedQuery;", "getQueryMethod", "Landroidx/room/vo/QueryMethod;", "processMapInfo", "", "mapInfoAnnotation", "Landroidx/room/compiler/processing/XAnnotationBox;", "Landroidx/room/MapInfo;", "queryExecutableElement", "adapterExtras", "Landroidx/room/solver/TypeAdapterExtras;", "processQuery", "input", "", "processQueryMethod", "queryMethod", "validateQuery", "Companion", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nQueryMethodProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryMethodProcessor.kt\nandroidx/room/processor/InternalQueryProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,349:1\n766#2:350\n857#2,2:351\n1549#2:353\n1620#2,3:354\n819#2:357\n847#2:358\n1747#2,3:359\n848#2:362\n1549#2:363\n1620#2,3:364\n1747#2,3:367\n2624#2,3:370\n1360#2:373\n1446#2,5:374\n1549#2:379\n1620#2,3:380\n800#2,11:383\n766#2:394\n857#2,2:395\n1179#2,2:397\n1253#2,4:399\n1549#2:403\n1620#2,3:404\n1179#2,2:408\n1253#2,4:410\n1747#2,3:414\n1#3:407\n*S KotlinDebug\n*F\n+ 1 QueryMethodProcessor.kt\nandroidx/room/processor/InternalQueryProcessor\n*L\n153#1:350\n153#1:351,2\n154#1:353\n154#1:354,3\n162#1:357\n162#1:358\n163#1:359,3\n162#1:362\n164#1:363\n164#1:364,3\n233#1:367,3\n248#1:370,3\n251#1:373\n251#1:374,5\n252#1:379\n252#1:380,3\n254#1:383,11\n256#1:394\n256#1:395,2\n257#1:397,2\n257#1:399,4\n260#1:403\n260#1:404,3\n298#1:408,2\n298#1:410,4\n305#1:414,3\n*E\n"})
final class InternalQueryProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final XMethodElement executableElement;
    @NotNull
    private final XType containing;
    @Nullable
    private final DatabaseVerifier dbVerifier;
    @NotNull
    private static final QueryType[] PREPARED_TYPES;

    public InternalQueryProcessor(@NotNull Context context, @NotNull XMethodElement executableElement, @NotNull XType containing, @Nullable DatabaseVerifier dbVerifier) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)executableElement, (String)"executableElement");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        this.context = context;
        this.executableElement = executableElement;
        this.containing = containing;
        this.dbVerifier = dbVerifier;
    }

    public /* synthetic */ InternalQueryProcessor(Context context, XMethodElement xMethodElement, XType xType, DatabaseVerifier databaseVerifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            databaseVerifier = null;
        }
        this(context, xMethodElement, xType, databaseVerifier);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final XMethodElement getExecutableElement() {
        return this.executableElement;
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @Nullable
    public final DatabaseVerifier getDbVerifier() {
        return this.dbVerifier;
    }

    @NotNull
    public final QueryMethod processQuery(@Nullable String input) {
        ParsedQuery parsedQuery;
        MethodProcessorDelegate delegate = MethodProcessorDelegate.Companion.createFor(this.context, this.containing, this.executableElement);
        XType returnType = delegate.extractReturnType();
        Checks checks = this.context.getChecker();
        boolean bl = !MethodProcessorDelegateKt.isSuspendAndReturnsDeferredType(delegate);
        XElement xElement = (XElement)this.executableElement;
        String string = returnType.getRawType().getTypeName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"returnType.rawType.typeName.toString()");
        checks.check(bl, xElement, ProcessorErrors.INSTANCE.suspendReturnsDeferredType(string), new Object[0]);
        if (input != null) {
            ParsedQuery query2 = SqlParser.Companion.parse(input);
            this.context.getChecker().check(query2.getErrors().isEmpty(), (XElement)this.executableElement, CollectionsKt.joinToString$default((Iterable)query2.getErrors(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new Object[0]);
            this.validateQuery(query2);
            Object[] objectArray = new Object[]{this.executableElement};
            this.context.getChecker().check(Xtype_extKt.isNotError(returnType), (XElement)this.executableElement, ProcessorErrors.INSTANCE.getCANNOT_RESOLVE_RETURN_TYPE(), objectArray);
            parsedQuery = query2;
        } else {
            parsedQuery = ParsedQuery.Companion.getMISSING();
        }
        ParsedQuery query3 = parsedQuery;
        this.context.getChecker().notUnbound(returnType, (XElement)this.executableElement, ProcessorErrors.INSTANCE.getCANNOT_USE_UNBOUND_GENERICS_IN_QUERY_METHODS(), new Object[0]);
        boolean isPreparedQuery = ArraysKt.contains((Object[])PREPARED_TYPES, (Object)((Object)query3.getType()));
        QueryMethod queryMethod = isPreparedQuery ? (QueryMethod)this.getPreparedQueryMethod(delegate, returnType, query3) : this.getQueryMethod(delegate, returnType, query3);
        return this.processQueryMethod(queryMethod);
    }

    /*
     * WARNING - void declaration
     */
    private final QueryMethod processQueryMethod(QueryMethod queryMethod) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Pair it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = queryMethod.getSectionToParamMapping();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(it.getSecond() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Section.BindVar)it.getFirst()).getText());
        }
        List missing = (List)destination$iv$iv;
        if (!((Collection)missing).isEmpty()) {
            this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.missingParameterForBindVariable(missing), new Object[0]);
        }
        Iterable $this$filterNot$iv = queryMethod.getParameters();
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl;
            block9: {
                QueryParameter param = (QueryParameter)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = queryMethod.getSectionToParamMapping();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Pair it2 = (Pair)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it2.getSecond(), (Object)param)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            QueryParameter param = (QueryParameter)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(p0.getSqlName());
        }
        List unused = (List)destination$iv$iv2;
        if (!((Collection)unused).isEmpty()) {
            this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.unusedQueryMethodParameter(unused), new Object[0]);
        }
        return queryMethod;
    }

    private final void validateQuery(ParsedQuery query2) {
        boolean skipQueryVerification = this.executableElement.hasAnnotation(Reflection.getOrCreateKotlinClass(SkipQueryVerification.class));
        if (skipQueryVerification) {
            return;
        }
        DatabaseVerifier databaseVerifier = this.dbVerifier;
        query2.setResultInfo(databaseVerifier != null ? databaseVerifier.analyze(query2.getOriginal()) : null);
        QueryResultInfo queryResultInfo = query2.getResultInfo();
        if ((queryResultInfo != null ? queryResultInfo.getError() : null) != null) {
            RLog rLog = this.context.getLogger();
            XElement xElement = (XElement)this.executableElement;
            QueryResultInfo queryResultInfo2 = query2.getResultInfo();
            Intrinsics.checkNotNull((Object)queryResultInfo2);
            SQLException sQLException = queryResultInfo2.getError();
            Intrinsics.checkNotNull((Object)sQLException);
            rLog.e(xElement, DatabaseVerificationErrors.INSTANCE.cannotVerifyQuery(sQLException), new Object[0]);
        }
    }

    private final WriteQueryMethod getPreparedQueryMethod(MethodProcessorDelegate delegate, XType returnType, ParsedQuery query2) {
        PreparedQueryResultBinder resultBinder2 = delegate.findPreparedResultBinder(returnType, query2);
        this.context.getChecker().check(resultBinder2.getAdapter() != null, (XElement)this.executableElement, ProcessorErrors.INSTANCE.cannotFindPreparedQueryResultAdapter(returnType.asTypeName().toString(this.context.getCodeLanguage()), query2.getType()), new Object[0]);
        List<QueryParameter> parameters = delegate.extractQueryParams(query2);
        return new WriteQueryMethod(this.executableElement, query2, returnType, parameters, resultBinder2);
    }

    /*
     * WARNING - void declaration
     */
    private final QueryMethod getQueryMethod(MethodProcessorDelegate delegate, XType returnType, ParsedQuery query2) {
        QueryResultBinder resultBinder2 = delegate.findResultBinder(returnType, query2, (Function1<? super TypeAdapterExtras, Unit>)((Function1)new Function1<TypeAdapterExtras, Unit>(delegate, this, query2){
            final /* synthetic */ MethodProcessorDelegate $delegate;
            final /* synthetic */ InternalQueryProcessor this$0;
            final /* synthetic */ ParsedQuery $query;
            {
                this.$delegate = $delegate;
                this.this$0 = $receiver;
                this.$query = $query;
                super(1);
            }

            public final void invoke(@NotNull TypeAdapterExtras $this$findResultBinder) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)$this$findResultBinder, (String)"$this$findResultBinder");
                    XAnnotationBox xAnnotationBox = this.$delegate.getExecutableElement().getAnnotation(Reflection.getOrCreateKotlinClass(MapInfo.class));
                    if (xAnnotationBox == null) break block0;
                    XAnnotationBox xAnnotationBox2 = xAnnotationBox;
                    InternalQueryProcessor internalQueryProcessor = this.this$0;
                    ParsedQuery parsedQuery = this.$query;
                    MethodProcessorDelegate methodProcessorDelegate = this.$delegate;
                    XAnnotationBox it = xAnnotationBox2;
                    boolean bl = false;
                    InternalQueryProcessor.access$processMapInfo(internalQueryProcessor, it, parsedQuery, methodProcessorDelegate.getExecutableElement(), $this$findResultBinder);
                }
            }
        }));
        this.context.getChecker().check(resultBinder2.getAdapter() != null, (XElement)this.executableElement, ProcessorErrors.INSTANCE.cannotFindQueryResultAdapter(returnType.asTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
        boolean inTransaction = this.executableElement.hasAnnotation(Reflection.getOrCreateKotlinClass(Transaction.class));
        if (query2.getType() == QueryType.SELECT && !inTransaction) {
            boolean hasRelations;
            boolean bl;
            Object object = resultBinder2.getAdapter();
            if (object != null && (object = ((QueryResultAdapter)object).getRowAdapters()) != null) {
                boolean bl2;
                block21: {
                    Iterable $this$any$iv = (Iterable)object;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            RowAdapter adapter = (RowAdapter)element$iv;
                            boolean bl3 = false;
                            boolean bl4 = adapter instanceof PojoRowAdapter && !((Collection)((PojoRowAdapter)adapter).getRelationCollectors()).isEmpty();
                            if (!bl4) continue;
                            bl2 = true;
                            break block21;
                        }
                        bl2 = false;
                    }
                }
                bl = bl2;
            } else {
                bl = hasRelations = false;
            }
            if (hasRelations) {
                this.context.getLogger().w(Warning.RELATION_QUERY_WITHOUT_TRANSACTION, (XElement)this.executableElement, ProcessorErrors.INSTANCE.getTRANSACTION_MISSING_ON_RELATION(), new Object[0]);
            }
        }
        QueryResultInfo queryResultInfo = query2.getResultInfo();
        if (queryResultInfo != null) {
            QueryResultInfo queryResultInfo2 = queryResultInfo;
            boolean bl = false;
            Object object = resultBinder2.getAdapter();
            if (object != null) {
                Object mappings;
                if ((object = ((QueryResultAdapter)object).getMappings()) != null && !(mappings = object).isEmpty()) {
                    boolean bl5;
                    block22: {
                        Iterable $this$none$iv = (Iterable)mappings;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl5 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                QueryMappedRowAdapter.Mapping it = (QueryMappedRowAdapter.Mapping)element$iv;
                                boolean bl6 = false;
                                if (!(it instanceof PojoRowAdapter.PojoMapping)) continue;
                                bl5 = false;
                                break block22;
                            }
                            bl5 = true;
                        }
                    }
                    if (!bl5) {
                        void $this$associateTo$iv$iv;
                        void $this$associate$iv;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        void $this$filterIsInstanceTo$iv$iv;
                        Object object2;
                        void $this$mapTo$iv$iv;
                        void $this$flatMapTo$iv$iv;
                        Iterable $this$flatMap$iv = (Iterable)mappings;
                        boolean $i$f$flatMap = false;
                        Iterable element$iv = $this$flatMap$iv;
                        Iterable destination$iv$iv = new ArrayList();
                        boolean $i$f$flatMapTo = false;
                        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                            QueryMappedRowAdapter.Mapping it = (QueryMappedRowAdapter.Mapping)element$iv$iv;
                            boolean bl7 = false;
                            Iterable list$iv$iv = it.getUsedColumns();
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        List usedColumns = (List)destination$iv$iv;
                        Iterable $this$map$iv = queryResultInfo2.getColumns();
                        boolean $i$f$map = false;
                        destination$iv$iv = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo22 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            ColumnInfo bl7 = (ColumnInfo)item$iv$iv;
                            object2 = destination$iv$iv2;
                            boolean bl8 = false;
                            object2.add(it.getName());
                        }
                        List columnNames2 = (List)destination$iv$iv2;
                        List unusedColumns = CollectionsKt.minus((Iterable)columnNames2, (Iterable)usedColumns);
                        Iterable $this$filterIsInstance$iv = (Iterable)mappings;
                        boolean $i$f$filterIsInstance22 = false;
                        Iterable $i$f$mapTo22 = $this$filterIsInstance$iv;
                        Collection destination$iv$iv3 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof PojoRowAdapter.PojoMapping)) continue;
                            destination$iv$iv3.add(element$iv$iv);
                        }
                        List pojoMappings = (List)destination$iv$iv3;
                        Iterable $i$f$filterIsInstance22 = pojoMappings;
                        boolean $i$f$filter = false;
                        destination$iv$iv3 = $this$filter$iv;
                        Collection destination$iv$iv4 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            PojoRowAdapter.PojoMapping it = (PojoRowAdapter.PojoMapping)element$iv$iv;
                            boolean bl9 = false;
                            boolean bl10 = !((Collection)it.getUnusedFields()).isEmpty();
                            if (!bl10) continue;
                            destination$iv$iv4.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv4;
                        boolean $i$f$associate2 = false;
                        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                        destination$iv$iv4 = $this$associate$iv;
                        Object destination$iv$iv5 = new LinkedHashMap(capacity$iv);
                        boolean $i$f$associateTo = false;
                        for (Object element$iv$iv : $this$associateTo$iv$iv) {
                            Map bl9 = destination$iv$iv5;
                            PojoRowAdapter.PojoMapping it = (PojoRowAdapter.PojoMapping)element$iv$iv;
                            boolean bl11 = false;
                            it = TuplesKt.to((Object)it.getPojo().getTypeName().toString(this.context.getCodeLanguage()), it.getUnusedFields());
                            bl9.put(it.getFirst(), it.getSecond());
                        }
                        Map pojoUnusedFields = destination$iv$iv5;
                        if (!((Collection)unusedColumns).isEmpty() || !pojoUnusedFields.isEmpty()) {
                            void $this$mapTo$iv$iv2;
                            void $this$map$iv2;
                            Iterable $i$f$associate2 = pojoMappings;
                            object2 = ProcessorErrors.INSTANCE;
                            boolean $i$f$map2 = false;
                            $this$associateTo$iv$iv = $this$map$iv2;
                            destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                void it;
                                PojoRowAdapter.PojoMapping bl9 = (PojoRowAdapter.PojoMapping)item$iv$iv;
                                Object object3 = destination$iv$iv5;
                                boolean bl12 = false;
                                object3.add(it.getPojo().getTypeName().toString(this.context.getCodeLanguage()));
                            }
                            String warningMsg = ((ProcessorErrors)object2).cursorPojoMismatch((List)destination$iv$iv5, unusedColumns, columnNames2, pojoUnusedFields);
                            this.context.getLogger().w(Warning.CURSOR_MISMATCH, (XElement)this.executableElement, warningMsg, new Object[0]);
                        }
                    }
                }
            }
        }
        List<QueryParameter> parameters = delegate.extractQueryParams(query2);
        return new ReadQueryMethod(this.executableElement, query2, returnType, parameters, inTransaction, resultBinder2);
    }

    /*
     * WARNING - void declaration
     */
    private final void processMapInfo(XAnnotationBox<MapInfo> mapInfoAnnotation, ParsedQuery query2, XMethodElement queryExecutableElement, TypeAdapterExtras adapterExtras) {
        List<ColumnInfo> resultColumns;
        void $this$associateTo$iv$iv;
        CharSequence charSequence;
        CharSequence charSequence2;
        String keyColumn = ((MapInfo)mapInfoAnnotation.getValue()).keyColumn();
        CharSequence charSequence3 = ((MapInfo)mapInfoAnnotation.getValue()).keyTable();
        if (charSequence3.length() == 0) {
            boolean bl = false;
            charSequence2 = null;
        } else {
            charSequence2 = charSequence3;
        }
        String keyTable = (String)charSequence2;
        String valueColumn = ((MapInfo)mapInfoAnnotation.getValue()).valueColumn();
        CharSequence charSequence4 = ((MapInfo)mapInfoAnnotation.getValue()).valueTable();
        if (charSequence4.length() == 0) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence4;
        }
        String valueTable = (String)charSequence;
        Iterable $this$associate$iv = query2.getTables();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Table it = (Table)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getAlias());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map resultTableAliases = destination$iv$iv;
        this.context.getChecker().check(((CharSequence)keyColumn).length() > 0 || ((CharSequence)valueColumn).length() > 0, (XElement)queryExecutableElement, ProcessorErrors.INSTANCE.getMAP_INFO_MUST_HAVE_AT_LEAST_ONE_COLUMN_PROVIDED(), new Object[0]);
        QueryResultInfo queryResultInfo = query2.getResultInfo();
        List<ColumnInfo> list = resultColumns = queryResultInfo != null ? queryResultInfo.getColumns() : null;
        if (resultColumns != null) {
            this.context.getChecker().check(((CharSequence)keyColumn).length() == 0 || InternalQueryProcessor.processMapInfo$contains(resultColumns, resultTableAliases, keyColumn, keyTable), (XElement)queryExecutableElement, (Function0<String>)((Function0)new Function0<String>(keyTable, keyColumn, resultColumns){
                final /* synthetic */ String $keyTable;
                final /* synthetic */ String $keyColumn;
                final /* synthetic */ List<ColumnInfo> $resultColumns;
                {
                    this.$keyTable = $keyTable;
                    this.$keyColumn = $keyColumn;
                    this.$resultColumns = $resultColumns;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final String invoke() {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this.$resultColumns;
                    String string = (String)(this.$keyTable != null ? this.$keyTable + "." : "") + this.$keyColumn;
                    ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                    boolean $i$f$map = false;
                    void var3_5 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ColumnInfo columnInfo2 = (ColumnInfo)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getName());
                    }
                    collection = (List)destination$iv$iv;
                    return processorErrors.cannotMapInfoSpecifiedColumn(string, (List<String>)collection);
                }
            }));
            this.context.getChecker().check(((CharSequence)valueColumn).length() == 0 || InternalQueryProcessor.processMapInfo$contains(resultColumns, resultTableAliases, valueColumn, valueTable), (XElement)queryExecutableElement, (Function0<String>)((Function0)new Function0<String>(valueTable, valueColumn, resultColumns){
                final /* synthetic */ String $valueTable;
                final /* synthetic */ String $valueColumn;
                final /* synthetic */ List<ColumnInfo> $resultColumns;
                {
                    this.$valueTable = $valueTable;
                    this.$valueColumn = $valueColumn;
                    this.$resultColumns = $resultColumns;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final String invoke() {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this.$resultColumns;
                    String string = (String)(this.$valueTable != null ? this.$valueTable + "." : "") + this.$valueColumn;
                    ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                    boolean $i$f$map = false;
                    void var3_5 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ColumnInfo columnInfo2 = (ColumnInfo)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getName());
                    }
                    collection = (List)destination$iv$iv;
                    return processorErrors.cannotMapInfoSpecifiedColumn(string, (List<String>)collection);
                }
            }));
        }
        adapterExtras.putData(Reflection.getOrCreateKotlinClass(androidx.room.vo.MapInfo.class), new androidx.room.vo.MapInfo(keyColumn, valueColumn));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean processMapInfo$contains(List<ColumnInfo> $this$processMapInfo_u24contains, Map<String, String> resultTableAliases, String columnName, String tableName) {
        boolean bl;
        Iterable $this$any$iv = $this$processMapInfo_u24contains;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            String resultTableAlias;
            String string;
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            ColumnInfo resultColumn = (ColumnInfo)element$iv;
            boolean bl2 = false;
            if (resultColumn.getOriginTable() != null) {
                String it;
                boolean bl3 = false;
                string = resultTableAliases.get(it);
                if (string == null) {
                    string = it;
                }
            } else {
                string = resultTableAlias = null;
            }
            if (Intrinsics.areEqual((Object)resultColumn.getName(), (Object)columnName)) {
                if (tableName == null) return true;
                if (Intrinsics.areEqual((Object)resultTableAlias, (Object)tableName)) return true;
                if (Intrinsics.areEqual((Object)resultColumn.getOriginTable(), (Object)tableName)) {
                    return true;
                }
                boolean bl4 = false;
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final /* synthetic */ void access$processMapInfo(InternalQueryProcessor $this, XAnnotationBox mapInfoAnnotation, ParsedQuery query2, XMethodElement queryExecutableElement, TypeAdapterExtras adapterExtras) {
        $this.processMapInfo((XAnnotationBox<MapInfo>)mapInfoAnnotation, query2, queryExecutableElement, adapterExtras);
    }

    static {
        QueryType[] queryTypeArray = new QueryType[]{QueryType.INSERT, QueryType.DELETE, QueryType.UPDATE};
        PREPARED_TYPES = queryTypeArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Landroidx/room/processor/InternalQueryProcessor$Companion;", "", "()V", "PREPARED_TYPES", "", "Landroidx/room/parser/QueryType;", "getPREPARED_TYPES", "()[Landroidx/room/parser/QueryType;", "[Landroidx/room/parser/QueryType;", "room-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QueryType[] getPREPARED_TYPES() {
            return PREPARED_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

