/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.AutoMigration;
import androidx.room.Database;
import androidx.room.SkipQueryVerification;
import androidx.room.compiler.codegen.CodeLanguage;
import androidx.room.compiler.codegen.XClassName;
import androidx.room.compiler.codegen.XTypeName;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.RoomTypeNames;
import androidx.room.log.RLog;
import androidx.room.migration.bundle.DatabaseBundle;
import androidx.room.migration.bundle.SchemaBundle;
import androidx.room.parser.Table;
import androidx.room.processor.AutoMigrationProcessor;
import androidx.room.processor.Context;
import androidx.room.processor.DaoProcessor;
import androidx.room.processor.DatabaseProcessor;
import androidx.room.processor.DatabaseViewProcessor;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.ProcessorErrors;
import androidx.room.util.SchemaFileResolver;
import androidx.room.verifier.DatabaseVerificationErrors;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.verifier.QueryResultInfo;
import androidx.room.vo.Dao;
import androidx.room.vo.DaoMethod;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.DeleteOrUpdateShortcutMethod;
import androidx.room.vo.Entity;
import androidx.room.vo.Field;
import androidx.room.vo.ForeignKey;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.HasFieldsKt;
import androidx.room.vo.Index;
import androidx.room.vo.InsertOrUpsertShortcutMethod;
import androidx.room.vo.Pojo;
import androidx.room.vo.ShortcutEntity;
import androidx.room.vo.Warning;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0013J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"0!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J$\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0\u001c2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0\u001cJ\u001e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00052\f\u0010-\u001a\b\u0012\u0004\u0012\u00020'0\u001cH\u0002J\u001e\u0010.\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010-\u001a\b\u0012\u0004\u0012\u00020'0\u001cH\u0002J,\u0010/\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u001c2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020'0\u001cH\u0002J\u001e\u00102\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010-\u001a\b\u0012\u0004\u0012\u00020'0\u001cH\u0002J,\u00103\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00052\f\u0010-\u001a\b\u0012\u0004\u0012\u00020'0\u001c2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0\u001cH\u0002J$\u00104\u001a\u00020+2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"0!2\u0006\u00106\u001a\u000207H\u0002R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00068"}, d2={"Landroidx/room/processor/DatabaseProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XTypeElement;)V", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Landroidx/room/compiler/processing/XTypeElement;", "roomDatabaseType", "Landroidx/room/compiler/processing/XType;", "getRoomDatabaseType", "()Landroidx/room/compiler/processing/XType;", "roomDatabaseType$delegate", "Lkotlin/Lazy;", "doProcess", "Landroidx/room/vo/Database;", "getValidatedSchemaFile", "Ljava/io/File;", "version", "", "schemaFolderPath", "Ljava/nio/file/Path;", "process", "processAutoMigrations", "", "Landroidx/room/vo/AutoMigration;", "latestDbSchema", "Landroidx/room/migration/bundle/DatabaseBundle;", "processDatabaseViews", "", "Landroidx/room/vo/DatabaseView;", "dbAnnotation", "Landroidx/room/compiler/processing/XAnnotationBox;", "Landroidx/room/Database;", "processEntities", "Landroidx/room/vo/Entity;", "resolveDatabaseViews", "views", "validateExternalContentFts", "", "dbElement", "entities", "validateForeignKeys", "validateUniqueDaoClasses", "daoMethods", "Landroidx/room/vo/DaoMethod;", "validateUniqueIndices", "validateUniqueTableAndViewNames", "verifyDatabaseViews", "map", "dbVerifier", "Landroidx/room/verifier/DatabaseVerifier;", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nDatabaseProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseProcessor.kt\nandroidx/room/processor/DatabaseProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,568:1\n1747#2,3:569\n1194#2,2:585\n1222#2,4:587\n1855#2:591\n1855#2:592\n1603#2,9:593\n1855#2:602\n1856#2:604\n1612#2:605\n1549#2:606\n1620#2,3:607\n1856#2:610\n1856#2:611\n1360#2:612\n1446#2,2:613\n1549#2:615\n1620#2,3:616\n1448#2,3:619\n1477#2:622\n1502#2,3:623\n1505#2,3:633\n1655#2,8:644\n1549#2:652\n1620#2,3:653\n1549#2:657\n1620#2,3:658\n1477#2:661\n1502#2,3:662\n1505#2,3:672\n1549#2:676\n1620#2,3:677\n1855#2,2:680\n1855#2:683\n1855#2:684\n1856#2:687\n1855#2:688\n1856#2:691\n1856#2:692\n1549#2:693\n1620#2,3:694\n1549#2:697\n1620#2,3:698\n1477#2:701\n1502#2,3:702\n1505#2,3:712\n1549#2:723\n1620#2,3:724\n1855#2,2:727\n819#2:730\n847#2,2:731\n1855#2,2:733\n1603#2,9:735\n1855#2:744\n1856#2:746\n1612#2:747\n1603#2,9:748\n1855#2:757\n1856#2:759\n1612#2:760\n1549#2:761\n1620#2,3:762\n1549#2:765\n1620#2,3:766\n766#2:769\n857#2:770\n1726#2,3:771\n858#2:774\n1855#2,2:775\n1549#2:777\n1620#2,3:778\n2624#2,3:781\n11653#3,9:572\n13579#3:581\n13580#3:583\n11662#3:584\n1#4:582\n1#4:603\n1#4:745\n1#4:758\n361#5,7:626\n515#5:636\n500#5,6:637\n361#5,7:665\n361#5,7:705\n515#5:715\n500#5,6:716\n215#6:643\n216#6:656\n215#6:675\n216#6:682\n215#6,2:685\n215#6,2:689\n215#6:722\n216#6:729\n*S KotlinDebug\n*F\n+ 1 DatabaseProcessor.kt\nandroidx/room/processor/DatabaseProcessor\n*L\n130#1:569,3\n264#1:585,2\n264#1:587,4\n265#1:591\n266#1:592\n279#1:593,9\n279#1:602\n279#1:604\n279#1:605\n306#1:606\n306#1:607,3\n266#1:610\n265#1:611\n317#1:612\n317#1:613,2\n319#1:615\n319#1:616,3\n317#1:619,3\n321#1:622\n321#1:623,3\n321#1:633,3\n325#1:644,8\n330#1:652\n330#1:653,3\n344#1:657\n344#1:658,3\n345#1:661\n345#1:662,3\n345#1:672,3\n350#1:676\n350#1:677,3\n352#1:680,2\n380#1:683\n381#1:684\n381#1:687\n386#1:688\n386#1:691\n380#1:692\n399#1:693\n399#1:694,3\n406#1:697\n406#1:698,3\n414#1:701\n414#1:702,3\n414#1:712,3\n419#1:723\n419#1:724,3\n423#1:727,2\n433#1:730\n433#1:731,2\n437#1:733,2\n457#1:735,9\n457#1:744\n457#1:746\n457#1:747\n477#1:748,9\n477#1:757\n477#1:759\n477#1:760\n524#1:761\n524#1:762,3\n528#1:765\n528#1:766,3\n546#1:769\n546#1:770\n546#1:771,3\n546#1:774\n547#1:775,2\n558#1:777\n558#1:778,3\n525#1:781,3\n174#1:572,9\n174#1:581\n174#1:583\n174#1:584\n174#1:582\n279#1:603\n457#1:745\n477#1:758\n321#1:626,7\n322#1:636\n322#1:637,6\n345#1:665,7\n414#1:705,7\n415#1:715\n415#1:716,6\n323#1:643\n323#1:656\n346#1:675\n346#1:682\n382#1:685,2\n387#1:689,2\n416#1:722\n416#1:729\n*E\n"})
public final class DatabaseProcessor {
    @NotNull
    private final XTypeElement element;
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy roomDatabaseType$delegate;

    public DatabaseProcessor(@NotNull Context baseContext, @NotNull XTypeElement element) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.element = element;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, null, 6, null);
        this.roomDatabaseType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ DatabaseProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getContext().getProcessingEnv().requireType((XTypeName)RoomTypeNames.INSTANCE.getROOM_DB());
            }
        }));
    }

    @NotNull
    public final XTypeElement getElement() {
        return this.element;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final XType getRoomDatabaseType() {
        Lazy lazy = this.roomDatabaseType$delegate;
        return (XType)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final androidx.room.vo.Database process() {
        try {
            androidx.room.vo.Database database = this.doProcess();
            return database;
        }
        finally {
            block3: {
                DatabaseVerifier databaseVerifier = this.context.getDatabaseVerifier();
                if (databaseVerifier == null) break block3;
                databaseVerifier.closeConnection(this.context);
            }
        }
    }

    private final androidx.room.vo.Database doProcess() {
        boolean bl;
        List daoMethods2;
        List<DatabaseView> views;
        List<Entity> entities;
        XAnnotationBox dbAnnotation;
        block4: {
            DatabaseVerifier dbVerifier;
            XAnnotationBox xAnnotationBox = this.element.getAnnotation(Reflection.getOrCreateKotlinClass(Database.class));
            Intrinsics.checkNotNull((Object)xAnnotationBox);
            dbAnnotation = xAnnotationBox;
            entities = this.processEntities((XAnnotationBox<Database>)dbAnnotation, this.element);
            Map<XTypeElement, DatabaseView> viewsMap = this.processDatabaseViews((XAnnotationBox<Database>)dbAnnotation);
            this.validateForeignKeys(this.element, entities);
            this.validateExternalContentFts(this.element, entities);
            boolean extendsRoomDb = this.getRoomDatabaseType().isAssignableFrom(this.element.getType());
            this.context.getChecker().check(extendsRoomDb, (XElement)this.element, ProcessorErrors.INSTANCE.getDB_MUST_EXTEND_ROOM_DB(), new Object[0]);
            views = this.resolveDatabaseViews(CollectionsKt.toList((Iterable)viewsMap.values()));
            DatabaseVerifier databaseVerifier = dbVerifier = this.element.hasAnnotation(Reflection.getOrCreateKotlinClass(SkipQueryVerification.class)) ? null : DatabaseVerifier.Companion.create(this.context, (XElement)this.element, entities, views);
            if (dbVerifier != null) {
                this.context.attachDatabaseVerifier(dbVerifier);
                this.verifyDatabaseViews(viewsMap, dbVerifier);
            }
            this.validateUniqueTableAndViewNames(this.element, entities, views);
            XType declaredType = this.element.getType();
            daoMethods2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)this.element.getAllMethods(), (Function1)doProcess.daoMethods.1.INSTANCE), (Function1)doProcess.daoMethods.2.INSTANCE), (Function1)((Function1)new Function1<XMethodElement, DaoMethod>(this, declaredType, dbVerifier){
                final /* synthetic */ DatabaseProcessor this$0;
                final /* synthetic */ XType $declaredType;
                final /* synthetic */ DatabaseVerifier $dbVerifier;
                {
                    this.this$0 = $receiver;
                    this.$declaredType = $declaredType;
                    this.$dbVerifier = $dbVerifier;
                    super(1);
                }

                @Nullable
                public final DaoMethod invoke(@NotNull XMethodElement executable) {
                    DaoMethod daoMethod;
                    Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
                    XType daoType = executable.getReturnType();
                    XTypeElement daoElement = daoType.getTypeElement();
                    if (daoElement == null) {
                        this.this$0.getContext().getLogger().e((XElement)executable, ProcessorErrors.INSTANCE.getDATABASE_INVALID_DAO_METHOD_RETURN_TYPE(), new Object[0]);
                        daoMethod = null;
                    } else {
                        if (executable.hasAnnotation(Reflection.getOrCreateKotlinClass(JvmName.class))) {
                            this.this$0.getContext().getLogger().w(Warning.JVM_NAME_ON_OVERRIDDEN_METHOD, (XElement)executable, ProcessorErrors.INSTANCE.getJVM_NAME_ON_OVERRIDDEN_METHOD(), new Object[0]);
                        }
                        if (this.this$0.getContext().getCodeLanguage() == CodeLanguage.KOTLIN && executable.isKotlinPropertyMethod()) {
                            this.this$0.getContext().getLogger().e((XElement)executable, ProcessorErrors.INSTANCE.getKOTLIN_PROPERTY_OVERRIDE(), new Object[0]);
                        }
                        Dao dao = new DaoProcessor(this.this$0.getContext(), daoElement, this.$declaredType, this.$dbVerifier).process();
                        daoMethod = new DaoMethod(executable, dao);
                    }
                    return daoMethod;
                }
            })));
            this.validateUniqueDaoClasses(this.element, daoMethods2, entities);
            this.validateUniqueIndices(this.element, entities);
            Iterable $this$any$iv = entities;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Entity it = (Entity)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = !((Collection)it.getForeignKeys()).isEmpty();
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean hasForeignKeys = bl;
        int n = ((Database)dbAnnotation.getValue()).version();
        XTypeElement xTypeElement = this.element;
        XType xType = this.element.getType();
        boolean bl4 = ((Database)dbAnnotation.getValue()).exportSchema();
        androidx.room.vo.Database database = new androidx.room.vo.Database(xTypeElement, xType, entities, views, daoMethods2, n, bl4, hasForeignKeys);
        database.setAutoMigrations(this.processAutoMigrations(this.element, database.getBundle()));
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<androidx.room.vo.AutoMigration> processAutoMigrations(XTypeElement element, DatabaseBundle latestDbSchema) {
        v0 = element.getAnnotation(Reflection.getOrCreateKotlinClass(Database.class));
        Intrinsics.checkNotNull((Object)v0);
        dbAnnotation = v0;
        autoMigrationList = dbAnnotation.getAsAnnotationBoxArray("autoMigrations");
        if (autoMigrationList.length == 0) {
            return CollectionsKt.emptyList();
        }
        if (!((Database)dbAnnotation.getValue()).exportSchema()) {
            this.context.getLogger().e((XElement)element, ProcessorErrors.INSTANCE.getAUTO_MIGRATION_FOUND_BUT_EXPORT_SCHEMA_OFF(), new Object[0]);
            return CollectionsKt.emptyList();
        }
        schemaInFolderPath = this.context.getSchemaInFolderPath();
        if (schemaInFolderPath == null) {
            this.context.getLogger().e((XElement)element, ProcessorErrors.INSTANCE.getAUTO_MIGRATION_SCHEMA_IN_FOLDER_NULL(), new Object[0]);
            return CollectionsKt.emptyList();
        }
        $this$mapNotNull$iv = autoMigrationList;
        $i$f$mapNotNull = false;
        var8_8 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var14_14 = ((void)$this$forEach$iv$iv$iv).length;
        for (var13_13 = 0; var13_13 < var14_14; ++var13_13) {
            block21: {
                block22: {
                    block20: {
                        element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var13_13];
                        $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
                        it = element$iv$iv;
                        $i$a$-mapNotNull-DatabaseProcessor$processAutoMigrations$1 = false;
                        var20_20 = new String[]{element.asClassName().getCanonicalName()};
                        databaseSchemaInFolderPath = Path.of(schemaInFolderPath, var20_20);
                        autoMigration = (AutoMigration)it.getValue();
                        v1 = autoMigration.from();
                        Intrinsics.checkNotNullExpressionValue((Object)databaseSchemaInFolderPath, (String)"databaseSchemaInFolderPath");
                        if (this.getValidatedSchemaFile(v1, databaseSchemaInFolderPath) != null) break block20;
                        v2 = null;
                        break block21;
                    }
                    var23_23 = new FileInputStream(validatedFromSchemaFile);
                    var24_24 = null;
                    try {
                        it = (FileInputStream)var23_23;
                        $i$a$-use-DatabaseProcessor$processAutoMigrations$1$fromSchemaBundle$1 = false;
                        var25_25 /* !! */  = DatabaseProcessor.processAutoMigrations$lambda$3$deserializeSchemaFile(databaseSchemaInFolderPath, it, autoMigration.from());
                    }
                    catch (Throwable var25_26) {
                        var24_24 = var25_26;
                        throw var25_26;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var23_23, (Throwable)var24_24);
                    }
                    fromSchemaBundle = var25_25 /* !! */ ;
                    if (autoMigration.to() != latestDbSchema.getVersion()) break block22;
                    v3 = latestDbSchema;
                    ** GOTO lbl74
                }
                if (this.getValidatedSchemaFile(autoMigration.to(), databaseSchemaInFolderPath) == null) {
                    v2 = null;
                } else {
                    var25_25 /* !! */  = new FileInputStream(validatedToSchemaFile);
                    var26_29 = null;
                    try {
                        it = (FileInputStream)var25_25 /* !! */ ;
                        $i$a$-use-DatabaseProcessor$processAutoMigrations$1$toSchemaBundle$1 = false;
                        var28_31 = DatabaseProcessor.processAutoMigrations$lambda$3$deserializeSchemaFile(databaseSchemaInFolderPath, it, autoMigration.to());
                        v3 = var28_31;
                    }
                    catch (Throwable var28_32) {
                        var26_29 = var28_32;
                        throw var28_32;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var25_25 /* !! */ , (Throwable)var26_29);
                    }
                    toSchemaBundle = v3;
                    if (fromSchemaBundle == null || toSchemaBundle == null) {
                        this.context.getLogger().e((XElement)element, ProcessorErrors.INSTANCE.autoMigrationSchemasMustBeRoomGenerated(autoMigration.from(), autoMigration.to()), new Object[0]);
                        v2 = null;
                    } else {
                        v4 = it.getAsType("spec");
                        Intrinsics.checkNotNull((Object)v4);
                        v2 = new AutoMigrationProcessor(this.context, v4, fromSchemaBundle, toSchemaBundle).process();
                    }
                }
            }
            if (v2 == null) continue;
            it$iv$iv = v2;
            $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final File getValidatedSchemaFile(int version, Path schemaFolderPath) {
        SchemaFileResolver schemaFileResolver = SchemaFileResolver.Companion.getRESOLVER();
        Path path = schemaFolderPath.resolve(version + ".json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"schemaFolderPath.resolve(\"$version.json\")");
        File schemaFile = schemaFileResolver.getFile(path);
        if (!schemaFile.exists()) {
            Object[] objectArray = new Object[]{this.element};
            this.context.getLogger().e(ProcessorErrors.INSTANCE.autoMigrationSchemasNotFound(version + ".json", ((Object)schemaFolderPath).toString()), objectArray);
            return null;
        }
        if (schemaFile.length() <= 0L) {
            Object[] objectArray = new Object[]{this.element};
            this.context.getLogger().e(ProcessorErrors.INSTANCE.autoMigrationSchemaIsEmpty(version + ".json", ((Object)schemaFolderPath).toString()), objectArray);
            return null;
        }
        return schemaFile;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateForeignKeys(XTypeElement element, List<? extends Entity> entities) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = entities;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Entity entity = (Entity)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getTableName(), element$iv$iv);
        }
        Map byTableName = destination$iv$iv;
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = entity.getForeignKeys();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapNotNullTo$iv$iv;
                ForeignKey foreignKey = (ForeignKey)element$iv2;
                boolean bl2 = false;
                Entity parent = (Entity)byTableName.get(foreignKey.getParentTable());
                if (parent == null) {
                    this.context.getLogger().e((XElement)element, ProcessorErrors.INSTANCE.foreignKeyMissingParentEntityInDatabase(foreignKey.getParentTable(), entity.getElement().getQualifiedName()), new Object[0]);
                    continue;
                }
                Iterable $this$mapNotNull$iv = foreignKey.getParentColumns();
                boolean $i$f$mapNotNull = false;
                Object object = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach3 = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Field it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    String columnName = (String)element$iv$iv;
                    boolean bl4 = false;
                    Field parentField = HasFieldsKt.findFieldByColumnName(parent, columnName);
                    if (parentField == null) {
                        this.context.getLogger().e((XElement)entity.getElement(), ProcessorErrors.INSTANCE.foreignKeyParentColumnDoesNotExist(parent.getElement().getQualifiedName(), columnName, HasFieldsKt.getColumnNames(parent)), new Object[0]);
                    }
                    if (parentField == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List parentFields = (List)destination$iv$iv2;
                if (parentFields.size() != foreignKey.getParentColumns().size() || parent.isUnique(foreignKey.getParentColumns())) continue;
                ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                String string = parent.getElement().getQualifiedName();
                object = entity.getElement().getQualifiedName();
                List<String> list = foreignKey.getParentColumns();
                $this$forEach$iv$iv$iv = foreignKey.getChildFields();
                XElement xElement = (XElement)parent.getElement();
                RLog rLog = this.context.getLogger();
                boolean $i$f$map = false;
                iterator = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Field bl4 = (Field)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl6 = false;
                    collection.add(it.getColumnName());
                }
                collection = (List)destination$iv$iv3;
                List list2 = collection;
                rLog.e(xElement, processorErrors.foreignKeyMissingIndexInParent(string, list, (String)object, list2), new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueIndices(XTypeElement element, List<? extends Entity> entities) {
        void $this$filterTo$iv$iv;
        Object it;
        Object $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Object object;
        Index index;
        Object element$iv$iv2;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = entities;
        boolean $i$f$flatMap = false;
        Object object2 = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Entity entity = (Entity)element$iv$iv2;
            boolean bl = false;
            Iterable $this$map$iv = entity.getIndices();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                index = (Index)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                object.add(new Pair((Object)it2.getName(), (Object)entity));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object3;
            element$iv$iv2 = iterator.next();
            it = (Pair)element$iv$iv2;
            boolean bl = false;
            String key$iv$iv = (String)it.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv2);
        }
        Object $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv$iv2 = (Map.Entry)iterator.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        Object $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Collection<CallSite> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry element$iv;
            Map.Entry it3 = element$iv = (Map.Entry)object2.next();
            boolean bl = false;
            Iterable $this$distinctBy$iv = (Iterable)it3.getValue();
            boolean $i$f$distinctBy = false;
            HashSet<XTypeName> set$iv = new HashSet<XTypeName>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                Pair it4 = (Pair)e$iv;
                boolean bl4 = false;
                XTypeName key$iv = ((Entity)it4.getSecond()).getTypeName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            if (((List)list$iv).size() <= 1) continue;
            $this$distinctBy$iv = (Iterable)it3.getValue();
            String string = (String)it3.getKey();
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            index = (XElement)element;
            object = this.context.getLogger();
            boolean $i$f$map = false;
            set$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it5;
                Pair bl4 = (Pair)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl5 = false;
                collection.add((CallSite)((Object)(((Entity)it5.getSecond()).getTypeName().toString(this.context.getCodeLanguage()) + " > " + it5.getFirst())));
            }
            collection = (List)destination$iv$iv3;
            ((RLog)object).e((XElement)index, processorErrors.duplicateIndexInDatabase(string, (List<String>)collection), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueDaoClasses(XTypeElement dbElement, List<DaoMethod> daoMethods2, List<? extends Entity> entities) {
        Iterator<Map.Entry<String, ShortcutEntity>> iterator;
        void $this$forEach$iv;
        Object list$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object element$iv$iv;
        Iterator $this$groupByTo$iv$iv;
        DaoMethod it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Entity entity = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Pojo)((Object)it)).getTypeName());
        }
        Set entityTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Object $this$groupBy$iv = daoMethods2;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            element$iv$iv = iterator2.next();
            it = (DaoMethod)element$iv$iv;
            boolean bl3 = false;
            XClassName key$iv$iv = it.getDao().getTypeName();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$groupByTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            Collection<String> collection;
            Iterator $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map.Entry element$iv;
            Map.Entry it2 = element$iv = $this$groupByTo$iv$iv.next();
            boolean bl = false;
            if (((List)it2.getValue()).size() <= 1) continue;
            element$iv$iv = (Iterable)it2.getValue();
            list$iv$iv = ((XClassName)it2.getKey()).toString(this.context.getCodeLanguage());
            ProcessorErrors bl3 = ProcessorErrors.INSTANCE;
            boolean $i$f$map2 = false;
            $this$getOrPut$iv$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator answer$iv$iv$iv = $this$mapTo$iv$iv2.iterator();
            while (answer$iv$iv$iv.hasNext()) {
                void it3;
                Object item$iv$iv = answer$iv$iv$iv.next();
                iterator = (DaoMethod)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it3.getElement().getName());
            }
            collection = (List)destination$iv$iv2;
            String error = bl3.duplicateDao((String)list$iv$iv, (List<String>)collection);
            Iterable $this$forEach$iv2 = (Iterable)it2.getValue();
            boolean $i$f$forEach2 = false;
            $this$mapTo$iv$iv2 = $this$forEach$iv2.iterator();
            while ($this$mapTo$iv$iv2.hasNext()) {
                Object element$iv2 = $this$mapTo$iv$iv2.next();
                DaoMethod daoMethod = (DaoMethod)element$iv2;
                boolean bl5 = false;
                this.context.getLogger().e((XElement)daoMethod.getElement(), ProcessorErrors.INSTANCE.getDAO_METHOD_CONFLICTS_WITH_OTHERS(), new Object[0]);
            }
            this.context.getLogger().e((XElement)dbElement, error, new Object[0]);
        }
        Function3 check2 = (Function3)new Function3<XElement, Dao, XTypeName, Unit>((Set<? extends XTypeName>)entityTypeNames, this, dbElement){
            final /* synthetic */ Set<XTypeName> $entityTypeNames;
            final /* synthetic */ DatabaseProcessor this$0;
            final /* synthetic */ XTypeElement $dbElement;
            {
                this.$entityTypeNames = $entityTypeNames;
                this.this$0 = $receiver;
                this.$dbElement = $dbElement;
                super(3);
            }

            public final void invoke(@NotNull XElement element, @NotNull Dao dao, @Nullable XTypeName typeName2) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
                    XTypeName xTypeName = typeName2;
                    if (xTypeName == null) break block1;
                    XTypeName xTypeName2 = xTypeName;
                    Set<XTypeName> set = this.$entityTypeNames;
                    DatabaseProcessor databaseProcessor = this.this$0;
                    XTypeElement xTypeElement = this.$dbElement;
                    XTypeName it = xTypeName2;
                    boolean bl = false;
                    if (!set.contains(typeName2)) {
                        databaseProcessor.getContext().getLogger().e(element, ProcessorErrors.INSTANCE.shortcutEntityIsNotInDatabase(xTypeElement.getQualifiedName(), dao.getTypeName().toString(databaseProcessor.getContext().getCodeLanguage()), typeName2.toString(databaseProcessor.getContext().getCodeLanguage())), new Object[0]);
                    }
                }
            }
        };
        Iterable $this$forEach$iv3 = daoMethods2;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            Map.Entry<String, ShortcutEntity> it4;
            Map.Entry<String, ShortcutEntity> element$iv3;
            boolean $i$f$forEach4;
            Map<String, ShortcutEntity> $this$forEach$iv4;
            Object method;
            DaoMethod daoMethod = (DaoMethod)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv5 = daoMethod.getDao().getDeleteOrUpdateShortcutMethods();
            boolean $i$f$forEach5 = false;
            for (Object element$iv4 : $this$forEach$iv5) {
                method = (DeleteOrUpdateShortcutMethod)element$iv4;
                boolean bl6 = false;
                $this$forEach$iv4 = ((DeleteOrUpdateShortcutMethod)method).getEntities();
                $i$f$forEach4 = false;
                iterator = $this$forEach$iv4.entrySet().iterator();
                while (iterator.hasNext()) {
                    it4 = element$iv3 = (Map.Entry<String, ShortcutEntity>)iterator.next();
                    boolean bl7 = false;
                    check2.invoke((Object)((DeleteOrUpdateShortcutMethod)method).getElement(), (Object)daoMethod.getDao(), (Object)((ShortcutEntity)it4.getValue()).getEntityTypeName());
                }
            }
            $this$forEach$iv5 = daoMethod.getDao().getInsertOrUpsertShortcutMethods();
            $i$f$forEach5 = false;
            for (Object element$iv4 : $this$forEach$iv5) {
                method = (InsertOrUpsertShortcutMethod)element$iv4;
                boolean bl8 = false;
                $this$forEach$iv4 = ((InsertOrUpsertShortcutMethod)method).getEntities();
                $i$f$forEach4 = false;
                iterator = $this$forEach$iv4.entrySet().iterator();
                while (iterator.hasNext()) {
                    it4 = element$iv3 = iterator.next();
                    boolean bl9 = false;
                    check2.invoke((Object)((InsertOrUpsertShortcutMethod)method).getElement(), (Object)daoMethod.getDao(), (Object)it4.getValue().getEntityTypeName());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueTableAndViewNames(XTypeElement dbElement, List<? extends Entity> entities, List<DatabaseView> views) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Object $this$filter$iv;
        String key$iv$iv;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            Entity entity = (Entity)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getTableName();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            collection.add(new Triple((Object)string2, (Object)it.getTypeName().toString(this.context.getCodeLanguage()), (Object)it.getElement()));
        }
        List entitiesInfo = (List)destination$iv$iv;
        Iterable $this$map$iv2 = views;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it;
            DatabaseView bl = (DatabaseView)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string = it.getViewName();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            collection.add(new Triple((Object)string3, (Object)it.getTypeName().toString(this.context.getCodeLanguage()), (Object)it.getElement()));
        }
        List viewsInfo = (List)destination$iv$iv2;
        $this$map$iv2 = CollectionsKt.plus((Collection)entitiesInfo, (Iterable)viewsInfo);
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
            Object object;
            String name;
            Triple it = (Triple)element$iv$iv2;
            boolean bl = false;
            key$iv$iv = name = (String)it.component1();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv2);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        item$iv$iv2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (item$iv$iv2.hasNext()) {
            Object it = element$iv$iv2 = (Map.Entry)item$iv$iv2.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        $this$filter$iv = destination$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Map.Entry element$iv;
            Map.Entry byName = element$iv = iterator.next();
            boolean bl = false;
            element$iv$iv2 = (Iterable)byName.getValue();
            String string = (String)byName.getKey();
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            boolean $i$f$map3 = false;
            key$iv$iv = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv3) {
                Triple triple = (Triple)item$iv$iv4;
                collection2 = destination$iv$iv3;
                boolean bl4 = false;
                String typeName2 = (String)triple.component2();
                collection2.add(typeName2);
            }
            collection2 = (List)destination$iv$iv3;
            String error = processorErrors.duplicateTableNames(string, (List<String>)collection2);
            Iterable $this$forEach$iv2 = (Iterable)byName.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Triple triple = (Triple)element$iv2;
                boolean bl5 = false;
                XTypeElement element = (XTypeElement)triple.component3();
                this.context.getLogger().e((XElement)element, error, new Object[0]);
            }
            this.context.getLogger().e((XElement)dbElement, error, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateExternalContentFts(XTypeElement dbElement, List<? extends Entity> entities) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = CollectionsKt.filterIsInstance((Iterable)entities, FtsEntity.class);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FtsEntity it = (FtsEntity)element$iv$iv;
            boolean bl = false;
            if (it.getFtsOptions().getContentEntity() == null || entities.contains(it.getFtsOptions().getContentEntity())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FtsEntity it = (FtsEntity)element$iv;
            boolean bl = false;
            RLog rLog = this.context.getLogger();
            XElement xElement = (XElement)dbElement;
            String string = it.getElement().getQualifiedName();
            Entity entity = it.getFtsOptions().getContentEntity();
            Intrinsics.checkNotNull((Object)entity);
            rLog.e(xElement, ProcessorErrors.INSTANCE.missingExternalContentEntity(string, entity.getElement().getQualifiedName()), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> processEntities(XAnnotationBox<Database> dbAnnotation, XTypeElement element) {
        void $this$mapNotNullTo$iv$iv;
        List entityList = dbAnnotation.getAsTypeList("entities");
        this.context.getChecker().check(!((Collection)entityList).isEmpty(), (XElement)element, ProcessorErrors.INSTANCE.getDATABASE_ANNOTATION_MUST_HAVE_LIST_OF_ENTITIES(), new Object[0]);
        Iterable $this$mapNotNull$iv = entityList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Entity entity;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            XType it = (XType)element$iv$iv;
            boolean bl2 = false;
            XTypeElement typeElement = it.getTypeElement();
            if (typeElement == null) {
                this.context.getLogger().e((XElement)element, ProcessorErrors.INSTANCE.invalidEntityTypeInDatabaseAnnotation(it.asTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
                entity = null;
            } else {
                entity = EntityProcessorKt.EntityProcessor$default(this.context, typeElement, null, 4, null).process();
            }
            if (entity == null) continue;
            Entity it$iv$iv = entity;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<XTypeElement, DatabaseView> processDatabaseViews(XAnnotationBox<Database> dbAnnotation) {
        void $this$mapNotNullTo$iv$iv;
        List viewList = dbAnnotation.getAsTypeList("views");
        Iterable $this$mapNotNull$iv = viewList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            XType it = (XType)element$iv$iv;
            boolean bl2 = false;
            XTypeElement viewElement = it.getTypeElement();
            if (viewElement == null) {
                this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.invalidViewTypeInDatabaseAnnotation(it.asTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
                pair = null;
            } else {
                pair = TuplesKt.to((Object)viewElement, (Object)new DatabaseViewProcessor(this.context, viewElement, null, 4, null).process());
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final void verifyDatabaseViews(Map<XTypeElement, DatabaseView> map, DatabaseVerifier dbVerifier) {
        for (Map.Entry<XTypeElement, DatabaseView> entry : map.entrySet()) {
            XTypeElement viewElement = entry.getKey();
            DatabaseView view = entry.getValue();
            if (viewElement.hasAnnotation(Reflection.getOrCreateKotlinClass(SkipQueryVerification.class))) continue;
            view.getQuery().setResultInfo(dbVerifier.analyze(view.getQuery().getOriginal()));
            QueryResultInfo queryResultInfo = view.getQuery().getResultInfo();
            if ((queryResultInfo != null ? queryResultInfo.getError() : null) == null) continue;
            RLog rLog = this.context.getLogger();
            XElement xElement = (XElement)viewElement;
            QueryResultInfo queryResultInfo2 = view.getQuery().getResultInfo();
            Intrinsics.checkNotNull((Object)queryResultInfo2);
            SQLException sQLException = queryResultInfo2.getError();
            Intrinsics.checkNotNull((Object)sQLException);
            rLog.e(xElement, DatabaseVerificationErrors.INSTANCE.cannotVerifyQuery(sQLException), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DatabaseView> resolveDatabaseViews(@NotNull List<DatabaseView> views) {
        Collection collection;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(views, (String)"views");
        if (views.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = views;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Set<String> destination$iv$iv = (Set<String>)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10)));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator<Object> it;
            DatabaseView databaseView = (DatabaseView)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((DatabaseView)((Object)it)).getViewName());
        }
        List viewNames = (List)((Object)destination$iv$iv);
        for (DatabaseView view : views) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            $this$mapTo$iv$iv = view.getQuery().getTables();
            object = view.getTables();
            boolean $i$f$map2 = false;
            void $i$f$mapTo2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Table table = (Table)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                String name = table.component1();
                collection.add(name);
            }
            object.addAll((List)destination$iv$iv2);
        }
        List unresolvedViews = CollectionsKt.toMutableList((Collection)views);
        Map resolvedViews = new LinkedHashMap();
        List result = new ArrayList();
        do {
            Collection<String> collection2;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Iterable $this$forEach$iv;
            DatabaseView view;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Set tables;
            for (Map.Entry $this$mapTo$iv$iv2 : resolvedViews.entrySet()) {
                String viewName = (String)$this$mapTo$iv$iv2.getKey();
                tables = (Set)$this$mapTo$iv$iv2.getValue();
                for (DatabaseView view2 : unresolvedViews) {
                    if (!view2.getTables().removeIf(arg_0 -> DatabaseProcessor.resolveDatabaseViews$lambda$40((Function1)new Function1<String, Boolean>(viewName){
                        final /* synthetic */ String $viewName;
                        {
                            this.$viewName = $viewName;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return StringsKt.equals((String)it, (String)this.$viewName, (boolean)true);
                        }
                    }, arg_0))) continue;
                    view2.getTables().addAll(tables);
                }
            }
            int countNewlyResolved = 0;
            Iterable $this$mapTo$iv$iv2 = unresolvedViews;
            boolean $i$f$filter = false;
            tables = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                Object element$iv$iv;
                block13: {
                    element$iv$iv = iterator.next();
                    view = (DatabaseView)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$all$iv = view.getTables();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (DatabaseProcessor.resolveDatabaseViews$isTable(viewNames, it)) continue;
                            bl = false;
                            break block13;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv = $this$filterTo$iv$iv.next();
                DatabaseView view3 = (DatabaseView)element$iv;
                boolean bl = false;
                resolvedViews.put(view3.getViewName(), view3.getTables());
                unresolvedViews.remove(view3);
                result.add(view3);
                ++countNewlyResolved;
            }
            if (countNewlyResolved != 0) continue;
            $this$forEach$iv = unresolvedViews;
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            collection = (XElement)this.element;
            object = this.context.getLogger();
            boolean $i$f$map3 = false;
            $this$filterTo$iv$iv = $this$map$iv3;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                view = (DatabaseView)item$iv$iv;
                collection2 = destination$iv$iv3;
                boolean bl = false;
                collection2.add(it.getViewName());
            }
            collection2 = (List)destination$iv$iv3;
            ((RLog)object).e((XElement)collection, processorErrors.viewCircularReferenceDetected((List<String>)collection2), new Object[0]);
            break;
        } while (!((Collection)unresolvedViews).isEmpty());
        return result;
    }

    private static final DatabaseBundle processAutoMigrations$lambda$3$deserializeSchemaFile(Path databaseSchemaInFolderPath, FileInputStream fileInputStream, int versionNumber) {
        DatabaseBundle databaseBundle;
        try {
            databaseBundle = SchemaBundle.Companion.deserialize((InputStream)fileInputStream).getDatabase();
        }
        catch (Throwable th) {
            ProcessorErrors.INSTANCE.invalidAutoMigrationSchema(versionNumber + ".json", ((Object)databaseSchemaInFolderPath).toString());
            databaseBundle = null;
        }
        return databaseBundle;
    }

    private static final boolean resolveDatabaseViews$isTable(List<String> viewNames, String name) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = viewNames;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)it, (String)name, (boolean)true)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean resolveDatabaseViews$lambda$40(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

