/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.annotation.VisibleForTesting;
import androidx.room.compiler.codegen.CodeLanguage;
import androidx.room.compiler.codegen.VisibilityModifier;
import androidx.room.compiler.codegen.XCodeBlock;
import androidx.room.compiler.codegen.XFunSpec;
import androidx.room.compiler.codegen.XTypeName;
import androidx.room.compiler.codegen.XTypeSpec;
import androidx.room.ext.CommonTypeNames;
import androidx.room.ext.RoomMemberNames;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SupportDbTypeNames;
import androidx.room.solver.CodeGenScope;
import androidx.room.vo.Database;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.Pojo;
import androidx.room.writer.FtsTableInfoValidationWriter;
import androidx.room.writer.TableInfoValidationWriter;
import androidx.room.writer.ValidationWriter;
import androidx.room.writer.ViewInfoValidationWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Landroidx/room/writer/SQLiteOpenHelperWriter;", "", "database", "Landroidx/room/vo/Database;", "(Landroidx/room/vo/Database;)V", "getDatabase", "()Landroidx/room/vo/Database;", "dbParamName", "", "createCreateAllTables", "Landroidx/room/compiler/codegen/XFunSpec;", "scope", "Landroidx/room/solver/CodeGenScope;", "createDropAllTables", "createDropTableQuery", "entity", "Landroidx/room/vo/Entity;", "createDropViewQuery", "view", "Landroidx/room/vo/DatabaseView;", "createInvokeCallbacksCode", "Landroidx/room/compiler/codegen/XCodeBlock;", "methodName", "createOnCreate", "createOnOpen", "createOnPostMigrate", "createOnPreMigrate", "createOpenCallback", "Landroidx/room/compiler/codegen/XTypeSpec;", "createTableQuery", "createValidateMigration", "", "createViewQuery", "write", "", "outVar", "configParamName", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nSQLiteOpenHelperWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLiteOpenHelperWriter.kt\nandroidx/room/writer/SQLiteOpenHelperWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n1855#2,2:346\n1855#2,2:348\n1549#2:350\n1620#2,3:351\n1855#2,2:354\n1855#2,2:356\n1855#2,2:358\n766#2:360\n857#2,2:361\n1360#2:363\n1446#2,5:364\n1855#2,2:369\n*S KotlinDebug\n*F\n+ 1 SQLiteOpenHelperWriter.kt\nandroidx/room/writer/SQLiteOpenHelperWriter\n*L\n101#1:346,2\n174#1:348,2\n201#1:350\n201#1:351,3\n241#1:354,2\n255#1:356,2\n258#1:358,2\n286#1:360\n286#1:361,2\n287#1:363\n287#1:364,5\n288#1:369,2\n*E\n"})
public final class SQLiteOpenHelperWriter {
    @NotNull
    private final Database database;
    @NotNull
    private final String dbParamName;

    public SQLiteOpenHelperWriter(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
        this.dbParamName = "db";
    }

    @NotNull
    public final Database getDatabase() {
        return this.database;
    }

    public final void write(@NotNull String outVar, @NotNull String configParamName, @NotNull CodeGenScope scope) {
        XCodeBlock.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)outVar, (String)"outVar");
        Intrinsics.checkNotNullParameter((Object)configParamName, (String)"configParamName");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        XCodeBlock.Builder $this$write_u24lambda_u240 = builder2 = scope.getBuilder();
        boolean bl = false;
        String sqliteConfigVar = scope.getTmpVar("_sqliteConfig");
        String callbackVar = scope.getTmpVar("_openCallback");
        Object[] objectArray = new Object[]{configParamName, this.createOpenCallback(scope), this.database.getIdentityHash(), this.database.getLegacyIdentityHash()};
        XCodeBlock.Builder.addLocalVariable$default((XCodeBlock.Builder)$this$write_u24lambda_u240, (String)callbackVar, (XTypeName)((XTypeName)SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CALLBACK()), (boolean)false, (XCodeBlock)XCodeBlock.Companion.ofNewInstance($this$write_u24lambda_u240.getLanguage(), (XTypeName)RoomTypeNames.INSTANCE.getOPEN_HELPER(), "%L, %L, %S, %S", objectArray), (int)4, null);
        objectArray = new Object[]{SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CONFIG(), configParamName, configParamName, callbackVar};
        XCodeBlock.Builder.Companion.addLocalVal($this$write_u24lambda_u240, sqliteConfigVar, (XTypeName)SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CONFIG(), "%T.builder(%L.context).name(%L.name).callback(%L).build()", objectArray);
        objectArray = new Object[]{configParamName, sqliteConfigVar};
        XCodeBlock.Builder.Companion.addLocalVal($this$write_u24lambda_u240, outVar, (XTypeName)SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER(), "%L.sqliteOpenHelperFactory.create(%L)", objectArray);
    }

    private final XTypeSpec createOpenCallback(CodeGenScope scope) {
        Object[] objectArray = new Object[]{this.database.getVersion()};
        Object[] $this$createOpenCallback_u24lambda_u242 = objectArray = XTypeSpec.Companion.anonymousClassBuilder(scope.getLanguage(), "%L", objectArray);
        boolean bl = false;
        $this$createOpenCallback_u24lambda_u242.superclass((XTypeName)RoomTypeNames.INSTANCE.getOPEN_HELPER_DELEGATE());
        $this$createOpenCallback_u24lambda_u242.addFunction(this.createCreateAllTables(scope));
        $this$createOpenCallback_u24lambda_u242.addFunction(this.createDropAllTables(scope.fork()));
        $this$createOpenCallback_u24lambda_u242.addFunction(this.createOnCreate(scope.fork()));
        $this$createOpenCallback_u24lambda_u242.addFunction(this.createOnOpen(scope.fork()));
        $this$createOpenCallback_u24lambda_u242.addFunction(this.createOnPreMigrate(scope));
        $this$createOpenCallback_u24lambda_u242.addFunction(this.createOnPostMigrate(scope));
        Iterable $this$forEach$iv = this.createValidateMigration(scope.fork());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XFunSpec it = (XFunSpec)element$iv;
            boolean bl2 = false;
            $this$createOpenCallback_u24lambda_u242.addFunction(it);
        }
        return objectArray.build();
    }

    /*
     * WARNING - void declaration
     */
    private final List<XFunSpec> createValidateMigration(CodeGenScope scope) {
        void $this$mapTo$iv$iv;
        Object $this$createValidateMigration_u24lambda_u246;
        Object methodScope;
        String methodName;
        List methodBuilders = new ArrayList();
        ArrayDeque entities = new ArrayDeque(this.database.getEntities());
        ArrayDeque views = new ArrayDeque(this.database.getViews());
        while (!entities.isEmpty() || !views.isEmpty()) {
            int statementCount;
            ValidationWriter validationWriter;
            XFunSpec.Builder builder2;
            boolean isPrimaryMethod = methodBuilders.isEmpty();
            methodName = isPrimaryMethod ? "onValidateSchema" : "onValidateSchema" + (methodBuilders.size() + 1);
            XFunSpec.Builder $this$createValidateMigration_u24lambda_u243 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)scope.getLanguage(), (String)methodName, (VisibilityModifier)(isPrimaryMethod ? VisibilityModifier.PUBLIC : VisibilityModifier.PRIVATE), (boolean)false, (boolean)isPrimaryMethod, (int)8, null);
            boolean bl = false;
            $this$createValidateMigration_u24lambda_u243.returns((XTypeName)RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT());
            XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createValidateMigration_u24lambda_u243, (XTypeName)((XTypeName)SupportDbTypeNames.INSTANCE.getDB()), (String)this.dbParamName, null, (int)4, null);
            for (statementCount = 0; !entities.isEmpty() && statementCount < 1000; statementCount += validationWriter.statementCount()) {
                ValidationWriter validationWriter2;
                methodScope = scope.fork();
                Entity entity = (Entity)entities.poll();
                if (entity instanceof FtsEntity) {
                    Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"entity");
                    validationWriter2 = new FtsTableInfoValidationWriter((FtsEntity)entity);
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"entity");
                    validationWriter2 = new TableInfoValidationWriter(entity);
                }
                validationWriter = validationWriter2;
                validationWriter.write(this.dbParamName, (CodeGenScope)methodScope);
                $this$createValidateMigration_u24lambda_u243.addCode(((CodeGenScope)methodScope).generate());
            }
            while (!views.isEmpty() && statementCount < 1000) {
                methodScope = scope.fork();
                DatabaseView view = (DatabaseView)views.poll();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
                validationWriter = new ViewInfoValidationWriter(view);
                validationWriter.write(this.dbParamName, (CodeGenScope)methodScope);
                $this$createValidateMigration_u24lambda_u243.addCode(((CodeGenScope)methodScope).generate());
                statementCount += validationWriter.statementCount();
            }
            if (!isPrimaryMethod) {
                methodScope = new Object[]{XCodeBlock.Companion.ofNewInstance(scope.getLanguage(), (XTypeName)RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT(), "true, null", new Object[0])};
                XFunSpec.Builder.Companion.addStatement($this$createValidateMigration_u24lambda_u243, "return %L", (Object[])methodScope);
            }
            XFunSpec.Builder validateMethod = builder2;
            methodBuilders.add(validateMethod);
        }
        if (methodBuilders.size() > 1) {
            methodName = XCodeBlock.Companion.builder(scope.getLanguage());
            $this$createValidateMigration_u24lambda_u246 = methodName;
            boolean bl = false;
            String resultVar = scope.getTmpVar("_result");
            XCodeBlock.Builder.addLocalVariable$default((XCodeBlock.Builder)$this$createValidateMigration_u24lambda_u246, (String)resultVar, (XTypeName)((XTypeName)RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT()), (boolean)true, null, (int)8, null);
            Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)methodBuilders, (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XFunSpec.Builder it = (XFunSpec.Builder)element$iv;
                boolean bl2 = false;
                Object[] objectArray = new Object[]{resultVar, it.getName(), this.dbParamName};
                $this$createValidateMigration_u24lambda_u246.addStatement("%L = %L(%L)", objectArray);
                objectArray = new Object[]{resultVar};
                Object[] $this$createValidateMigration_u24lambda_u246_u24lambda_u245_u24lambda_u244 = objectArray = $this$createValidateMigration_u24lambda_u246.beginControlFlow("if (!%L.isValid)", objectArray);
                boolean bl3 = false;
                Object[] objectArray2 = new Object[]{resultVar};
                $this$createValidateMigration_u24lambda_u246_u24lambda_u245_u24lambda_u244.addStatement("return %L", objectArray2);
                $this$createValidateMigration_u24lambda_u246.endControlFlow();
            }
            Object[] objectArray = new Object[]{XCodeBlock.Companion.ofNewInstance(scope.getLanguage(), (XTypeName)RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT(), "true, null", new Object[0])};
            $this$createValidateMigration_u24lambda_u246.addStatement("return %L", objectArray);
            XCodeBlock body2 = methodName.build();
            ((XFunSpec.Builder)CollectionsKt.first((List)methodBuilders)).addCode(body2);
        } else if (methodBuilders.size() == 1) {
            Object[] body2 = new Object[]{XCodeBlock.Companion.ofNewInstance(scope.getLanguage(), (XTypeName)RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT(), "true, null", new Object[0])};
            XFunSpec.Builder.Companion.addStatement((XFunSpec.Builder)CollectionsKt.first((List)methodBuilders), "return %L", body2);
        }
        Iterable $this$map$iv = methodBuilders;
        boolean $i$f$map = false;
        $this$createValidateMigration_u24lambda_u246 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            methodScope = (XFunSpec.Builder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.build());
        }
        return (List)destination$iv$iv;
    }

    private final XFunSpec createOnCreate(CodeGenScope scope) {
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createOnCreate_u24lambda_u248 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)scope.getLanguage(), (String)"onCreate", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (int)8, null);
        boolean bl = false;
        XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createOnCreate_u24lambda_u248, (XTypeName)((XTypeName)SupportDbTypeNames.INSTANCE.getDB()), (String)this.dbParamName, null, (int)4, null);
        $this$createOnCreate_u24lambda_u248.addCode(this.createInvokeCallbacksCode(scope, "onCreate"));
        return builder2.build();
    }

    private final XFunSpec createOnOpen(CodeGenScope scope) {
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createOnOpen_u24lambda_u249 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)scope.getLanguage(), (String)"onOpen", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (int)8, null);
        boolean bl = false;
        XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createOnOpen_u24lambda_u249, (XTypeName)((XTypeName)SupportDbTypeNames.INSTANCE.getDB()), (String)this.dbParamName, null, (int)4, null);
        Object[] objectArray = new Object[]{this.dbParamName};
        XFunSpec.Builder.Companion.addStatement($this$createOnOpen_u24lambda_u249, "mDatabase = %L", objectArray);
        if (this.database.getEnableForeignKeys()) {
            objectArray = new Object[]{this.dbParamName, "PRAGMA foreign_keys = ON"};
            XFunSpec.Builder.Companion.addStatement($this$createOnOpen_u24lambda_u249, "%L.execSQL(%S)", objectArray);
        }
        objectArray = new Object[]{this.dbParamName};
        XFunSpec.Builder.Companion.addStatement($this$createOnOpen_u24lambda_u249, "internalInitInvalidationTracker(%L)", objectArray);
        $this$createOnOpen_u24lambda_u249.addCode(this.createInvokeCallbacksCode(scope, "onOpen"));
        return builder2.build();
    }

    private final XFunSpec createCreateAllTables(CodeGenScope scope) {
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createCreateAllTables_u24lambda_u2411 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)scope.getLanguage(), (String)"createAllTables", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (int)8, null);
        boolean bl = false;
        XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createCreateAllTables_u24lambda_u2411, (XTypeName)((XTypeName)SupportDbTypeNames.INSTANCE.getDB()), (String)this.dbParamName, null, (int)4, null);
        Iterable $this$forEach$iv = this.database.getBundle().buildCreateQueries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            Object[] objectArray = new Object[]{this.dbParamName, it};
            XFunSpec.Builder.Companion.addStatement($this$createCreateAllTables_u24lambda_u2411, "%L.execSQL(%S)", objectArray);
        }
        return builder2.build();
    }

    private final XFunSpec createDropAllTables(CodeGenScope scope) {
        Object[] objectArray;
        Pojo it;
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createDropAllTables_u24lambda_u2414 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)scope.getLanguage(), (String)"dropAllTables", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (int)8, null);
        boolean bl = false;
        XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createDropAllTables_u24lambda_u2414, (XTypeName)((XTypeName)SupportDbTypeNames.INSTANCE.getDB()), (String)this.dbParamName, null, (int)4, null);
        Iterable $this$forEach$iv = this.database.getEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Entity)element$iv;
            boolean bl2 = false;
            objectArray = new Object[]{this.dbParamName, this.createDropTableQuery((Entity)it)};
            XFunSpec.Builder.Companion.addStatement($this$createDropAllTables_u24lambda_u2414, "%L.execSQL(%S)", objectArray);
        }
        $this$forEach$iv = this.database.getViews();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (DatabaseView)element$iv;
            boolean bl3 = false;
            objectArray = new Object[]{this.dbParamName, this.createDropViewQuery((DatabaseView)it)};
            XFunSpec.Builder.Companion.addStatement($this$createDropAllTables_u24lambda_u2414, "%L.execSQL(%S)", objectArray);
        }
        $this$createDropAllTables_u24lambda_u2414.addCode(this.createInvokeCallbacksCode(scope, "onDestructiveMigration"));
        return builder2.build();
    }

    private final XFunSpec createOnPreMigrate(CodeGenScope scope) {
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createOnPreMigrate_u24lambda_u2415 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)scope.getLanguage(), (String)"onPreMigrate", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (int)8, null);
        boolean bl = false;
        XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createOnPreMigrate_u24lambda_u2415, (XTypeName)((XTypeName)SupportDbTypeNames.INSTANCE.getDB()), (String)this.dbParamName, null, (int)4, null);
        Object[] objectArray = new Object[]{RoomMemberNames.INSTANCE.getDB_UTIL_DROP_FTS_SYNC_TRIGGERS(), this.dbParamName};
        XFunSpec.Builder.Companion.addStatement($this$createOnPreMigrate_u24lambda_u2415, "%M(%L)", objectArray);
        return builder2.build();
    }

    /*
     * WARNING - void declaration
     */
    private final XFunSpec createOnPostMigrate(CodeGenScope scope) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        FtsEntity it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createOnPostMigrate_u24lambda_u2419 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)scope.getLanguage(), (String)"onPostMigrate", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (int)8, null);
        boolean bl = false;
        XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createOnPostMigrate_u24lambda_u2419, (XTypeName)((XTypeName)SupportDbTypeNames.INSTANCE.getDB()), (String)this.dbParamName, null, (int)4, null);
        Iterable iterable = CollectionsKt.filterIsInstance((Iterable)this.database.getEntities(), FtsEntity.class);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FtsEntity)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getFtsOptions().getContentEntity() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (FtsEntity)element$iv$iv;
            boolean bl3 = false;
            Iterable list$iv$iv = it.getContentSyncTriggerCreateQueries();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String syncTriggerQuery = (String)element$iv;
            boolean bl4 = false;
            Object[] objectArray = new Object[]{this.dbParamName, syncTriggerQuery};
            XFunSpec.Builder.Companion.addStatement($this$createOnPostMigrate_u24lambda_u2419, "%L.execSQL(%S)", objectArray);
        }
        return builder2.build();
    }

    private final XCodeBlock createInvokeCallbacksCode(CodeGenScope scope, String methodName) {
        XCodeBlock.Builder builder2;
        XCodeBlock.Builder builder3;
        String localCallbackListVarName = scope.getTmpVar("_callbacks");
        String callbackVarName = scope.getTmpVar("_callback");
        XCodeBlock.Builder $this$createInvokeCallbacksCode_u24lambda_u2422 = builder3 = XCodeBlock.Companion.builder(scope.getLanguage());
        boolean bl = false;
        Object[] objectArray = new XTypeName[]{$this$createInvokeCallbacksCode_u24lambda_u2422.getLanguage() == CodeLanguage.KOTLIN ? (XTypeName)RoomTypeNames.INSTANCE.getROOM_DB_CALLBACK() : XTypeName.Companion.getProducerExtendsName((XTypeName)RoomTypeNames.INSTANCE.getROOM_DB_CALLBACK())};
        XCodeBlock.Builder.Companion.addLocalVal($this$createInvokeCallbacksCode_u24lambda_u2422, localCallbackListVarName, CommonTypeNames.INSTANCE.getLIST().parametrizedBy((XTypeName[])objectArray).copy(true), "mCallbacks", new Object[0]);
        objectArray = new Object[]{localCallbackListVarName};
        Object[] $this$createInvokeCallbacksCode_u24lambda_u2422_u24lambda_u2421 = objectArray = $this$createInvokeCallbacksCode_u24lambda_u2422.beginControlFlow("if (%L != null)", objectArray);
        boolean bl2 = false;
        XCodeBlock.Builder $this$createInvokeCallbacksCode_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420 = builder2 = XCodeBlock.Builder.Companion.beginForEachControlFlow((XCodeBlock.Builder)$this$createInvokeCallbacksCode_u24lambda_u2422_u24lambda_u2421, callbackVarName, (XTypeName)RoomTypeNames.INSTANCE.getROOM_DB_CALLBACK(), localCallbackListVarName);
        boolean bl3 = false;
        Object[] objectArray2 = new Object[]{callbackVarName, methodName, this.dbParamName};
        $this$createInvokeCallbacksCode_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.addStatement("%L.%L(%L)", objectArray2);
        $this$createInvokeCallbacksCode_u24lambda_u2422_u24lambda_u2421.endControlFlow();
        $this$createInvokeCallbacksCode_u24lambda_u2422.endControlFlow();
        return builder3.build();
    }

    @VisibleForTesting
    @NotNull
    public final String createTableQuery(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity.getCreateTableQuery();
    }

    @VisibleForTesting
    @NotNull
    public final String createViewQuery(@NotNull DatabaseView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return view.getCreateViewQuery();
    }

    @VisibleForTesting
    @NotNull
    public final String createDropTableQuery(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return "DROP TABLE IF EXISTS `" + entity.getTableName() + "`";
    }

    @VisibleForTesting
    @NotNull
    public final String createDropViewQuery(@NotNull DatabaseView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return "DROP VIEW IF EXISTS `" + view.getViewName() + "`";
    }
}

