/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.room.vo

import androidx.room.compiler.processing.XMethodElement

/**
 * Represents a DAO bridge method that to supported the boxed version of a generic abstract class or
 * interface in Kotlin. When generating the Java implementation of the DAO, Room needs to also
 * override the bridge method generated by Kotlin for the boxed version support, see KT-46650.
 */
data class KotlinBoxedPrimitiveMethodDelegate(
    val element: XMethodElement,
    val concreteMethod: XMethodElement
)
