/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.room.compiler.codegen.CodeLanguage;
import androidx.room.compiler.codegen.VisibilityModifier;
import androidx.room.compiler.codegen.XClassName;
import androidx.room.compiler.codegen.XCodeBlock;
import androidx.room.compiler.codegen.XFunSpec;
import androidx.room.compiler.codegen.XMemberName;
import androidx.room.compiler.codegen.XTypeName;
import androidx.room.compiler.codegen.XTypeSpec;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SupportDbTypeNames;
import androidx.room.migration.bundle.DatabaseViewBundle;
import androidx.room.migration.bundle.EntityBundle;
import androidx.room.migration.bundle.FtsEntityBundle;
import androidx.room.migration.bundle.IndexBundle;
import androidx.room.vo.AutoMigration;
import androidx.room.writer.AutoMigrationWriter;
import androidx.room.writer.TypeWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002JD\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130.2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u00101\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J4\u00103\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00104\u001a\u00020+2\u0006\u00100\u001a\u00020+2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130.H\u0002J\u0018\u00105\u001a\u00020\u00182\u0006\u00106\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u00107\u001a\u000208H\u0002J\b\u00109\u001a\u000208H\u0002J\b\u0010:\u001a\u00020;H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Landroidx/room/writer/AutoMigrationWriter;", "Landroidx/room/writer/TypeWriter;", "dbElement", "Landroidx/room/compiler/processing/XTypeElement;", "autoMigration", "Landroidx/room/vo/AutoMigration;", "codeLanguage", "Landroidx/room/compiler/codegen/CodeLanguage;", "(Landroidx/room/compiler/processing/XTypeElement;Landroidx/room/vo/AutoMigration;Landroidx/room/compiler/codegen/CodeLanguage;)V", "addedColumns", "", "Landroidx/room/vo/AutoMigration$AddedColumn;", "addedTables", "", "Landroidx/room/vo/AutoMigration$AddedTable;", "getAutoMigration", "()Landroidx/room/vo/AutoMigration;", "complexChangedTables", "", "", "Landroidx/room/vo/AutoMigration$ComplexChangedTable;", "deletedTables", "renamedTables", "addComplexChangeStatements", "", "migrateBuilder", "Landroidx/room/compiler/codegen/XFunSpec$Builder;", "addDatabaseExecuteSqlStatement", "sql", "addDeleteTableStatements", "addDropViewStatements", "addMigrationStatements", "addNewColumnStatements", "addNewTableStatements", "addRecreateViewStatements", "addRenameTableStatements", "addSimpleChangeStatements", "addStatementsToCheckForeignKeyConstraint", "tableName", "addStatementsToContentTransfer", "oldTableName", "tableNameWithNewPrefix", "oldEntityBundle", "Landroidx/room/migration/bundle/EntityBundle;", "newEntityBundle", "renamedColumnsMap", "", "addStatementsToCreateNewTable", "newTable", "addStatementsToDropTableAndRenameTempTable", "newTableName", "addStatementsToMigrateFtsTable", "oldTable", "addStatementsToRecreateIndexes", "table", "createConstructor", "Landroidx/room/compiler/codegen/XFunSpec;", "createMigrateMethod", "createTypeSpecBuilder", "Landroidx/room/compiler/codegen/XTypeSpec$Builder;", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nAutoMigrationWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoMigrationWriter.kt\nandroidx/room/writer/AutoMigrationWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,486:1\n1855#2,2:487\n1855#2,2:489\n1045#2:491\n1855#2,2:492\n766#2:494\n857#2,2:495\n1855#2,2:497\n766#2:499\n857#2,2:500\n1855#2,2:502\n1855#2,2:504\n1855#2,2:506\n1855#2,2:510\n1855#2,2:512\n215#3,2:508\n*S KotlinDebug\n*F\n+ 1 AutoMigrationWriter.kt\nandroidx/room/writer/AutoMigrationWriter\n*L\n142#1:487,2\n153#1:489,2\n167#1:491\n169#1:492,2\n224#1:494\n224#1:495,2\n229#1:497,2\n303#1:499\n303#1:500,2\n308#1:502,2\n360#1:504,2\n391#1:506,2\n429#1:510,2\n460#1:512,2\n410#1:508,2\n*E\n"})
public final class AutoMigrationWriter
extends TypeWriter {
    @NotNull
    private final XTypeElement dbElement;
    @NotNull
    private final AutoMigration autoMigration;
    @NotNull
    private final List<AutoMigration.AddedColumn> addedColumns;
    @NotNull
    private final Set<AutoMigration.AddedTable> addedTables;
    @NotNull
    private final Map<String, String> renamedTables;
    @NotNull
    private final Map<String, AutoMigration.ComplexChangedTable> complexChangedTables;
    @NotNull
    private final List<String> deletedTables;

    public AutoMigrationWriter(@NotNull XTypeElement dbElement, @NotNull AutoMigration autoMigration, @NotNull CodeLanguage codeLanguage2) {
        Intrinsics.checkNotNullParameter((Object)dbElement, (String)"dbElement");
        Intrinsics.checkNotNullParameter((Object)autoMigration, (String)"autoMigration");
        Intrinsics.checkNotNullParameter((Object)codeLanguage2, (String)"codeLanguage");
        super(codeLanguage2);
        this.dbElement = dbElement;
        this.autoMigration = autoMigration;
        this.addedColumns = this.autoMigration.getSchemaDiff().getAddedColumns();
        this.addedTables = this.autoMigration.getSchemaDiff().getAddedTables();
        this.renamedTables = this.autoMigration.getSchemaDiff().getRenamedTables();
        this.complexChangedTables = this.autoMigration.getSchemaDiff().getComplexChangedTables();
        this.deletedTables = this.autoMigration.getSchemaDiff().getDeletedTables();
    }

    @NotNull
    public final AutoMigration getAutoMigration() {
        return this.autoMigration;
    }

    @Override
    @NotNull
    public XTypeSpec.Builder createTypeSpecBuilder() {
        XTypeSpec.Builder builder2;
        XTypeSpec.Builder builder3;
        XTypeSpec.Builder $this$createTypeSpecBuilder_u24lambda_u240 = builder3 = (builder2 = XTypeSpec.Companion.classBuilder$default((XTypeSpec.Companion)XTypeSpec.Companion, (CodeLanguage)this.getCodeLanguage(), (XClassName)this.autoMigration.getImplTypeName(this.dbElement.asClassName()), (boolean)false, (int)4, null));
        boolean bl = false;
        XTypeSpec.Builder.Companion.addOriginatingElement($this$createTypeSpecBuilder_u24lambda_u240, (XElement)this.dbElement);
        $this$createTypeSpecBuilder_u24lambda_u240.superclass((XTypeName)RoomTypeNames.INSTANCE.getMIGRATION());
        if ($this$createTypeSpecBuilder_u24lambda_u240.getLanguage() == CodeLanguage.KOTLIN) {
            $this$createTypeSpecBuilder_u24lambda_u240.setVisibility(VisibilityModifier.INTERNAL);
        }
        if (this.autoMigration.getSpecClassName() != null) {
            XTypeSpec.Builder.Companion.addProperty$default((XTypeSpec.Builder.Companion)XTypeSpec.Builder.Companion, (XTypeSpec.Builder)builder2, (String)"callback", (XTypeName)((XTypeName)RoomTypeNames.INSTANCE.getAUTO_MIGRATION_SPEC()), (VisibilityModifier)VisibilityModifier.PRIVATE, (boolean)false, !this.autoMigration.isSpecProvided() ? XCodeBlock.Companion.ofNewInstance$default((XCodeBlock.Companion)XCodeBlock.Companion, (CodeLanguage)this.getCodeLanguage(), (XTypeName)((XTypeName)this.autoMigration.getSpecClassName()), null, (Object[])new Object[0], (int)4, null) : null, (int)8, null);
        }
        $this$createTypeSpecBuilder_u24lambda_u240.addFunction(this.createConstructor());
        $this$createTypeSpecBuilder_u24lambda_u240.addFunction(this.createMigrateMethod());
        return builder2;
    }

    private final XFunSpec createConstructor() {
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createConstructor_u24lambda_u241 = builder2 = XFunSpec.Companion.constructorBuilder(this.getCodeLanguage(), VisibilityModifier.PUBLIC);
        boolean bl = false;
        XCodeBlock[] xCodeBlockArray = new XCodeBlock[2];
        Object[] objectArray = new Object[]{this.autoMigration.getFrom()};
        xCodeBlockArray[0] = XCodeBlock.Companion.of(this.getCodeLanguage(), "%L", objectArray);
        objectArray = new Object[]{this.autoMigration.getTo()};
        xCodeBlockArray[1] = XCodeBlock.Companion.of(this.getCodeLanguage(), "%L", objectArray);
        $this$createConstructor_u24lambda_u241.callSuperConstructor(xCodeBlockArray);
        if (this.autoMigration.isSpecProvided()) {
            XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createConstructor_u24lambda_u241, (XTypeName)((XTypeName)RoomTypeNames.INSTANCE.getAUTO_MIGRATION_SPEC()), (String)"callback", null, (int)4, null);
            XFunSpec.Builder.Companion.addStatement($this$createConstructor_u24lambda_u241, "this.callback = callback", new Object[0]);
        }
        return builder2.build();
    }

    private final XFunSpec createMigrateMethod() {
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createMigrateMethod_u24lambda_u242 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)this.getCodeLanguage(), (String)"migrate", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (int)8, null);
        boolean bl = false;
        XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createMigrateMethod_u24lambda_u242, (XTypeName)((XTypeName)SupportDbTypeNames.INSTANCE.getDB()), (String)"db", null, (int)4, null);
        this.addMigrationStatements($this$createMigrateMethod_u24lambda_u242);
        if (this.autoMigration.getSpecClassName() != null) {
            XFunSpec.Builder.Companion.addStatement($this$createMigrateMethod_u24lambda_u242, "callback.onPostMigrate(db)", new Object[0]);
        }
        XFunSpec.Builder migrateFunctionBuilder = builder2;
        return migrateFunctionBuilder.build();
    }

    private final void addMigrationStatements(XFunSpec.Builder migrateBuilder) {
        this.addDropViewStatements(migrateBuilder);
        this.addSimpleChangeStatements(migrateBuilder);
        this.addComplexChangeStatements(migrateBuilder);
        this.addRecreateViewStatements(migrateBuilder);
    }

    private final void addDropViewStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.autoMigration.getSchemaDiff().getFromViews();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseViewBundle view = (DatabaseViewBundle)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, "DROP VIEW " + view.getViewName());
        }
    }

    private final void addRecreateViewStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.autoMigration.getSchemaDiff().getToViews();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseViewBundle view = (DatabaseViewBundle)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, view.createView());
        }
    }

    private final void addComplexChangeStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$sortedBy$iv = this.complexChangedTables.values();
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AutoMigration.ComplexChangedTable it = (AutoMigration.ComplexChangedTable)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.getNewVersionEntityBundle() instanceof FtsEntityBundle);
                it = (AutoMigration.ComplexChangedTable)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it.getNewVersionEntityBundle() instanceof FtsEntityBundle));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AutoMigration.ComplexChangedTable complexChangedTable = (AutoMigration.ComplexChangedTable)element$iv;
            boolean bl = false;
            String tableNameWithNewPrefix = complexChangedTable.component2();
            EntityBundle oldEntityBundle = complexChangedTable.component3();
            EntityBundle newEntityBundle = complexChangedTable.component4();
            Map<String, String> renamedColumnsMap = complexChangedTable.component5();
            if (oldEntityBundle instanceof FtsEntityBundle && !StringsKt.isBlank((CharSequence)((FtsEntityBundle)oldEntityBundle).getFtsOptions().getContentTable())) {
                this.addStatementsToMigrateFtsTable(migrateBuilder, oldEntityBundle, newEntityBundle, renamedColumnsMap);
                continue;
            }
            this.addStatementsToCreateNewTable(newEntityBundle, migrateBuilder);
            this.addStatementsToContentTransfer(oldEntityBundle.getTableName(), tableNameWithNewPrefix, oldEntityBundle, newEntityBundle, renamedColumnsMap, migrateBuilder);
            this.addStatementsToDropTableAndRenameTempTable(oldEntityBundle.getTableName(), newEntityBundle.getTableName(), tableNameWithNewPrefix, migrateBuilder);
            this.addStatementsToRecreateIndexes(newEntityBundle, migrateBuilder);
            if (!(!((Collection)newEntityBundle.getForeignKeys()).isEmpty())) continue;
            this.addStatementsToCheckForeignKeyConstraint(newEntityBundle.getTableName(), migrateBuilder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addStatementsToMigrateFtsTable(XFunSpec.Builder migrateBuilder, EntityBundle oldTable, EntityBundle newTable, Map<String, String> renamedColumnsMap) {
        void $this$addStatementsToMigrateFtsTable_u24lambda_u249;
        void $this$filterTo$iv$iv;
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "DROP TABLE `" + oldTable.getTableName() + "`");
        this.addDatabaseExecuteSqlStatement(migrateBuilder, newTable.createTable());
        Iterable $this$filter$iv = oldTable.getFieldsByColumnName().keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = oldTable.getFieldsByColumnName().keySet().contains(it) || renamedColumnsMap.containsKey(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newColumnSequence = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        List oldColumnSequence = new ArrayList();
        Iterable $this$forEach$iv = newColumnSequence;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            String column = (String)element$iv;
            boolean bl = false;
            String string = renamedColumnsMap.get(column);
            if (string == null) {
                string = column;
            }
            oldColumnSequence.add(string);
        }
        if (oldTable instanceof FtsEntityBundle) {
            oldColumnSequence.add("rowid");
            newColumnSequence.add("docid");
        }
        Intrinsics.checkNotNull((Object)newTable, (String)"null cannot be cast to non-null type androidx.room.migration.bundle.FtsEntityBundle");
        String contentTable = ((FtsEntityBundle)newTable).getFtsOptions().getContentTable();
        String selectFromTable = ((CharSequence)contentTable).length() == 0 ? oldTable.getTableName() : contentTable;
        Object element$iv = object = new StringBuilder();
        XFunSpec.Builder builder2 = migrateBuilder;
        AutoMigrationWriter autoMigrationWriter = this;
        boolean bl = false;
        $this$addStatementsToMigrateFtsTable_u24lambda_u249.append("INSERT INTO `" + newTable.getTableName() + "` (" + CollectionsKt.joinToString$default((Iterable)newColumnSequence, (CharSequence)",", null, null, (int)0, null, (Function1)addStatementsToMigrateFtsTable.2.1.INSTANCE, (int)30, null) + ") SELECT " + CollectionsKt.joinToString$default((Iterable)oldColumnSequence, (CharSequence)",", null, null, (int)0, null, (Function1)addStatementsToMigrateFtsTable.2.2.INSTANCE, (int)30, null) + " FROM `" + selectFromTable + "`");
        Unit unit = Unit.INSTANCE;
        String string = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        autoMigrationWriter.addDatabaseExecuteSqlStatement(builder2, string);
    }

    private final void addSimpleChangeStatements(XFunSpec.Builder migrateBuilder) {
        this.addDeleteTableStatements(migrateBuilder);
        this.addRenameTableStatements(migrateBuilder);
        this.addNewColumnStatements(migrateBuilder);
        this.addNewTableStatements(migrateBuilder);
    }

    private final void addStatementsToCreateNewTable(EntityBundle newTable, XFunSpec.Builder migrateBuilder) {
        this.addDatabaseExecuteSqlStatement(migrateBuilder, newTable.createNewTable());
    }

    /*
     * WARNING - void declaration
     */
    private final void addStatementsToContentTransfer(String oldTableName, String tableNameWithNewPrefix, EntityBundle oldEntityBundle, EntityBundle newEntityBundle, Map<String, String> renamedColumnsMap, XFunSpec.Builder migrateBuilder) {
        void $this$addStatementsToContentTransfer_u24lambda_u2412;
        StringBuilder stringBuilder;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = newEntityBundle.getFieldsByColumnName().keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = oldEntityBundle.getFieldsByColumnName().keySet().contains(it) || renamedColumnsMap.containsKey(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newColumnSequence = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        List oldColumnSequence = new ArrayList();
        Iterable $this$forEach$iv = newColumnSequence;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            String column = (String)element$iv;
            boolean bl = false;
            String string = renamedColumnsMap.get(column);
            if (string == null) {
                string = column;
            }
            oldColumnSequence.add(string);
        }
        StringBuilder $i$f$forEach22 = stringBuilder = new StringBuilder();
        XFunSpec.Builder builder2 = migrateBuilder;
        AutoMigrationWriter autoMigrationWriter = this;
        boolean bl = false;
        $this$addStatementsToContentTransfer_u24lambda_u2412.append("INSERT INTO `" + tableNameWithNewPrefix + "` (" + CollectionsKt.joinToString$default((Iterable)newColumnSequence, (CharSequence)",", null, null, (int)0, null, (Function1)addStatementsToContentTransfer.2.1.INSTANCE, (int)30, null) + ") SELECT " + CollectionsKt.joinToString$default((Iterable)oldColumnSequence, (CharSequence)",", null, null, (int)0, null, (Function1)addStatementsToContentTransfer.2.2.INSTANCE, (int)30, null) + " FROM `" + oldTableName + "`");
        Unit unit = Unit.INSTANCE;
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        autoMigrationWriter.addDatabaseExecuteSqlStatement(builder2, string);
    }

    private final void addStatementsToDropTableAndRenameTempTable(String oldTableName, String newTableName, String tableNameWithNewPrefix, XFunSpec.Builder migrateBuilder) {
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "DROP TABLE `" + oldTableName + "`");
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "ALTER TABLE `" + tableNameWithNewPrefix + "` RENAME TO `" + newTableName + "`");
    }

    private final void addStatementsToRecreateIndexes(EntityBundle table, XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = table.getIndices();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexBundle index = (IndexBundle)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, index.getCreateSql(table.getTableName()));
        }
    }

    private final void addStatementsToCheckForeignKeyConstraint(String tableName, XFunSpec.Builder migrateBuilder) {
        Object[] objectArray = new Object[]{XMemberName.Companion.packageMember(RoomTypeNames.INSTANCE.getDB_UTIL(), "foreignKeyCheck"), tableName};
        XFunSpec.Builder.Companion.addStatement(migrateBuilder, "%M(db, %S)", objectArray);
    }

    private final void addDeleteTableStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.deletedTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String deleteTableSql;
            StringBuilder stringBuilder;
            String tableName = (String)element$iv;
            boolean bl = false;
            StringBuilder $this$addDeleteTableStatements_u24lambda_u2415_u24lambda_u2414 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$addDeleteTableStatements_u24lambda_u2415_u24lambda_u2414.append("DROP TABLE `" + tableName + "`");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, deleteTableSql);
        }
    }

    private final void addRenameTableStatements(XFunSpec.Builder migrateBuilder) {
        Map<String, String> $this$forEach$iv = this.renamedTables;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String renameTableSql;
            StringBuilder stringBuilder;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String oldName = entry.getKey();
            String newName = entry.getValue();
            StringBuilder $this$addRenameTableStatements_u24lambda_u2417_u24lambda_u2416 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$addRenameTableStatements_u24lambda_u2417_u24lambda_u2416.append("ALTER TABLE `" + oldName + "` RENAME TO `" + newName + "`");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, renameTableSql);
        }
    }

    private final void addNewColumnStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.addedColumns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String addNewColumnSql;
            StringBuilder stringBuilder;
            AutoMigration.AddedColumn it = (AutoMigration.AddedColumn)element$iv;
            boolean bl = false;
            StringBuilder $this$addNewColumnStatements_u24lambda_u2420_u24lambda_u2419 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$addNewColumnStatements_u24lambda_u2420_u24lambda_u2419.append("ALTER TABLE `" + it.getTableName() + "` ADD COLUMN `" + it.getFieldBundle().getColumnName() + "` " + it.getFieldBundle().getAffinity());
            if (it.getFieldBundle().isNonNull()) {
                $this$addNewColumnStatements_u24lambda_u2420_u24lambda_u2419.append(" NOT NULL");
            }
            String string = it.getFieldBundle().getDefaultValue();
            boolean bl3 = string != null ? ((CharSequence)string).length() > 0 : false;
            if (bl3) {
                $this$addNewColumnStatements_u24lambda_u2420_u24lambda_u2419.append(" DEFAULT " + it.getFieldBundle().getDefaultValue());
            } else {
                if (!(!it.getFieldBundle().isNonNull())) {
                    boolean bl4 = false;
                    String string2 = "A Non-Null field should always have a default value.";
                    throw new IllegalStateException(string2.toString());
                }
                $this$addNewColumnStatements_u24lambda_u2420_u24lambda_u2419.append(" DEFAULT NULL");
            }
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, addNewColumnSql);
        }
    }

    private final void addNewTableStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.addedTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AutoMigration.AddedTable addedTable = (AutoMigration.AddedTable)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, addedTable.getEntityBundle().createTable());
            this.addStatementsToRecreateIndexes(addedTable.getEntityBundle(), migrateBuilder);
        }
    }

    private final void addDatabaseExecuteSqlStatement(XFunSpec.Builder migrateBuilder, String sql) {
        Object[] objectArray = new Object[]{sql};
        XFunSpec.Builder.Companion.addStatement(migrateBuilder, "db.execSQL(%S)", objectArray);
    }
}

