/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.guava;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.concurrent.futures.ResolvableFuture;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@SuppressLint(value={"RestrictedAPI"})
public class GuavaRoom {
    private static Executor sDirectExecutor = new Executor(){

        @Override
        public void execute(@NonNull Runnable runnable) {
            runnable.run();
        }
    };

    private GuavaRoom() {
    }

    @Deprecated
    public static <T> ListenableFuture<T> createListenableFuture(Callable<T> callable, RoomSQLiteQuery query, boolean releaseQuery) {
        return GuavaRoom.createListenableFuture(ArchTaskExecutor.getIOThreadExecutor(), callable, query, releaseQuery, null);
    }

    @Deprecated
    public static <T> ListenableFuture<T> createListenableFuture(RoomDatabase roomDatabase, Callable<T> callable, RoomSQLiteQuery query, boolean releaseQuery) {
        return GuavaRoom.createListenableFuture(roomDatabase.getQueryExecutor(), callable, query, releaseQuery, null);
    }

    @SuppressLint(value={"LambdaLast"})
    public static <T> ListenableFuture<T> createListenableFuture(RoomDatabase roomDatabase, boolean inTransaction, Callable<T> callable, RoomSQLiteQuery query, boolean releaseQuery) {
        return GuavaRoom.createListenableFuture(GuavaRoom.getExecutor(roomDatabase, inTransaction), callable, query, releaseQuery, null);
    }

    @NonNull
    public static <T> ListenableFuture<T> createListenableFuture(@NonNull RoomDatabase roomDatabase, boolean inTransaction, @NonNull Callable<T> callable, @NonNull RoomSQLiteQuery query, boolean releaseQuery, @Nullable CancellationSignal cancellationSignal) {
        return GuavaRoom.createListenableFuture(GuavaRoom.getExecutor(roomDatabase, inTransaction), callable, query, releaseQuery, cancellationSignal);
    }

    private static <T> ListenableFuture<T> createListenableFuture(Executor executor, Callable<T> callable, final RoomSQLiteQuery query, boolean releaseQuery, final @Nullable CancellationSignal cancellationSignal) {
        final ListenableFuture<T> future = GuavaRoom.createListenableFuture(executor, callable);
        if (cancellationSignal != null && Build.VERSION.SDK_INT >= 16) {
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    if (future.isCancelled()) {
                        cancellationSignal.cancel();
                    }
                }
            }, sDirectExecutor);
        }
        if (releaseQuery) {
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    query.release();
                }
            }, sDirectExecutor);
        }
        return future;
    }

    @Deprecated
    @NonNull
    public static <T> ListenableFuture<T> createListenableFuture(@NonNull RoomDatabase roomDatabase, @NonNull Callable<T> callable) {
        return GuavaRoom.createListenableFuture(roomDatabase, false, callable);
    }

    @NonNull
    public static <T> ListenableFuture<T> createListenableFuture(@NonNull RoomDatabase roomDatabase, boolean inTransaction, @NonNull Callable<T> callable) {
        return GuavaRoom.createListenableFuture(GuavaRoom.getExecutor(roomDatabase, inTransaction), callable);
    }

    @NonNull
    private static <T> ListenableFuture<T> createListenableFuture(@NonNull Executor executor, final @NonNull Callable<T> callable) {
        final ResolvableFuture future = ResolvableFuture.create();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Object result = callable.call();
                    future.set(result);
                }
                catch (Throwable throwable) {
                    future.setException(throwable);
                }
            }
        });
        return future;
    }

    private static Executor getExecutor(RoomDatabase database, boolean inTransaction) {
        if (inTransaction) {
            return database.getTransactionExecutor();
        }
        return database.getQueryExecutor();
    }
}

