/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.migration.bundle;

import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.migration.bundle.SchemaEquality;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class SchemaEqualityUtil {
    static <T, K extends SchemaEquality<K>> boolean checkSchemaEquality(@Nullable Map<T, K> map1, @Nullable Map<T, K> map2) {
        if (map1 == null) {
            return map2 == null;
        }
        if (map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<T, K> pair : map1.entrySet()) {
            if (SchemaEqualityUtil.checkSchemaEquality((SchemaEquality)pair.getValue(), (SchemaEquality)map2.get(pair.getKey()))) continue;
            return false;
        }
        return true;
    }

    static <K extends SchemaEquality<K>> boolean checkSchemaEquality(@Nullable List<K> list1, @Nullable List<K> list2) {
        if (list1 == null) {
            return list2 == null;
        }
        if (list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (SchemaEquality item1 : list1) {
            boolean matched = false;
            for (SchemaEquality item2 : list2) {
                if (!SchemaEqualityUtil.checkSchemaEquality(item1, item2)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    static <K extends SchemaEquality<K>> boolean checkSchemaEquality(@Nullable K item1, @Nullable K item2) {
        if (item1 == null) {
            return item2 == null;
        }
        if (item2 == null) {
            return false;
        }
        return item1.isSchemaEqual(item2);
    }

    private SchemaEqualityUtil() {
    }
}

