/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.migration.bundle;

import androidx.annotation.RestrictTo;
import androidx.room.migration.bundle.BundleUtil;
import androidx.room.migration.bundle.SchemaEquality;
import com.google.gson.annotations.SerializedName;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0013\u00a2\u0006\u0002\u0010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0016R\u0016\u0010\u0005\u001a\u00020\u00048\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0003\u001a\u00020\u00048\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000e"}, d2={"Landroidx/room/migration/bundle/DatabaseViewBundle;", "Landroidx/room/migration/bundle/SchemaEquality;", "()V", "viewName", "", "createSql", "(Ljava/lang/String;Ljava/lang/String;)V", "getCreateSql", "()Ljava/lang/String;", "getViewName", "createView", "isSchemaEqual", "", "other", "room-migration"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class DatabaseViewBundle
implements SchemaEquality<DatabaseViewBundle> {
    @SerializedName(value="viewName")
    @NotNull
    private final String viewName;
    @SerializedName(value="createSql")
    @NotNull
    private final String createSql;

    public DatabaseViewBundle(@NotNull String viewName, @NotNull String createSql) {
        Intrinsics.checkNotNullParameter((Object)viewName, (String)"viewName");
        Intrinsics.checkNotNullParameter((Object)createSql, (String)"createSql");
        this.viewName = viewName;
        this.createSql = createSql;
    }

    @NotNull
    public String getViewName() {
        return this.viewName;
    }

    @NotNull
    public String getCreateSql() {
        return this.createSql;
    }

    @Deprecated(message="Marked deprecated to avoid usage in the codebase")
    private DatabaseViewBundle() {
        this("", "");
    }

    @NotNull
    public String createView() {
        return BundleUtil.replaceViewName(this.getCreateSql(), this.getViewName());
    }

    @Override
    public boolean isSchemaEqual(@NotNull DatabaseViewBundle other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.getViewName(), (Object)other.getViewName()) && Intrinsics.areEqual((Object)this.getCreateSql(), (Object)other.getCreateSql());
    }
}

