/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.paging;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.paging.PagingSource;
import androidx.paging.PagingState;
import androidx.room.CoroutinesRoomKt;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.paging.LimitOffsetPagingSourceKt;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000}\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000*\u0001\u0019\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B+\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\fB)\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001e2\u0006\u0010\u001f\u001a\u00020 H%J\u001e\u0010!\u001a\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#2\u0006\u0010$\u001a\u00020\u0004H\u0002J&\u0010%\u001a\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J#\u0010&\u001a\u0004\u0018\u00010\u00042\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000(H\u0016\u00a2\u0006\u0002\u0010)J+\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000+2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J+\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000+2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J3\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000+2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#2\u0006\u0010\u0010\u001a\u00020\u0004H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J5\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000+2\u0006\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020\u0004H\u0002J\b\u00105\u001a\u000206H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00067"}, d2={"Landroidx/room/paging/LimitOffsetPagingSource;", "Value", "", "Landroidx/paging/PagingSource;", "", "supportSQLiteQuery", "Landroidx/sqlite/db/SupportSQLiteQuery;", "db", "Landroidx/room/RoomDatabase;", "tables", "", "", "(Landroidx/sqlite/db/SupportSQLiteQuery;Landroidx/room/RoomDatabase;[Ljava/lang/String;)V", "sourceQuery", "Landroidx/room/RoomSQLiteQuery;", "(Landroidx/room/RoomSQLiteQuery;Landroidx/room/RoomDatabase;[Ljava/lang/String;)V", "itemCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "getItemCount$room_paging_release", "()Ljava/util/concurrent/atomic/AtomicInteger;", "jumpingSupported", "", "getJumpingSupported", "()Z", "observer", "androidx/room/paging/LimitOffsetPagingSource$observer$1", "Landroidx/room/paging/LimitOffsetPagingSource$observer$1;", "registeredObserver", "Ljava/util/concurrent/atomic/AtomicBoolean;", "convertRows", "", "cursor", "Landroid/database/Cursor;", "getLimit", "params", "Landroidx/paging/PagingSource$LoadParams;", "key", "getOffset", "getRefreshKey", "state", "Landroidx/paging/PagingState;", "(Landroidx/paging/PagingState;)Ljava/lang/Integer;", "initialLoad", "Landroidx/paging/PagingSource$LoadResult;", "(Landroidx/paging/PagingSource$LoadParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "load", "loadFromDb", "(Landroidx/paging/PagingSource$LoadParams;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryDatabase", "offset", "limit", "(IIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryItemCount", "registerObserverIfNecessary", "", "room-paging_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class LimitOffsetPagingSource<Value>
extends PagingSource<Integer, Value> {
    @NotNull
    private final RoomSQLiteQuery sourceQuery;
    @NotNull
    private final RoomDatabase db;
    @NotNull
    private final AtomicInteger itemCount;
    @NotNull
    private final observer.1 observer;
    @NotNull
    private final AtomicBoolean registeredObserver;

    public LimitOffsetPagingSource(@NotNull RoomSQLiteQuery sourceQuery, @NotNull RoomDatabase db, String ... tables) {
        Intrinsics.checkNotNullParameter((Object)sourceQuery, (String)"sourceQuery");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        this.sourceQuery = sourceQuery;
        this.db = db;
        this.itemCount = new AtomicInteger(-1);
        this.observer = new InvalidationTracker.Observer(tables, this){
            final /* synthetic */ String[] $tables;
            final /* synthetic */ LimitOffsetPagingSource<Value> this$0;
            {
                this.$tables = $tables;
                this.this$0 = $receiver;
                super($tables);
            }

            public void onInvalidated(@NotNull Set<String> tables) {
                Intrinsics.checkNotNullParameter(tables, (String)"tables");
                this.this$0.invalidate();
            }
        };
        this.registeredObserver = new AtomicBoolean(false);
    }

    public LimitOffsetPagingSource(@NotNull SupportSQLiteQuery supportSQLiteQuery, @NotNull RoomDatabase db, String ... tables) {
        Intrinsics.checkNotNullParameter((Object)supportSQLiteQuery, (String)"supportSQLiteQuery");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.copyFrom((SupportSQLiteQuery)supportSQLiteQuery);
        Intrinsics.checkNotNullExpressionValue((Object)roomSQLiteQuery, (String)"copyFrom(supportSQLiteQuery)");
        this(roomSQLiteQuery, db, Arrays.copyOf(tables, tables.length));
    }

    @NotNull
    public final AtomicInteger getItemCount$room_paging_release() {
        return this.itemCount;
    }

    @Nullable
    public Object load(@NotNull PagingSource.LoadParams<Integer> params, @NotNull Continuation<? super PagingSource.LoadResult<Integer, Value>> $completion) {
        return LimitOffsetPagingSource.load$suspendImpl(this, params, $completion);
    }

    static /* synthetic */ Object load$suspendImpl(LimitOffsetPagingSource this_, PagingSource.LoadParams params, Continuation $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)CoroutinesRoomKt.getQueryDispatcher((RoomDatabase)this_.db)), (Function2)new Function2<CoroutineScope, Continuation<? super PagingSource.LoadResult<Integer, Value>>, Object>(this_, (PagingSource.LoadParams<Integer>)params, null){
            int label;
            final /* synthetic */ LimitOffsetPagingSource<Value> this$0;
            final /* synthetic */ PagingSource.LoadParams<Integer> $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        LimitOffsetPagingSource.access$registerObserverIfNecessary(this.this$0);
                        tempCount = this.this$0.getItemCount$room_paging_release().get();
                        if (tempCount >= 0) break;
                        this.label = 1;
                        v0 = LimitOffsetPagingSource.access$initialLoad(this.this$0, this.$params, (Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        v1 /* !! */  = (PagingSource.LoadResult)v0;
                        ** GOTO lbl29
                    }
                }
                this.label = 2;
                v2 = LimitOffsetPagingSource.access$loadFromDb(this.this$0, this.$params, tempCount, (Continuation)this);
                if (v2 == var4_2) {
                    return var4_2;
                }
                ** GOTO lbl26
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl26:
                        // 2 sources

                        loadResult = (PagingSource.LoadResult)v2;
                        LimitOffsetPagingSource.access$getDb$p(this.this$0).getInvalidationTracker().refreshVersionsSync();
                        v1 /* !! */  = this.this$0.getInvalid() != false ? (PagingSource.LoadResult)LimitOffsetPagingSourceKt.access$getINVALID$p() : var3_4;
lbl29:
                        // 2 sources

                        return v1 /* !! */ ;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super PagingSource.LoadResult<Integer, Value>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Continuation)$completion);
    }

    private final Object initialLoad(PagingSource.LoadParams<Integer> params, Continuation<? super PagingSource.LoadResult<Integer, Value>> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.db, (Function1)new Function1<Continuation<? super PagingSource.LoadResult<Integer, Value>>, Object>(this, params, null){
            int label;
            final /* synthetic */ LimitOffsetPagingSource<Value> this$0;
            final /* synthetic */ PagingSource.LoadParams<Integer> $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        int tempCount = LimitOffsetPagingSource.access$queryItemCount(this.this$0);
                        this.this$0.getItemCount$room_paging_release().set(tempCount);
                        this.label = 1;
                        Object object3 = LimitOffsetPagingSource.access$loadFromDb(this.this$0, this.$params, tempCount, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super PagingSource.LoadResult<Integer, Value>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final Object loadFromDb(PagingSource.LoadParams<Integer> params, int itemCount, Continuation<? super PagingSource.LoadResult<Integer, Value>> $completion) {
        Integer n = (Integer)params.getKey();
        int key = n == null ? 0 : n;
        int limit = this.getLimit(params, key);
        int offset = this.getOffset(params, key, itemCount);
        return this.queryDatabase(offset, limit, itemCount, $completion);
    }

    private final int getLimit(PagingSource.LoadParams<Integer> params, int key) {
        return params instanceof PagingSource.LoadParams.Prepend ? (key < params.getLoadSize() ? key : params.getLoadSize()) : params.getLoadSize();
    }

    private final int getOffset(PagingSource.LoadParams<Integer> params, int key, int itemCount) {
        int n;
        PagingSource.LoadParams<Integer> loadParams = params;
        if (loadParams instanceof PagingSource.LoadParams.Prepend) {
            n = key < params.getLoadSize() ? 0 : key - params.getLoadSize();
        } else if (loadParams instanceof PagingSource.LoadParams.Append) {
            n = key;
        } else if (loadParams instanceof PagingSource.LoadParams.Refresh) {
            n = key >= itemCount ? Math.max(0, itemCount - params.getLoadSize()) : key;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object queryDatabase(int offset, int limit, int itemCount, Continuation<? super PagingSource.LoadResult<Integer, Value>> $completion) {
        String limitOffsetQuery = "SELECT * FROM ( " + this.sourceQuery.getSql() + " ) LIMIT " + limit + " OFFSET " + offset;
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)limitOffsetQuery, (int)this.sourceQuery.getArgCount());
        Intrinsics.checkNotNullExpressionValue((Object)roomSQLiteQuery, (String)"acquire(\n            lim\u2026eQuery.argCount\n        )");
        RoomSQLiteQuery sqLiteQuery = roomSQLiteQuery;
        sqLiteQuery.copyArgumentsFrom(this.sourceQuery);
        Cursor cursor = this.db.query((SupportSQLiteQuery)sqLiteQuery);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"db.query(sqLiteQuery)");
        Cursor cursor2 = cursor;
        List<Value> data = null;
        try {
            data = this.convertRows(cursor2);
        }
        finally {
            cursor2.close();
            sqLiteQuery.release();
        }
        int nextPosToLoad = offset + data.size();
        Integer nextKey = data.isEmpty() || data.size() < limit || nextPosToLoad >= itemCount ? (Integer)null : Boxing.boxInt((int)nextPosToLoad);
        Integer prevKey = offset <= 0 || data.isEmpty() ? null : Boxing.boxInt((int)offset);
        return new PagingSource.LoadResult.Page(data, (Object)prevKey, (Object)nextKey, offset, Math.max(0, itemCount - nextPosToLoad));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int queryItemCount() {
        String countQuery = "SELECT COUNT(*) FROM ( " + this.sourceQuery.getSql() + " )";
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)countQuery, (int)this.sourceQuery.getArgCount());
        Intrinsics.checkNotNullExpressionValue((Object)roomSQLiteQuery, (String)"acquire(\n            cou\u2026eQuery.argCount\n        )");
        RoomSQLiteQuery sqLiteQuery = roomSQLiteQuery;
        sqLiteQuery.copyArgumentsFrom(this.sourceQuery);
        Cursor cursor = this.db.query((SupportSQLiteQuery)sqLiteQuery);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"db.query(sqLiteQuery)");
        Cursor cursor2 = cursor;
        try {
            if (cursor2.moveToFirst()) {
                int n = cursor2.getInt(0);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            cursor2.close();
            sqLiteQuery.release();
        }
    }

    @NonNull
    @NotNull
    protected abstract List<Value> convertRows(@NotNull Cursor var1);

    private final void registerObserverIfNecessary() {
        if (this.registeredObserver.compareAndSet(false, true)) {
            this.db.getInvalidationTracker().addWeakObserver((InvalidationTracker.Observer)this.observer);
        }
    }

    @Nullable
    public Integer getRefreshKey(@NotNull PagingState<Integer, Value> state) {
        Integer n;
        Intrinsics.checkNotNullParameter(state, (String)"state");
        int initialLoadSize = state.getConfig().initialLoadSize;
        if (state.getAnchorPosition() == null) {
            n = null;
        } else {
            Integer n2 = state.getAnchorPosition();
            Intrinsics.checkNotNull((Object)n2);
            n = Math.max(0, n2 - initialLoadSize / 2);
        }
        return n;
    }

    public boolean getJumpingSupported() {
        return true;
    }

    public static final /* synthetic */ void access$registerObserverIfNecessary(LimitOffsetPagingSource $this) {
        $this.registerObserverIfNecessary();
    }

    public static final /* synthetic */ Object access$initialLoad(LimitOffsetPagingSource $this, PagingSource.LoadParams params, Continuation $completion) {
        return $this.initialLoad((PagingSource.LoadParams<Integer>)params, $completion);
    }

    public static final /* synthetic */ Object access$loadFromDb(LimitOffsetPagingSource $this, PagingSource.LoadParams params, int itemCount, Continuation $completion) {
        return $this.loadFromDb((PagingSource.LoadParams<Integer>)params, itemCount, $completion);
    }

    public static final /* synthetic */ RoomDatabase access$getDb$p(LimitOffsetPagingSource $this) {
        return $this.db;
    }

    public static final /* synthetic */ int access$queryItemCount(LimitOffsetPagingSource $this) {
        return $this.queryItemCount();
    }

    public static final /* synthetic */ Object access$queryDatabase(LimitOffsetPagingSource $this, int offset, int limit, int itemCount, Continuation $completion) {
        return $this.queryDatabase(offset, limit, itemCount, $completion);
    }
}

