/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.sqlite.db.SupportSQLiteProgram;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RoomSQLiteQuery
implements SupportSQLiteQuery,
SupportSQLiteProgram {
    @VisibleForTesting
    static final int POOL_LIMIT = 15;
    @VisibleForTesting
    static final int DESIRED_POOL_SIZE = 10;
    private volatile String mQuery;
    @VisibleForTesting
    final long[] mLongBindings;
    @VisibleForTesting
    final double[] mDoubleBindings;
    @VisibleForTesting
    final String[] mStringBindings;
    @VisibleForTesting
    final byte[][] mBlobBindings;
    private final int[] mBindingTypes;
    @VisibleForTesting
    final int mCapacity;
    @VisibleForTesting
    int mArgCount;
    @VisibleForTesting
    static final TreeMap<Integer, RoomSQLiteQuery> sQueryPool = new TreeMap();
    private static final int NULL = 1;
    private static final int LONG = 2;
    private static final int DOUBLE = 3;
    private static final int STRING = 4;
    private static final int BLOB = 5;

    public static RoomSQLiteQuery copyFrom(SupportSQLiteQuery supportSQLiteQuery) {
        final RoomSQLiteQuery query = RoomSQLiteQuery.acquire(supportSQLiteQuery.getSql(), supportSQLiteQuery.getArgCount());
        supportSQLiteQuery.bindTo(new SupportSQLiteProgram(){

            public void bindNull(int index) {
                query.bindNull(index);
            }

            public void bindLong(int index, long value) {
                query.bindLong(index, value);
            }

            public void bindDouble(int index, double value) {
                query.bindDouble(index, value);
            }

            public void bindString(int index, String value) {
                query.bindString(index, value);
            }

            public void bindBlob(int index, byte[] value) {
                query.bindBlob(index, value);
            }

            public void clearBindings() {
                query.clearBindings();
            }

            public void close() {
            }
        });
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoomSQLiteQuery acquire(String query, int argumentCount) {
        TreeMap<Integer, RoomSQLiteQuery> treeMap = sQueryPool;
        synchronized (treeMap) {
            Map.Entry<Integer, RoomSQLiteQuery> entry = sQueryPool.ceilingEntry(argumentCount);
            if (entry != null) {
                sQueryPool.remove(entry.getKey());
                RoomSQLiteQuery sqliteQuery = entry.getValue();
                sqliteQuery.init(query, argumentCount);
                return sqliteQuery;
            }
        }
        RoomSQLiteQuery sqLiteQuery = new RoomSQLiteQuery(argumentCount);
        sqLiteQuery.init(query, argumentCount);
        return sqLiteQuery;
    }

    private RoomSQLiteQuery(int capacity) {
        this.mCapacity = capacity;
        int limit = capacity + 1;
        this.mBindingTypes = new int[limit];
        this.mLongBindings = new long[limit];
        this.mDoubleBindings = new double[limit];
        this.mStringBindings = new String[limit];
        this.mBlobBindings = new byte[limit][];
    }

    void init(String query, int argCount) {
        this.mQuery = query;
        this.mArgCount = argCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        TreeMap<Integer, RoomSQLiteQuery> treeMap = sQueryPool;
        synchronized (treeMap) {
            sQueryPool.put(this.mCapacity, this);
            RoomSQLiteQuery.prunePoolLocked();
        }
    }

    private static void prunePoolLocked() {
        if (sQueryPool.size() > 15) {
            int toBeRemoved = sQueryPool.size() - 10;
            Iterator<Integer> iterator = sQueryPool.descendingKeySet().iterator();
            while (toBeRemoved-- > 0) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    public String getSql() {
        return this.mQuery;
    }

    public int getArgCount() {
        return this.mArgCount;
    }

    public void bindTo(SupportSQLiteProgram program) {
        block7: for (int index = 1; index <= this.mArgCount; ++index) {
            switch (this.mBindingTypes[index]) {
                case 1: {
                    program.bindNull(index);
                    continue block7;
                }
                case 2: {
                    program.bindLong(index, this.mLongBindings[index]);
                    continue block7;
                }
                case 3: {
                    program.bindDouble(index, this.mDoubleBindings[index]);
                    continue block7;
                }
                case 4: {
                    program.bindString(index, this.mStringBindings[index]);
                    continue block7;
                }
                case 5: {
                    program.bindBlob(index, this.mBlobBindings[index]);
                }
            }
        }
    }

    public void bindNull(int index) {
        this.mBindingTypes[index] = 1;
    }

    public void bindLong(int index, long value) {
        this.mBindingTypes[index] = 2;
        this.mLongBindings[index] = value;
    }

    public void bindDouble(int index, double value) {
        this.mBindingTypes[index] = 3;
        this.mDoubleBindings[index] = value;
    }

    public void bindString(int index, String value) {
        this.mBindingTypes[index] = 4;
        this.mStringBindings[index] = value;
    }

    public void bindBlob(int index, byte[] value) {
        this.mBindingTypes[index] = 5;
        this.mBlobBindings[index] = value;
    }

    public void close() {
    }

    public void copyArgumentsFrom(RoomSQLiteQuery other) {
        int argCount = other.getArgCount() + 1;
        System.arraycopy(other.mBindingTypes, 0, this.mBindingTypes, 0, argCount);
        System.arraycopy(other.mLongBindings, 0, this.mLongBindings, 0, argCount);
        System.arraycopy(other.mStringBindings, 0, this.mStringBindings, 0, argCount);
        System.arraycopy(other.mBlobBindings, 0, this.mBlobBindings, 0, argCount);
        System.arraycopy(other.mDoubleBindings, 0, this.mDoubleBindings, 0, argCount);
    }

    public void clearBindings() {
        Arrays.fill(this.mBindingTypes, 1);
        Arrays.fill(this.mStringBindings, null);
        Arrays.fill((Object[])this.mBlobBindings, null);
        this.mQuery = null;
    }
}

