/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

public class DatabaseConfiguration {
    @NonNull
    public final SupportSQLiteOpenHelper.Factory sqliteOpenHelperFactory;
    @NonNull
    public final Context context;
    @Nullable
    public final String name;
    @NonNull
    public final RoomDatabase.MigrationContainer migrationContainer;
    @Nullable
    public final List<RoomDatabase.Callback> callbacks;
    public final boolean allowMainThreadQueries;
    public final RoomDatabase.JournalMode journalMode;
    @NonNull
    public final Executor queryExecutor;
    public final boolean multiInstanceInvalidation;
    public final boolean requireMigration;
    public final boolean allowDestructiveMigrationOnDowngrade;
    private final Set<Integer> mMigrationNotRequiredFrom;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public DatabaseConfiguration(@NonNull Context context, @Nullable String name, @NonNull SupportSQLiteOpenHelper.Factory sqliteOpenHelperFactory, @NonNull RoomDatabase.MigrationContainer migrationContainer, @Nullable List<RoomDatabase.Callback> callbacks, boolean allowMainThreadQueries, RoomDatabase.JournalMode journalMode, @NonNull Executor queryExecutor, boolean multiInstanceInvalidation, boolean requireMigration, boolean allowDestructiveMigrationOnDowngrade, @Nullable Set<Integer> migrationNotRequiredFrom) {
        this.sqliteOpenHelperFactory = sqliteOpenHelperFactory;
        this.context = context;
        this.name = name;
        this.migrationContainer = migrationContainer;
        this.callbacks = callbacks;
        this.allowMainThreadQueries = allowMainThreadQueries;
        this.journalMode = journalMode;
        this.queryExecutor = queryExecutor;
        this.multiInstanceInvalidation = multiInstanceInvalidation;
        this.requireMigration = requireMigration;
        this.allowDestructiveMigrationOnDowngrade = allowDestructiveMigrationOnDowngrade;
        this.mMigrationNotRequiredFrom = migrationNotRequiredFrom;
    }

    public boolean isMigrationRequiredFrom(int version) {
        return this.isMigrationRequired(version, version + 1);
    }

    public boolean isMigrationRequired(int fromVersion, int toVersion) {
        boolean isDowngrade;
        boolean bl = isDowngrade = fromVersion > toVersion;
        if (isDowngrade && this.allowDestructiveMigrationOnDowngrade) {
            return false;
        }
        return this.requireMigration && (this.mMigrationNotRequiredFrom == null || !this.mMigrationNotRequiredFrom.contains(fromVersion));
    }
}

