/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import android.database.Cursor;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.sqlite.db.SupportSQLiteDatabase;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class FtsTableInfo {
    private static final String[] FTS_OPTIONS = new String[]{"tokenize=", "compress=", "content=", "languageid=", "matchinfo=", "notindexed=", "order=", "prefix=", "uncompress="};
    public final String name;
    public final Set<String> columns;
    public final Set<String> options;

    public FtsTableInfo(String name, Set<String> columns, Set<String> options) {
        this.name = name;
        this.columns = columns;
        this.options = options;
    }

    public FtsTableInfo(String name, Set<String> columns, String createSql) {
        this.name = name;
        this.columns = columns;
        this.options = FtsTableInfo.parseOptions(createSql);
    }

    public static FtsTableInfo read(SupportSQLiteDatabase database, String tableName) {
        Set<String> columns = FtsTableInfo.readColumns(database, tableName);
        Set<String> options = FtsTableInfo.readOptions(database, tableName);
        return new FtsTableInfo(tableName, columns, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> readColumns(SupportSQLiteDatabase database, String tableName) {
        HashSet<String> columns = new HashSet<String>();
        try (Cursor cursor = database.query("PRAGMA table_info(`" + tableName + "`)");){
            if (cursor.getColumnCount() > 0) {
                int nameIndex = cursor.getColumnIndex("name");
                while (cursor.moveToNext()) {
                    columns.add(cursor.getString(nameIndex));
                }
            }
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> readOptions(SupportSQLiteDatabase database, String tableName) {
        String sql = "";
        try (Cursor cursor = database.query("SELECT * FROM sqlite_master WHERE `name` = '" + tableName + "'");){
            if (cursor.moveToFirst()) {
                sql = cursor.getString(cursor.getColumnIndexOrThrow("sql"));
            }
        }
        return FtsTableInfo.parseOptions(sql);
    }

    @VisibleForTesting
    static Set<String> parseOptions(String createStatement) {
        if (createStatement.isEmpty()) {
            return new HashSet<String>();
        }
        String argsString = createStatement.substring(createStatement.indexOf(40) + 1, createStatement.lastIndexOf(41));
        ArrayList<String> args = new ArrayList<String>();
        ArrayDeque<Character> quoteStack = new ArrayDeque<Character>();
        int lastDelimiterIndex = -1;
        block6: for (int i = 0; i < argsString.length(); ++i) {
            char c = argsString.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '`': {
                    if (quoteStack.isEmpty()) {
                        quoteStack.push(Character.valueOf(c));
                        continue block6;
                    }
                    if (((Character)quoteStack.peek()).charValue() != c) continue block6;
                    quoteStack.pop();
                    continue block6;
                }
                case '[': {
                    if (!quoteStack.isEmpty()) continue block6;
                    quoteStack.push(Character.valueOf(c));
                    continue block6;
                }
                case ']': {
                    if (quoteStack.isEmpty() || ((Character)quoteStack.peek()).charValue() != '[') continue block6;
                    quoteStack.pop();
                    continue block6;
                }
                case ',': {
                    if (!quoteStack.isEmpty()) continue block6;
                    args.add(argsString.substring(lastDelimiterIndex + 1, i).trim());
                    lastDelimiterIndex = i;
                }
            }
        }
        args.add(argsString.substring(lastDelimiterIndex + 1).trim());
        HashSet<String> options = new HashSet<String>();
        for (String arg : args) {
            for (String validOption : FTS_OPTIONS) {
                if (!arg.startsWith(validOption)) continue;
                options.add(arg);
            }
        }
        return options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FtsTableInfo that = (FtsTableInfo)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) {
            return false;
        }
        return this.options != null ? this.options.equals(that.options) : that.options == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FtsTableInfo{name='" + this.name + '\'' + ", columns=" + this.columns + ", options=" + this.options + '}';
    }
}

