/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.database.SQLException;
import android.database.sqlite.SQLiteTransactionListener;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.room.AutoCloser;
import androidx.room.AutoClosingRoomOpenHelper;
import androidx.room.DelegatingOpenHelper;
import androidx.room.util.SneakyThrow;
import androidx.sqlite.db.SupportSQLiteCompat;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0003\u0015\u0016\u0017B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0097\u0001J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\u0010H\u0017J\u0011\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0097\u0001R\u0010\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Landroidx/room/AutoClosingRoomOpenHelper;", "Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "Landroidx/room/DelegatingOpenHelper;", "delegate", "autoCloser", "Landroidx/room/AutoCloser;", "(Landroidx/sqlite/db/SupportSQLiteOpenHelper;Landroidx/room/AutoCloser;)V", "autoClosingDb", "Landroidx/room/AutoClosingRoomOpenHelper$AutoClosingSupportSQLiteDatabase;", "getDelegate", "()Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "close", "", "getDatabaseName", "", "getReadableDatabase", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "getWritableDatabase", "setWriteAheadLoggingEnabled", "p0", "", "AutoClosingSupportSQLiteDatabase", "AutoClosingSupportSqliteStatement", "KeepAliveCursor", "room-runtime_release"})
public final class AutoClosingRoomOpenHelper
implements SupportSQLiteOpenHelper,
DelegatingOpenHelper {
    @NotNull
    private final SupportSQLiteOpenHelper delegate;
    @JvmField
    @NotNull
    public final AutoCloser autoCloser;
    @NotNull
    private final AutoClosingSupportSQLiteDatabase autoClosingDb;

    public AutoClosingRoomOpenHelper(@NotNull SupportSQLiteOpenHelper delegate, @NotNull AutoCloser autoCloser) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)autoCloser, (String)"autoCloser");
        this.delegate = delegate;
        this.autoCloser = autoCloser;
        this.autoCloser.init(this.getDelegate());
        this.autoClosingDb = new AutoClosingSupportSQLiteDatabase(this.autoCloser);
    }

    @Override
    @NotNull
    public SupportSQLiteOpenHelper getDelegate() {
        return this.delegate;
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public String getDatabaseName() {
        return this.delegate.getDatabaseName();
    }

    @RequiresApi(api=16)
    public void setWriteAheadLoggingEnabled(boolean p0) {
        this.delegate.setWriteAheadLoggingEnabled(p0);
    }

    @RequiresApi(api=24)
    @NotNull
    public SupportSQLiteDatabase getWritableDatabase() {
        this.autoClosingDb.pokeOpen();
        return this.autoClosingDb;
    }

    @RequiresApi(api=24)
    @NotNull
    public SupportSQLiteDatabase getReadableDatabase() {
        this.autoClosingDb.pokeOpen();
        return this.autoClosingDb;
    }

    public void close() {
        try {
            this.autoClosingDb.close();
        }
        catch (IOException e) {
            SneakyThrow.reThrow(e);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J+\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\"0!H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020\u0010H\u0016J\b\u0010'\u001a\u00020\u0012H\u0016J\b\u0010(\u001a\u00020\u001bH\u0016J \u0010)\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u001bH\u0016J\b\u0010.\u001a\u00020\u001bH\u0016J\b\u0010/\u001a\u00020\u001bH\u0016J\b\u00100\u001a\u00020\u001bH\u0016J\b\u00101\u001a\u00020\u001bH\u0017J\u0010\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u0012H\u0016J\u0006\u00104\u001a\u00020\u0006J\u0010\u00105\u001a\u0002062\u0006\u00105\u001a\u000207H\u0016J\u0018\u00105\u001a\u0002062\u0006\u00105\u001a\u0002072\u0006\u00108\u001a\u000209H\u0017J\u0010\u00105\u001a\u0002062\u0006\u00105\u001a\u00020\u0010H\u0016J#\u00105\u001a\u0002062\u0006\u00105\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\u001bH\u0017J\u0010\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u00062\u0006\u0010A\u001a\u00020\u0012H\u0016J\u0010\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020$H\u0016J\u0010\u0010D\u001a\u00020\u00062\u0006\u0010C\u001a\u00020$H\u0016J\b\u0010E\u001a\u00020\u0006H\u0016J\u0010\u0010F\u001a\u00020\u00062\u0006\u0010G\u001a\u00020\u0012H\u0016J;\u0010H\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016\u00a2\u0006\u0002\u0010IJ\b\u0010J\u001a\u00020\u001bH\u0016J\u0010\u0010J\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Landroidx/room/AutoClosingRoomOpenHelper$AutoClosingSupportSQLiteDatabase;", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "autoCloser", "Landroidx/room/AutoCloser;", "(Landroidx/room/AutoCloser;)V", "beginTransaction", "", "beginTransactionNonExclusive", "beginTransactionWithListener", "transactionListener", "Landroid/database/sqlite/SQLiteTransactionListener;", "beginTransactionWithListenerNonExclusive", "close", "compileStatement", "Landroidx/sqlite/db/SupportSQLiteStatement;", "sql", "", "delete", "", "table", "whereClause", "whereArgs", "", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)I", "disableWriteAheadLogging", "enableWriteAheadLogging", "", "endTransaction", "execSQL", "bindArgs", "(Ljava/lang/String;[Ljava/lang/Object;)V", "getAttachedDbs", "", "Landroid/util/Pair;", "getMaximumSize", "", "getPageSize", "getPath", "getVersion", "inTransaction", "insert", "conflictAlgorithm", "values", "Landroid/content/ContentValues;", "isDatabaseIntegrityOk", "isDbLockedByCurrentThread", "isOpen", "isReadOnly", "isWriteAheadLoggingEnabled", "needUpgrade", "newVersion", "pokeOpen", "query", "Landroid/database/Cursor;", "Landroidx/sqlite/db/SupportSQLiteQuery;", "cancellationSignal", "Landroid/os/CancellationSignal;", "(Ljava/lang/String;[Ljava/lang/Object;)Landroid/database/Cursor;", "setForeignKeyConstraintsEnabled", "enable", "setLocale", "locale", "Ljava/util/Locale;", "setMaxSqlCacheSize", "cacheSize", "setMaximumSize", "numBytes", "setPageSize", "setTransactionSuccessful", "setVersion", "version", "update", "(Ljava/lang/String;ILandroid/content/ContentValues;Ljava/lang/String;[Ljava/lang/Object;)I", "yieldIfContendedSafely", "sleepAfterYieldDelay", "room-runtime_release"})
    public static final class AutoClosingSupportSQLiteDatabase
    implements SupportSQLiteDatabase {
        @NotNull
        private final AutoCloser autoCloser;

        public AutoClosingSupportSQLiteDatabase(@NotNull AutoCloser autoCloser) {
            Intrinsics.checkNotNullParameter((Object)autoCloser, (String)"autoCloser");
            this.autoCloser = autoCloser;
        }

        public final void pokeOpen() {
            this.autoCloser.executeRefCountingFunction(pokeOpen.1.INSTANCE);
        }

        @NotNull
        public SupportSQLiteStatement compileStatement(@NotNull String sql) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            return new AutoClosingSupportSqliteStatement(sql, this.autoCloser);
        }

        public void beginTransaction() {
            SupportSQLiteDatabase db = this.autoCloser.incrementCountAndEnsureDbIsOpen();
            try {
                db.beginTransaction();
            }
            catch (Throwable t) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw t;
            }
        }

        public void beginTransactionNonExclusive() {
            SupportSQLiteDatabase db = this.autoCloser.incrementCountAndEnsureDbIsOpen();
            try {
                db.beginTransactionNonExclusive();
            }
            catch (Throwable t) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw t;
            }
        }

        public void beginTransactionWithListener(@NotNull SQLiteTransactionListener transactionListener) {
            Intrinsics.checkNotNullParameter((Object)transactionListener, (String)"transactionListener");
            SupportSQLiteDatabase db = this.autoCloser.incrementCountAndEnsureDbIsOpen();
            try {
                db.beginTransactionWithListener(transactionListener);
            }
            catch (Throwable t) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw t;
            }
        }

        public void beginTransactionWithListenerNonExclusive(@NotNull SQLiteTransactionListener transactionListener) {
            Intrinsics.checkNotNullParameter((Object)transactionListener, (String)"transactionListener");
            SupportSQLiteDatabase db = this.autoCloser.incrementCountAndEnsureDbIsOpen();
            try {
                db.beginTransactionWithListenerNonExclusive(transactionListener);
            }
            catch (Throwable t) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw t;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endTransaction() {
            if (this.autoCloser.getDelegateDatabase$room_runtime_release() == null) {
                boolean bl = false;
                String string = "End transaction called but delegateDb is null";
                throw new IllegalStateException(string.toString());
            }
            try {
                SupportSQLiteDatabase supportSQLiteDatabase = this.autoCloser.getDelegateDatabase$room_runtime_release();
                Intrinsics.checkNotNull((Object)supportSQLiteDatabase);
                supportSQLiteDatabase.endTransaction();
            }
            finally {
                this.autoCloser.decrementCountAndScheduleClose();
            }
        }

        public void setTransactionSuccessful() {
            Unit unit;
            SupportSQLiteDatabase supportSQLiteDatabase = this.autoCloser.getDelegateDatabase$room_runtime_release();
            if (supportSQLiteDatabase != null) {
                supportSQLiteDatabase.setTransactionSuccessful();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                throw new IllegalStateException("setTransactionSuccessful called but delegateDb is null".toString());
            }
        }

        public boolean inTransaction() {
            return this.autoCloser.getDelegateDatabase$room_runtime_release() == null ? false : (Boolean)this.autoCloser.executeRefCountingFunction(inTransaction.1.INSTANCE);
        }

        public boolean isDbLockedByCurrentThread() {
            return this.autoCloser.getDelegateDatabase$room_runtime_release() == null ? false : (Boolean)this.autoCloser.executeRefCountingFunction(isDbLockedByCurrentThread.1.INSTANCE);
        }

        public boolean yieldIfContendedSafely() {
            return (Boolean)this.autoCloser.executeRefCountingFunction(yieldIfContendedSafely.1.INSTANCE);
        }

        public boolean yieldIfContendedSafely(long sleepAfterYieldDelay) {
            return (Boolean)this.autoCloser.executeRefCountingFunction(yieldIfContendedSafely.2.INSTANCE);
        }

        public int getVersion() {
            return ((Number)this.autoCloser.executeRefCountingFunction(getVersion.1.INSTANCE)).intValue();
        }

        public void setVersion(int version) {
            this.autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, Object>(version){
                final /* synthetic */ int $version;
                {
                    this.$version = $version;
                    super(1);
                }

                @org.jetbrains.annotations.Nullable
                public final Object invoke(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    db.setVersion(this.$version);
                    return null;
                }
            });
        }

        public long getMaximumSize() {
            return ((Number)this.autoCloser.executeRefCountingFunction(getMaximumSize.1.INSTANCE)).longValue();
        }

        public long setMaximumSize(long numBytes) {
            return ((Number)this.autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, Long>(numBytes){
                final /* synthetic */ long $numBytes;
                {
                    this.$numBytes = $numBytes;
                    super(1);
                }

                @NotNull
                public final Long invoke(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    return db.setMaximumSize(this.$numBytes);
                }
            })).longValue();
        }

        public long getPageSize() {
            return ((Number)this.autoCloser.executeRefCountingFunction(getPageSize.1.INSTANCE)).longValue();
        }

        public void setPageSize(long numBytes) {
            this.autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, Object>(numBytes){
                final /* synthetic */ long $numBytes;
                {
                    this.$numBytes = $numBytes;
                    super(1);
                }

                @org.jetbrains.annotations.Nullable
                public final Object invoke(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    db.setPageSize(this.$numBytes);
                    return null;
                }
            });
        }

        @NotNull
        public Cursor query(@NotNull String query) {
            Cursor cursor;
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            try {
                cursor = this.autoCloser.incrementCountAndEnsureDbIsOpen().query(query);
            }
            catch (Throwable throwable) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw throwable;
            }
            Cursor result = cursor;
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            return new KeepAliveCursor(result, this.autoCloser);
        }

        @NotNull
        public Cursor query(@NotNull String query, @NotNull Object[] bindArgs) {
            Cursor cursor;
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)bindArgs, (String)"bindArgs");
            try {
                cursor = this.autoCloser.incrementCountAndEnsureDbIsOpen().query(query, bindArgs);
            }
            catch (Throwable throwable) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw throwable;
            }
            Cursor result = cursor;
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            return new KeepAliveCursor(result, this.autoCloser);
        }

        @NotNull
        public Cursor query(@NotNull SupportSQLiteQuery query) {
            Cursor cursor;
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            try {
                cursor = this.autoCloser.incrementCountAndEnsureDbIsOpen().query(query);
            }
            catch (Throwable throwable) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw throwable;
            }
            Cursor result = cursor;
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            return new KeepAliveCursor(result, this.autoCloser);
        }

        @RequiresApi(api=24)
        @NotNull
        public Cursor query(@NotNull SupportSQLiteQuery query, @NotNull CancellationSignal cancellationSignal) {
            Cursor cursor;
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)cancellationSignal, (String)"cancellationSignal");
            try {
                cursor = this.autoCloser.incrementCountAndEnsureDbIsOpen().query(query, cancellationSignal);
            }
            catch (Throwable throwable) {
                this.autoCloser.decrementCountAndScheduleClose();
                throw throwable;
            }
            Cursor result = cursor;
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            return new KeepAliveCursor(result, this.autoCloser);
        }

        public long insert(@NotNull String table, int conflictAlgorithm, @NotNull ContentValues values) throws SQLException {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            return ((Number)this.autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, Long>(table, conflictAlgorithm, values){
                final /* synthetic */ String $table;
                final /* synthetic */ int $conflictAlgorithm;
                final /* synthetic */ ContentValues $values;
                {
                    this.$table = $table;
                    this.$conflictAlgorithm = $conflictAlgorithm;
                    this.$values = $values;
                    super(1);
                }

                @NotNull
                public final Long invoke(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    return db.insert(this.$table, this.$conflictAlgorithm, this.$values);
                }
            })).longValue();
        }

        public int delete(@NotNull String table, @NotNull String whereClause, @NotNull Object[] whereArgs) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)whereClause, (String)"whereClause");
            Intrinsics.checkNotNullParameter((Object)whereArgs, (String)"whereArgs");
            return ((Number)this.autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, Integer>(table, whereClause, whereArgs){
                final /* synthetic */ String $table;
                final /* synthetic */ String $whereClause;
                final /* synthetic */ Object[] $whereArgs;
                {
                    this.$table = $table;
                    this.$whereClause = $whereClause;
                    this.$whereArgs = $whereArgs;
                    super(1);
                }

                @NotNull
                public final Integer invoke(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    return db.delete(this.$table, this.$whereClause, this.$whereArgs);
                }
            })).intValue();
        }

        public int update(@NotNull String table, int conflictAlgorithm, @NotNull ContentValues values, @NotNull String whereClause, @NotNull Object[] whereArgs) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            Intrinsics.checkNotNullParameter((Object)whereClause, (String)"whereClause");
            Intrinsics.checkNotNullParameter((Object)whereArgs, (String)"whereArgs");
            return ((Number)this.autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, Integer>(table, conflictAlgorithm, values, whereClause, whereArgs){
                final /* synthetic */ String $table;
                final /* synthetic */ int $conflictAlgorithm;
                final /* synthetic */ ContentValues $values;
                final /* synthetic */ String $whereClause;
                final /* synthetic */ Object[] $whereArgs;
                {
                    this.$table = $table;
                    this.$conflictAlgorithm = $conflictAlgorithm;
                    this.$values = $values;
                    this.$whereClause = $whereClause;
                    this.$whereArgs = $whereArgs;
                    super(1);
                }

                @NotNull
                public final Integer invoke(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    return db.update(this.$table, this.$conflictAlgorithm, this.$values, this.$whereClause, this.$whereArgs);
                }
            })).intValue();
        }

        public void execSQL(@NotNull String sql) throws SQLException {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            this.autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, Object>(sql){
                final /* synthetic */ String $sql;
                {
                    this.$sql = $sql;
                    super(1);
                }

                @org.jetbrains.annotations.Nullable
                public final Object invoke(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    db.execSQL(this.$sql);
                    return null;
                }
            });
        }

        public void execSQL(@NotNull String sql, @NotNull Object[] bindArgs) throws SQLException {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            Intrinsics.checkNotNullParameter((Object)bindArgs, (String)"bindArgs");
            this.autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, Object>(sql, bindArgs){
                final /* synthetic */ String $sql;
                final /* synthetic */ Object[] $bindArgs;
                {
                    this.$sql = $sql;
                    this.$bindArgs = $bindArgs;
                    super(1);
                }

                @org.jetbrains.annotations.Nullable
                public final Object invoke(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    db.execSQL(this.$sql, this.$bindArgs);
                    return null;
                }
            });
        }

        public boolean isReadOnly() {
            return (Boolean)this.autoCloser.executeRefCountingFunction(isReadOnly.1.INSTANCE);
        }

        public boolean isOpen() {
            SupportSQLiteDatabase supportSQLiteDatabase = this.autoCloser.getDelegateDatabase$room_runtime_release();
            if (supportSQLiteDatabase == null) {
                return false;
            }
            SupportSQLiteDatabase localDelegate = supportSQLiteDatabase;
            return localDelegate.isOpen();
        }

        public boolean needUpgrade(int newVersion) {
            return (Boolean)this.autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, Boolean>(newVersion){
                final /* synthetic */ int $newVersion;
                {
                    this.$newVersion = $newVersion;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    return db.needUpgrade(this.$newVersion);
                }
            });
        }

        @NotNull
        public String getPath() {
            Object v = this.autoCloser.executeRefCountingFunction(getPath.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(v, (String)"autoCloser.executeRefCou\u2026   obj.path\n            }");
            return (String)v;
        }

        public void setLocale(@NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            this.autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, Object>(locale){
                final /* synthetic */ Locale $locale;
                {
                    this.$locale = $locale;
                    super(1);
                }

                @org.jetbrains.annotations.Nullable
                public final Object invoke(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    db.setLocale(this.$locale);
                    return null;
                }
            });
        }

        public void setMaxSqlCacheSize(int cacheSize) {
            this.autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, Object>(cacheSize){
                final /* synthetic */ int $cacheSize;
                {
                    this.$cacheSize = $cacheSize;
                    super(1);
                }

                @org.jetbrains.annotations.Nullable
                public final Object invoke(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    db.setMaxSqlCacheSize(this.$cacheSize);
                    return null;
                }
            });
        }

        @RequiresApi(api=16)
        public void setForeignKeyConstraintsEnabled(boolean enable) {
            this.autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, Object>(enable){
                final /* synthetic */ boolean $enable;
                {
                    this.$enable = $enable;
                    super(1);
                }

                @org.jetbrains.annotations.Nullable
                public final Object invoke(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    if (Build.VERSION.SDK_INT >= 16) {
                        db.setForeignKeyConstraintsEnabled(this.$enable);
                    }
                    return null;
                }
            });
        }

        public boolean enableWriteAheadLogging() {
            throw new UnsupportedOperationException("Enable/disable write ahead logging on the OpenHelper instead of on the database directly.");
        }

        public void disableWriteAheadLogging() {
            throw new UnsupportedOperationException("Enable/disable write ahead logging on the OpenHelper instead of on the database directly.");
        }

        @RequiresApi(api=16)
        public boolean isWriteAheadLoggingEnabled() {
            return (Boolean)this.autoCloser.executeRefCountingFunction(isWriteAheadLoggingEnabled.1.INSTANCE);
        }

        @NotNull
        public List<Pair<String, String>> getAttachedDbs() {
            Object v = this.autoCloser.executeRefCountingFunction(getAttachedDbs.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(v, (String)"autoCloser.executeRefCou\u2026attachedDbs\n            }");
            return (List)v;
        }

        public boolean isDatabaseIntegrityOk() {
            return (Boolean)this.autoCloser.executeRefCountingFunction(isDatabaseIntegrityOk.1.INSTANCE);
        }

        public void close() throws IOException {
            this.autoCloser.closeDatabaseIfOpen();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J!\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fH\u0096\u0001J\t\u0010\u000e\u001a\u00020\u0007H\u0097\u0001J\u0019\u0010\u000f\u001a\n \r*\u0004\u0018\u00010\u00100\u00102\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\t\u0010\u0011\u001a\u00020\nH\u0096\u0001J\u0019\u0010\u0012\u001a\u00020\n2\u000e\u0010\t\u001a\n \r*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J\u0019\u0010\u0014\u001a\u00020\n2\u000e\u0010\t\u001a\n \r*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J\u0019\u0010\u0015\u001a\n \r*\u0004\u0018\u00010\u00130\u00132\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J4\u0010\u0016\u001a(\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00130\u0013 \r*\u0014\u0012\u000e\b\u0001\u0012\n \r*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u00170\u0017H\u0096\u0001\u00a2\u0006\u0002\u0010\u0018J\t\u0010\u0019\u001a\u00020\nH\u0096\u0001J\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\u0011\u0010\u001c\u001a\n \r*\u0004\u0018\u00010\u001d0\u001dH\u0096\u0001J\u0011\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\u0011\u0010 \u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\u0011\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\b\u0010#\u001a\u00020$H\u0017J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020$0&H\u0017J\t\u0010'\u001a\u00020\nH\u0096\u0001J\u0011\u0010(\u001a\u00020)2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\u0019\u0010*\u001a\n \r*\u0004\u0018\u00010\u00130\u00132\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\u0011\u0010+\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\t\u0010,\u001a\u00020-H\u0096\u0001J\t\u0010.\u001a\u00020-H\u0096\u0001J\t\u0010/\u001a\u00020-H\u0096\u0001J\t\u00100\u001a\u00020-H\u0096\u0001J\t\u00101\u001a\u00020-H\u0096\u0001J\t\u00102\u001a\u00020-H\u0096\u0001J\u0011\u00103\u001a\u00020-2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\u0011\u00104\u001a\u00020-2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\t\u00105\u001a\u00020-H\u0096\u0001J\t\u00106\u001a\u00020-H\u0096\u0001J\t\u00107\u001a\u00020-H\u0096\u0001J\u0011\u00108\u001a\u00020-2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\t\u00109\u001a\u00020-H\u0096\u0001J\u0019\u0010:\u001a\u00020\u00072\u000e\u0010\t\u001a\n \r*\u0004\u0018\u00010;0;H\u0096\u0001J\u0019\u0010<\u001a\u00020\u00072\u000e\u0010\t\u001a\n \r*\u0004\u0018\u00010=0=H\u0096\u0001J\t\u0010>\u001a\u00020-H\u0097\u0001J!\u0010?\u001a\n \r*\u0004\u0018\u00010\u001d0\u001d2\u000e\u0010\t\u001a\n \r*\u0004\u0018\u00010\u001d0\u001dH\u0096\u0001J\u0010\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u001dH\u0017J)\u0010B\u001a\u00020\u00072\u000e\u0010\t\u001a\n \r*\u0004\u0018\u00010C0C2\u000e\u0010\u000b\u001a\n \r*\u0004\u0018\u00010$0$H\u0096\u0001J\u001e\u0010D\u001a\u00020\u00072\u0006\u0010E\u001a\u00020C2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020$0&H\u0017J\u0019\u0010G\u001a\u00020\u00072\u000e\u0010\t\u001a\n \r*\u0004\u0018\u00010;0;H\u0096\u0001J\u0019\u0010H\u001a\u00020\u00072\u000e\u0010\t\u001a\n \r*\u0004\u0018\u00010=0=H\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Landroidx/room/AutoClosingRoomOpenHelper$KeepAliveCursor;", "Landroid/database/Cursor;", "delegate", "autoCloser", "Landroidx/room/AutoCloser;", "(Landroid/database/Cursor;Landroidx/room/AutoCloser;)V", "close", "", "copyStringToBuffer", "p0", "", "p1", "Landroid/database/CharArrayBuffer;", "kotlin.jvm.PlatformType", "deactivate", "getBlob", "", "getColumnCount", "getColumnIndex", "", "getColumnIndexOrThrow", "getColumnName", "getColumnNames", "", "()[Ljava/lang/String;", "getCount", "getDouble", "", "getExtras", "Landroid/os/Bundle;", "getFloat", "", "getInt", "getLong", "", "getNotificationUri", "Landroid/net/Uri;", "getNotificationUris", "", "getPosition", "getShort", "", "getString", "getType", "getWantsAllOnMoveCalls", "", "isAfterLast", "isBeforeFirst", "isClosed", "isFirst", "isLast", "isNull", "move", "moveToFirst", "moveToLast", "moveToNext", "moveToPosition", "moveToPrevious", "registerContentObserver", "Landroid/database/ContentObserver;", "registerDataSetObserver", "Landroid/database/DataSetObserver;", "requery", "respond", "setExtras", "extras", "setNotificationUri", "Landroid/content/ContentResolver;", "setNotificationUris", "cr", "uris", "unregisterContentObserver", "unregisterDataSetObserver", "room-runtime_release"})
    private static final class KeepAliveCursor
    implements Cursor {
        @NotNull
        private final Cursor delegate;
        @NotNull
        private final AutoCloser autoCloser;

        public KeepAliveCursor(@NotNull Cursor delegate, @NotNull AutoCloser autoCloser) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)autoCloser, (String)"autoCloser");
            this.delegate = delegate;
            this.autoCloser = autoCloser;
        }

        public void copyStringToBuffer(int p0, CharArrayBuffer p1) {
            this.delegate.copyStringToBuffer(p0, p1);
        }

        @Deprecated(message="Deprecated in Java")
        public void deactivate() {
            this.delegate.deactivate();
        }

        public byte[] getBlob(int p0) {
            return this.delegate.getBlob(p0);
        }

        public int getColumnCount() {
            return this.delegate.getColumnCount();
        }

        public int getColumnIndex(String p0) {
            return this.delegate.getColumnIndex(p0);
        }

        public int getColumnIndexOrThrow(String p0) {
            return this.delegate.getColumnIndexOrThrow(p0);
        }

        public String getColumnName(int p0) {
            return this.delegate.getColumnName(p0);
        }

        public String[] getColumnNames() {
            return this.delegate.getColumnNames();
        }

        public int getCount() {
            return this.delegate.getCount();
        }

        public double getDouble(int p0) {
            return this.delegate.getDouble(p0);
        }

        public Bundle getExtras() {
            return this.delegate.getExtras();
        }

        public float getFloat(int p0) {
            return this.delegate.getFloat(p0);
        }

        public int getInt(int p0) {
            return this.delegate.getInt(p0);
        }

        public long getLong(int p0) {
            return this.delegate.getLong(p0);
        }

        public int getPosition() {
            return this.delegate.getPosition();
        }

        public short getShort(int p0) {
            return this.delegate.getShort(p0);
        }

        public String getString(int p0) {
            return this.delegate.getString(p0);
        }

        public int getType(int p0) {
            return this.delegate.getType(p0);
        }

        public boolean getWantsAllOnMoveCalls() {
            return this.delegate.getWantsAllOnMoveCalls();
        }

        public boolean isAfterLast() {
            return this.delegate.isAfterLast();
        }

        public boolean isBeforeFirst() {
            return this.delegate.isBeforeFirst();
        }

        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        public boolean isFirst() {
            return this.delegate.isFirst();
        }

        public boolean isLast() {
            return this.delegate.isLast();
        }

        public boolean isNull(int p0) {
            return this.delegate.isNull(p0);
        }

        public boolean move(int p0) {
            return this.delegate.move(p0);
        }

        public boolean moveToFirst() {
            return this.delegate.moveToFirst();
        }

        public boolean moveToLast() {
            return this.delegate.moveToLast();
        }

        public boolean moveToNext() {
            return this.delegate.moveToNext();
        }

        public boolean moveToPosition(int p0) {
            return this.delegate.moveToPosition(p0);
        }

        public boolean moveToPrevious() {
            return this.delegate.moveToPrevious();
        }

        public void registerContentObserver(ContentObserver p0) {
            this.delegate.registerContentObserver(p0);
        }

        public void registerDataSetObserver(DataSetObserver p0) {
            this.delegate.registerDataSetObserver(p0);
        }

        @Deprecated(message="Deprecated in Java")
        public boolean requery() {
            return this.delegate.requery();
        }

        public Bundle respond(Bundle p0) {
            return this.delegate.respond(p0);
        }

        public void setNotificationUri(ContentResolver p0, Uri p1) {
            this.delegate.setNotificationUri(p0, p1);
        }

        public void unregisterContentObserver(ContentObserver p0) {
            this.delegate.unregisterContentObserver(p0);
        }

        public void unregisterDataSetObserver(DataSetObserver p0) {
            this.delegate.unregisterDataSetObserver(p0);
        }

        public void close() {
            this.delegate.close();
            this.autoCloser.decrementCountAndScheduleClose();
        }

        @RequiresApi(api=29)
        public void setNotificationUris(@NotNull ContentResolver cr, @NotNull List<? extends Uri> uris) {
            Intrinsics.checkNotNullParameter((Object)cr, (String)"cr");
            Intrinsics.checkNotNullParameter(uris, (String)"uris");
            SupportSQLiteCompat.Api29Impl.setNotificationUris((Cursor)this.delegate, (ContentResolver)cr, uris);
        }

        @RequiresApi(api=19)
        @NotNull
        public Uri getNotificationUri() {
            Uri uri = SupportSQLiteCompat.Api19Impl.getNotificationUri((Cursor)this.delegate);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getNotificationUri(delegate)");
            return uri;
        }

        @RequiresApi(api=29)
        @NotNull
        public List<Uri> getNotificationUris() {
            List list = SupportSQLiteCompat.Api29Impl.getNotificationUris((Cursor)this.delegate);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNotificationUris(delegate)");
            return list;
        }

        @RequiresApi(api=23)
        public void setExtras(@NotNull Bundle extras) {
            Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
            SupportSQLiteCompat.Api23Impl.setExtras((Cursor)this.delegate, (Bundle)extras);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\fH\u0016J\b\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0001H\u0002J\b\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010\u001c\u001a\u00020\u0014H\u0016J'\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\u001e0 H\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u000eH\u0016J\u001a\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010%\u001a\u00020\u0014H\u0016J\b\u0010&\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\n\u0012\u0006\u0012\u0004\u0018\u00010\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Landroidx/room/AutoClosingRoomOpenHelper$AutoClosingSupportSqliteStatement;", "Landroidx/sqlite/db/SupportSQLiteStatement;", "sql", "", "autoCloser", "Landroidx/room/AutoCloser;", "(Ljava/lang/String;Landroidx/room/AutoCloser;)V", "binds", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "bindBlob", "", "index", "", "value", "", "bindDouble", "", "bindLong", "", "bindNull", "bindString", "clearBindings", "close", "doBinds", "supportSQLiteStatement", "execute", "executeInsert", "executeSqliteStatementWithRefCount", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "executeUpdateDelete", "saveBinds", "bindIndex", "simpleQueryForLong", "simpleQueryForString", "room-runtime_release"})
    private static final class AutoClosingSupportSqliteStatement
    implements SupportSQLiteStatement {
        @NotNull
        private final String sql;
        @NotNull
        private final AutoCloser autoCloser;
        @NotNull
        private final ArrayList<Object> binds;

        public AutoClosingSupportSqliteStatement(@NotNull String sql, @NotNull AutoCloser autoCloser) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            Intrinsics.checkNotNullParameter((Object)autoCloser, (String)"autoCloser");
            this.sql = sql;
            this.autoCloser = autoCloser;
            this.binds = new ArrayList();
        }

        private final <T> T executeSqliteStatementWithRefCount(Function1<? super SupportSQLiteStatement, ? extends T> block) {
            return (T)this.autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, T>(this, block){
                final /* synthetic */ AutoClosingSupportSqliteStatement this$0;
                final /* synthetic */ Function1<SupportSQLiteStatement, T> $block;
                {
                    this.this$0 = $receiver;
                    this.$block = $block;
                    super(1);
                }

                public final T invoke(@NotNull SupportSQLiteDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    SupportSQLiteStatement supportSQLiteStatement = db.compileStatement(AutoClosingSupportSqliteStatement.access$getSql$p(this.this$0));
                    Intrinsics.checkNotNullExpressionValue((Object)supportSQLiteStatement, (String)"db.compileStatement(sql)");
                    SupportSQLiteStatement statement = supportSQLiteStatement;
                    AutoClosingSupportSqliteStatement.access$doBinds(this.this$0, statement);
                    return (T)this.$block.invoke((Object)statement);
                }
            });
        }

        private final void doBinds(SupportSQLiteStatement supportSQLiteStatement) {
            Iterable $this$forEachIndexed$iv = this.binds;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int i = n;
                boolean bl = false;
                int bindIndex = i + 1;
                Object bind = this.binds.get(i);
                if (bind == null) {
                    supportSQLiteStatement.bindNull(bindIndex);
                    continue;
                }
                if (bind instanceof Long) {
                    supportSQLiteStatement.bindLong(bindIndex, ((Number)bind).longValue());
                    continue;
                }
                if (bind instanceof Double) {
                    supportSQLiteStatement.bindDouble(bindIndex, ((Number)bind).doubleValue());
                    continue;
                }
                if (bind instanceof String) {
                    supportSQLiteStatement.bindString(bindIndex, (String)bind);
                    continue;
                }
                if (!(bind instanceof byte[])) continue;
                supportSQLiteStatement.bindBlob(bindIndex, (byte[])bind);
            }
        }

        private final void saveBinds(int bindIndex, Object value) {
            int i;
            int index = bindIndex - 1;
            if (index >= this.binds.size() && (i = this.binds.size()) <= index) {
                while (true) {
                    this.binds.add(null);
                    if (i == index) break;
                    ++i;
                }
            }
            this.binds.set(index, value);
        }

        public void close() throws IOException {
        }

        public void execute() {
            this.executeSqliteStatementWithRefCount(execute.1.INSTANCE);
        }

        public int executeUpdateDelete() {
            return ((Number)this.executeSqliteStatementWithRefCount(executeUpdateDelete.1.INSTANCE)).intValue();
        }

        public long executeInsert() {
            return ((Number)this.executeSqliteStatementWithRefCount(executeInsert.1.INSTANCE)).longValue();
        }

        public long simpleQueryForLong() {
            return ((Number)this.executeSqliteStatementWithRefCount(simpleQueryForLong.1.INSTANCE)).longValue();
        }

        @NotNull
        public String simpleQueryForString() {
            Object t = this.executeSqliteStatementWithRefCount(simpleQueryForString.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(t, (String)"executeSqliteStatementWi\u2026ForString()\n            }");
            return (String)t;
        }

        public void bindNull(int index) {
            this.saveBinds(index, null);
        }

        public void bindLong(int index, long value) {
            this.saveBinds(index, value);
        }

        public void bindDouble(int index, double value) {
            this.saveBinds(index, value);
        }

        public void bindString(int index, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.saveBinds(index, value);
        }

        public void bindBlob(int index, @NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.saveBinds(index, value);
        }

        public void clearBindings() {
            this.binds.clear();
        }

        public static final /* synthetic */ String access$getSql$p(AutoClosingSupportSqliteStatement $this) {
            return $this.sql;
        }

        public static final /* synthetic */ void access$doBinds(AutoClosingSupportSqliteStatement $this, SupportSQLiteStatement supportSQLiteStatement) {
            $this.doBinds(supportSQLiteStatement);
        }
    }
}

