/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Build;
import android.os.CancellationSignal;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.room.AutoCloser;
import androidx.room.AutoClosingRoomOpenHelper;
import androidx.room.AutoClosingRoomOpenHelperFactory;
import androidx.room.DatabaseConfiguration;
import androidx.room.DelegatingOpenHelper;
import androidx.room.ExperimentalRoomApi;
import androidx.room.InvalidationTracker;
import androidx.room.MultiInstanceInvalidationService;
import androidx.room.QueryInterceptorOpenHelperFactory;
import androidx.room.Room;
import androidx.room.SQLiteCopyOpenHelper;
import androidx.room.SQLiteCopyOpenHelperFactory;
import androidx.room.TransactionExecutor;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteCompat;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u0000 m2\u00020\u0001:\u0007klmnopqB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00105\u001a\u000206H\u0017J\b\u00107\u001a\u000206H\u0017J\b\u00108\u001a\u000206H\u0017J\b\u00109\u001a\u000206H'J\b\u0010:\u001a\u000206H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0010H\u0016J\b\u0010>\u001a\u00020\u0013H$J\u0010\u0010?\u001a\u00020#2\u0006\u0010@\u001a\u00020AH$J\b\u0010B\u001a\u000206H\u0017J*\u0010C\u001a\b\u0012\u0004\u0012\u00020D0\u001c2\u001a\u0010\u0007\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\n0EH\u0017J\b\u0010F\u001a\u00020GH\u0017J\b\u0010H\u001a\u00020#H\u0016J\b\u0010I\u001a\u00020*H\u0016J\u0016\u0010J\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0KH\u0017J\"\u0010L\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u001c0EH\u0015J\b\u0010M\u001a\u00020*H\u0016J#\u0010N\u001a\u0004\u0018\u0001HO\"\u0004\b\u0000\u0010O2\f\u0010P\u001a\b\u0012\u0004\u0012\u0002HO0\tH\u0016\u00a2\u0006\u0002\u0010QJ\b\u0010R\u001a\u00020\u0004H\u0016J\u0010\u0010S\u001a\u0002062\u0006\u0010T\u001a\u00020AH\u0017J\b\u0010U\u001a\u000206H\u0002J\b\u0010V\u001a\u000206H\u0002J\u0010\u0010W\u001a\u0002062\u0006\u0010X\u001a\u00020 H\u0014J\u001c\u0010Y\u001a\u00020Z2\u0006\u0010Y\u001a\u00020[2\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010]H\u0017J'\u0010Y\u001a\u00020Z2\u0006\u0010Y\u001a\u00020\u00102\u0010\u0010^\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010_H\u0016\u00a2\u0006\u0002\u0010`J\u0010\u0010a\u001a\u0002062\u0006\u0010b\u001a\u00020cH\u0016J!\u0010a\u001a\u0002Hd\"\u0004\b\u0000\u0010d2\f\u0010b\u001a\b\u0012\u0004\u0012\u0002Hd0eH\u0016\u00a2\u0006\u0002\u0010fJ\b\u0010g\u001a\u000206H\u0017J+\u0010h\u001a\u0004\u0018\u0001HO\"\u0004\b\u0000\u0010O2\f\u0010i\u001a\b\u0012\u0004\u0012\u0002HO0\t2\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010jR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\n0\b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001f\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00010\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u0019\u0010\u0018R \u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c8\u0004@\u0004X\u0085\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001e\u0010\u0002R\u001a\u0010\u001f\u001a\u0004\u0018\u00010 8\u0004@\u0004X\u0085\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b!\u0010\u0002R$\u0010\"\u001a\u00020#8\u0000@\u0000X\u0081.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b$\u0010\u0002\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.8G\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u00020*X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u00103\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Landroidx/room/RoomDatabase;", "", "()V", "allowMainThreadQueries", "", "autoCloser", "Landroidx/room/AutoCloser;", "autoMigrationSpecs", "", "Ljava/lang/Class;", "Landroidx/room/migration/AutoMigrationSpec;", "getAutoMigrationSpecs", "()Ljava/util/Map;", "setAutoMigrationSpecs", "(Ljava/util/Map;)V", "backingFieldMap", "", "getBackingFieldMap", "invalidationTracker", "Landroidx/room/InvalidationTracker;", "getInvalidationTracker", "()Landroidx/room/InvalidationTracker;", "isMainThread", "isMainThread$room_runtime_release", "()Z", "isOpen", "isOpen$annotations", "mCallbacks", "", "Landroidx/room/RoomDatabase$Callback;", "getMCallbacks$annotations", "mDatabase", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "getMDatabase$annotations", "openHelper", "Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "getOpenHelper$room_runtime_release$annotations", "getOpenHelper$room_runtime_release", "()Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "setOpenHelper$room_runtime_release", "(Landroidx/sqlite/db/SupportSQLiteOpenHelper;)V", "queryExecutor", "Ljava/util/concurrent/Executor;", "readWriteLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "suspendingTransactionId", "Ljava/lang/ThreadLocal;", "", "getSuspendingTransactionId", "()Ljava/lang/ThreadLocal;", "transactionExecutor", "typeConverters", "writeAheadLoggingEnabled", "assertNotMainThread", "", "assertNotSuspendingTransaction", "beginTransaction", "clearAllTables", "close", "compileStatement", "Landroidx/sqlite/db/SupportSQLiteStatement;", "sql", "createInvalidationTracker", "createOpenHelper", "config", "Landroidx/room/DatabaseConfiguration;", "endTransaction", "getAutoMigrations", "Landroidx/room/migration/Migration;", "", "getCloseLock", "Ljava/util/concurrent/locks/Lock;", "getOpenHelper", "getQueryExecutor", "getRequiredAutoMigrationSpecs", "", "getRequiredTypeConverters", "getTransactionExecutor", "getTypeConverter", "T", "klass", "(Ljava/lang/Class;)Ljava/lang/Object;", "inTransaction", "init", "configuration", "internalBeginTransaction", "internalEndTransaction", "internalInitInvalidationTracker", "db", "query", "Landroid/database/Cursor;", "Landroidx/sqlite/db/SupportSQLiteQuery;", "signal", "Landroid/os/CancellationSignal;", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Landroid/database/Cursor;", "runInTransaction", "body", "Ljava/lang/Runnable;", "V", "Ljava/util/concurrent/Callable;", "(Ljava/util/concurrent/Callable;)Ljava/lang/Object;", "setTransactionSuccessful", "unwrapOpenHelper", "clazz", "(Ljava/lang/Class;Landroidx/sqlite/db/SupportSQLiteOpenHelper;)Ljava/lang/Object;", "Builder", "Callback", "Companion", "JournalMode", "MigrationContainer", "PrepackagedDatabaseCallback", "QueryCallback", "room-runtime_release"})
public abstract class RoomDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @Nullable
    protected volatile SupportSQLiteDatabase mDatabase;
    private Executor queryExecutor;
    private Executor transactionExecutor;
    public SupportSQLiteOpenHelper openHelper;
    @NotNull
    private final InvalidationTracker invalidationTracker = this.createInvalidationTracker();
    private boolean allowMainThreadQueries;
    private boolean writeAheadLoggingEnabled;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @JvmField
    @Nullable
    protected List<? extends Callback> mCallbacks;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs = new LinkedHashMap();
    @NotNull
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    @Nullable
    private AutoCloser autoCloser;
    @NotNull
    private final ThreadLocal<Integer> suspendingTransactionId = new ThreadLocal();
    @NotNull
    private final Map<String, Object> backingFieldMap;
    @NotNull
    private final Map<Class<?>, Object> typeConverters;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final int MAX_BIND_PARAMETER_CNT = 999;

    public RoomDatabase() {
        Map map = Collections.synchronizedMap(new LinkedHashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(mutableMapOf())");
        this.backingFieldMap = map;
        this.typeConverters = new LinkedHashMap();
    }

    @Deprecated(message="Will be hidden in the next release.")
    protected static /* synthetic */ void getMDatabase$annotations() {
    }

    @NotNull
    public final SupportSQLiteOpenHelper getOpenHelper$room_runtime_release() {
        SupportSQLiteOpenHelper supportSQLiteOpenHelper = this.openHelper;
        if (supportSQLiteOpenHelper != null) {
            return supportSQLiteOpenHelper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"openHelper");
        return null;
    }

    public final void setOpenHelper$room_runtime_release(@NotNull SupportSQLiteOpenHelper supportSQLiteOpenHelper) {
        Intrinsics.checkNotNullParameter((Object)supportSQLiteOpenHelper, (String)"<set-?>");
        this.openHelper = supportSQLiteOpenHelper;
    }

    @VisibleForTesting
    public static /* synthetic */ void getOpenHelper$room_runtime_release$annotations() {
    }

    @NotNull
    public InvalidationTracker getInvalidationTracker() {
        return this.invalidationTracker;
    }

    @Deprecated(message="Will be hidden in a future release.")
    protected static /* synthetic */ void getMCallbacks$annotations() {
    }

    @NotNull
    protected final Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> getAutoMigrationSpecs() {
        return this.autoMigrationSpecs;
    }

    protected final void setAutoMigrationSpecs(@NotNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.autoMigrationSpecs = map;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public Lock getCloseLock() {
        ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readWriteLock.readLock()");
        return readLock;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final ThreadLocal<Integer> getSuspendingTransactionId() {
        return this.suspendingTransactionId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final Map<String, Object> getBackingFieldMap() {
        return this.backingFieldMap;
    }

    @Nullable
    public <T> T getTypeConverter(@NotNull Class<T> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        return (T)this.typeConverters.get(klass);
    }

    @CallSuper
    public void init(@NotNull DatabaseConfiguration configuration2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this.setOpenHelper$room_runtime_release(this.createOpenHelper(configuration2));
        Set<Class<? extends AutoMigrationSpec>> requiredAutoMigrationSpecs = this.getRequiredAutoMigrationSpecs();
        BitSet usedSpecs = new BitSet();
        for (Class<? extends AutoMigrationSpec> spec : requiredAutoMigrationSpecs) {
            int foundIndex = -1;
            int n = configuration2.autoMigrationSpecs.size() + -1;
            if (0 <= n) {
                do {
                    int providedIndex;
                    AutoMigrationSpec provided;
                    if (!spec.isAssignableFrom((provided = configuration2.autoMigrationSpecs.get(providedIndex = n--)).getClass())) continue;
                    foundIndex = providedIndex;
                    usedSpecs.set(foundIndex);
                    break;
                } while (0 <= n);
            }
            if (!(foundIndex >= 0)) {
                boolean $i$a$-require-RoomDatabase$init$32 = false;
                String $i$a$-require-RoomDatabase$init$32 = "A required auto migration spec (" + spec.getCanonicalName() + ") is missing in the database configuration.";
                throw new IllegalArgumentException($i$a$-require-RoomDatabase$init$32.toString());
            }
            this.autoMigrationSpecs.put(spec, configuration2.autoMigrationSpecs.get(foundIndex));
        }
        int n = configuration2.autoMigrationSpecs.size() + -1;
        if (0 <= n) {
            do {
                int providedIndex;
                if (usedSpecs.get(providedIndex = n--)) continue;
                boolean $i$a$-require-RoomDatabase$init$42 = false;
                String $i$a$-require-RoomDatabase$init$42 = "Unexpected auto migration specs found. Annotate AutoMigrationSpec implementation with @ProvidedAutoMigrationSpec annotation or remove this spec from the builder.";
                throw new IllegalArgumentException($i$a$-require-RoomDatabase$init$42.toString());
            } while (0 <= n);
        }
        List<Migration> autoMigrations = this.getAutoMigrations(this.autoMigrationSpecs);
        for (Migration autoMigration : autoMigrations) {
            boolean migrationExists = configuration2.migrationContainer.getMigrations().containsKey(autoMigration.startVersion);
            if (migrationExists) continue;
            Migration[] $i$a$-require-RoomDatabase$init$32 = new Migration[]{autoMigration};
            configuration2.migrationContainer.addMigrations($i$a$-require-RoomDatabase$init$32);
        }
        Object providedIndex = this.unwrapOpenHelper(SQLiteCopyOpenHelper.class, this.getOpenHelper$room_runtime_release());
        if (providedIndex != null) {
            ((SQLiteCopyOpenHelper)providedIndex).setDatabaseConfiguration(configuration2);
        }
        if ((providedIndex = this.unwrapOpenHelper(AutoClosingRoomOpenHelper.class, this.getOpenHelper$room_runtime_release())) != null) {
            Object it = providedIndex;
            boolean bl2 = false;
            this.autoCloser = ((AutoClosingRoomOpenHelper)it).autoCloser;
            this.getInvalidationTracker().setAutoCloser$room_runtime_release(((AutoClosingRoomOpenHelper)it).autoCloser);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            boolean enabled = configuration2.journalMode == JournalMode.WRITE_AHEAD_LOGGING;
            this.getOpenHelper$room_runtime_release().setWriteAheadLoggingEnabled(enabled);
            bl = enabled;
        } else {
            bl = false;
        }
        boolean wal = bl;
        this.mCallbacks = configuration2.callbacks;
        this.queryExecutor = configuration2.queryExecutor;
        this.transactionExecutor = new TransactionExecutor(configuration2.transactionExecutor);
        this.allowMainThreadQueries = configuration2.allowMainThreadQueries;
        this.writeAheadLoggingEnabled = wal;
        if (configuration2.multiInstanceInvalidationServiceIntent != null) {
            if (configuration2.name == null) {
                String it = "Required value was null.";
                throw new IllegalArgumentException(it.toString());
            }
            this.getInvalidationTracker().startMultiInstanceInvalidation$room_runtime_release(configuration2.context, configuration2.name, configuration2.multiInstanceInvalidationServiceIntent);
        }
        Map<Class<?>, List<Class<?>>> requiredFactories = this.getRequiredTypeConverters();
        BitSet used = new BitSet();
        Map<Class<?>, List<Class<?>>> $this$forEach$iv = requiredFactories;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Class<?>, List<Class<?>>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Class<?>, List<Class<?>>> element$iv;
            Map.Entry<Class<?>, List<Class<?>>> entry = element$iv = iterator.next();
            boolean bl3 = false;
            Class<?> daoName = entry.getKey();
            List<Class<?>> converters = entry.getValue();
            for (Class<?> converter : converters) {
                int foundIndex = -1;
                int n2 = configuration2.typeConverters.size() + -1;
                if (0 <= n2) {
                    do {
                        int providedIndex2;
                        Object provided;
                        if (!converter.isAssignableFrom((provided = configuration2.typeConverters.get(providedIndex2 = n2--)).getClass())) continue;
                        foundIndex = providedIndex2;
                        used.set(foundIndex);
                        break;
                    } while (0 <= n2);
                }
                if (!(foundIndex >= 0)) {
                    boolean bl4 = false;
                    String string = "A required type converter (" + converter + ") for " + daoName.getCanonicalName() + " is missing in the database configuration.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.typeConverters.put(converter, configuration2.typeConverters.get(foundIndex));
            }
        }
        int n3 = configuration2.typeConverters.size() + -1;
        if (0 <= n3) {
            do {
                int providedIndex3;
                if (used.get(providedIndex3 = n3--)) continue;
                Object converter = configuration2.typeConverters.get(providedIndex3);
                throw new IllegalArgumentException("Unexpected type converter " + converter + ". Annotate TypeConverter class with @ProvidedTypeConverter annotation or remove this converter from the builder.");
            } while (0 <= n3);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @JvmSuppressWildcards
    @NotNull
    public List<Migration> getAutoMigrations(@NotNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
        Intrinsics.checkNotNullParameter(autoMigrationSpecs, (String)"autoMigrationSpecs");
        return CollectionsKt.emptyList();
    }

    private final <T> T unwrapOpenHelper(Class<T> clazz, SupportSQLiteOpenHelper openHelper) {
        if (clazz.isInstance(openHelper)) {
            return (T)openHelper;
        }
        return openHelper instanceof DelegatingOpenHelper ? (T)this.unwrapOpenHelper(clazz, ((DelegatingOpenHelper)openHelper).getDelegate()) : null;
    }

    @NotNull
    protected abstract SupportSQLiteOpenHelper createOpenHelper(@NotNull DatabaseConfiguration var1);

    @NotNull
    protected abstract InvalidationTracker createInvalidationTracker();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        return MapsKt.emptyMap();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        return SetsKt.emptySet();
    }

    @WorkerThread
    public abstract void clearAllTables();

    public boolean isOpen() {
        Boolean bl;
        AutoCloser autoCloser = this.autoCloser;
        if (autoCloser != null) {
            bl = autoCloser.isActive();
        } else {
            SupportSQLiteDatabase supportSQLiteDatabase = this.mDatabase;
            bl = supportSQLiteDatabase != null ? Boolean.valueOf(supportSQLiteDatabase.isOpen()) : null;
        }
        return Intrinsics.areEqual((Object)bl, (Object)true);
    }

    public static /* synthetic */ void isOpen$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isOpen()) {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"readWriteLock.writeLock()");
            Lock closeLock = writeLock;
            closeLock.lock();
            try {
                this.getInvalidationTracker().stopMultiInstanceInvalidation$room_runtime_release();
                this.getOpenHelper$room_runtime_release().close();
            }
            finally {
                closeLock.unlock();
            }
        }
    }

    public final boolean isMainThread$room_runtime_release() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public void assertNotMainThread() {
        if (this.allowMainThreadQueries) {
            return;
        }
        if (!(!this.isMainThread$room_runtime_release())) {
            boolean bl = false;
            String string = "Cannot access database on the main thread since it may potentially lock the UI for a long period of time.";
            throw new IllegalStateException(string.toString());
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void assertNotSuspendingTransaction() {
        if (!(this.inTransaction() || this.suspendingTransactionId.get() == null)) {
            boolean bl = false;
            String string = "Cannot access database on a different coroutine context inherited from a suspending transaction.";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public Cursor query(@NotNull String query, @Nullable Object[] args) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Cursor cursor = this.getOpenHelper$room_runtime_release().getWritableDatabase().query((SupportSQLiteQuery)new SimpleSQLiteQuery(query, args));
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"openHelper.writableDatab\u2026SQLiteQuery(query, args))");
        return cursor;
    }

    @JvmOverloads
    @NotNull
    public Cursor query(@NotNull SupportSQLiteQuery query, @Nullable CancellationSignal signal) {
        Cursor cursor;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.assertNotMainThread();
        this.assertNotSuspendingTransaction();
        if (signal != null && Build.VERSION.SDK_INT >= 16) {
            Cursor cursor2 = this.getOpenHelper$room_runtime_release().getWritableDatabase().query(query, signal);
            cursor = cursor2;
            Intrinsics.checkNotNullExpressionValue((Object)cursor2, (String)"{\n            openHelper\u2026(query, signal)\n        }");
        } else {
            Cursor cursor3 = this.getOpenHelper$room_runtime_release().getWritableDatabase().query(query);
            cursor = cursor3;
            Intrinsics.checkNotNullExpressionValue((Object)cursor3, (String)"{\n            openHelper\u2026se.query(query)\n        }");
        }
        return cursor;
    }

    public static /* synthetic */ Cursor query$default(RoomDatabase roomDatabase, SupportSQLiteQuery supportSQLiteQuery, CancellationSignal cancellationSignal, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: query");
        }
        if ((n & 2) != 0) {
            cancellationSignal = null;
        }
        return roomDatabase.query(supportSQLiteQuery, cancellationSignal);
    }

    @NotNull
    public SupportSQLiteStatement compileStatement(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        this.assertNotMainThread();
        this.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = this.getOpenHelper$room_runtime_release().getWritableDatabase().compileStatement(sql);
        Intrinsics.checkNotNullExpressionValue((Object)supportSQLiteStatement, (String)"openHelper.writableDatabase.compileStatement(sql)");
        return supportSQLiteStatement;
    }

    @Deprecated(message="beginTransaction() is deprecated", replaceWith=@ReplaceWith(expression="runInTransaction(Runnable)", imports={}))
    public void beginTransaction() {
        this.assertNotMainThread();
        AutoCloser autoCloser = this.autoCloser;
        if (autoCloser == null) {
            this.internalBeginTransaction();
        } else {
            autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, Object>(this){
                final /* synthetic */ RoomDatabase this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final Object invoke(@NotNull SupportSQLiteDatabase it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    RoomDatabase.access$internalBeginTransaction(this.this$0);
                    return null;
                }
            });
        }
    }

    private final void internalBeginTransaction() {
        this.assertNotMainThread();
        SupportSQLiteDatabase database = this.getOpenHelper$room_runtime_release().getWritableDatabase();
        InvalidationTracker invalidationTracker = this.getInvalidationTracker();
        Intrinsics.checkNotNullExpressionValue((Object)database, (String)"database");
        invalidationTracker.syncTriggers$room_runtime_release(database);
        if (Build.VERSION.SDK_INT >= 16 && database.isWriteAheadLoggingEnabled()) {
            database.beginTransactionNonExclusive();
        } else {
            database.beginTransaction();
        }
    }

    @Deprecated(message="endTransaction() is deprecated", replaceWith=@ReplaceWith(expression="runInTransaction(Runnable)", imports={}))
    public void endTransaction() {
        AutoCloser autoCloser = this.autoCloser;
        if (autoCloser == null) {
            this.internalEndTransaction();
        } else {
            autoCloser.executeRefCountingFunction((Function1)new Function1<SupportSQLiteDatabase, Object>(this){
                final /* synthetic */ RoomDatabase this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final Object invoke(@NotNull SupportSQLiteDatabase it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    RoomDatabase.access$internalEndTransaction(this.this$0);
                    return null;
                }
            });
        }
    }

    private final void internalEndTransaction() {
        this.getOpenHelper$room_runtime_release().getWritableDatabase().endTransaction();
        if (!this.inTransaction()) {
            this.getInvalidationTracker().refreshVersionsAsync();
        }
    }

    @NotNull
    public SupportSQLiteOpenHelper getOpenHelper() {
        return this.getOpenHelper$room_runtime_release();
    }

    @NotNull
    public Executor getQueryExecutor() {
        Executor executor = this.queryExecutor;
        if (executor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"queryExecutor");
            executor = null;
        }
        return executor;
    }

    @NotNull
    public Executor getTransactionExecutor() {
        Executor executor = this.transactionExecutor;
        if (executor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transactionExecutor");
            executor = null;
        }
        return executor;
    }

    @Deprecated(message="setTransactionSuccessful() is deprecated", replaceWith=@ReplaceWith(expression="runInTransaction(Runnable)", imports={}))
    public void setTransactionSuccessful() {
        this.getOpenHelper$room_runtime_release().getWritableDatabase().setTransactionSuccessful();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInTransaction(@NotNull Runnable body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.beginTransaction();
        try {
            body.run();
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public <V> V runInTransaction(@NotNull Callable<V> body) {
        void var2_2;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.beginTransaction();
        try {
            V result = body.call();
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
        return var2_2;
    }

    protected void internalInitInvalidationTracker(@NotNull SupportSQLiteDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.getInvalidationTracker().internalInit(db);
    }

    public boolean inTransaction() {
        return this.getOpenHelper$room_runtime_release().getWritableDatabase().inTransaction();
    }

    @JvmOverloads
    @NotNull
    public final Cursor query(@NotNull SupportSQLiteQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return RoomDatabase.query$default(this, query, null, 2, null);
    }

    public static final /* synthetic */ void access$internalBeginTransaction(RoomDatabase $this) {
        $this.internalBeginTransaction();
    }

    public static final /* synthetic */ void access$internalEndTransaction(RoomDatabase $this) {
        $this.internalEndTransaction();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0017j\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Landroidx/room/RoomDatabase$JournalMode;", "", "(Ljava/lang/String;I)V", "isLowRamDevice", "", "activityManager", "Landroid/app/ActivityManager;", "resolve", "context", "Landroid/content/Context;", "AUTOMATIC", "TRUNCATE", "WRITE_AHEAD_LOGGING", "room-runtime_release"})
    public static final class JournalMode
    extends Enum<JournalMode> {
        public static final /* enum */ JournalMode AUTOMATIC = new JournalMode();
        public static final /* enum */ JournalMode TRUNCATE = new JournalMode();
        public static final /* enum */ JournalMode WRITE_AHEAD_LOGGING = new JournalMode();
        private static final /* synthetic */ JournalMode[] $VALUES;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public JournalMode resolve(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (this != AUTOMATIC) {
                return this;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                Object object = context.getSystemService("activity");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
                }
                ActivityManager manager = (ActivityManager)object;
                if (!this.isLowRamDevice(manager)) {
                    return WRITE_AHEAD_LOGGING;
                }
            }
            return TRUNCATE;
        }

        private final boolean isLowRamDevice(ActivityManager activityManager) {
            return Build.VERSION.SDK_INT >= 19 ? SupportSQLiteCompat.Api19Impl.isLowRamDevice((ActivityManager)activityManager) : false;
        }

        public static JournalMode[] values() {
            return (JournalMode[])$VALUES.clone();
        }

        public static JournalMode valueOf(String value) {
            return Enum.valueOf(JournalMode.class, value);
        }

        static {
            $VALUES = journalModeArray = new JournalMode[]{JournalMode.AUTOMATIC, JournalMode.TRUNCATE, JournalMode.WRITE_AHEAD_LOGGING};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0015\n\u0002\b\u000b\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B'\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0016\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00104\u001a\u00020\u0014H\u0016J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00106\u001a\u00020\u0016H\u0016J'\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020:09\"\u00020:H\u0016\u00a2\u0006\u0002\u0010;J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010=\u001a\u00020\u0003H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\r\u0010>\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010?J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010A\u001a\u00020\tH\u0016J\u001e\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010A\u001a\u00020\t2\u0006\u00106\u001a\u00020*H\u0017J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010C\u001a\u00020\u0019H\u0016J\u001e\u0010B\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010C\u001a\u00020\u00192\u0006\u00106\u001a\u00020*H\u0017J\u001c\u0010D\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0017J$\u0010D\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u00106\u001a\u00020*H\u0017J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u000e\u0010G\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u001a\u0010H\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\n\u0010I\u001a\u00020J\"\u00020%H\u0016J\u000e\u0010K\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u0018\u0010L\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J \u0010M\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010P\u001a\u00020(H\u0017J\u001e\u0010Q\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010+\u001a\u00020,2\u0006\u0010R\u001a\u00020.H\u0016J\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010R\u001a\u00020.H\u0016J\u0016\u0010T\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010R\u001a\u00020.H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Landroidx/room/RoomDatabase$Builder;", "T", "Landroidx/room/RoomDatabase;", "", "context", "Landroid/content/Context;", "klass", "Ljava/lang/Class;", "name", "", "(Landroid/content/Context;Ljava/lang/Class;Ljava/lang/String;)V", "allowDestructiveMigrationOnDowngrade", "", "allowMainThreadQueries", "autoCloseTimeUnit", "Ljava/util/concurrent/TimeUnit;", "autoCloseTimeout", "", "autoMigrationSpecs", "", "Landroidx/room/migration/AutoMigrationSpec;", "callbacks", "Landroidx/room/RoomDatabase$Callback;", "copyFromAssetPath", "copyFromFile", "Ljava/io/File;", "copyFromInputStream", "Ljava/util/concurrent/Callable;", "Ljava/io/InputStream;", "factory", "Landroidx/sqlite/db/SupportSQLiteOpenHelper$Factory;", "journalMode", "Landroidx/room/RoomDatabase$JournalMode;", "migrationContainer", "Landroidx/room/RoomDatabase$MigrationContainer;", "migrationStartAndEndVersions", "", "", "migrationsNotRequiredFrom", "multiInstanceInvalidationIntent", "Landroid/content/Intent;", "prepackagedDatabaseCallback", "Landroidx/room/RoomDatabase$PrepackagedDatabaseCallback;", "queryCallback", "Landroidx/room/RoomDatabase$QueryCallback;", "queryCallbackExecutor", "Ljava/util/concurrent/Executor;", "queryExecutor", "requireMigration", "transactionExecutor", "typeConverters", "addAutoMigrationSpec", "autoMigrationSpec", "addCallback", "callback", "addMigrations", "migrations", "", "Landroidx/room/migration/Migration;", "([Landroidx/room/migration/Migration;)Landroidx/room/RoomDatabase$Builder;", "addTypeConverter", "typeConverter", "build", "()Landroidx/room/RoomDatabase;", "createFromAsset", "databaseFilePath", "createFromFile", "databaseFile", "createFromInputStream", "inputStreamCallable", "enableMultiInstanceInvalidation", "fallbackToDestructiveMigration", "fallbackToDestructiveMigrationFrom", "startVersions", "", "fallbackToDestructiveMigrationOnDowngrade", "openHelperFactory", "setAutoCloseTimeout", "setJournalMode", "setMultiInstanceInvalidationServiceIntent", "invalidationServiceIntent", "setQueryCallback", "executor", "setQueryExecutor", "setTransactionExecutor", "room-runtime_release"})
    public static class Builder<T extends RoomDatabase> {
        @NotNull
        private final Context context;
        @NotNull
        private final Class<T> klass;
        @Nullable
        private final String name;
        @NotNull
        private final List<Callback> callbacks;
        @Nullable
        private PrepackagedDatabaseCallback prepackagedDatabaseCallback;
        @Nullable
        private QueryCallback queryCallback;
        @Nullable
        private Executor queryCallbackExecutor;
        @NotNull
        private final List<Object> typeConverters;
        @NotNull
        private List<AutoMigrationSpec> autoMigrationSpecs;
        @Nullable
        private Executor queryExecutor;
        @Nullable
        private Executor transactionExecutor;
        @Nullable
        private SupportSQLiteOpenHelper.Factory factory;
        private boolean allowMainThreadQueries;
        @NotNull
        private JournalMode journalMode;
        @Nullable
        private Intent multiInstanceInvalidationIntent;
        private boolean requireMigration;
        private boolean allowDestructiveMigrationOnDowngrade;
        private long autoCloseTimeout;
        @Nullable
        private TimeUnit autoCloseTimeUnit;
        @NotNull
        private final MigrationContainer migrationContainer;
        @NotNull
        private Set<Integer> migrationsNotRequiredFrom;
        @Nullable
        private Set<Integer> migrationStartAndEndVersions;
        @Nullable
        private String copyFromAssetPath;
        @Nullable
        private File copyFromFile;
        @Nullable
        private Callable<InputStream> copyFromInputStream;

        public Builder(@NotNull Context context, @NotNull Class<T> klass, @Nullable String name) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            this.context = context;
            this.klass = klass;
            this.name = name;
            this.callbacks = new ArrayList();
            this.typeConverters = new ArrayList();
            this.autoMigrationSpecs = new ArrayList();
            this.journalMode = JournalMode.AUTOMATIC;
            this.requireMigration = true;
            this.autoCloseTimeout = -1L;
            this.migrationContainer = new MigrationContainer();
            this.migrationsNotRequiredFrom = new LinkedHashSet();
        }

        @NotNull
        public Builder<T> createFromAsset(@NotNull String databaseFilePath) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)databaseFilePath, (String)"databaseFilePath");
            Builder $this$createFromAsset_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$createFromAsset_u24lambda_u2d0.copyFromAssetPath = databaseFilePath;
            return builder;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NotNull
        public Builder<T> createFromAsset(@NotNull String databaseFilePath, @NotNull PrepackagedDatabaseCallback callback2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)databaseFilePath, (String)"databaseFilePath");
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            Builder $this$createFromAsset_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$createFromAsset_u24lambda_u2d1.prepackagedDatabaseCallback = callback2;
            $this$createFromAsset_u24lambda_u2d1.copyFromAssetPath = databaseFilePath;
            return builder;
        }

        @NotNull
        public Builder<T> createFromFile(@NotNull File databaseFile) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)databaseFile, (String)"databaseFile");
            Builder $this$createFromFile_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$createFromFile_u24lambda_u2d2.copyFromFile = databaseFile;
            return builder;
        }

        @SuppressLint(value={"BuilderSetStyle", "StreamFiles"})
        @NotNull
        public Builder<T> createFromFile(@NotNull File databaseFile, @NotNull PrepackagedDatabaseCallback callback2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)databaseFile, (String)"databaseFile");
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            Builder $this$createFromFile_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$createFromFile_u24lambda_u2d3.prepackagedDatabaseCallback = callback2;
            $this$createFromFile_u24lambda_u2d3.copyFromFile = databaseFile;
            return builder;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NotNull
        public Builder<T> createFromInputStream(@NotNull Callable<InputStream> inputStreamCallable) {
            Builder builder;
            Intrinsics.checkNotNullParameter(inputStreamCallable, (String)"inputStreamCallable");
            Builder $this$createFromInputStream_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$createFromInputStream_u24lambda_u2d4.copyFromInputStream = inputStreamCallable;
            return builder;
        }

        @SuppressLint(value={"BuilderSetStyle", "LambdaLast"})
        @NotNull
        public Builder<T> createFromInputStream(@NotNull Callable<InputStream> inputStreamCallable, @NotNull PrepackagedDatabaseCallback callback2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(inputStreamCallable, (String)"inputStreamCallable");
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            Builder $this$createFromInputStream_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            $this$createFromInputStream_u24lambda_u2d5.prepackagedDatabaseCallback = callback2;
            $this$createFromInputStream_u24lambda_u2d5.copyFromInputStream = inputStreamCallable;
            return builder;
        }

        @NotNull
        public Builder<T> openHelperFactory(@Nullable SupportSQLiteOpenHelper.Factory factory) {
            Builder builder;
            Builder $this$openHelperFactory_u24lambda_u2d6 = builder = this;
            boolean bl = false;
            $this$openHelperFactory_u24lambda_u2d6.factory = factory;
            return builder;
        }

        @NotNull
        public Builder<T> addMigrations(Migration ... migrations) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)migrations, (String)"migrations");
            Builder $this$addMigrations_u24lambda_u2d7 = builder = this;
            boolean bl = false;
            if ($this$addMigrations_u24lambda_u2d7.migrationStartAndEndVersions == null) {
                $this$addMigrations_u24lambda_u2d7.migrationStartAndEndVersions = new HashSet();
            }
            int n = migrations.length;
            for (int i = 0; i < n; ++i) {
                Migration migration = migrations[i];
                Set<Integer> set = $this$addMigrations_u24lambda_u2d7.migrationStartAndEndVersions;
                Intrinsics.checkNotNull(set);
                set.add(migration.startVersion);
                Set<Integer> set2 = $this$addMigrations_u24lambda_u2d7.migrationStartAndEndVersions;
                Intrinsics.checkNotNull(set2);
                set2.add(migration.endVersion);
            }
            $this$addMigrations_u24lambda_u2d7.migrationContainer.addMigrations(Arrays.copyOf(migrations, migrations.length));
            return builder;
        }

        @NotNull
        public Builder<T> addAutoMigrationSpec(@NotNull AutoMigrationSpec autoMigrationSpec) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)autoMigrationSpec, (String)"autoMigrationSpec");
            Builder $this$addAutoMigrationSpec_u24lambda_u2d8 = builder = this;
            boolean bl = false;
            $this$addAutoMigrationSpec_u24lambda_u2d8.autoMigrationSpecs.add(autoMigrationSpec);
            return builder;
        }

        @NotNull
        public Builder<T> allowMainThreadQueries() {
            Builder builder;
            Builder $this$allowMainThreadQueries_u24lambda_u2d9 = builder = this;
            boolean bl = false;
            $this$allowMainThreadQueries_u24lambda_u2d9.allowMainThreadQueries = true;
            return builder;
        }

        @NotNull
        public Builder<T> setJournalMode(@NotNull JournalMode journalMode) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)journalMode), (String)"journalMode");
            Builder $this$setJournalMode_u24lambda_u2d10 = builder = this;
            boolean bl = false;
            $this$setJournalMode_u24lambda_u2d10.journalMode = journalMode;
            return builder;
        }

        @NotNull
        public Builder<T> setQueryExecutor(@NotNull Executor executor) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Builder $this$setQueryExecutor_u24lambda_u2d11 = builder = this;
            boolean bl = false;
            $this$setQueryExecutor_u24lambda_u2d11.queryExecutor = executor;
            return builder;
        }

        @NotNull
        public Builder<T> setTransactionExecutor(@NotNull Executor executor) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Builder $this$setTransactionExecutor_u24lambda_u2d12 = builder = this;
            boolean bl = false;
            $this$setTransactionExecutor_u24lambda_u2d12.transactionExecutor = executor;
            return builder;
        }

        @NotNull
        public Builder<T> enableMultiInstanceInvalidation() {
            Builder builder;
            Builder $this$enableMultiInstanceInvalidation_u24lambda_u2d13 = builder = this;
            boolean bl = false;
            $this$enableMultiInstanceInvalidation_u24lambda_u2d13.multiInstanceInvalidationIntent = $this$enableMultiInstanceInvalidation_u24lambda_u2d13.name != null ? new Intent($this$enableMultiInstanceInvalidation_u24lambda_u2d13.context, MultiInstanceInvalidationService.class) : (Intent)null;
            return builder;
        }

        @ExperimentalRoomApi
        @NotNull
        public Builder<T> setMultiInstanceInvalidationServiceIntent(@NotNull Intent invalidationServiceIntent) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)invalidationServiceIntent, (String)"invalidationServiceIntent");
            Builder $this$setMultiInstanceInvalidationServiceIntent_u24lambda_u2d14 = builder = this;
            boolean bl = false;
            $this$setMultiInstanceInvalidationServiceIntent_u24lambda_u2d14.multiInstanceInvalidationIntent = $this$setMultiInstanceInvalidationServiceIntent_u24lambda_u2d14.name != null ? invalidationServiceIntent : null;
            return builder;
        }

        @NotNull
        public Builder<T> fallbackToDestructiveMigration() {
            Builder builder;
            Builder $this$fallbackToDestructiveMigration_u24lambda_u2d15 = builder = this;
            boolean bl = false;
            $this$fallbackToDestructiveMigration_u24lambda_u2d15.requireMigration = false;
            $this$fallbackToDestructiveMigration_u24lambda_u2d15.allowDestructiveMigrationOnDowngrade = true;
            return builder;
        }

        @NotNull
        public Builder<T> fallbackToDestructiveMigrationOnDowngrade() {
            Builder builder;
            Builder $this$fallbackToDestructiveMigrationOnDowngrade_u24lambda_u2d16 = builder = this;
            boolean bl = false;
            $this$fallbackToDestructiveMigrationOnDowngrade_u24lambda_u2d16.requireMigration = true;
            $this$fallbackToDestructiveMigrationOnDowngrade_u24lambda_u2d16.allowDestructiveMigrationOnDowngrade = true;
            return builder;
        }

        @NotNull
        public Builder<T> fallbackToDestructiveMigrationFrom(int ... startVersions) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)startVersions, (String)"startVersions");
            Builder $this$fallbackToDestructiveMigrationFrom_u24lambda_u2d17 = builder = this;
            boolean bl = false;
            for (int startVersion : startVersions) {
                $this$fallbackToDestructiveMigrationFrom_u24lambda_u2d17.migrationsNotRequiredFrom.add(startVersion);
            }
            return builder;
        }

        @NotNull
        public Builder<T> addCallback(@NotNull Callback callback2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            Builder $this$addCallback_u24lambda_u2d18 = builder = this;
            boolean bl = false;
            $this$addCallback_u24lambda_u2d18.callbacks.add(callback2);
            return builder;
        }

        @NotNull
        public Builder<T> setQueryCallback(@NotNull QueryCallback queryCallback, @NotNull Executor executor) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)queryCallback, (String)"queryCallback");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Builder $this$setQueryCallback_u24lambda_u2d19 = builder = this;
            boolean bl = false;
            $this$setQueryCallback_u24lambda_u2d19.queryCallback = queryCallback;
            $this$setQueryCallback_u24lambda_u2d19.queryCallbackExecutor = executor;
            return builder;
        }

        @NotNull
        public Builder<T> addTypeConverter(@NotNull Object typeConverter) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)typeConverter, (String)"typeConverter");
            Builder $this$addTypeConverter_u24lambda_u2d20 = builder = this;
            boolean bl = false;
            $this$addTypeConverter_u24lambda_u2d20.typeConverters.add(typeConverter);
            return builder;
        }

        @ExperimentalRoomApi
        @NotNull
        public Builder<T> setAutoCloseTimeout(@IntRange(from=0L) long autoCloseTimeout, @NotNull TimeUnit autoCloseTimeUnit) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)autoCloseTimeUnit), (String)"autoCloseTimeUnit");
            Builder $this$setAutoCloseTimeout_u24lambda_u2d22 = builder = this;
            boolean bl = false;
            if (!(autoCloseTimeout >= 0L)) {
                boolean bl2 = false;
                String string = "autoCloseTimeout must be >= 0";
                throw new IllegalArgumentException(string.toString());
            }
            $this$setAutoCloseTimeout_u24lambda_u2d22.autoCloseTimeout = autoCloseTimeout;
            $this$setAutoCloseTimeout_u24lambda_u2d22.autoCloseTimeUnit = autoCloseTimeUnit;
            return builder;
        }

        @NotNull
        public T build() {
            SupportSQLiteOpenHelper.Factory factory;
            SupportSQLiteOpenHelper.Factory factory2;
            SupportSQLiteOpenHelper.Factory version2;
            if (this.queryExecutor == null && this.transactionExecutor == null) {
                this.queryExecutor = this.transactionExecutor = ArchTaskExecutor.getIOThreadExecutor();
            } else if (this.queryExecutor != null && this.transactionExecutor == null) {
                this.transactionExecutor = this.queryExecutor;
            } else if (this.queryExecutor == null) {
                this.queryExecutor = this.transactionExecutor;
            }
            if (this.migrationStartAndEndVersions != null) {
                Set<Integer> set = this.migrationStartAndEndVersions;
                Intrinsics.checkNotNull(set);
                Iterator<Integer> iterator = set.iterator();
                while (iterator.hasNext()) {
                    int version2 = ((Number)iterator.next()).intValue();
                    if (!this.migrationsNotRequiredFrom.contains(version2)) continue;
                    boolean $i$a$-require-RoomDatabase$Builder$build$22 = false;
                    String $i$a$-require-RoomDatabase$Builder$build$22 = "Inconsistency detected. A Migration was supplied to addMigration(Migration... migrations) that has a start or end version equal to a start version supplied to fallbackToDestructiveMigrationFrom(int... startVersions). Start version: " + version2;
                    throw new IllegalArgumentException($i$a$-require-RoomDatabase$Builder$build$22.toString());
                }
            }
            SupportSQLiteOpenHelper.Factory factory3 = version2 = this.factory == null ? (SupportSQLiteOpenHelper.Factory)new FrameworkSQLiteOpenHelperFactory() : this.factory;
            if (version2 != null) {
                SupportSQLiteOpenHelper.Factory factory4;
                SupportSQLiteOpenHelper.Factory it = version2;
                boolean bl = false;
                if (this.autoCloseTimeout > 0L) {
                    if (this.name == null) {
                        boolean $i$a$-requireNotNull-RoomDatabase$Builder$build$factory$1$22 = false;
                        String $i$a$-requireNotNull-RoomDatabase$Builder$build$factory$1$22 = "Cannot create auto-closing database for an in-memory database.";
                        throw new IllegalArgumentException($i$a$-requireNotNull-RoomDatabase$Builder$build$factory$1$22.toString());
                    }
                    TimeUnit timeUnit = this.autoCloseTimeUnit;
                    if (timeUnit == null) {
                        String string = "Required value was null.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    Executor executor = this.queryExecutor;
                    if (executor == null) {
                        String string = "Required value was null.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    AutoCloser autoCloser = new AutoCloser(this.autoCloseTimeout, timeUnit, executor);
                    factory4 = new AutoClosingRoomOpenHelperFactory(it, autoCloser);
                } else {
                    factory4 = it;
                }
                it = factory4;
                boolean bl2 = false;
                if (this.copyFromAssetPath != null || this.copyFromFile != null || this.copyFromInputStream != null) {
                    int copyFromInputStreamConfig;
                    int copyFromFileConfig;
                    if (this.name == null) {
                        boolean $i$a$-requireNotNull-RoomDatabase$Builder$build$factory$2$22 = false;
                        String $i$a$-requireNotNull-RoomDatabase$Builder$build$factory$2$22 = "Cannot create from asset or file for an in-memory database.";
                        throw new IllegalArgumentException($i$a$-requireNotNull-RoomDatabase$Builder$build$factory$2$22.toString());
                    }
                    int copyFromAssetPathConfig = this.copyFromAssetPath == null ? 0 : 1;
                    int copyConfigurations = copyFromAssetPathConfig + (copyFromFileConfig = this.copyFromFile == null ? 0 : 1) + (copyFromInputStreamConfig = this.copyFromInputStream == null ? 0 : 1);
                    if (!(copyConfigurations == 1)) {
                        boolean bl3 = false;
                        String string = "More than one of createFromAsset(), createFromInputStream(), and createFromFile() were called on this Builder, but the database can only be created using one of the three configurations.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    factory2 = new SQLiteCopyOpenHelperFactory(this.copyFromAssetPath, this.copyFromFile, this.copyFromInputStream, it);
                } else {
                    factory2 = it;
                }
            } else {
                factory2 = null;
            }
            SupportSQLiteOpenHelper.Factory it = factory2;
            boolean bl = false;
            if (it == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.queryCallback != null) {
                Executor executor = this.queryCallbackExecutor;
                if (executor == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                QueryCallback queryCallback = this.queryCallback;
                if (queryCallback == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                factory = new QueryInterceptorOpenHelperFactory(it, executor, queryCallback);
            } else {
                factory = it;
            }
            SupportSQLiteOpenHelper.Factory factory5 = factory;
            Executor executor = this.queryExecutor;
            if (executor == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            Executor executor2 = this.transactionExecutor;
            if (executor2 == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            DatabaseConfiguration configuration2 = new DatabaseConfiguration(this.context, this.name, factory5, this.migrationContainer, this.callbacks, this.allowMainThreadQueries, this.journalMode.resolve(this.context), executor, executor2, this.multiInstanceInvalidationIntent, this.requireMigration, this.allowDestructiveMigrationOnDowngrade, this.migrationsNotRequiredFrom, this.copyFromAssetPath, this.copyFromFile, this.copyFromInputStream, this.prepackagedDatabaseCallback, this.typeConverters, this.autoMigrationSpecs);
            RoomDatabase db = (RoomDatabase)Room.Companion.getGeneratedImplementation(this.klass, "_Impl");
            db.init(configuration2);
            return (T)db;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J!\u0010\u000b\u001a\u00020\t2\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\f\"\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000b\u001a\u00020\t2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0016J \u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J6\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J \u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u00180\u0018H\u0016R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/room/RoomDatabase$MigrationContainer;", "", "()V", "migrations", "", "", "Ljava/util/TreeMap;", "Landroidx/room/migration/Migration;", "addMigration", "", "migration", "addMigrations", "", "([Landroidx/room/migration/Migration;)V", "", "findMigrationPath", "start", "end", "findUpMigrationPath", "result", "", "upgrade", "", "getMigrations", "", "room-runtime_release"})
    public static class MigrationContainer {
        @NotNull
        private final Map<Integer, TreeMap<Integer, Migration>> migrations = new LinkedHashMap();

        public void addMigrations(Migration ... migrations) {
            Intrinsics.checkNotNullParameter((Object)migrations, (String)"migrations");
            Migration[] $this$forEach$iv = migrations;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Migration element$iv;
                Migration p0 = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                this.addMigration(p0);
            }
        }

        public void addMigrations(@NotNull List<? extends Migration> migrations) {
            Intrinsics.checkNotNullParameter(migrations, (String)"migrations");
            Iterable $this$forEach$iv = migrations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Migration p0 = (Migration)element$iv;
                boolean bl = false;
                this.addMigration(p0);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void addMigration(Migration migration) {
            Integer n;
            TreeMap targetMap;
            Object object;
            void $this$getOrPut$iv;
            int start = migration.startVersion;
            int end = migration.endVersion;
            Map<Integer, TreeMap<Integer, Migration>> map = this.migrations;
            Integer key$iv = start;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                TreeMap answer$iv = new TreeMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            if (((Map)(targetMap = (TreeMap)object)).containsKey(n = Integer.valueOf(end))) {
                Log.w((String)"ROOM", (String)("Overriding migration " + targetMap.get(end) + " with " + migration));
            }
            n = end;
            ((Map)targetMap).put(n, migration);
        }

        @NotNull
        public Map<Integer, Map<Integer, Migration>> getMigrations() {
            return this.migrations;
        }

        @Nullable
        public List<Migration> findMigrationPath(int start, int end) {
            if (start == end) {
                return CollectionsKt.emptyList();
            }
            boolean migrateUp = end > start;
            List result = new ArrayList();
            return this.findUpMigrationPath(result, migrateUp, start, end);
        }

        private final List<Migration> findUpMigrationPath(List<Migration> result, boolean upgrade, int start, int end) {
            block5: {
                boolean found;
                int migrationStart = start;
                block0: do {
                    TreeMap<Integer, Migration> targetNodes;
                    boolean bl = upgrade ? migrationStart < end : migrationStart > end;
                    if (!bl) break block5;
                    if (this.migrations.get(migrationStart) == null) {
                        return null;
                    }
                    Set keySet = upgrade ? (Set)targetNodes.descendingKeySet() : targetNodes.keySet();
                    found = false;
                    for (Integer targetVersion : keySet) {
                        boolean shouldAddToPath;
                        boolean bl2;
                        int n;
                        if (upgrade) {
                            n = migrationStart + 1;
                            Intrinsics.checkNotNullExpressionValue((Object)targetVersion, (String)"targetVersion");
                            int n2 = targetVersion;
                            bl2 = n <= n2 ? n2 <= end : false;
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)targetVersion, (String)"targetVersion");
                            n = targetVersion;
                            bl2 = end <= n ? n < migrationStart : false;
                        }
                        if (!(shouldAddToPath = bl2)) continue;
                        Migration migration = targetNodes.get(targetVersion);
                        Intrinsics.checkNotNull((Object)migration);
                        result.add(migration);
                        migrationStart = targetVersion;
                        found = true;
                        continue block0;
                    }
                } while (found);
                return null;
            }
            return result;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Landroidx/room/RoomDatabase$Callback;", "", "()V", "onCreate", "", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "onDestructiveMigration", "onOpen", "room-runtime_release"})
    public static abstract class Callback {
        public void onCreate(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        }

        public void onOpen(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        }

        public void onDestructiveMigration(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Landroidx/room/RoomDatabase$PrepackagedDatabaseCallback;", "", "()V", "onOpenPrepackagedDatabase", "", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "room-runtime_release"})
    public static abstract class PrepackagedDatabaseCallback {
        public void onOpenPrepackagedDatabase(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Landroidx/room/RoomDatabase$QueryCallback;", "", "onQuery", "", "sqlQuery", "", "bindArgs", "", "room-runtime_release"})
    public static interface QueryCallback {
        public void onQuery(@NotNull String var1, @NotNull List<? extends Object> var2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/room/RoomDatabase$Companion;", "", "()V", "MAX_BIND_PARAMETER_CNT", "", "room-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

