/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.sqlite.db.SupportSQLiteProgram;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\b\u0017\u0018\u0000 42\u00020\u00012\u00020\u0002:\u000234B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u000eH\u0016J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0016J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u001aH\u0016J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u0002H\u0016J\b\u0010*\u001a\u00020\u001fH\u0016J\b\u0010+\u001a\u00020\u001fH\u0016J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u0000H\u0016J\b\u0010.\u001a\u00020\u0004H\u0016J\b\u0010/\u001a\u00020\u001aH\u0016J\u0018\u00100\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u0004H\u0016J\b\u00102\u001a\u00020\u001fH\u0016R\u0018\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\bR \u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r8\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u0012\u0004\b\u000f\u0010\bR\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\bR\u0016\u0010\u0016\u001a\u00020\u00178\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0018\u0010\bR\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\r8\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u001d\u0012\u0004\b\u001c\u0010\b\u00a8\u00065"}, d2={"Landroidx/room/RoomSQLiteQuery;", "Landroidx/sqlite/db/SupportSQLiteQuery;", "Landroidx/sqlite/db/SupportSQLiteProgram;", "capacity", "", "(I)V", "argCount", "getArgCount$annotations", "()V", "bindingTypes", "", "getBindingTypes$annotations", "blobBindings", "", "", "getBlobBindings$annotations", "[[B", "getCapacity", "()I", "doubleBindings", "", "getDoubleBindings$annotations", "longBindings", "", "getLongBindings$annotations", "query", "", "stringBindings", "getStringBindings$annotations", "[Ljava/lang/String;", "bindBlob", "", "index", "value", "bindDouble", "", "bindLong", "", "bindNull", "bindString", "bindTo", "program", "clearBindings", "close", "copyArgumentsFrom", "other", "getArgCount", "getSql", "init", "initArgCount", "release", "Binding", "Companion", "room-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class RoomSQLiteQuery
implements SupportSQLiteQuery,
SupportSQLiteProgram {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @VisibleForTesting
    private final int capacity;
    @Nullable
    private volatile String query;
    @JvmField
    @NotNull
    public final long[] longBindings;
    @JvmField
    @NotNull
    public final double[] doubleBindings;
    @JvmField
    @NotNull
    public final String[] stringBindings;
    @JvmField
    @NotNull
    public final byte[][] blobBindings;
    @NotNull
    private final int[] bindingTypes;
    @JvmField
    public int argCount;
    public static final int POOL_LIMIT = 15;
    public static final int DESIRED_POOL_SIZE = 10;
    @JvmField
    @NotNull
    public static final TreeMap<Integer, RoomSQLiteQuery> queryPool = new TreeMap();
    private static final int NULL = 1;
    private static final int LONG = 2;
    private static final int DOUBLE = 3;
    private static final int STRING = 4;
    private static final int BLOB = 5;

    private RoomSQLiteQuery(int capacity) {
        this.capacity = capacity;
        int limit = this.capacity + 1;
        this.bindingTypes = new int[limit];
        this.longBindings = new long[limit];
        this.doubleBindings = new double[limit];
        this.stringBindings = new String[limit];
        this.blobBindings = new byte[limit][];
    }

    public final int getCapacity() {
        return this.capacity;
    }

    @VisibleForTesting
    public static /* synthetic */ void getLongBindings$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getDoubleBindings$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getStringBindings$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getBlobBindings$annotations() {
    }

    private static /* synthetic */ void getBindingTypes$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getArgCount$annotations() {
    }

    public void init(@NotNull String query, int initArgCount) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.query = query;
        this.argCount = initArgCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        TreeMap<Integer, RoomSQLiteQuery> treeMap = queryPool;
        synchronized (treeMap) {
            boolean bl = false;
            ((Map)queryPool).put(this.capacity, this);
            Companion.prunePoolLocked$room_runtime_release();
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public String getSql() {
        String string = this.query;
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        return string;
    }

    public int getArgCount() {
        return this.argCount;
    }

    public void bindTo(@NotNull SupportSQLiteProgram program) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        int index = 1;
        int n = this.argCount;
        if (index <= n) {
            while (true) {
                switch (this.bindingTypes[index]) {
                    case 1: {
                        program.bindNull(index);
                        break;
                    }
                    case 2: {
                        program.bindLong(index, this.longBindings[index]);
                        break;
                    }
                    case 3: {
                        program.bindDouble(index, this.doubleBindings[index]);
                        break;
                    }
                    case 4: {
                        program.bindString(index, this.stringBindings[index]);
                        break;
                    }
                    case 5: {
                        program.bindBlob(index, this.blobBindings[index]);
                    }
                }
                if (index == n) break;
                ++index;
            }
        }
    }

    public void bindNull(int index) {
        this.bindingTypes[index] = 1;
    }

    public void bindLong(int index, long value) {
        this.bindingTypes[index] = 2;
        this.longBindings[index] = value;
    }

    public void bindDouble(int index, double value) {
        this.bindingTypes[index] = 3;
        this.doubleBindings[index] = value;
    }

    public void bindString(int index, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bindingTypes[index] = 4;
        this.stringBindings[index] = value;
    }

    public void bindBlob(int index, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bindingTypes[index] = 5;
        this.blobBindings[index] = value;
    }

    public void close() {
    }

    public void copyArgumentsFrom(@NotNull RoomSQLiteQuery other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int argCount = other.argCount + 1;
        System.arraycopy(other.bindingTypes, 0, this.bindingTypes, 0, argCount);
        System.arraycopy(other.longBindings, 0, this.longBindings, 0, argCount);
        System.arraycopy(other.stringBindings, 0, this.stringBindings, 0, argCount);
        System.arraycopy(other.blobBindings, 0, this.blobBindings, 0, argCount);
        System.arraycopy(other.doubleBindings, 0, this.doubleBindings, 0, argCount);
    }

    public void clearBindings() {
        Arrays.fill(this.bindingTypes, 1);
        Arrays.fill(this.stringBindings, null);
        Arrays.fill((Object[])this.blobBindings, null);
        this.query = null;
    }

    @JvmStatic
    @NotNull
    public static final RoomSQLiteQuery copyFrom(@NotNull SupportSQLiteQuery supportSQLiteQuery) {
        return Companion.copyFrom(supportSQLiteQuery);
    }

    @JvmStatic
    @NotNull
    public static final RoomSQLiteQuery acquire(@NotNull String query, int argumentCount) {
        return Companion.acquire(query, argumentCount);
    }

    public /* synthetic */ RoomSQLiteQuery(int capacity, DefaultConstructorMarker $constructor_marker) {
        this(capacity);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0081\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/room/RoomSQLiteQuery$Binding;", "", "room-runtime_release"})
    public static @interface Binding {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\r\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u0002\u00a8\u0006\u001b"}, d2={"Landroidx/room/RoomSQLiteQuery$Companion;", "", "()V", "BLOB", "", "DESIRED_POOL_SIZE", "getDESIRED_POOL_SIZE$annotations", "DOUBLE", "LONG", "NULL", "POOL_LIMIT", "getPOOL_LIMIT$annotations", "STRING", "queryPool", "Ljava/util/TreeMap;", "Landroidx/room/RoomSQLiteQuery;", "getQueryPool$annotations", "acquire", "query", "", "argumentCount", "copyFrom", "supportSQLiteQuery", "Landroidx/sqlite/db/SupportSQLiteQuery;", "prunePoolLocked", "", "prunePoolLocked$room_runtime_release", "room-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getPOOL_LIMIT$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getDESIRED_POOL_SIZE$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getQueryPool$annotations() {
        }

        @JvmStatic
        @NotNull
        public final RoomSQLiteQuery copyFrom(@NotNull SupportSQLiteQuery supportSQLiteQuery) {
            Intrinsics.checkNotNullParameter((Object)supportSQLiteQuery, (String)"supportSQLiteQuery");
            String string = supportSQLiteQuery.getSql();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"supportSQLiteQuery.sql");
            RoomSQLiteQuery query = this.acquire(string, supportSQLiteQuery.getArgCount());
            supportSQLiteQuery.bindTo(new SupportSQLiteProgram(query){
                private final /* synthetic */ RoomSQLiteQuery $$delegate_0;
                {
                    this.$$delegate_0 = $query;
                }

                public void bindBlob(int p0, byte[] p1) {
                    Intrinsics.checkNotNullExpressionValue((Object)p1, (String)"bindBlob(...)");
                    this.$$delegate_0.bindBlob(p0, p1);
                }

                public void bindDouble(int p0, double p1) {
                    this.$$delegate_0.bindDouble(p0, p1);
                }

                public void bindLong(int p0, long p1) {
                    this.$$delegate_0.bindLong(p0, p1);
                }

                public void bindNull(int p0) {
                    this.$$delegate_0.bindNull(p0);
                }

                public void bindString(int p0, String p1) {
                    Intrinsics.checkNotNullExpressionValue((Object)p1, (String)"bindString(...)");
                    this.$$delegate_0.bindString(p0, p1);
                }

                public void clearBindings() {
                    this.$$delegate_0.clearBindings();
                }

                public void close() {
                    this.$$delegate_0.close();
                }
            });
            return query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final RoomSQLiteQuery acquire(@NotNull String query, int argumentCount) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            TreeMap<Integer, RoomSQLiteQuery> treeMap = queryPool;
            synchronized (treeMap) {
                block4: {
                    boolean bl = false;
                    Map.Entry<Integer, RoomSQLiteQuery> entry = queryPool.ceilingEntry(argumentCount);
                    if (entry == null) break block4;
                    queryPool.remove(entry.getKey());
                    RoomSQLiteQuery sqliteQuery = entry.getValue();
                    sqliteQuery.init(query, argumentCount);
                    Intrinsics.checkNotNullExpressionValue((Object)sqliteQuery, (String)"sqliteQuery");
                    RoomSQLiteQuery roomSQLiteQuery = sqliteQuery;
                    return roomSQLiteQuery;
                }
                Unit unit = Unit.INSTANCE;
            }
            RoomSQLiteQuery sqLiteQuery = new RoomSQLiteQuery(argumentCount, null);
            sqLiteQuery.init(query, argumentCount);
            return sqLiteQuery;
        }

        public final void prunePoolLocked$room_runtime_release() {
            if (queryPool.size() > 15) {
                int toBeRemoved = queryPool.size() - 10;
                Iterator<Integer> iterator = queryPool.descendingKeySet().iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"queryPool.descendingKeySet().iterator()");
                Iterator<Integer> iterator2 = iterator;
                while (toBeRemoved-- > 0) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

