/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.content.Context;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.room.DatabaseConfiguration;
import androidx.room.DelegatingOpenHelper;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.room.util.FileUtil;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory;
import androidx.sqlite.util.ProcessLock;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u001cH\u0002J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\bH\u0002J\u0018\u0010&\u001a\u00020 2\u0006\u0010%\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u001cH\u0002J\u000e\u0010'\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u001cH\u0017J\u0010\u0010*\u001a\u00020 2\u0006\u0010#\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001a\u00a8\u0006+"}, d2={"Landroidx/room/SQLiteCopyOpenHelper;", "Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "Landroidx/room/DelegatingOpenHelper;", "context", "Landroid/content/Context;", "copyFromAssetPath", "", "copyFromFile", "Ljava/io/File;", "copyFromInputStream", "Ljava/util/concurrent/Callable;", "Ljava/io/InputStream;", "databaseVersion", "", "delegate", "(Landroid/content/Context;Ljava/lang/String;Ljava/io/File;Ljava/util/concurrent/Callable;ILandroidx/sqlite/db/SupportSQLiteOpenHelper;)V", "databaseConfiguration", "Landroidx/room/DatabaseConfiguration;", "databaseName", "getDatabaseName", "()Ljava/lang/String;", "getDelegate", "()Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "readableDatabase", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "getReadableDatabase", "()Landroidx/sqlite/db/SupportSQLiteDatabase;", "verified", "", "writableDatabase", "getWritableDatabase", "close", "", "copyDatabaseFile", "destinationFile", "writable", "createFrameworkOpenHelper", "databaseFile", "dispatchOnOpenPrepackagedDatabase", "setDatabaseConfiguration", "setWriteAheadLoggingEnabled", "enabled", "verifyDatabaseFile", "room-runtime_release"})
public final class SQLiteCopyOpenHelper
implements SupportSQLiteOpenHelper,
DelegatingOpenHelper {
    @NotNull
    private final Context context;
    @Nullable
    private final String copyFromAssetPath;
    @Nullable
    private final File copyFromFile;
    @Nullable
    private final Callable<InputStream> copyFromInputStream;
    private final int databaseVersion;
    @NotNull
    private final SupportSQLiteOpenHelper delegate;
    private DatabaseConfiguration databaseConfiguration;
    private boolean verified;

    public SQLiteCopyOpenHelper(@NotNull Context context, @Nullable String copyFromAssetPath, @Nullable File copyFromFile, @Nullable Callable<InputStream> copyFromInputStream, int databaseVersion, @NotNull SupportSQLiteOpenHelper delegate) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.context = context;
        this.copyFromAssetPath = copyFromAssetPath;
        this.copyFromFile = copyFromFile;
        this.copyFromInputStream = copyFromInputStream;
        this.databaseVersion = databaseVersion;
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public SupportSQLiteOpenHelper getDelegate() {
        return this.delegate;
    }

    @Nullable
    public String getDatabaseName() {
        return this.getDelegate().getDatabaseName();
    }

    @RequiresApi(api=16)
    public void setWriteAheadLoggingEnabled(boolean enabled) {
        this.getDelegate().setWriteAheadLoggingEnabled(enabled);
    }

    @NotNull
    public SupportSQLiteDatabase getWritableDatabase() {
        if (!this.verified) {
            this.verifyDatabaseFile(true);
            this.verified = true;
        }
        return this.getDelegate().getWritableDatabase();
    }

    @NotNull
    public SupportSQLiteDatabase getReadableDatabase() {
        if (!this.verified) {
            this.verifyDatabaseFile(false);
            this.verified = true;
        }
        return this.getDelegate().getReadableDatabase();
    }

    public synchronized void close() {
        this.getDelegate().close();
        this.verified = false;
    }

    public final void setDatabaseConfiguration(@NotNull DatabaseConfiguration databaseConfiguration) {
        Intrinsics.checkNotNullParameter((Object)databaseConfiguration, (String)"databaseConfiguration");
        this.databaseConfiguration = databaseConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void verifyDatabaseFile(boolean writable) {
        String string = this.getDatabaseName();
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        String name = string;
        File databaseFile = this.context.getDatabasePath(name);
        DatabaseConfiguration databaseConfiguration = this.databaseConfiguration;
        if (databaseConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"databaseConfiguration");
            databaseConfiguration = null;
        }
        boolean processLevelLock = databaseConfiguration.multiInstanceInvalidation;
        ProcessLock copyLock = new ProcessLock(name, this.context.getFilesDir(), processLevelLock);
        try {
            int n;
            ProcessLock.lock$default((ProcessLock)copyLock, (boolean)false, (int)1, null);
            if (!databaseFile.exists()) {
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)databaseFile, (String)"databaseFile");
                    this.copyDatabaseFile(databaseFile, writable);
                    return;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to copy database file.", e);
                }
            }
            try {
                Intrinsics.checkNotNullExpressionValue((Object)databaseFile, (String)"databaseFile");
                n = DBUtil.readVersion(databaseFile);
            }
            catch (IOException e) {
                Log.w((String)"ROOM", (String)"Unable to read database version.", (Throwable)e);
                copyLock.unlock();
                return;
            }
            int currentVersion = n;
            if (currentVersion == this.databaseVersion) {
                return;
            }
            DatabaseConfiguration databaseConfiguration2 = this.databaseConfiguration;
            if (databaseConfiguration2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"databaseConfiguration");
                databaseConfiguration2 = null;
            }
            if (databaseConfiguration2.isMigrationRequired(currentVersion, this.databaseVersion)) {
                return;
            }
            if (this.context.deleteDatabase(name)) {
                try {
                    this.copyDatabaseFile(databaseFile, writable);
                    return;
                }
                catch (IOException e) {
                    Log.w((String)"ROOM", (String)"Unable to copy database file.", (Throwable)e);
                    return;
                }
            }
            Log.w((String)"ROOM", (String)("Failed to delete database file (" + name + ") for a copy destructive migration."));
            return;
        }
        finally {
            copyLock.unlock();
        }
    }

    private final void copyDatabaseFile(File destinationFile, boolean writable) throws IOException {
        ReadableByteChannel input = null;
        if (this.copyFromAssetPath != null) {
            ReadableByteChannel readableByteChannel = Channels.newChannel(this.context.getAssets().open(this.copyFromAssetPath));
            Intrinsics.checkNotNullExpressionValue((Object)readableByteChannel, (String)"newChannel(context.assets.open(copyFromAssetPath))");
            input = readableByteChannel;
        } else if (this.copyFromFile != null) {
            FileChannel fileChannel = new FileInputStream(this.copyFromFile).getChannel();
            Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"FileInputStream(copyFromFile).channel");
            input = fileChannel;
        } else if (this.copyFromInputStream != null) {
            InputStream inputStream;
            try {
                inputStream = this.copyFromInputStream.call();
            }
            catch (Exception e) {
                throw new IOException("inputStreamCallable exception on call", e);
            }
            InputStream inputStream2 = inputStream;
            ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream2);
            Intrinsics.checkNotNullExpressionValue((Object)readableByteChannel, (String)"newChannel(inputStream)");
            input = readableByteChannel;
        } else {
            throw new IllegalStateException("copyFromAssetPath, copyFromFile and copyFromInputStream are all null!");
        }
        File intermediateFile = File.createTempFile("room-copy-helper", ".tmp", this.context.getCacheDir());
        intermediateFile.deleteOnExit();
        FileChannel output = new FileOutputStream(intermediateFile).getChannel();
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
        FileUtil.copy(input, output);
        File parent = destinationFile.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directories for " + destinationFile.getAbsolutePath());
        }
        Intrinsics.checkNotNullExpressionValue((Object)intermediateFile, (String)"intermediateFile");
        this.dispatchOnOpenPrepackagedDatabase(intermediateFile, writable);
        if (!intermediateFile.renameTo(destinationFile)) {
            throw new IOException("Failed to move intermediate file (" + intermediateFile.getAbsolutePath() + ") to destination (" + destinationFile.getAbsolutePath() + ").");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispatchOnOpenPrepackagedDatabase(File databaseFile, boolean writable) {
        DatabaseConfiguration databaseConfiguration = this.databaseConfiguration;
        if (databaseConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"databaseConfiguration");
            databaseConfiguration = null;
        }
        if (databaseConfiguration.prepackagedDatabaseCallback == null) {
            return;
        }
        Closeable closeable = (Closeable)this.createFrameworkOpenHelper(databaseFile);
        Throwable throwable = null;
        try {
            SupportSQLiteOpenHelper helper = (SupportSQLiteOpenHelper)closeable;
            boolean bl = false;
            SupportSQLiteDatabase db = writable ? helper.getWritableDatabase() : helper.getReadableDatabase();
            DatabaseConfiguration databaseConfiguration2 = this.databaseConfiguration;
            if (databaseConfiguration2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"databaseConfiguration");
                databaseConfiguration2 = null;
            }
            RoomDatabase.PrepackagedDatabaseCallback prepackagedDatabaseCallback = databaseConfiguration2.prepackagedDatabaseCallback;
            Intrinsics.checkNotNull((Object)prepackagedDatabaseCallback);
            prepackagedDatabaseCallback.onOpenPrepackagedDatabase(db);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final SupportSQLiteOpenHelper createFrameworkOpenHelper(File databaseFile) {
        int n;
        try {
            n = DBUtil.readVersion(databaseFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Malformed database file, unable to read version.", e);
        }
        int version2 = n;
        FrameworkSQLiteOpenHelperFactory factory = new FrameworkSQLiteOpenHelperFactory();
        int n2 = RangesKt.coerceAtLeast((int)version2, (int)1);
        SupportSQLiteOpenHelper.Configuration configuration2 = SupportSQLiteOpenHelper.Configuration.Companion.builder(this.context).name(databaseFile.getAbsolutePath()).callback(new SupportSQLiteOpenHelper.Callback(version2, n2){
            final /* synthetic */ int $version;
            {
                this.$version = $version;
                super($super_call_param$1);
            }

            public void onCreate(@NotNull SupportSQLiteDatabase db) {
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            }

            public void onUpgrade(@NotNull SupportSQLiteDatabase db, int oldVersion, int newVersion) {
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            }

            public void onOpen(@NotNull SupportSQLiteDatabase db) {
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                if (this.$version < 1) {
                    db.setVersion(this.$version);
                }
            }
        }).build();
        return factory.create(configuration2);
    }
}

