/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.testing;

import android.annotation.SuppressLint;
import android.app.Instrumentation;
import android.content.Context;
import android.database.Cursor;
import android.os.Build;
import android.util.Log;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.room.DatabaseConfiguration;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.migration.bundle.DatabaseBundle;
import androidx.room.migration.bundle.DatabaseViewBundle;
import androidx.room.migration.bundle.EntityBundle;
import androidx.room.migration.bundle.FieldBundle;
import androidx.room.migration.bundle.ForeignKeyBundle;
import androidx.room.migration.bundle.FtsEntityBundle;
import androidx.room.migration.bundle.IndexBundle;
import androidx.room.migration.bundle.SchemaBundle;
import androidx.room.util.FtsTableInfo;
import androidx.room.util.TableInfo;
import androidx.room.util.ViewInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u0016\u0018\u0000 <2\u00020\u0001:\u0004<=>?B!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fB7\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aH\u0016J@\u0010!\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\n\u0012\u0004\u0012\u00020\u000f0\"2\u0014\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\n0$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0017J\u0012\u0010*\u001a\u00020\u001f2\b\u0010+\u001a\u0004\u0018\u00010,H\u0014J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u000e2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u00103\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u00052\u0006\u00104\u001a\u000205H\u0002J9\u00106\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0006\u00107\u001a\u00020\u001d2\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020.09\"\u00020.H\u0017\u00a2\u0006\u0002\u0010:J\u0012\u0010;\u001a\u00020\u001f2\b\u0010+\u001a\u0004\u0018\u00010,H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Landroidx/room/testing/MigrationTestHelper;", "Lorg/junit/rules/TestWatcher;", "instrumentation", "Landroid/app/Instrumentation;", "assetsFolder", "", "openFactory", "Landroidx/sqlite/db/SupportSQLiteOpenHelper$Factory;", "(Landroid/app/Instrumentation;Ljava/lang/String;Landroidx/sqlite/db/SupportSQLiteOpenHelper$Factory;)V", "databaseClass", "Ljava/lang/Class;", "Landroidx/room/RoomDatabase;", "(Landroid/app/Instrumentation;Ljava/lang/Class;)V", "specs", "", "Landroidx/room/migration/AutoMigrationSpec;", "(Landroid/app/Instrumentation;Ljava/lang/Class;Ljava/util/List;Landroidx/sqlite/db/SupportSQLiteOpenHelper$Factory;)V", "databaseConfiguration", "Landroidx/room/DatabaseConfiguration;", "getDatabaseConfiguration$room_testing_release", "()Landroidx/room/DatabaseConfiguration;", "setDatabaseConfiguration$room_testing_release", "(Landroidx/room/DatabaseConfiguration;)V", "managedDatabases", "", "Ljava/lang/ref/WeakReference;", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "managedRoomDatabases", "testStarted", "", "closeWhenFinished", "", "db", "createAutoMigrationSpecMap", "", "requiredAutoMigrationSpecs", "", "userProvidedSpecs", "createDatabase", "name", "version", "", "finished", "description", "Lorg/junit/runner/Description;", "getAutoMigrations", "Landroidx/room/migration/Migration;", "loadSchema", "Landroidx/room/migration/bundle/SchemaBundle;", "context", "Landroid/content/Context;", "openDatabase", "roomOpenHelper", "Landroidx/room/RoomOpenHelper;", "runMigrationsAndValidate", "validateDroppedTables", "migrations", "", "(Ljava/lang/String;IZ[Landroidx/room/migration/Migration;)Landroidx/sqlite/db/SupportSQLiteDatabase;", "starting", "Companion", "CreatingDelegate", "MigratingDelegate", "RoomOpenHelperDelegate", "room-testing_release"})
@SourceDebugExtension(value={"SMAP\nMigrationTestHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationTestHelper.kt\nandroidx/room/testing/MigrationTestHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,680:1\n1855#2,2:681\n1855#2:683\n288#2,2:684\n1856#2:686\n1855#2,2:687\n1855#2,2:689\n*S KotlinDebug\n*F\n+ 1 MigrationTestHelper.kt\nandroidx/room/testing/MigrationTestHelper\n*L\n268#1:681,2\n355#1:683\n356#1:684,2\n355#1:686\n379#1:687,2\n388#1:689,2\n*E\n"})
public class MigrationTestHelper
extends TestWatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String assetsFolder;
    @NotNull
    private final SupportSQLiteOpenHelper.Factory openFactory;
    @NotNull
    private final List<WeakReference<SupportSQLiteDatabase>> managedDatabases;
    @NotNull
    private final List<WeakReference<RoomDatabase>> managedRoomDatabases;
    private boolean testStarted;
    @NotNull
    private final Instrumentation instrumentation;
    @NotNull
    private final List<AutoMigrationSpec> specs;
    @Nullable
    private final Class<? extends RoomDatabase> databaseClass;
    public DatabaseConfiguration databaseConfiguration;
    @NotNull
    private static final String TAG = "MigrationTestHelper";

    @NotNull
    public final DatabaseConfiguration getDatabaseConfiguration$room_testing_release() {
        DatabaseConfiguration databaseConfiguration = this.databaseConfiguration;
        if (databaseConfiguration != null) {
            return databaseConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"databaseConfiguration");
        return null;
    }

    public final void setDatabaseConfiguration$room_testing_release(@NotNull DatabaseConfiguration databaseConfiguration) {
        Intrinsics.checkNotNullParameter((Object)databaseConfiguration, (String)"<set-?>");
        this.databaseConfiguration = databaseConfiguration;
    }

    @Deprecated(message="\n            Cannot be used to run migration tests involving [AutoMigration].\n            To test [AutoMigration], you must use [MigrationTestHelper(Instrumentation, Class, List,\n            SupportSQLiteOpenHelper.Factory)] for tests containing a\n            [androidx.room.ProvidedAutoMigrationSpec], or use\n            [MigrationTestHelper(Instrumentation, Class, List)] otherwise.\n      ")
    @JvmOverloads
    public MigrationTestHelper(@NotNull Instrumentation instrumentation, @NotNull String assetsFolder, @NotNull SupportSQLiteOpenHelper.Factory openFactory) {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        Intrinsics.checkNotNullParameter((Object)assetsFolder, (String)"assetsFolder");
        Intrinsics.checkNotNullParameter((Object)openFactory, (String)"openFactory");
        this.managedDatabases = new ArrayList();
        this.managedRoomDatabases = new ArrayList();
        this.instrumentation = instrumentation;
        this.assetsFolder = assetsFolder;
        this.openFactory = openFactory;
        this.databaseClass = null;
        this.specs = new ArrayList();
    }

    public /* synthetic */ MigrationTestHelper(Instrumentation instrumentation, String string, SupportSQLiteOpenHelper.Factory factory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            factory = (SupportSQLiteOpenHelper.Factory)new FrameworkSQLiteOpenHelperFactory();
        }
        this(instrumentation, string, factory);
    }

    public MigrationTestHelper(@NotNull Instrumentation instrumentation, @NotNull Class<? extends RoomDatabase> databaseClass) {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        Intrinsics.checkNotNullParameter(databaseClass, (String)"databaseClass");
        this(instrumentation, databaseClass, CollectionsKt.emptyList(), (SupportSQLiteOpenHelper.Factory)new FrameworkSQLiteOpenHelperFactory());
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public MigrationTestHelper(@NotNull Instrumentation instrumentation, @NotNull Class<? extends RoomDatabase> databaseClass, @NotNull List<? extends AutoMigrationSpec> specs, @NotNull SupportSQLiteOpenHelper.Factory openFactory) {
        String string;
        void it;
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        Intrinsics.checkNotNullParameter(databaseClass, (String)"databaseClass");
        Intrinsics.checkNotNullParameter(specs, (String)"specs");
        Intrinsics.checkNotNullParameter((Object)openFactory, (String)"openFactory");
        this.managedDatabases = new ArrayList();
        this.managedRoomDatabases = new ArrayList();
        String string2 = databaseClass.getCanonicalName();
        if (string2 == null) {
            String string3 = "Required value was null.";
            throw new IllegalStateException(string3.toString());
        }
        String string4 = string2;
        MigrationTestHelper migrationTestHelper = this;
        boolean bl = false;
        if (StringsKt.endsWith$default((String)it, (String)"/", (boolean)false, (int)2, null)) {
            String string5 = databaseClass.getCanonicalName();
            Intrinsics.checkNotNull((Object)string5);
            String string6 = it.substring(0, string5.length() - 1);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = it;
        }
        migrationTestHelper.assetsFolder = string;
        this.instrumentation = instrumentation;
        this.openFactory = openFactory;
        this.databaseClass = databaseClass;
        this.specs = specs;
    }

    public /* synthetic */ MigrationTestHelper(Instrumentation instrumentation, Class clazz, List list, SupportSQLiteOpenHelper.Factory factory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            factory = (SupportSQLiteOpenHelper.Factory)new FrameworkSQLiteOpenHelperFactory();
        }
        this(instrumentation, clazz, list, factory);
    }

    protected void starting(@Nullable Description description) {
        super.starting(description);
        this.testStarted = true;
    }

    @SuppressLint(value={"RestrictedApi"})
    @NotNull
    public SupportSQLiteDatabase createDatabase(@NotNull String name, int version) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        File file = this.instrumentation.getTargetContext().getDatabasePath(name);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"instrumentation.targetCo\u2026ext.getDatabasePath(name)");
        File dbPath = file;
        if (dbPath.exists()) {
            Log.d((String)TAG, (String)("deleting database file " + name));
            if (!dbPath.delete()) {
                boolean $i$a$-check-MigrationTestHelper$createDatabase$22 = false;
                String $i$a$-check-MigrationTestHelper$createDatabase$22 = "There is a database file and I could not delete it. Make sure you don't have any open connections to that database before calling this method.";
                throw new IllegalStateException($i$a$-check-MigrationTestHelper$createDatabase$22.toString());
            }
        }
        SchemaBundle schemaBundle = this.loadSchema(version);
        RoomDatabase.MigrationContainer container = new RoomDatabase.MigrationContainer();
        Context context = this.instrumentation.getTargetContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"instrumentation.targetContext");
        Executor executor = ArchTaskExecutor.getIOThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getIOThreadExecutor()");
        Executor executor2 = ArchTaskExecutor.getIOThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor2, (String)"getIOThreadExecutor()");
        DatabaseConfiguration configuration = new DatabaseConfiguration(context, name, this.openFactory, container, null, true, RoomDatabase.JournalMode.TRUNCATE, executor, executor2, null, true, false, SetsKt.emptySet(), null, null, null, null, CollectionsKt.emptyList(), CollectionsKt.emptyList());
        RoomOpenHelper roomOpenHelper = new RoomOpenHelper(configuration, (RoomOpenHelper.Delegate)new CreatingDelegate(schemaBundle.getDatabase()), schemaBundle.getDatabase().getIdentityHash(), schemaBundle.getDatabase().getIdentityHash());
        return this.openDatabase(name, roomOpenHelper);
    }

    @SuppressLint(value={"RestrictedApi"})
    @NotNull
    public SupportSQLiteDatabase runMigrationsAndValidate(@NotNull String name, int version, boolean validateDroppedTables, Migration ... migrations) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)migrations, (String)"migrations");
        File dbPath = this.instrumentation.getTargetContext().getDatabasePath(name);
        if (!dbPath.exists()) {
            boolean $i$a$-check-MigrationTestHelper$runMigrationsAndValidate$22 = false;
            String $i$a$-check-MigrationTestHelper$runMigrationsAndValidate$22 = "Cannot find the database file for " + name + ". Before calling runMigrations, you must first create the database via createDatabase.";
            throw new IllegalStateException($i$a$-check-MigrationTestHelper$runMigrationsAndValidate$22.toString());
        }
        SchemaBundle schemaBundle = this.loadSchema(version);
        RoomDatabase.MigrationContainer container = new RoomDatabase.MigrationContainer();
        container.addMigrations(Arrays.copyOf(migrations, migrations.length));
        List<Migration> autoMigrations = this.getAutoMigrations(this.specs);
        Iterable $this$forEach$iv = autoMigrations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Migration autoMigration = (Migration)element$iv;
            boolean bl = false;
            boolean migrationExists = container.contains(autoMigration.startVersion, autoMigration.endVersion);
            if (migrationExists) continue;
            Migration[] migrationArray = new Migration[]{autoMigration};
            container.addMigrations(migrationArray);
        }
        Context context = this.instrumentation.getTargetContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"instrumentation.targetContext");
        Executor executor = ArchTaskExecutor.getIOThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getIOThreadExecutor()");
        Executor executor2 = ArchTaskExecutor.getIOThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor2, (String)"getIOThreadExecutor()");
        this.setDatabaseConfiguration$room_testing_release(new DatabaseConfiguration(context, name, this.openFactory, container, null, true, RoomDatabase.JournalMode.TRUNCATE, executor, executor2, null, true, false, SetsKt.emptySet(), null, null, null, null, CollectionsKt.emptyList(), CollectionsKt.emptyList()));
        RoomOpenHelper roomOpenHelper = new RoomOpenHelper(this.getDatabaseConfiguration$room_testing_release(), (RoomOpenHelper.Delegate)new MigratingDelegate(schemaBundle.getDatabase(), validateDroppedTables), schemaBundle.getDatabase().getIdentityHash(), schemaBundle.getDatabase().getIdentityHash());
        return this.openDatabase(name, roomOpenHelper);
    }

    private final List<Migration> getAutoMigrations(List<? extends AutoMigrationSpec> userProvidedSpecs) {
        if (this.databaseClass == null) {
            if (!userProvidedSpecs.isEmpty()) {
                throw new IllegalStateException("You must provide the database class in the MigrationTestHelper constructor in order to test auto migrations.".toString());
            }
            Log.e((String)TAG, (String)"If you have any AutoMigrations in your implementation, you must use a non-deprecated MigrationTestHelper constructor to provide the Database class in order to test them. If you do not have any AutoMigrations to test, you may ignore this warning.");
            return new ArrayList();
        }
        RoomDatabase db = (RoomDatabase)Room.getGeneratedImplementation(this.databaseClass, (String)"_Impl");
        Set requiredAutoMigrationSpecs = db.getRequiredAutoMigrationSpecs();
        return db.getAutoMigrations(this.createAutoMigrationSpecMap(requiredAutoMigrationSpecs, userProvidedSpecs));
    }

    private final Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> createAutoMigrationSpecMap(Set<? extends Class<? extends AutoMigrationSpec>> requiredAutoMigrationSpecs, List<? extends AutoMigrationSpec> userProvidedSpecs) {
        Map map;
        if (requiredAutoMigrationSpecs.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map $this$createAutoMigrationSpecMap_u24lambda_u247 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = requiredAutoMigrationSpecs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            Class spec;
            block4: {
                spec = (Class)element$iv;
                boolean bl2 = false;
                Iterable $this$firstOrNull$iv = userProvidedSpecs;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    AutoMigrationSpec provided = (AutoMigrationSpec)element$iv2;
                    boolean bl3 = false;
                    if (!spec.isAssignableFrom(provided.getClass())) continue;
                    v0 = element$iv2;
                    break block4;
                }
                v0 = null;
            }
            AutoMigrationSpec match = v0;
            if (!(match != null)) {
                boolean bl4 = false;
                String string = "A required auto migration spec (" + spec.getCanonicalName() + ") has not been provided.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$createAutoMigrationSpecMap_u24lambda_u247.put(spec, match);
        }
        return MapsKt.build((Map)map);
    }

    private final SupportSQLiteDatabase openDatabase(String name, RoomOpenHelper roomOpenHelper) {
        Context context = this.instrumentation.getTargetContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"instrumentation.targetContext");
        SupportSQLiteOpenHelper.Configuration config = SupportSQLiteOpenHelper.Configuration.Companion.builder(context).callback((SupportSQLiteOpenHelper.Callback)roomOpenHelper).name(name).build();
        SupportSQLiteDatabase db = this.openFactory.create(config).getWritableDatabase();
        this.managedDatabases.add(new WeakReference<SupportSQLiteDatabase>(db));
        return db;
    }

    protected void finished(@Nullable Description description) {
        WeakReference dbRef;
        super.finished(description);
        Iterable $this$forEach$iv = this.managedDatabases;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            dbRef = (WeakReference)element$iv;
            boolean bl = false;
            SupportSQLiteDatabase db = (SupportSQLiteDatabase)dbRef.get();
            if (db == null || !db.isOpen()) continue;
            try {
                db.close();
            }
            catch (Throwable throwable) {
            }
        }
        $this$forEach$iv = this.managedRoomDatabases;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RoomDatabase roomDatabase;
            dbRef = (WeakReference)element$iv;
            boolean bl = false;
            RoomDatabase roomDatabase2 = roomDatabase = (RoomDatabase)dbRef.get();
            if (roomDatabase2 == null) continue;
            roomDatabase2.close();
        }
    }

    public void closeWhenFinished(@NotNull SupportSQLiteDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        if (!this.testStarted) {
            boolean bl = false;
            String string = "You cannot register a database to be closed before the test starts. Maybe you forgot to annotate MigrationTestHelper as a test rule? (@Rule)";
            throw new IllegalStateException(string.toString());
        }
        this.managedDatabases.add(new WeakReference<SupportSQLiteDatabase>(db));
    }

    public void closeWhenFinished(@NotNull RoomDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        if (!this.testStarted) {
            boolean bl = false;
            String string = "You cannot register a database to be closed before the test starts. Maybe you forgot to annotate MigrationTestHelper as a test rule? (@Rule)";
            throw new IllegalStateException(string.toString());
        }
        this.managedRoomDatabases.add(new WeakReference<RoomDatabase>(db));
    }

    private final SchemaBundle loadSchema(int version) {
        SchemaBundle schemaBundle;
        try {
            Context context = this.instrumentation.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"instrumentation.context");
            schemaBundle = this.loadSchema(context, version);
        }
        catch (FileNotFoundException testAssetsIOExceptions) {
            SchemaBundle schemaBundle2;
            Log.w((String)TAG, (String)"Could not find the schema file in the test assets. Checking the application assets");
            try {
                Context context = this.instrumentation.getTargetContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"instrumentation.targetContext");
                schemaBundle2 = this.loadSchema(context, version);
            }
            catch (FileNotFoundException appAssetsException) {
                throw new FileNotFoundException("Cannot find the schema file in the assets folder. Make sure to include the exported json schemas in your test assert inputs. See https://developer.android.com/training/data-storage/room/migrating-db-versions#export-schema for details. Missing file: " + testAssetsIOExceptions.getMessage());
            }
            schemaBundle = schemaBundle2;
        }
        return schemaBundle;
    }

    private final SchemaBundle loadSchema(Context context, int version) {
        InputStream inputStream = context.getAssets().open(this.assetsFolder + '/' + version + ".json");
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.assets.open(\"$assetsFolder/$version.json\")");
        InputStream input = inputStream;
        return SchemaBundle.Companion.deserialize(input);
    }

    @Deprecated(message="\n            Cannot be used to run migration tests involving [AutoMigration].\n            To test [AutoMigration], you must use [MigrationTestHelper(Instrumentation, Class, List,\n            SupportSQLiteOpenHelper.Factory)] for tests containing a\n            [androidx.room.ProvidedAutoMigrationSpec], or use\n            [MigrationTestHelper(Instrumentation, Class, List)] otherwise.\n      ")
    @JvmOverloads
    public MigrationTestHelper(@NotNull Instrumentation instrumentation, @NotNull String assetsFolder) {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        Intrinsics.checkNotNullParameter((Object)assetsFolder, (String)"assetsFolder");
        this(instrumentation, assetsFolder, null, 4, null);
    }

    @JvmOverloads
    public MigrationTestHelper(@NotNull Instrumentation instrumentation, @NotNull Class<? extends RoomDatabase> databaseClass, @NotNull List<? extends AutoMigrationSpec> specs) {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        Intrinsics.checkNotNullParameter(databaseClass, (String)"databaseClass");
        Intrinsics.checkNotNullParameter(specs, (String)"specs");
        this(instrumentation, databaseClass, specs, null, 8, null);
    }

    @JvmStatic
    @NotNull
    public static final TableInfo toTableInfo$room_testing_release(@NotNull EntityBundle entityBundle) {
        return Companion.toTableInfo$room_testing_release(entityBundle);
    }

    @JvmStatic
    @NotNull
    public static final FtsTableInfo toFtsTableInfo$room_testing_release(@NotNull FtsEntityBundle ftsEntityBundle) {
        return Companion.toFtsTableInfo$room_testing_release(ftsEntityBundle);
    }

    @JvmStatic
    @NotNull
    public static final ViewInfo toViewInfo$room_testing_release(@NotNull DatabaseViewBundle viewBundle) {
        return Companion.toViewInfo$room_testing_release(viewBundle);
    }

    @JvmStatic
    @NotNull
    public static final Set<TableInfo.Index> toIndices$room_testing_release(@Nullable List<? extends IndexBundle> indices) {
        return Companion.toIndices$room_testing_release(indices);
    }

    @JvmStatic
    @NotNull
    public static final Set<TableInfo.ForeignKey> toForeignKeys$room_testing_release(@Nullable List<? extends ForeignKeyBundle> bundles) {
        return Companion.toForeignKeys$room_testing_release(bundles);
    }

    @JvmStatic
    @NotNull
    public static final Set<String> toColumnNamesSet$room_testing_release(@NotNull EntityBundle entity) {
        return Companion.toColumnNamesSet$room_testing_release(entity);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, TableInfo.Column> toColumnMap$room_testing_release(@NotNull EntityBundle entity) {
        return Companion.toColumnMap$room_testing_release(entity);
    }

    @JvmStatic
    @NotNull
    public static final TableInfo.Column toColumn$room_testing_release(@NotNull EntityBundle entity, @NotNull FieldBundle field) {
        return Companion.toColumn$room_testing_release(entity, field);
    }

    @JvmStatic
    public static final int findPrimaryKeyPosition$room_testing_release(@NotNull EntityBundle entity, @NotNull FieldBundle field) {
        return Companion.findPrimaryKeyPosition$room_testing_release(entity, field);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u000bJ\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u000eJ!\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\u0011J\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\u0014J#\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0001\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0001\u00a2\u0006\u0002\b\u001fJ#\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00132\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u0018H\u0001\u00a2\u0006\u0002\b$J\u0015\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0001\u00a2\u0006\u0002\b-R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Landroidx/room/testing/MigrationTestHelper$Companion;", "", "()V", "TAG", "", "findPrimaryKeyPosition", "", "entity", "Landroidx/room/migration/bundle/EntityBundle;", "field", "Landroidx/room/migration/bundle/FieldBundle;", "findPrimaryKeyPosition$room_testing_release", "toColumn", "Landroidx/room/util/TableInfo$Column;", "toColumn$room_testing_release", "toColumnMap", "", "toColumnMap$room_testing_release", "toColumnNamesSet", "", "toColumnNamesSet$room_testing_release", "toForeignKeys", "Landroidx/room/util/TableInfo$ForeignKey;", "bundles", "", "Landroidx/room/migration/bundle/ForeignKeyBundle;", "toForeignKeys$room_testing_release", "toFtsTableInfo", "Landroidx/room/util/FtsTableInfo;", "ftsEntityBundle", "Landroidx/room/migration/bundle/FtsEntityBundle;", "toFtsTableInfo$room_testing_release", "toIndices", "Landroidx/room/util/TableInfo$Index;", "indices", "Landroidx/room/migration/bundle/IndexBundle;", "toIndices$room_testing_release", "toTableInfo", "Landroidx/room/util/TableInfo;", "entityBundle", "toTableInfo$room_testing_release", "toViewInfo", "Landroidx/room/util/ViewInfo;", "viewBundle", "Landroidx/room/migration/bundle/DatabaseViewBundle;", "toViewInfo$room_testing_release", "room-testing_release"})
    @SourceDebugExtension(value={"SMAP\nMigrationTestHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationTestHelper.kt\nandroidx/room/testing/MigrationTestHelper$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,680:1\n1549#2:681\n1620#2,3:682\n1549#2:685\n1620#2,3:686\n1549#2:689\n1620#2,3:690\n1194#2,2:693\n1222#2,4:695\n350#2,7:699\n*S KotlinDebug\n*F\n+ 1 MigrationTestHelper.kt\nandroidx/room/testing/MigrationTestHelper$Companion\n*L\n612#1:681\n612#1:682,3\n630#1:685\n630#1:686,3\n644#1:689\n644#1:690,3\n653#1:693,2\n653#1:695,4\n674#1:699,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TableInfo toTableInfo$room_testing_release(@NotNull EntityBundle entityBundle) {
            Intrinsics.checkNotNullParameter((Object)entityBundle, (String)"entityBundle");
            return new TableInfo(entityBundle.getTableName(), this.toColumnMap$room_testing_release(entityBundle), this.toForeignKeys$room_testing_release(entityBundle.getForeignKeys()), this.toIndices$room_testing_release(entityBundle.getIndices()));
        }

        @JvmStatic
        @NotNull
        public final FtsTableInfo toFtsTableInfo$room_testing_release(@NotNull FtsEntityBundle ftsEntityBundle) {
            Intrinsics.checkNotNullParameter((Object)ftsEntityBundle, (String)"ftsEntityBundle");
            return new FtsTableInfo(ftsEntityBundle.getTableName(), this.toColumnNamesSet$room_testing_release((EntityBundle)ftsEntityBundle), ftsEntityBundle.getCreateSql());
        }

        @JvmStatic
        @NotNull
        public final ViewInfo toViewInfo$room_testing_release(@NotNull DatabaseViewBundle viewBundle) {
            Intrinsics.checkNotNullParameter((Object)viewBundle, (String)"viewBundle");
            return new ViewInfo(viewBundle.getViewName(), viewBundle.createView());
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Set<TableInfo.Index> toIndices$room_testing_release(@Nullable List<? extends IndexBundle> indices) {
            void $this$mapTo$iv$iv;
            if (indices == null) {
                return SetsKt.emptySet();
            }
            Iterable $this$map$iv = indices;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void bundle;
                IndexBundle indexBundle = (IndexBundle)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = bundle.getName();
                boolean bl2 = bundle.isUnique();
                List list = bundle.getColumnNames();
                Intrinsics.checkNotNull((Object)list);
                List list2 = bundle.getOrders();
                Intrinsics.checkNotNull((Object)list2);
                collection.add(new TableInfo.Index(string, bl2, list, list2));
            }
            Set result = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Set<TableInfo.ForeignKey> toForeignKeys$room_testing_release(@Nullable List<? extends ForeignKeyBundle> bundles) {
            void $this$mapTo$iv$iv;
            if (bundles == null) {
                return SetsKt.emptySet();
            }
            Iterable $this$map$iv = bundles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void bundle;
                ForeignKeyBundle foreignKeyBundle = (ForeignKeyBundle)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new TableInfo.ForeignKey(bundle.getTable(), bundle.getOnDelete(), bundle.getOnUpdate(), bundle.getColumns(), bundle.getReferencedColumns()));
            }
            Set result = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Set<String> toColumnNamesSet$room_testing_release(@NotNull EntityBundle entity) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Iterable $this$map$iv = entity.getFields();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void field;
                FieldBundle fieldBundle = (FieldBundle)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(field.getColumnName());
            }
            Set result = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Map<String, TableInfo.Column> toColumnMap$room_testing_release(@NotNull EntityBundle entity) {
            void $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Map result = new HashMap();
            Iterable $this$associateBy$iv = entity.getFields();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void bundle;
                FieldBundle fieldBundle = (FieldBundle)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                TableInfo.Column column = Companion.toColumn$room_testing_release(entity, (FieldBundle)bundle);
                result.put(column.name, column);
                map.put(Unit.INSTANCE, element$iv$iv);
            }
            return result;
        }

        @JvmStatic
        @NotNull
        public final TableInfo.Column toColumn$room_testing_release(@NotNull EntityBundle entity, @NotNull FieldBundle field) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new TableInfo.Column(field.getColumnName(), field.getAffinity(), field.isNonNull(), this.findPrimaryKeyPosition$room_testing_release(entity, field), field.getDefaultValue(), 1);
        }

        @JvmStatic
        public final int findPrimaryKeyPosition$room_testing_release(@NotNull EntityBundle entity, @NotNull FieldBundle field) {
            int n;
            block2: {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                List $this$indexOfFirst$iv = entity.getPrimaryKey().getColumnNames();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    String columnName = (String)item$iv;
                    boolean bl = false;
                    if (StringsKt.equals((String)field.getColumnName(), (String)columnName, (boolean)true)) {
                        n = index$iv;
                        break block2;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            return n + 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Landroidx/room/testing/MigrationTestHelper$CreatingDelegate;", "Landroidx/room/testing/MigrationTestHelper$RoomOpenHelperDelegate;", "databaseBundle", "Landroidx/room/migration/bundle/DatabaseBundle;", "(Landroidx/room/migration/bundle/DatabaseBundle;)V", "createAllTables", "", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "onValidateSchema", "Landroidx/room/RoomOpenHelper$ValidationResult;", "room-testing_release"})
    @SourceDebugExtension(value={"SMAP\nMigrationTestHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationTestHelper.kt\nandroidx/room/testing/MigrationTestHelper$CreatingDelegate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,680:1\n1855#2,2:681\n*S KotlinDebug\n*F\n+ 1 MigrationTestHelper.kt\nandroidx/room/testing/MigrationTestHelper$CreatingDelegate\n*L\n551#1:681,2\n*E\n"})
    public static final class CreatingDelegate
    extends RoomOpenHelperDelegate {
        public CreatingDelegate(@NotNull DatabaseBundle databaseBundle) {
            Intrinsics.checkNotNullParameter((Object)databaseBundle, (String)"databaseBundle");
            super(databaseBundle);
        }

        public void createAllTables(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Iterable $this$forEach$iv = this.getMDatabaseBundle().buildCreateQueries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String query = (String)element$iv;
                boolean bl = false;
                db.execSQL(query);
            }
        }

        @NotNull
        public RoomOpenHelper.ValidationResult onValidateSchema(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            throw new UnsupportedOperationException("This open helper just creates the database but it received a migration request.");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/room/testing/MigrationTestHelper$MigratingDelegate;", "Landroidx/room/testing/MigrationTestHelper$RoomOpenHelperDelegate;", "databaseBundle", "Landroidx/room/migration/bundle/DatabaseBundle;", "mVerifyDroppedTables", "", "(Landroidx/room/migration/bundle/DatabaseBundle;Z)V", "createAllTables", "", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "onValidateSchema", "Landroidx/room/RoomOpenHelper$ValidationResult;", "room-testing_release"})
    @SourceDebugExtension(value={"SMAP\nMigrationTestHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationTestHelper.kt\nandroidx/room/testing/MigrationTestHelper$MigratingDelegate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CursorUtil.kt\nandroidx/room/util/CursorUtil\n*L\n1#1,680:1\n1855#2,2:681\n1855#2,2:683\n1855#2,2:685\n145#3,7:687\n*S KotlinDebug\n*F\n+ 1 MigrationTestHelper.kt\nandroidx/room/testing/MigrationTestHelper$MigratingDelegate\n*L\n472#1:681,2\n501#1:683,2\n518#1:685,2\n532#1:687,7\n*E\n"})
    public static final class MigratingDelegate
    extends RoomOpenHelperDelegate {
        private final boolean mVerifyDroppedTables;

        public MigratingDelegate(@NotNull DatabaseBundle databaseBundle, boolean mVerifyDroppedTables) {
            Intrinsics.checkNotNullParameter((Object)databaseBundle, (String)"databaseBundle");
            super(databaseBundle);
            this.mVerifyDroppedTables = mVerifyDroppedTables;
        }

        public void createAllTables(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            throw new UnsupportedOperationException("Was expecting to migrate but received create.Make sure you have created the database first.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public RoomOpenHelper.ValidationResult onValidateSchema(@NotNull SupportSQLiteDatabase db) {
            TableInfo found;
            Object expected;
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Map tables = this.getMDatabaseBundle().getEntitiesByTableName();
            Iterable $this$forEach$iv = tables.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EntityBundle entity = (EntityBundle)element$iv;
                boolean bl = false;
                if (entity instanceof FtsEntityBundle) {
                    expected = Companion.toFtsTableInfo$room_testing_release((FtsEntityBundle)entity);
                    if (Intrinsics.areEqual((Object)expected, (Object)(found = FtsTableInfo.Companion.read(db, entity.getTableName())))) continue;
                    return new RoomOpenHelper.ValidationResult(false, StringsKt.trimIndent((String)("\n                                " + ((FtsTableInfo)expected).name + "\n                                Expected: " + expected + "\n                                Found: " + found + "\n                            ")));
                }
                expected = Companion.toTableInfo$room_testing_release(entity);
                if (Intrinsics.areEqual((Object)expected, (Object)(found = TableInfo.Companion.read(db, entity.getTableName())))) continue;
                return new RoomOpenHelper.ValidationResult(false, StringsKt.trimIndent((String)("\n                                " + ((TableInfo)expected).name + "\n                                Expected: " + expected + "\n                                found: " + found + "\n                            ")));
            }
            $this$forEach$iv = this.getMDatabaseBundle().getViews();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DatabaseViewBundle view = (DatabaseViewBundle)element$iv;
                boolean bl = false;
                expected = Companion.toViewInfo$room_testing_release(view);
                if (Intrinsics.areEqual((Object)expected, (Object)(found = ViewInfo.Companion.read(db, view.getViewName())))) continue;
                return new RoomOpenHelper.ValidationResult(false, StringsKt.trimIndent((String)("\n                                " + ((ViewInfo)expected).name + "\n                                Expected: " + expected + "\n                                Found: " + found + "\n                            ")));
            }
            if (this.mVerifyDroppedTables) {
                void $this$useCursor$iv;
                String[] $this$onValidateSchema_u24lambda_u243 = $i$f$forEach3 = SetsKt.createSetBuilder();
                boolean bl = false;
                Iterable $this$forEach$iv2 = tables.values();
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    EntityBundle entity = (EntityBundle)element$iv;
                    boolean bl2 = false;
                    $this$onValidateSchema_u24lambda_u243.add(entity.getTableName());
                    if (!(entity instanceof FtsEntityBundle)) continue;
                    $this$onValidateSchema_u24lambda_u243.addAll(((FtsEntityBundle)entity).getShadowTableNames());
                }
                Set expectedTables = SetsKt.build((Set)$i$f$forEach3);
                String[] $i$f$forEach3 = new String[]{"room_master_table", "android_metadata", "sqlite_sequence"};
                $i$f$forEach3 = db.query("SELECT name FROM sqlite_master WHERE type='table' AND name NOT IN(?, ?, ?)", (Object[])$i$f$forEach3);
                boolean $i$f$useCursor = false;
                if (Build.VERSION.SDK_INT > 15) {
                    Closeable closeable = (Closeable)$this$useCursor$iv;
                    Throwable throwable = null;
                    try {
                        Cursor cursor = (Cursor)closeable;
                        boolean bl3 = false;
                        while (cursor.moveToNext()) {
                            String tableName = cursor.getString(0);
                            if (expectedTables.contains(tableName)) continue;
                            RoomOpenHelper.ValidationResult validationResult = new RoomOpenHelper.ValidationResult(false, "Unexpected table " + tableName);
                            return validationResult;
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                try {
                    void cursor = $this$useCursor$iv;
                    boolean bl4 = false;
                    while (cursor.moveToNext()) {
                        String tableName = cursor.getString(0);
                        if (expectedTables.contains(tableName)) continue;
                        RoomOpenHelper.ValidationResult validationResult = new RoomOpenHelper.ValidationResult(false, "Unexpected table " + tableName);
                        return validationResult;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    $this$useCursor$iv.close();
                }
            }
            return new RoomOpenHelper.ValidationResult(true, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Landroidx/room/testing/MigrationTestHelper$RoomOpenHelperDelegate;", "Landroidx/room/RoomOpenHelper$Delegate;", "mDatabaseBundle", "Landroidx/room/migration/bundle/DatabaseBundle;", "(Landroidx/room/migration/bundle/DatabaseBundle;)V", "getMDatabaseBundle", "()Landroidx/room/migration/bundle/DatabaseBundle;", "dropAllTables", "", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "onCreate", "onOpen", "room-testing_release"})
    public static abstract class RoomOpenHelperDelegate
    extends RoomOpenHelper.Delegate {
        @NotNull
        private final DatabaseBundle mDatabaseBundle;

        public RoomOpenHelperDelegate(@NotNull DatabaseBundle mDatabaseBundle) {
            Intrinsics.checkNotNullParameter((Object)mDatabaseBundle, (String)"mDatabaseBundle");
            super(mDatabaseBundle.getVersion());
            this.mDatabaseBundle = mDatabaseBundle;
        }

        @NotNull
        public final DatabaseBundle getMDatabaseBundle() {
            return this.mDatabaseBundle;
        }

        public void dropAllTables(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            throw new UnsupportedOperationException("cannot drop all tables in the test");
        }

        public void onCreate(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        }

        public void onOpen(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        }
    }
}

