/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice;

import android.app.slice.Slice;
import android.content.Context;
import android.graphics.drawable.Icon;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.collection.ArraySet;
import androidx.core.graphics.drawable.IconCompat;
import androidx.slice.Slice;
import androidx.slice.SliceItem;
import androidx.slice.SliceSpec;
import java.util.Set;

@RequiresApi(value=28)
public class SliceConvert {
    private static final String TAG = "SliceConvert";

    public static android.app.slice.Slice unwrap(Slice slice) {
        if (slice == null || slice.getUri() == null) {
            return null;
        }
        Slice.Builder builder = new Slice.Builder(slice.getUri(), SliceConvert.unwrap(slice.getSpec()));
        builder.addHints(slice.getHints());
        for (SliceItem item : slice.getItems()) {
            switch (item.getFormat()) {
                case "slice": {
                    builder.addSubSlice(SliceConvert.unwrap(item.getSlice()), item.getSubType());
                    break;
                }
                case "image": {
                    builder.addIcon(item.getIcon().toIcon(), item.getSubType(), item.getHints());
                    break;
                }
                case "input": {
                    builder.addRemoteInput(item.getRemoteInput(), item.getSubType(), item.getHints());
                    break;
                }
                case "action": {
                    builder.addAction(item.getAction(), SliceConvert.unwrap(item.getSlice()), item.getSubType());
                    break;
                }
                case "text": {
                    builder.addText(item.getText(), item.getSubType(), item.getHints());
                    break;
                }
                case "int": {
                    builder.addInt(item.getInt(), item.getSubType(), item.getHints());
                    break;
                }
                case "long": {
                    builder.addLong(item.getLong(), item.getSubType(), item.getHints());
                }
            }
        }
        return builder.build();
    }

    private static android.app.slice.SliceSpec unwrap(SliceSpec spec) {
        if (spec == null) {
            return null;
        }
        return new android.app.slice.SliceSpec(spec.getType(), spec.getRevision());
    }

    static Set<android.app.slice.SliceSpec> unwrap(Set<SliceSpec> supportedSpecs) {
        ArraySet ret = new ArraySet();
        if (supportedSpecs != null) {
            for (SliceSpec spec : supportedSpecs) {
                ret.add(SliceConvert.unwrap(spec));
            }
        }
        return ret;
    }

    public static Slice wrap(android.app.slice.Slice slice, Context context) {
        if (slice == null || slice.getUri() == null) {
            return null;
        }
        Slice.Builder builder = new Slice.Builder(slice.getUri());
        builder.addHints(slice.getHints());
        builder.setSpec(SliceConvert.wrap(slice.getSpec()));
        for (android.app.slice.SliceItem item : slice.getItems()) {
            switch (item.getFormat()) {
                case "slice": {
                    builder.addSubSlice(SliceConvert.wrap(item.getSlice(), context), item.getSubType());
                    break;
                }
                case "image": {
                    try {
                        builder.addIcon(IconCompat.createFromIcon((Context)context, (Icon)item.getIcon()), item.getSubType(), item.getHints());
                    }
                    catch (IllegalArgumentException e) {
                        Log.w((String)TAG, (String)"The icon resource isn't available.", (Throwable)e);
                    }
                    break;
                }
                case "input": {
                    builder.addRemoteInput(item.getRemoteInput(), item.getSubType(), item.getHints());
                    break;
                }
                case "action": {
                    builder.addAction(item.getAction(), SliceConvert.wrap(item.getSlice(), context), item.getSubType());
                    break;
                }
                case "text": {
                    builder.addText(item.getText(), item.getSubType(), item.getHints());
                    break;
                }
                case "int": {
                    builder.addInt(item.getInt(), item.getSubType(), item.getHints());
                    break;
                }
                case "long": {
                    builder.addLong(item.getLong(), item.getSubType(), item.getHints());
                }
            }
        }
        return builder.build();
    }

    private static SliceSpec wrap(android.app.slice.SliceSpec spec) {
        if (spec == null) {
            return null;
        }
        return new SliceSpec(spec.getType(), spec.getRevision());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static Set<SliceSpec> wrap(Set<android.app.slice.SliceSpec> supportedSpecs) {
        ArraySet ret = new ArraySet();
        if (supportedSpecs != null) {
            for (android.app.slice.SliceSpec spec : supportedSpecs) {
                ret.add(SliceConvert.wrap(spec));
            }
        }
        return ret;
    }

    private SliceConvert() {
    }
}

