/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice;

import android.app.PendingIntent;
import android.app.RemoteInput;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.text.format.DateUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.IconCompat;
import androidx.core.util.Pair;
import androidx.slice.ArrayUtils;
import androidx.slice.Slice;
import androidx.slice.SliceItemHolder;
import androidx.versionedparcelable.CustomVersionedParcelable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

@RequiresApi(value=19)
public final class SliceItem
extends CustomVersionedParcelable {
    private static final String HINTS = "hints";
    private static final String FORMAT = "format";
    private static final String SUBTYPE = "subtype";
    private static final String OBJ = "obj";
    private static final String OBJ_2 = "obj_2";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Slice.SliceHint
    protected String[] mHints = new String[0];
    String mFormat;
    String mSubType;
    Object mObj;
    SliceItemHolder mHolder;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public SliceItem(Object obj, @SliceType String format, String subType, @Slice.SliceHint String[] hints) {
        this.mHints = hints;
        this.mFormat = format;
        this.mSubType = subType;
        this.mObj = obj;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public SliceItem(Object obj, @SliceType String format, String subType, @Slice.SliceHint List<String> hints) {
        this(obj, format, subType, hints.toArray(new String[hints.size()]));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public SliceItem() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public SliceItem(PendingIntent intent, Slice slice, String format, String subType, @Slice.SliceHint String[] hints) {
        this((Object)new Pair((Object)intent, (Object)slice), format, subType, hints);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public SliceItem(ActionHandler action, Slice slice, String format, String subType, @Slice.SliceHint String[] hints) {
        this((Object)new Pair((Object)action, (Object)slice), format, subType, hints);
    }

    @NonNull
    @Slice.SliceHint
    public List<String> getHints() {
        return Arrays.asList(this.mHints);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void addHint(@Slice.SliceHint String hint) {
        this.mHints = ArrayUtils.appendElement(String.class, this.mHints, hint);
    }

    @SliceType
    public String getFormat() {
        return this.mFormat;
    }

    public String getSubType() {
        return this.mSubType;
    }

    public CharSequence getText() {
        return (CharSequence)this.mObj;
    }

    public IconCompat getIcon() {
        return (IconCompat)this.mObj;
    }

    public PendingIntent getAction() {
        Object action = ((Pair)this.mObj).first;
        if (action instanceof PendingIntent) {
            return (PendingIntent)action;
        }
        return null;
    }

    public void fireAction(@Nullable Context context, @Nullable Intent i) throws PendingIntent.CanceledException {
        this.fireActionInternal(context, i);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean fireActionInternal(@Nullable Context context, @Nullable Intent i) throws PendingIntent.CanceledException {
        Object action = ((Pair)this.mObj).first;
        if (action instanceof PendingIntent) {
            ((PendingIntent)action).send(context, 0, i, null, null);
            return false;
        }
        ((ActionHandler)action).onAction(this, context, i);
        return true;
    }

    @RequiresApi(value=20)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public RemoteInput getRemoteInput() {
        return (RemoteInput)this.mObj;
    }

    public int getInt() {
        return (Integer)this.mObj;
    }

    public Slice getSlice() {
        if ("action".equals(this.getFormat())) {
            return (Slice)((Pair)this.mObj).second;
        }
        return (Slice)this.mObj;
    }

    public long getLong() {
        return (Long)this.mObj;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public long getTimestamp() {
        return (Long)this.mObj;
    }

    public boolean hasHint(@Slice.SliceHint String hint) {
        return ArrayUtils.contains(this.mHints, hint);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public SliceItem(Bundle in) {
        this.mHints = in.getStringArray(HINTS);
        this.mFormat = in.getString(FORMAT);
        this.mSubType = in.getString(SUBTYPE);
        this.mObj = SliceItem.readObj(this.mFormat, in);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Bundle toBundle() {
        Bundle b = new Bundle();
        b.putStringArray(HINTS, this.mHints);
        b.putString(FORMAT, this.mFormat);
        b.putString(SUBTYPE, this.mSubType);
        this.writeObj(b, this.mObj, this.mFormat);
        return b;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean hasHints(@Slice.SliceHint String[] hints) {
        if (hints == null) {
            return true;
        }
        for (String hint : hints) {
            if (TextUtils.isEmpty((CharSequence)hint) || ArrayUtils.contains(this.mHints, hint)) continue;
            return false;
        }
        return true;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean hasAnyHints(String ... hints) {
        if (hints == null) {
            return false;
        }
        for (String hint : hints) {
            if (!ArrayUtils.contains(this.mHints, hint)) continue;
            return true;
        }
        return false;
    }

    private void writeObj(Bundle dest, Object obj, String type) {
        switch (type) {
            case "image": {
                dest.putBundle(OBJ, ((IconCompat)obj).toBundle());
                break;
            }
            case "input": {
                dest.putParcelable(OBJ, (Parcelable)obj);
                break;
            }
            case "slice": {
                dest.putParcelable(OBJ, (Parcelable)((Slice)obj).toBundle());
                break;
            }
            case "action": {
                dest.putParcelable(OBJ, (Parcelable)((PendingIntent)((Pair)obj).first));
                dest.putBundle(OBJ_2, ((Slice)((Pair)obj).second).toBundle());
                break;
            }
            case "text": {
                dest.putCharSequence(OBJ, (CharSequence)obj);
                break;
            }
            case "int": {
                dest.putInt(OBJ, ((Integer)this.mObj).intValue());
                break;
            }
            case "long": {
                dest.putLong(OBJ, ((Long)this.mObj).longValue());
            }
        }
    }

    private static Object readObj(String type, Bundle in) {
        switch (type) {
            case "image": {
                return IconCompat.createFromBundle((Bundle)in.getBundle(OBJ));
            }
            case "input": {
                return in.getParcelable(OBJ);
            }
            case "slice": {
                return new Slice(in.getBundle(OBJ));
            }
            case "text": {
                return in.getCharSequence(OBJ);
            }
            case "action": {
                return new Pair((Object)in.getParcelable(OBJ), (Object)new Slice(in.getBundle(OBJ_2)));
            }
            case "int": {
                return in.getInt(OBJ);
            }
            case "long": {
                return in.getLong(OBJ);
            }
        }
        throw new RuntimeException("Unsupported type " + type);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static String typeToString(String format) {
        switch (format) {
            case "slice": {
                return "Slice";
            }
            case "text": {
                return "Text";
            }
            case "image": {
                return "Image";
            }
            case "action": {
                return "Action";
            }
            case "int": {
                return "Int";
            }
            case "long": {
                return "Long";
            }
            case "input": {
                return "RemoteInput";
            }
        }
        return "Unrecognized format: " + format;
    }

    public String toString() {
        return this.toString("");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append(this.getFormat());
        if (this.getSubType() != null) {
            sb.append('<');
            sb.append(this.getSubType());
            sb.append('>');
        }
        sb.append(' ');
        if (this.mHints.length > 0) {
            Slice.appendHints(sb, this.mHints);
            sb.append(' ');
        }
        String nextIndent = indent + "  ";
        switch (this.getFormat()) {
            case "slice": {
                sb.append("{\n");
                sb.append(this.getSlice().toString(nextIndent));
                sb.append('\n').append(indent).append('}');
                break;
            }
            case "action": {
                Object action = ((Pair)this.mObj).first;
                sb.append('[').append(action).append("] ");
                sb.append("{\n");
                sb.append(this.getSlice().toString(nextIndent));
                sb.append('\n').append(indent).append('}');
                break;
            }
            case "text": {
                sb.append('\"').append(this.getText()).append('\"');
                break;
            }
            case "image": {
                sb.append(this.getIcon());
                break;
            }
            case "int": {
                if ("color".equals(this.getSubType())) {
                    int color = this.getInt();
                    sb.append(String.format("a=0x%02x r=0x%02x g=0x%02x b=0x%02x", Color.alpha((int)color), Color.red((int)color), Color.green((int)color), Color.blue((int)color)));
                    break;
                }
                if ("layout_direction".equals(this.getSubType())) {
                    sb.append(SliceItem.layoutDirectionToString(this.getInt()));
                    break;
                }
                sb.append(this.getInt());
                break;
            }
            case "long": {
                if ("millis".equals(this.getSubType())) {
                    if (this.getLong() == -1L) {
                        sb.append("INFINITY");
                        break;
                    }
                    sb.append(DateUtils.getRelativeTimeSpanString((long)this.getLong(), (long)Calendar.getInstance().getTimeInMillis(), (long)1000L, (int)262144));
                    break;
                }
                sb.append(this.getLong()).append('L');
                break;
            }
            default: {
                sb.append(SliceItem.typeToString(this.getFormat()));
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public void onPreParceling(boolean isStream) {
        this.mHolder = new SliceItemHolder(this.mFormat, this.mObj, isStream);
    }

    public void onPostParceling() {
        this.mObj = this.mHolder.getObj(this.mFormat);
        this.mHolder = null;
    }

    private static String layoutDirectionToString(int layoutDirection) {
        switch (layoutDirection) {
            case 0: {
                return "LTR";
            }
            case 1: {
                return "RTL";
            }
            case 2: {
                return "INHERIT";
            }
            case 3: {
                return "LOCALE";
            }
        }
        return Integer.toString(layoutDirection);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface ActionHandler {
        public void onAction(SliceItem var1, Context var2, Intent var3);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface SliceType {
    }
}

