/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.slice.SliceManagerCompat;
import androidx.slice.SliceManagerWrapper;
import androidx.slice.SliceSpec;
import java.util.List;
import java.util.Set;

@RequiresApi(value=19)
public abstract class SliceManager {
    @NonNull
    public static SliceManager getInstance(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 28) {
            return new SliceManagerWrapper(context);
        }
        return new SliceManagerCompat(context);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    SliceManager() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public abstract Set<SliceSpec> getPinnedSpecs(@NonNull Uri var1);

    public abstract int checkSlicePermission(@NonNull Uri var1, int var2, int var3);

    public abstract void grantSlicePermission(@NonNull String var1, @NonNull Uri var2);

    public abstract void revokeSlicePermission(@NonNull String var1, @NonNull Uri var2);

    @NonNull
    public abstract List<Uri> getPinnedSlices();
}

