/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Parcelable;
import android.os.Process;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.CoreComponentFactory;
import androidx.core.graphics.drawable.IconCompat;
import androidx.slice.Clock;
import androidx.slice.Slice;
import androidx.slice.SliceManager;
import androidx.slice.SliceSpec;
import androidx.slice.compat.CompatPermissionManager;
import androidx.slice.compat.SliceProviderCompat;
import androidx.slice.compat.SliceProviderWrapperContainer;
import androidx.slice.core.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class SliceProvider
extends ContentProvider
implements CoreComponentFactory.CompatWrapped {
    private static Set<SliceSpec> sSpecs;
    private static Clock sClock;
    private static final String TAG = "SliceProvider";
    private static final boolean DEBUG = false;
    private final String[] mAutoGrantPermissions;
    private SliceProviderCompat mCompat;
    private List<Uri> mPinnedSliceUris;

    public SliceProvider(String ... autoGrantPermissions) {
        this.mAutoGrantPermissions = autoGrantPermissions;
    }

    public SliceProvider() {
        this.mAutoGrantPermissions = new String[0];
    }

    @RequiresApi(value=19)
    public abstract boolean onCreateSliceProvider();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @RequiresApi(value=19)
    public Object getWrapper() {
        if (Build.VERSION.SDK_INT >= 28) {
            return new SliceProviderWrapperContainer.SliceProviderWrapper(this, this.mAutoGrantPermissions);
        }
        return null;
    }

    public final boolean onCreate() {
        if (Build.VERSION.SDK_INT < 19) {
            return false;
        }
        this.mPinnedSliceUris = new ArrayList<Uri>(SliceManager.getInstance(this.getContext()).getPinnedSlices());
        if (Build.VERSION.SDK_INT < 28) {
            this.mCompat = new SliceProviderCompat(this, this.onCreatePermissionManager(this.mAutoGrantPermissions), this.getContext());
        }
        return this.onCreateSliceProvider();
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @RequiresApi(value=19)
    protected CompatPermissionManager onCreatePermissionManager(String[] autoGrantPermissions) {
        return new CompatPermissionManager(this.getContext(), "slice_perms_" + ((Object)((Object)this)).getClass().getName(), Process.myUid(), autoGrantPermissions);
    }

    public final String getType(Uri uri) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        return "vnd.android.slice";
    }

    public Bundle call(String method, String arg, Bundle extras) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        return this.mCompat != null ? this.mCompat.call(method, arg, extras) : null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=19)
    public static Slice createPermissionSlice(Context context, Uri sliceUri, String callingPackage) {
        PendingIntent action = SliceProvider.createPermissionIntent(context, sliceUri, callingPackage);
        Slice.Builder parent = new Slice.Builder(sliceUri);
        Slice.Builder childAction = new Slice.Builder(parent).addIcon(IconCompat.createWithResource((Context)context, (int)R.drawable.abc_ic_permission), null, new String[0]).addHints(Arrays.asList("title", "shortcut")).addAction(action, new Slice.Builder(parent).build(), null);
        TypedValue tv = new TypedValue();
        new ContextThemeWrapper(context, 16974123).getTheme().resolveAttribute(16843829, tv, true);
        int deviceDefaultAccent = tv.data;
        parent.addSubSlice(new Slice.Builder(sliceUri.buildUpon().appendPath("permission").build()).addIcon(IconCompat.createWithResource((Context)context, (int)R.drawable.abc_ic_arrow_forward), null, new String[0]).addText(SliceProvider.getPermissionString(context, callingPackage), null, new String[0]).addInt(deviceDefaultAccent, "color", new String[0]).addSubSlice(childAction.build(), null).build(), null);
        return parent.addHints(Arrays.asList("permission_request")).build();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=19)
    public static PendingIntent createPermissionIntent(Context context, Uri sliceUri, String callingPackage) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(context.getPackageName(), "androidx.slice.compat.SlicePermissionActivity"));
        intent.putExtra("slice_uri", (Parcelable)sliceUri);
        intent.putExtra("pkg", callingPackage);
        intent.putExtra("provider_pkg", context.getPackageName());
        intent.setData(sliceUri.buildUpon().appendQueryParameter("package", callingPackage).build());
        return PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=19)
    public static CharSequence getPermissionString(Context context, String callingPackage) {
        PackageManager pm = context.getPackageManager();
        try {
            return context.getString(R.string.abc_slices_permission_request, new Object[]{pm.getApplicationInfo(callingPackage, 0).loadLabel(pm), context.getApplicationInfo().loadLabel(pm)});
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Unknown calling app", e);
        }
    }

    @RequiresApi(value=19)
    public abstract Slice onBindSlice(Uri var1);

    @RequiresApi(value=19)
    public void onSlicePinned(Uri sliceUri) {
    }

    @RequiresApi(value=19)
    public void onSliceUnpinned(Uri sliceUri) {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @RequiresApi(value=19)
    public void handleSlicePinned(Uri sliceUri) {
        if (!this.mPinnedSliceUris.contains(sliceUri)) {
            this.mPinnedSliceUris.add(sliceUri);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @RequiresApi(value=19)
    public void handleSliceUnpinned(Uri sliceUri) {
        if (this.mPinnedSliceUris.contains(sliceUri)) {
            this.mPinnedSliceUris.remove(sliceUri);
        }
    }

    @RequiresApi(value=19)
    @NonNull
    public Uri onMapIntentToUri(Intent intent) {
        throw new UnsupportedOperationException("This provider has not implemented intent to uri mapping");
    }

    @RequiresApi(value=19)
    public Collection<Uri> onGetSliceDescendants(Uri uri) {
        return Collections.emptyList();
    }

    @RequiresApi(value=19)
    @NonNull
    public List<Uri> getPinnedSlices() {
        return this.mPinnedSliceUris;
    }

    @Nullable
    public final Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    @RequiresApi(value=28)
    public final Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable Bundle queryArgs, @Nullable CancellationSignal cancellationSignal) {
        return null;
    }

    @Nullable
    @RequiresApi(value=16)
    public final Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder, @Nullable CancellationSignal cancellationSignal) {
        return null;
    }

    @Nullable
    public final Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    public final int bulkInsert(@NonNull Uri uri, @NonNull ContentValues[] values) {
        return 0;
    }

    public final int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    public final int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    @Nullable
    @RequiresApi(value=19)
    public final Uri canonicalize(@NonNull Uri url) {
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @RequiresApi(value=19)
    public static void setSpecs(Set<SliceSpec> specs) {
        sSpecs = specs;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=19)
    public static Set<SliceSpec> getCurrentSpecs() {
        return sSpecs;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @RequiresApi(value=19)
    public static void setClock(Clock clock) {
        sClock = clock;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @RequiresApi(value=19)
    public static Clock getClock() {
        return sClock;
    }
}

