/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.versionedparcelable.VersionedParcelable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=19)
public final class SliceSpec
implements VersionedParcelable {
    String mType;
    int mRevision;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public SliceSpec() {
    }

    public SliceSpec(@NonNull String type, int revision) {
        this.mType = type;
        this.mRevision = revision;
    }

    public String getType() {
        return this.mType;
    }

    public int getRevision() {
        return this.mRevision;
    }

    public boolean canRender(@NonNull SliceSpec candidate) {
        if (!this.mType.equals(candidate.mType)) {
            return false;
        }
        return this.mRevision >= candidate.mRevision;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SliceSpec)) {
            return false;
        }
        SliceSpec other = (SliceSpec)obj;
        return this.mType.equals(other.mType) && this.mRevision == other.mRevision;
    }

    public int hashCode() {
        return this.mType.hashCode() + this.mRevision;
    }

    public String toString() {
        return String.format("SliceSpec{%s,%d}", this.mType, this.mRevision);
    }
}

