/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.compat;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.collection.ArraySet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
public class CompatPermissionManager {
    private static final String TAG = "CompatPermissionManager";
    public static final String ALL_SUFFIX = "_all";
    private final Context mContext;
    private final String mPrefsName;
    private final int mMyUid;
    private final String[] mAutoGrantPermissions;

    public CompatPermissionManager(Context context, String prefsName, int myUid, String[] autoGrantPermissions) {
        this.mContext = context;
        this.mPrefsName = prefsName;
        this.mMyUid = myUid;
        this.mAutoGrantPermissions = autoGrantPermissions;
    }

    private SharedPreferences getPrefs() {
        return this.mContext.getSharedPreferences(this.mPrefsName, 0);
    }

    public int checkSlicePermission(Uri uri, int pid, int uid) {
        String[] pkgs;
        if (uid == this.mMyUid) {
            return 0;
        }
        for (String pkg : pkgs = this.mContext.getPackageManager().getPackagesForUid(uid)) {
            if (this.checkSlicePermission(uri, pkg) != 0) continue;
            return 0;
        }
        for (String autoGrantPermission : this.mAutoGrantPermissions) {
            if (this.mContext.checkPermission(autoGrantPermission, pid, uid) != 0) continue;
            for (String pkg : pkgs) {
                this.grantSlicePermission(uri, pkg);
            }
            return 0;
        }
        return this.mContext.checkUriPermission(uri, pid, uid, 2);
    }

    private int checkSlicePermission(Uri uri, String pkg) {
        PermissionState state = this.getPermissionState(pkg, uri.getAuthority());
        return state.hasAccess(uri.getPathSegments()) ? 0 : -1;
    }

    public void grantSlicePermission(Uri uri, String toPkg) {
        PermissionState state = this.getPermissionState(toPkg, uri.getAuthority());
        if (state.addPath(uri.getPathSegments())) {
            this.persist(state);
        }
    }

    public void revokeSlicePermission(Uri uri, String toPkg) {
        PermissionState state = this.getPermissionState(toPkg, uri.getAuthority());
        if (state.removePath(uri.getPathSegments())) {
            this.persist(state);
        }
    }

    private synchronized void persist(PermissionState state) {
        this.getPrefs().edit().putStringSet(state.getKey(), state.toPersistable()).putBoolean(state.getKey() + ALL_SUFFIX, state.hasAllPermissions()).apply();
    }

    private PermissionState getPermissionState(String pkg, String authority) {
        String key = pkg + "_" + authority;
        Set grant = this.getPrefs().getStringSet(key, Collections.emptySet());
        boolean hasAllPermissions = this.getPrefs().getBoolean(key + ALL_SUFFIX, false);
        return new PermissionState(grant, key, hasAllPermissions);
    }

    public static class PermissionState {
        private final ArraySet<String[]> mPaths = new ArraySet();
        private final String mKey;

        PermissionState(Set<String> grant, String key, boolean hasAllPermissions) {
            if (hasAllPermissions) {
                this.mPaths.add((Object)new String[0]);
            } else {
                for (String g : grant) {
                    this.mPaths.add((Object)this.decodeSegments(g));
                }
            }
            this.mKey = key;
        }

        public boolean hasAllPermissions() {
            return this.hasAccess(Collections.emptyList());
        }

        public String getKey() {
            return this.mKey;
        }

        public Set<String> toPersistable() {
            ArraySet ret = new ArraySet();
            for (String[] path : this.mPaths) {
                ret.add((Object)this.encodeSegments(path));
            }
            return ret;
        }

        public boolean hasAccess(List<String> path) {
            String[] inPath = path.toArray(new String[path.size()]);
            for (String[] p : this.mPaths) {
                if (!this.isPathPrefixMatch(p, inPath)) continue;
                return true;
            }
            return false;
        }

        boolean addPath(List<String> path) {
            String[] pathSegs = path.toArray(new String[path.size()]);
            for (int i = this.mPaths.size() - 1; i >= 0; --i) {
                String[] existing = (String[])this.mPaths.valueAt(i);
                if (this.isPathPrefixMatch(existing, pathSegs)) {
                    return false;
                }
                if (!this.isPathPrefixMatch(pathSegs, existing)) continue;
                this.mPaths.removeAt(i);
            }
            this.mPaths.add((Object)pathSegs);
            return true;
        }

        boolean removePath(List<String> path) {
            boolean changed = false;
            String[] pathSegs = path.toArray(new String[path.size()]);
            for (int i = this.mPaths.size() - 1; i >= 0; --i) {
                String[] existing = (String[])this.mPaths.valueAt(i);
                if (!this.isPathPrefixMatch(pathSegs, existing)) continue;
                changed = true;
                this.mPaths.removeAt(i);
            }
            return changed;
        }

        private boolean isPathPrefixMatch(String[] prefix, String[] path) {
            int prefixSize = prefix.length;
            if (path.length < prefixSize) {
                return false;
            }
            for (int i = 0; i < prefixSize; ++i) {
                if (Objects.equals(path[i], prefix[i])) continue;
                return false;
            }
            return true;
        }

        private String encodeSegments(String[] s) {
            Object[] out = new String[s.length];
            for (int i = 0; i < s.length; ++i) {
                out[i] = Uri.encode((String)s[i]);
            }
            return TextUtils.join((CharSequence)"/", (Object[])out);
        }

        private String[] decodeSegments(String s) {
            String[] sets = s.split("/", -1);
            for (int i = 0; i < sets.length; ++i) {
                sets[i] = Uri.decode((String)sets[i]);
            }
            return sets;
        }
    }
}

