/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.db.framework;

import android.content.Context;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.sqlite.db.SupportSQLiteCompat;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.framework.FrameworkSQLiteDatabase;
import androidx.sqlite.util.ProcessLock;
import androidx.sqlite.util.SneakyThrow;
import java.io.File;
import java.util.UUID;

class FrameworkSQLiteOpenHelper
implements SupportSQLiteOpenHelper {
    private static final String TAG = "SupportSQLite";
    private final Context mContext;
    private final String mName;
    private final SupportSQLiteOpenHelper.Callback mCallback;
    private final boolean mUseNoBackupDirectory;
    private final boolean mAllowDataLossOnRecovery;
    private final Object mLock;
    private OpenHelper mDelegate;
    private boolean mWriteAheadLoggingEnabled;

    FrameworkSQLiteOpenHelper(Context context, String name, SupportSQLiteOpenHelper.Callback callback) {
        this(context, name, callback, false);
    }

    FrameworkSQLiteOpenHelper(Context context, String name, SupportSQLiteOpenHelper.Callback callback, boolean useNoBackupDirectory) {
        this(context, name, callback, useNoBackupDirectory, false);
    }

    FrameworkSQLiteOpenHelper(Context context, String name, SupportSQLiteOpenHelper.Callback callback, boolean useNoBackupDirectory, boolean allowDataLossOnRecovery) {
        this.mContext = context;
        this.mName = name;
        this.mCallback = callback;
        this.mUseNoBackupDirectory = useNoBackupDirectory;
        this.mAllowDataLossOnRecovery = allowDataLossOnRecovery;
        this.mLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenHelper getDelegate() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDelegate == null) {
                FrameworkSQLiteDatabase[] dbRef = new FrameworkSQLiteDatabase[1];
                if (Build.VERSION.SDK_INT >= 23 && this.mName != null && this.mUseNoBackupDirectory) {
                    File file = new File(SupportSQLiteCompat.Api21Impl.getNoBackupFilesDir((Context)this.mContext), this.mName);
                    this.mDelegate = new OpenHelper(this.mContext, file.getAbsolutePath(), dbRef, this.mCallback, this.mAllowDataLossOnRecovery);
                } else {
                    this.mDelegate = new OpenHelper(this.mContext, this.mName, dbRef, this.mCallback, this.mAllowDataLossOnRecovery);
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    SupportSQLiteCompat.Api16Impl.setWriteAheadLoggingEnabled((SQLiteOpenHelper)this.mDelegate, (boolean)this.mWriteAheadLoggingEnabled);
                }
            }
            return this.mDelegate;
        }
    }

    public String getDatabaseName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=16)
    public void setWriteAheadLoggingEnabled(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDelegate != null) {
                SupportSQLiteCompat.Api16Impl.setWriteAheadLoggingEnabled((SQLiteOpenHelper)this.mDelegate, (boolean)enabled);
            }
            this.mWriteAheadLoggingEnabled = enabled;
        }
    }

    public SupportSQLiteDatabase getWritableDatabase() {
        return this.getDelegate().getSupportDatabase(true);
    }

    public SupportSQLiteDatabase getReadableDatabase() {
        return this.getDelegate().getSupportDatabase(false);
    }

    public void close() {
        this.getDelegate().close();
    }

    static class OpenHelper
    extends SQLiteOpenHelper {
        final FrameworkSQLiteDatabase[] mDbRef;
        final Context mContext;
        final SupportSQLiteOpenHelper.Callback mCallback;
        final boolean mAllowDataLossOnRecovery;
        private boolean mMigrated;
        private final ProcessLock mLock;
        private boolean mOpened;

        OpenHelper(Context context, String name, final FrameworkSQLiteDatabase[] dbRef, final SupportSQLiteOpenHelper.Callback callback, boolean allowDataLossOnRecovery) {
            super(context, name, null, callback.version, new DatabaseErrorHandler(){

                public void onCorruption(SQLiteDatabase dbObj) {
                    callback.onCorruption((SupportSQLiteDatabase)OpenHelper.getWrappedDb(dbRef, dbObj));
                }
            });
            this.mContext = context;
            this.mCallback = callback;
            this.mDbRef = dbRef;
            this.mAllowDataLossOnRecovery = allowDataLossOnRecovery;
            this.mLock = new ProcessLock(name == null ? UUID.randomUUID().toString() : name, context.getCacheDir(), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SupportSQLiteDatabase getSupportDatabase(boolean writable) {
            try {
                this.mLock.lock(!this.mOpened && this.getDatabaseName() != null);
                this.mMigrated = false;
                SQLiteDatabase db = this.innerGetDatabase(writable);
                if (this.mMigrated) {
                    this.close();
                    SupportSQLiteDatabase supportSQLiteDatabase = this.getSupportDatabase(writable);
                    return supportSQLiteDatabase;
                }
                FrameworkSQLiteDatabase frameworkSQLiteDatabase = this.getWrappedDb(db);
                return frameworkSQLiteDatabase;
            }
            finally {
                this.mLock.unlock();
            }
        }

        private SQLiteDatabase innerGetDatabase(boolean writable) {
            File databaseFile;
            File parentFile;
            String name = this.getDatabaseName();
            if (name != null && (parentFile = (databaseFile = this.mContext.getDatabasePath(name)).getParentFile()) != null) {
                parentFile.mkdirs();
                if (!parentFile.isDirectory()) {
                    Log.w((String)FrameworkSQLiteOpenHelper.TAG, (String)("Invalid database parent file, not a directory: " + parentFile));
                }
            }
            try {
                return this.getWritableOrReadableDatabase(writable);
            }
            catch (Throwable t2) {
                super.close();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException t2) {
                    // empty catch block
                }
                try {
                    return this.getWritableOrReadableDatabase(writable);
                }
                catch (Throwable t3) {
                    super.close();
                    Throwable openRetryError = t3;
                    if (openRetryError instanceof CallbackException) {
                        CallbackException callbackException = (CallbackException)openRetryError;
                        Throwable cause = callbackException.getCause();
                        switch (callbackException.getCallbackName()) {
                            case ON_CONFIGURE: 
                            case ON_CREATE: 
                            case ON_UPGRADE: 
                            case ON_DOWNGRADE: {
                                SneakyThrow.reThrow(cause);
                                break;
                            }
                        }
                        if (!(cause instanceof SQLiteException)) {
                            SneakyThrow.reThrow(cause);
                        }
                    } else if (openRetryError instanceof SQLiteException) {
                        if (name == null || !this.mAllowDataLossOnRecovery) {
                            SneakyThrow.reThrow(openRetryError);
                        }
                    } else {
                        SneakyThrow.reThrow(openRetryError);
                    }
                    this.mContext.deleteDatabase(name);
                    try {
                        return this.getWritableOrReadableDatabase(writable);
                    }
                    catch (CallbackException ex) {
                        SneakyThrow.reThrow(ex.getCause());
                        return null;
                    }
                }
            }
        }

        private SQLiteDatabase getWritableOrReadableDatabase(boolean writable) {
            if (writable) {
                return super.getWritableDatabase();
            }
            return super.getReadableDatabase();
        }

        FrameworkSQLiteDatabase getWrappedDb(SQLiteDatabase sqLiteDatabase) {
            return OpenHelper.getWrappedDb(this.mDbRef, sqLiteDatabase);
        }

        public void onCreate(SQLiteDatabase sqLiteDatabase) {
            try {
                this.mCallback.onCreate((SupportSQLiteDatabase)this.getWrappedDb(sqLiteDatabase));
            }
            catch (Throwable t) {
                throw new CallbackException(CallbackName.ON_CREATE, t);
            }
        }

        public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
            this.mMigrated = true;
            try {
                this.mCallback.onUpgrade((SupportSQLiteDatabase)this.getWrappedDb(sqLiteDatabase), oldVersion, newVersion);
            }
            catch (Throwable t) {
                throw new CallbackException(CallbackName.ON_UPGRADE, t);
            }
        }

        public void onConfigure(SQLiteDatabase db) {
            try {
                this.mCallback.onConfigure((SupportSQLiteDatabase)this.getWrappedDb(db));
            }
            catch (Throwable t) {
                throw new CallbackException(CallbackName.ON_CONFIGURE, t);
            }
        }

        public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.mMigrated = true;
            try {
                this.mCallback.onDowngrade((SupportSQLiteDatabase)this.getWrappedDb(db), oldVersion, newVersion);
            }
            catch (Throwable t) {
                throw new CallbackException(CallbackName.ON_DOWNGRADE, t);
            }
        }

        public void onOpen(SQLiteDatabase db) {
            if (!this.mMigrated) {
                try {
                    this.mCallback.onOpen((SupportSQLiteDatabase)this.getWrappedDb(db));
                }
                catch (Throwable t) {
                    throw new CallbackException(CallbackName.ON_OPEN, t);
                }
            }
            this.mOpened = true;
        }

        public void close() {
            try {
                this.mLock.lock();
                super.close();
                this.mDbRef[0] = null;
                this.mOpened = false;
            }
            finally {
                this.mLock.unlock();
            }
        }

        static FrameworkSQLiteDatabase getWrappedDb(FrameworkSQLiteDatabase[] refHolder, SQLiteDatabase sqLiteDatabase) {
            FrameworkSQLiteDatabase dbRef = refHolder[0];
            if (dbRef == null || !dbRef.isDelegate(sqLiteDatabase)) {
                refHolder[0] = new FrameworkSQLiteDatabase(sqLiteDatabase);
            }
            return refHolder[0];
        }

        static enum CallbackName {
            ON_CONFIGURE,
            ON_CREATE,
            ON_UPGRADE,
            ON_DOWNGRADE,
            ON_OPEN;

        }

        private static final class CallbackException
        extends RuntimeException {
            private final CallbackName mCallbackName;
            private final Throwable mCause;

            CallbackException(CallbackName callbackName, Throwable cause) {
                super(cause);
                this.mCallbackName = callbackName;
                this.mCause = cause;
            }

            public CallbackName getCallbackName() {
                return this.mCallbackName;
            }

            @Override
            @NonNull
            public Throwable getCause() {
                return this.mCause;
            }
        }
    }
}

